; VGM (SN76489) player for the Gameboy (DMG)
; /Mic, 2011
; 
; Assemble with wla-dx


.MEMORYMAP
	DEFAULTSLOT 1
	SLOTSIZE $4000
	SLOT 0 $0000
	SLOT 1 $4000
.ENDME

.ROMBANKSIZE $4000
.ROMBANKS 32

.ROMDMG
.CARTRIDGETYPE 1		; MBC1
.COMPUTEGBCHECKSUM
.COMPUTEGBCOMPLEMENTCHECK
.EMPTYFILL 0
.INCLUDE "nintendo_logo.i"
.INCLUDE "cgb_hardware.i"


.DEFINE SONG_LOCATION		$4000

.DEFINE MBC1_ROM_BANK_L		$2000
.DEFINE MBC1_ROM_BANK_H		$4000
.DEFINE MBC1_MODE			$6000


.ENUM $C000
TONE0_LATCH	ds 2
TONE1_LATCH	ds 2
TONE2_LATCH	ds 2
NOISE_LATCH	ds 2
VOL0_LATCH	ds 2
VOL1_LATCH	ds 2
VOL2_LATCH	ds 2
VOL3_LATCH	ds 2	; $10
PREV_VOLUME	ds 8
NRx2_ADDR	ds 8
LATCHED_REG	ds 1	; $20
TEMP		ds 1	; $21
TEMP2		ds 1	; $22
DELAY		ds 2	; $23
TEMP3		ds 1	; $25
TEMP4		ds 1	; $26
TEMP5		ds 1	; $27
WAIT_TIMER	ds 1	; 28
SONG_BANK	ds 1	; 29
.ENDE


.BANK 0 SLOT 0

.ORGA $00
nop
nop
nop
nop


.orga $40				;vbi.
	jp		irq_vbi
.orga $48				;lcd stat.
	jp		irq_lcd
.orga $50				;timer.
	jp		irq_tim
.orga $58				;serial.
	jp		irq_ser
.orga $60				;high to low.
	jp		irq_htl


.orga $100
nop
jp		main


.orga $150
main:
	di
	ld		sp,$fffe
	
	ld		a,$80
	ldh		(R_NR52),a		; sound master enable
	ld		a,$FF
	ldh		(R_NR50),a		; full output level for both left and right
	ldh		(R_NR51),a		; output all channels to both left and right
	
	ld		a,0
	ldh		(R_IF),a
	ldh		(R_IE),a
	ldh		(R_NR31),a
	ldh		(R_NR32),a
	ldh		(R_NR33),a
	;ldh		(R_NR34),a
	;ldh		(R_NR41),a
	ldh		(R_NR42),a
	ldh		(R_NR43),a
	ldh		(R_NR44),a	
	ldh		(R_NR11),a
	ldh		(R_NR12),a
	ldh		(R_NR13),a
	ldh		(R_NR14),a
	ldh		(R_NR21),a
	ldh		(R_NR22),a
	ldh		(R_NR23),a
	ldh		(R_NR24),a

	;ld		a,$FF
	ld		(TEMP2),a
	ld		(TEMP3),a
	ld		(TEMP4),a
	ld		(TEMP5),a
	
	; Disable tone sweep
	ld		a,8
	ldh		(R_NR10),a
	
	; Init envelope generators
	ld		a,$08
	ldh		(R_NR12),a
	ldh		(R_NR22),a
	ldh		(R_NR42),a

	ld		a,$80
	ldh		(R_NR14),a
	ldh		(R_NR24),a
	ld		a,0
	ldh		(R_NR44),a
	
	; Set 50% duty for square 1 & 2
	ld		a,$80
	ldh		(R_NR11),a
	ldh		(R_NR21),a

	; Load some data into waveform memory
	ld		a,0
	ldh		(R_NR30),a
	ld		hl,$FF30				; waveform RAM
	ld		a,$FF
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ld		a,$00
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ldi		(hl),a
	ld		a,$80
	ldh		(R_NR30),a
	
	ld		a,1
	ld		(SONG_BANK),a
	ld		(MBC1_ROM_BANK_L),a		; ROM bank 1 at $4000-$7FFF
	ld		a,0
	ld		(MBC1_ROM_BANK_H),a		; ROM bank upper bits
	ld		(MBC1_MODE),a			; ROM mode

	; Clear TONEx_LATCH, VOLx_LATCH and PREV_VOLUME
	ld		hl,TONE0_LATCH
	ld		b,24
-:
	ldi		(hl),a
	dec		b
	jr		nz,-
	
	; Initialize PPU
	call	init
	
	; Point to start of VGM data + sizeof VGM header
	ld		a,(SONG_LOCATION+$34)
	ld		l,a
	ld		a,(SONG_LOCATION+$35)
	ld		h,a

	ld		de,0			; VGM samples to delay
	
; Playback loop	
play:
	ldi		a,(hl)			; 8
	;ld		b,a				; 4  save the command byte
	cp		$70				; 8
	jr		c,+				; 12|8

; Wait n/44100 s  (n = [1..16])
; 28 cycles will have been spent when we enter this routine
short_wait:
	cp		$B3
	jr		z,papu_param

	;ld 		a,b 			; 4
	and 	$F 				; 8
	add 	e  				; 4. add the delay to the current delay (will either be 0, or negative if we're lagging behind)
	ld 		e,a 			; 4
	ld 		a,d 			; 4
	adc 	0 				; 8
	ld 		d,a 			; 4  ; 36
	;bit	 	7,d 			; 8
	rla						; 4
	jr 		nc,play 		; 12|8
	xor 	a 				; 4. clear a
	or 		e 				; 4
	jr 		z,play 			; 12|8  ; 68
-:
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	dec 	e				; 4
	jr		nz,-			; 12|8
	jr		play			; 12
+:	
	
	cp		$50				; 8
	jp		z,psg_param		; 16|12
	
	cp		$4B				; bank switch
	jp		z,bank_switch

	cp		$66				; loop
	jp		z,loop_song

	cp		$4F				; set gamegear stereo parameter
	jp		z,gg_stereo_param
	cp		$62				; wait one ntsc frame (1/60 s)
	jr		z,wait_frame_ntsc
	cp		$63				; wait one pal frame (1/50 s)
	jp		z,wait_frame_pal
	cp		$67
	jr		nz,+
+:
	cp		$61				; wait xxyy samples
	jp		z,long_wait
	; All other commands are unhandled and assumed to be 3 bytes long
	inc		hl
	inc		hl
	jr		play


papu_param:
	ldi		a,(hl)			; 8
	add		$10				; 8
	ld		c,a				; 4
	ldi		a,(hl)			; 8
	ld		($FF00+C),a		; 8
	jr		play
	
; Wait 1/60 s  ($2DF samples)
wait_frame_ntsc:
	ld 		a,$DF
	add 	e  		;4
	ld 		e,a 	;4
	ld 		a,d 	;4
	adc 	2 		;8
	ld 		d,a 	;4  ; 36
	bit 	7,d 	;8
	jr 		nz,play ;12|8	
	jp		long_wait_loop
	
	
; Wait 1/ 50 s  ($372 samples)
wait_frame_pal:
	ld 		a,$72	;8
	add 	e  		;4
	ld	 	e,a	 	;4
	ld 		a,d 	;4
	adc 	3 		;8
	ld 		d,a 	;4  ; 32
	bit 	7,d 	;8
	jp 		nz,play ;12|8
	jp		long_wait_loop
	

gg_stereo_param:
	ldi		a,(hl)
	ldh		(R_NR51),a		; GB and GG uses the same format for their stereo parameters
	jp		play


long_wait:
	ldi		a,(hl)			; 8
	add 	e				; 4
	ld		e,a				; 4
	ldi		a,(hl)			; 8
	adc 	d				; 4
	ld		d,a				; 4
	bit 	7,d				; 8
	jp 		nz,play			; 16|12 (56|52)
long_wait_loop:
	ld		a,d				; 4
	and		a				; 4
	jr		z,long_wait_loop_2
wait_256_frames:			; wait 256 VGM frames (256/44100 s)
	ld		b,0				; 8
-:
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	dec 	b				; 4
	jr		nz,-			; 12|8
	dec		d				; 4
	jr		long_wait_loop	; 12|8
	dec		de				; 8.  decrement de to take all the overhead into account		
long_wait_loop_2:
	ld		a,e				; 4
	ld		e,0				; 8
short_wait_2:
	and		a				; 4
	jr		nz,+			; 12|8
	nop						; 4
	nop						; 4
	nop						; 4
	nop						; 4
	jp		play			; 12 (tot 52)
+:	
	ld		c,a				; 4
	ld		c,a				; 4
	ld		c,a				; 4
	ld		c,a				; 4
-:
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	ld		a,(WAIT_TIMER)	; 16
	dec 	c				; 4
	jr		nz,-			; 12|8
	jp		play			; 16
	
	
	
; A value is being written to the PSG	
psg_param:
	ldi		a,(hl)			; 8
	ld		(TEMP),a		; 16

	push	hl				; 16
		
	bit		7,a				; 8
	jr		nz,latch_data 	; 12|8	
	ld		a,(LATCHED_REG)	; 16
	cp		6				; 8
	jr		nc,+			; 12|8
	; Set high 6 bits of tone register
	ld		c,a  			; 4
	ld		b,0  			; 8
	ld		a,(TEMP) 		; 16
	swap	a 				; 8
	and		$F0 			; 8
	push	de				; 16
	ld		d,a 			; 4
	ld		hl,TONE0_LATCH 	; 12
	add		hl,bc 			; 8
	ld		a,(hl)			; 8
	and		$0F 			; 8
	or		d 				; 4
	ld		(hl),a			; 8
	ld		a,(TEMP) 		; 16
	swap	a  				; 8
	and		3  				; 8
	inc		hl				; 8
	ld		(hl),a			; 8
	pop		de				; 12
	jp		tone_reg_updated ; 16 (264)
+:
	ld		c,a				; 4
	ld		b,0				; 8
	ld		hl,TONE0_LATCH	; 12
	add		hl,bc			; 8
	ld		a,(TEMP)		; 16
	and		$0F				; 8
	ld		(hl),a			; 8 (64)
check_vol_noise:
	ld		a,(LATCHED_REG)	; 16
	bit		3,a				; 8
	jr		nz,volume_reg_updated
	jp		noise_reg_updated
latch_data:
	ld		a,(TEMP)
	swap	a			; ddddLcct
	and 	7			; 00000cct
	push	de
	ld		d,a
	srl		a			; 000000cc
	ld		c,a
	ld		b,0
	ld		a,d			; 00000cct	
	and		1			; 0000000t
	sla		a			; 000000t0
	sla		a			; 00000t00
	or		c			; 00000tcc
	sla		a			; 0000tcc0
	ld		(LATCHED_REG),a
	ld		c,a
	ld		a,(TEMP)		; 16
	and		$0F				; 8
	ld		d,a				; 4
	ld		hl,TONE0_LATCH	; 12
	add		hl,bc			; 8
	ld		a,(hl)			; 8
	and		$F0				; 8
	or		d				; 4
	ld		(hl),a			; 8
	ld		a,(LATCHED_REG)	; 16
	cp		6				; 8
	pop		de				; 12
	jr		nc,check_vol_noise ; 12|8
	jp		tone_reg_updated   ; 16


volume_reg_updated:
	ld		a,(LATCHED_REG)			; 16
	cp		7*2						; 8
	jr		z,handle_noise_volume	; 12|8	
	cp		5*2						; 8
	jr		z,handle_tone1_volume	; 12|8
	cp		6*2						; 8
	jr		z,handle_wave_volume	; 12|8
; 64	
	ld		a,(PREV_VOLUME+0)		; 16
	ld		c,a						; 4
	
	ld		a,(VOL0_LATCH)			; 16
	ld		h,>volume_table			; 8
	ld		l,a						; 4
	ld		a,(hl)					; 8

	ld		(PREV_VOLUME+0),a		; 16
	
	sub		c						; 4
	bit		7,a						; 8.  is the difference negative?
	jr		z,+						; 12|8
	add		16						; 8.  wrap around, e.g. -1 => 15
	dec		de						; 8.  decrementing the volume takes much longer than incrementing, so dec de by one extra
+:
	ld		c,a						; 4
	ld		hl,NR12					; 12
	and		a						; 4
	jr		z,vol_no_diff			; 12|8
	ld		a,$08					; 8
	; Set the new volume by writing DIST(newVolume, previousVolume) times to the volume
	; envelope register.
-:
	ld		(hl),a					; 8
	dec		c						; 4
	jr		nz,-					; 12|8
vol_no_diff:
	; This has taken much longer than 1 VGM sample (~96 CPU cycles), so decrease
	; de accordingly
	dec		de						; 8
	dec		de						; 8
	dec		de						; 8
	dec		de						; 8
	pop		hl						; 12
	jp		play					; 16

handle_tone1_volume:
	ld		a,(PREV_VOLUME+2)
	ld		c,a
	ld		a,(VOL1_LATCH)
	ld		h,>volume_table
	ld		l,a
	ld		a,(hl)
	ld		(PREV_VOLUME+2),a	
	sub		c
	bit		7,a
	jr		z,+
	add		16
	dec		de
+:
	ld		c,a
	ld		hl,NR22
	and		a
	jr		z,vol_no_diff
	ld		a,$08
-:
	ld		(hl),a					; 8
	dec		c						; 4
	jr		nz,-					; 12|8
	jr		vol_no_diff
	
handle_noise_volume:
	ld		a,(PREV_VOLUME+6)
	ld		c,a
	ld		a,(VOL3_LATCH)
	ld		h,>volume_table
	ld		l,a
	ld		a,(hl)
	ld		(PREV_VOLUME+6),a	
	sub		c
	bit		7,a
	jr		z,+
	add		16
	dec		de
+:
	ld		c,a
	ld		hl,NR42
	and		a
	jr		z,vol_no_diff
	ld		a,$08
-:
	ld		(hl),a	;8
	dec		c			;4
	jr		nz,-		;12|8
	dec		de
	dec		de
	dec		de
	dec		de
	pop		hl
	jp		play
	
handle_wave_volume:
	ld		a,(VOL2_LATCH)		; 16
	and		$0F					; 8
	ld		c,a					; 4
	ld		b,0					; 8
	ld		hl,wave_volume_table ; 12
	add		hl,bc				; 8
	ld		a,(hl)				; 8
	ldh		(R_NR32),a			; 12
	dec		de					; 8
	dec		de					; 8
	dec		de					; 8
	dec		de					; 8
	pop		hl					; 12
	jp		play				; 16



tone_reg_updated:
	ld		hl,TONE0_LATCH	; 12
	ld		a,(LATCHED_REG)	; 16
	cp		2*2				; 8
	jr		z,wave_updated	; 12|8
	cp		1*2				; 8
	jr		z,tone1_updated	; 12|8

;60
	ld		hl,TONE0_LATCH	; 12
	ld		c,(hl)			; 8
	inc		hl				; 8
	ld		b,(hl)			; 8
	ld		hl,tone_freq	; 12
	add		hl,bc			; 8
	add		hl,bc			; 8
	ldi		a,(hl)			; 8
	ldh		(R_NR13),a		; 12
	ld		a,(hl)			; 8
	and 	7				; 8
	ld 		b,a				; 4
	ld 		a,(TEMP2)		; 16
	cp 		b				; 4
	jr 		z,+				; 12|8
	ld 		a,(PREV_VOLUME)	; 16
	swap 	a				; 8
	or 		8				; 8
	ldh	 	(R_NR12),a		; 12
	ld 		a,b				; 4
	ld 		(TEMP2),a		; 16
	or		$80				; 8
	ldh		(R_NR14),a		; 12
+:
	dec		de				; 8
	dec		de				; 8
	dec		de				; 8
	dec		de				; 8
	dec		de				; 8
	pop		hl				; 12
	jp		play			; 16

tone1_updated:
	ld		hl,TONE1_LATCH
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	ld		hl,tone_freq
	add		hl,bc
	add		hl,bc
	ldi		a,(hl)
	ldh		(R_NR23),a
	ld		a,(hl)
	and 	7
	ld 		b,a
	ld 		a,(TEMP3)
	cp 		b
	jr 		z,+
	ld 		a,(PREV_VOLUME+2)
	swap 	a
	or 		8
	ldh 	(R_NR22),a
	ld 		a,b
	ld 		(TEMP3),a
	or		$80
	ldh		(R_NR24),a
+:
	dec		de
	dec		de
	dec		de
	dec		de
	dec		de
	pop		hl
	jp		play

wave_updated:
;48
	ld		hl,TONE2_LATCH	; 12
	ld		c,(hl)			; 8
	inc		hl				; 8
	ld		b,(hl)			; 8
	ld		hl,wave_freq	; 12
	add		hl,bc			; 8
	add		hl,bc			; 8
	ldi		a,(hl)			; 8
	ld		b,(hl)			; 8
	ldh		(R_NR33),a		; 12
	ld 		a,(TEMP4)		; 16
	cp 		b				; 4
	jr 		z,+				; 12|8
	ld 		a,0
	ldh 	(R_NR30),a
	ld 		a,$80
	ldh 	(R_NR30),a
	ld 		a,b
	ld 		(TEMP4),a
	or		$80
	ldh		(R_NR34),a
+:	
	dec		de				; 8
	dec		de				; 8
	dec		de				; 8
	dec		de				; 8
	dec 	de				; 8
	pop		hl				; 12
	jp		play			; 16
	

noise_reg_updated:
	ld		a,(TEMP5)
	and		a
	jr		nz,+
	ld		a,$80
	ldh		(R_NR44),a
	ld		(TEMP5),a
	ld		a,(PREV_VOLUME+6)	; 16
	swap	a					; 8
	or		8					; 8
	ldh		(R_NR42),a			; 12
+:
	ld		a,(NOISE_LATCH)		; 16
	and		4					; 8
	sla		a					; 8
	xor		8					; 8
	jr		nz,periodic_noise	; 12|8
	ld		a,(NOISE_LATCH)		; 16
	and		3					; 8
	cp		3					; 8
	jr		z,white_noise_tone2_osc ; 12|8
	ld		hl,noise_table		; 12
	ld		c,a					; 4
	ld		b,0					; 8
	add		hl,bc				; 8
	ld		a,(hl)				; 8
	ldh		(R_NR43),a			; 12
	;ld		a,$80				; 8	
	;ldh		(R_NR44),a			; 12
	dec		de					; 8
	dec		de					; 8
	dec		de					; 8
	dec		de					; 8	
	dec		de					; 8
	pop		hl					; 12
	jp		play				; 16
white_noise_tone2_osc:
	dec		de
	dec		de
	dec		de
	pop		hl
	jp		play
periodic_noise:
	ld		a,(NOISE_LATCH)
	and		3
	cp		3
	jr		z,periodic_noise_tone2_osc	
	ld		hl,noise_table
	ld		c,a
	ld		b,0
	add		hl,bc
	ld		a,(hl)
	or		8
	ldh		(R_NR43),a
	;ld		a,$80
	;ldh		(R_NR44),a
	dec		de
	dec		de
	dec		de
	dec		de
	dec		de
	pop		hl
	jp		play
periodic_noise_tone2_osc:	
	ld		a,(TONE2_LATCH)
	ld		c,a
	ld		a,(TONE2_LATCH+1)
	ld		b,a
	ld		hl,tone2_noise_freq
	add		hl,bc
	ld		a,(hl)
	or		8
	ldh		(R_NR43),a
	;ld		a,$80
	;ldh		(R_NR44),a
	dec		de
	dec		de
	dec		de
	dec		de
	pop		hl
	jp		play


; Switch in the next 16kB of the song
bank_switch:
	ld		a,(SONG_BANK)
	inc		a
	ld		(SONG_BANK),a
	ld		($2000),a
	ld		hl,SONG_LOCATION
	jp		play


; Restart from the song's loop point	
loop_song:
	ld		a,1
	ld		(SONG_BANK),a
	ld		($2000),a
	ld		a,(SONG_LOCATION+$38)
	ld		l,a
	ld		a,(SONG_LOCATION+$39)
	ld		h,a
	jp		play



; Print a string on the nametable at $9800	
; HL=string, C=column, B=row	(c=0..31, r=0..23)
print_bg:
	push 	hl
	ld 		de,0
	ld 		hl,$9800
	or 		d		; Just to clear the CF

	; Multiply b by 32 and shift the overflowing bits into d
	sla 	b
	rl 		d
	sla 	b
	rl 		d
	sla 	b
	rl 		d
	sla 	b
	rl 		d
	sla 	b
	rl 		d

	add 	hl,de
	ld 		a,b
	ld 		b,0
	add 	hl,bc
	ld 		c,a
	add 	hl,bc
	pop 	bc
	push	hl
	pop		de
print_bg_loop:
	ld 		a,(bc)		; Get one byte from the string
	cp 		0
	ret 	z
	cp		''
	jr		nz,+
	ld		a,'e'
+:
	cp		''
	jr		nz,+
	ld		a,'e'
+:
	cp		''
	jr		nz,+
	ld		a,'a'
+:
	cp		''
	jr		nz,+
	ld		a,'a'
+:
	inc		bc
	sub		23			; +137 - 32 - 128
	ld		(de),a
	inc		de
	jp 		print_bg_loop
		

init:
	; Disable the screen
	ld		a,$00
	ldh		(R_LCDC),a

	ld		a,$D8  ;E4
	ldh		(R_BGP),a
	ldh		(R_OBP0),a
	ldh		(R_OBP1),a
	
	ld		a,32
	ldh		(R_WY),a
	;ld		a,80+7
	;ld		(R_WX),a
	
	; Clear the nametable at $9800 & $9C00
	ld 		hl,$9800
	ld		de,$800
	ld		a,-128
clear_nt:
	ldi		(hl),a
	dec		e
	jr		nz,clear_nt
	dec		d
	jr		nz,clear_nt
		
	; Copy pattern data to VRAM
	ld		hl,$8800
	ld 		de,bg_pat 	; Pointer to pattern_data
	ld 		bc,$1000			
copy_pat:
	ld 		a,(de)
	inc		de
	ldi		(hl),a
	dec 	c
	jr 		nz,copy_pat
	dec 	b
	jr 		nz,copy_pat

	ld		hl,$9C07
	ld		b,14
	ld		de,bg_nam
-:
	ld		c,14
--:
	ld		a,(de)
	sub		128
	ldi		(hl),a
	inc		de
	inc		de
	dec		c
	jr		nz,--
	ld		a,b
	ld		bc,18
	add		hl,bc
	ld		b,a
	dec		b
	jr		nz,-
	
	ld		hl,string2
	ld		b,0
	ld		c,1
	call	print_bg
	ld		hl,string3
	ld		b,1
	ld		c,1
	call	print_bg
	ld		hl,string4
	ld		b,2
	ld		c,1
	call	print_bg
	ld		hl,string5
	ld		b,3
	ld		c,1
	call	print_bg
	
	; Turn on the screen and BG and Window
	ld		a,$E1
	ldh		(R_LCDC),a

	ret
	

irq_vbi:
	reti
	
irq_lcd:
	reti
	
irq_tim:
	push	af
	ld		a,0
	ld		(WAIT_TIMER),a
	pop		af
	reti
	
irq_ser:
irq_htl:
	reti
	

bg_pat:
	.incbin "muttley.bin"
pattern_data:
    .incbin "font.bin"
bg_nam:
	.incbin "muttley.nam"

string1:
	.db "DMVGM"
	.db 0
string2:
	.db "DMVGM <-> Mic 2011"
	.db 0
string3:
	.db "Title5678901234567"
	.db 0
string4:
	.db "012345678901234567"
	.db 0
string5:
	.db "012345678901234567"
	.db 0
	
.org $1800	
volume_table:
.db 15,13,10,8,6,5,4,3
.db 3,  2, 2,1,1,1,0,0
;.db 15,14,13,12,11,10,9,8,7,6,5,3,2,1,0,0

.org $1900
wave_volume_table:
.db $20,$20,$20,$40,$40,$40,$60,$60
.db $60,$60,$60,$60,$60,$60,$00,$00

	
noise_table:
.db $35,$45,$55


.org $1A00
tone_freq:
.dw $07FE,$07FE,$07FD,$07FC,$07FB,$07FA,$07F8,$07F7,$07F6,$07F5,$07F4,$07F3,$07F1,$07F0,$07EF,$07EE
.dw $07ED,$07EC,$07EA,$07E9,$07E8,$07E7,$07E6,$07E5,$07E3,$07E2,$07E1,$07E0,$07DF,$07DE,$07DC,$07DB
.dw $07DA,$07D9,$07D8,$07D6,$07D5,$07D4,$07D3,$07D2,$07D1,$07CF,$07CE,$07CD,$07CC,$07CB,$07CA,$07C8
.dw $07C7,$07C6,$07C5,$07C4,$07C3,$07C1,$07C0,$07BF,$07BE,$07BD,$07BC,$07BA,$07B9,$07B8,$07B7,$07B6
.dw $07B5,$07B3,$07B2,$07B1,$07B0,$07AF,$07AD,$07AC,$07AB,$07AA,$07A9,$07A8,$07A6,$07A5,$07A4,$07A3
.dw $07A2,$07A1,$079F,$079E,$079D,$079C,$079B,$079A,$0798,$0797,$0796,$0795,$0794,$0793,$0791,$0790
.dw $078F,$078E,$078D,$078B,$078A,$0789,$0788,$0787,$0786,$0784,$0783,$0782,$0781,$0780,$077F,$077D
.dw $077C,$077B,$077A,$0779,$0778,$0776,$0775,$0774,$0773,$0772,$0771,$076F,$076E,$076D,$076C,$076B
.dw $076A,$0768,$0767,$0766,$0765,$0764,$0762,$0761,$0760,$075F,$075E,$075D,$075B,$075A,$0759,$0758
.dw $0757,$0756,$0754,$0753,$0752,$0751,$0750,$074F,$074D,$074C,$074B,$074A,$0749,$0748,$0746,$0745
.dw $0744,$0743,$0742,$0741,$073F,$073E,$073D,$073C,$073B,$0739,$0738,$0737,$0736,$0735,$0734,$0732
.dw $0731,$0730,$072F,$072E,$072D,$072B,$072A,$0729,$0728,$0727,$0726,$0724,$0723,$0722,$0721,$0720
.dw $071F,$071D,$071C,$071B,$071A,$0719,$0717,$0716,$0715,$0714,$0713,$0712,$0710,$070F,$070E,$070D
.dw $070C,$070B,$0709,$0708,$0707,$0706,$0705,$0704,$0702,$0701,$0700,$06FF,$06FE,$06FD,$06FB,$06FA
.dw $06F9,$06F8,$06F7,$06F6,$06F4,$06F3,$06F2,$06F1,$06F0,$06EE,$06ED,$06EC,$06EB,$06EA,$06E9,$06E7
.dw $06E6,$06E5,$06E4,$06E3,$06E2,$06E0,$06DF,$06DE,$06DD,$06DC,$06DB,$06D9,$06D8,$06D7,$06D6,$06D5
.dw $06D4,$06D2,$06D1,$06D0,$06CF,$06CE,$06CD,$06CB,$06CA,$06C9,$06C8,$06C7,$06C5,$06C4,$06C3,$06C2
.dw $06C1,$06C0,$06BE,$06BD,$06BC,$06BB,$06BA,$06B9,$06B7,$06B6,$06B5,$06B4,$06B3,$06B2,$06B0,$06AF
.dw $06AE,$06AD,$06AC,$06AB,$06A9,$06A8,$06A7,$06A6,$06A5,$06A3,$06A2,$06A1,$06A0,$069F,$069E,$069C
.dw $069B,$069A,$0699,$0698,$0697,$0695,$0694,$0693,$0692,$0691,$0690,$068E,$068D,$068C,$068B,$068A
.dw $0689,$0687,$0686,$0685,$0684,$0683,$0682,$0680,$067F,$067E,$067D,$067C,$067A,$0679,$0678,$0677
.dw $0676,$0675,$0673,$0672,$0671,$0670,$066F,$066E,$066C,$066B,$066A,$0669,$0668,$0667,$0665,$0664
.dw $0663,$0662,$0661,$0660,$065E,$065D,$065C,$065B,$065A,$0659,$0657,$0656,$0655,$0654,$0653,$0651
.dw $0650,$064F,$064E,$064D,$064C,$064A,$0649,$0648,$0647,$0646,$0645,$0643,$0642,$0641,$0640,$063F
.dw $063E,$063C,$063B,$063A,$0639,$0638,$0637,$0635,$0634,$0633,$0632,$0631,$062F,$062E,$062D,$062C
.dw $062B,$062A,$0628,$0627,$0626,$0625,$0624,$0623,$0621,$0620,$061F,$061E,$061D,$061C,$061A,$0619
.dw $0618,$0617,$0616,$0615,$0613,$0612,$0611,$0610,$060F,$060E,$060C,$060B,$060A,$0609,$0608,$0606
.dw $0605,$0604,$0603,$0602,$0601,$05FF,$05FE,$05FD,$05FC,$05FB,$05FA,$05F8,$05F7,$05F6,$05F5,$05F4
.dw $05F3,$05F1,$05F0,$05EF,$05EE,$05ED,$05EC,$05EA,$05E9,$05E8,$05E7,$05E6,$05E4,$05E3,$05E2,$05E1
.dw $05E0,$05DF,$05DD,$05DC,$05DB,$05DA,$05D9,$05D8,$05D6,$05D5,$05D4,$05D3,$05D2,$05D1,$05CF,$05CE
.dw $05CD,$05CC,$05CB,$05CA,$05C8,$05C7,$05C6,$05C5,$05C4,$05C3,$05C1,$05C0,$05BF,$05BE,$05BD,$05BB
.dw $05BA,$05B9,$05B8,$05B7,$05B6,$05B4,$05B3,$05B2,$05B1,$05B0,$05AF,$05AD,$05AC,$05AB,$05AA,$05A9
.dw $05A8,$05A6,$05A5,$05A4,$05A3,$05A2,$05A1,$059F,$059E,$059D,$059C,$059B,$059A,$0598,$0597,$0596
.dw $0595,$0594,$0592,$0591,$0590,$058F,$058E,$058D,$058B,$058A,$0589,$0588,$0587,$0586,$0584,$0583
.dw $0582,$0581,$0580,$057F,$057D,$057C,$057B,$057A,$0579,$0578,$0576,$0575,$0574,$0573,$0572,$0570
.dw $056F,$056E,$056D,$056C,$056B,$0569,$0568,$0567,$0566,$0565,$0564,$0562,$0561,$0560,$055F,$055E
.dw $055D,$055B,$055A,$0559,$0558,$0557,$0556,$0554,$0553,$0552,$0551,$0550,$054F,$054D,$054C,$054B
.dw $054A,$0549,$0547,$0546,$0545,$0544,$0543,$0542,$0540,$053F,$053E,$053D,$053C,$053B,$0539,$0538
.dw $0537,$0536,$0535,$0534,$0532,$0531,$0530,$052F,$052E,$052D,$052B,$052A,$0529,$0528,$0527,$0526
.dw $0524,$0523,$0522,$0521,$0520,$051E,$051D,$051C,$051B,$051A,$0519,$0517,$0516,$0515,$0514,$0513
.dw $0512,$0510,$050F,$050E,$050D,$050C,$050B,$0509,$0508,$0507,$0506,$0505,$0504,$0502,$0501,$0500
.dw $04FF,$04FE,$04FC,$04FB,$04FA,$04F9,$04F8,$04F7,$04F5,$04F4,$04F3,$04F2,$04F1,$04F0,$04EE,$04ED
.dw $04EC,$04EB,$04EA,$04E9,$04E7,$04E6,$04E5,$04E4,$04E3,$04E2,$04E0,$04DF,$04DE,$04DD,$04DC,$04DB
.dw $04D9,$04D8,$04D7,$04D6,$04D5,$04D3,$04D2,$04D1,$04D0,$04CF,$04CE,$04CC,$04CB,$04CA,$04C9,$04C8
.dw $04C7,$04C5,$04C4,$04C3,$04C2,$04C1,$04C0,$04BE,$04BD,$04BC,$04BB,$04BA,$04B9,$04B7,$04B6,$04B5
.dw $04B4,$04B3,$04B2,$04B0,$04AF,$04AE,$04AD,$04AC,$04AA,$04A9,$04A8,$04A7,$04A6,$04A5,$04A3,$04A2
.dw $04A1,$04A0,$049F,$049E,$049C,$049B,$049A,$0499,$0498,$0497,$0495,$0494,$0493,$0492,$0491,$0490
.dw $048E,$048D,$048C,$048B,$048A,$0488,$0487,$0486,$0485,$0484,$0483,$0481,$0480,$047F,$047E,$047D
.dw $047C,$047A,$0479,$0478,$0477,$0476,$0475,$0473,$0472,$0471,$0470,$046F,$046E,$046C,$046B,$046A
.dw $0469,$0468,$0467,$0465,$0464,$0463,$0462,$0461,$045F,$045E,$045D,$045C,$045B,$045A,$0458,$0457
.dw $0456,$0455,$0454,$0453,$0451,$0450,$044F,$044E,$044D,$044C,$044A,$0449,$0448,$0447,$0446,$0445
.dw $0443,$0442,$0441,$0440,$043F,$043D,$043C,$043B,$043A,$0439,$0438,$0436,$0435,$0434,$0433,$0432
.dw $0431,$042F,$042E,$042D,$042C,$042B,$042A,$0428,$0427,$0426,$0425,$0424,$0423,$0421,$0420,$041F
.dw $041E,$041D,$041C,$041A,$0419,$0418,$0417,$0416,$0414,$0413,$0412,$0411,$0410,$040F,$040D,$040C
.dw $040B,$040A,$0409,$0408,$0406,$0405,$0404,$0403,$0402,$0401,$03FF,$03FE,$03FD,$03FC,$03FB,$03FA
.dw $03F8,$03F7,$03F6,$03F5,$03F4,$03F3,$03F1,$03F0,$03EF,$03EE,$03ED,$03EB,$03EA,$03E9,$03E8,$03E7
.dw $03E6,$03E4,$03E3,$03E2,$03E1,$03E0,$03DF,$03DD,$03DC,$03DB,$03DA,$03D9,$03D8,$03D6,$03D5,$03D4
.dw $03D3,$03D2,$03D1,$03CF,$03CE,$03CD,$03CC,$03CB,$03C9,$03C8,$03C7,$03C6,$03C5,$03C4,$03C2,$03C1
.dw $03C0,$03BF,$03BE,$03BD,$03BB,$03BA,$03B9,$03B8,$03B7,$03B6,$03B4,$03B3,$03B2,$03B1,$03B0,$03AF
.dw $03AD,$03AC,$03AB,$03AA,$03A9,$03A8,$03A6,$03A5,$03A4,$03A3,$03A2,$03A0,$039F,$039E,$039D,$039C
.dw $039B,$0399,$0398,$0397,$0396,$0395,$0394,$0392,$0391,$0390,$038F,$038E,$038D,$038B,$038A,$0389
.dw $0388,$0387,$0386,$0384,$0383,$0382,$0381,$0380,$037F,$037D,$037C,$037B,$037A,$0379,$0377,$0376
.dw $0375,$0374,$0373,$0372,$0370,$036F,$036E,$036D,$036C,$036B,$0369,$0368,$0367,$0366,$0365,$0364
.dw $0362,$0361,$0360,$035F,$035E,$035D,$035B,$035A,$0359,$0358,$0357,$0355,$0354,$0353,$0352,$0351

wave_freq:
.dw $07FF,$07FF,$07FE,$07FE,$07FD,$07FD,$07FC,$07FB,$07FB,$07FA,$07FA,$07F9,$07F8,$07F8,$07F7,$07F7
.dw $07F6,$07F6,$07F5,$07F4,$07F4,$07F3,$07F3,$07F2,$07F1,$07F1,$07F0,$07F0,$07EF,$07EF,$07EE,$07ED
.dw $07ED,$07EC,$07EC,$07EB,$07EA,$07EA,$07E9,$07E9,$07E8,$07E7,$07E7,$07E6,$07E6,$07E5,$07E5,$07E4
.dw $07E3,$07E3,$07E2,$07E2,$07E1,$07E0,$07E0,$07DF,$07DF,$07DE,$07DE,$07DD,$07DC,$07DC,$07DB,$07DB
.dw $07DA,$07D9,$07D9,$07D8,$07D8,$07D7,$07D6,$07D6,$07D5,$07D5,$07D4,$07D4,$07D3,$07D2,$07D2,$07D1
.dw $07D1,$07D0,$07CF,$07CF,$07CE,$07CE,$07CD,$07CD,$07CC,$07CB,$07CB,$07CA,$07CA,$07C9,$07C8,$07C8
.dw $07C7,$07C7,$07C6,$07C5,$07C5,$07C4,$07C4,$07C3,$07C3,$07C2,$07C1,$07C1,$07C0,$07C0,$07BF,$07BE
.dw $07BE,$07BD,$07BD,$07BC,$07BC,$07BB,$07BA,$07BA,$07B9,$07B9,$07B8,$07B7,$07B7,$07B6,$07B6,$07B5
.dw $07B5,$07B4,$07B3,$07B3,$07B2,$07B2,$07B1,$07B0,$07B0,$07AF,$07AF,$07AE,$07AD,$07AD,$07AC,$07AC
.dw $07AB,$07AB,$07AA,$07A9,$07A9,$07A8,$07A8,$07A7,$07A6,$07A6,$07A5,$07A5,$07A4,$07A4,$07A3,$07A2
.dw $07A2,$07A1,$07A1,$07A0,$079F,$079F,$079E,$079E,$079D,$079C,$079C,$079B,$079B,$079A,$079A,$0799
.dw $0798,$0798,$0797,$0797,$0796,$0795,$0795,$0794,$0794,$0793,$0793,$0792,$0791,$0791,$0790,$0790
.dw $078F,$078E,$078E,$078D,$078D,$078C,$078B,$078B,$078A,$078A,$0789,$0789,$0788,$0787,$0787,$0786
.dw $0786,$0785,$0784,$0784,$0783,$0783,$0782,$0782,$0781,$0780,$0780,$077F,$077F,$077E,$077D,$077D
.dw $077C,$077C,$077B,$077B,$077A,$0779,$0779,$0778,$0778,$0777,$0776,$0776,$0775,$0775,$0774,$0773
.dw $0773,$0772,$0772,$0771,$0771,$0770,$076F,$076F,$076E,$076E,$076D,$076C,$076C,$076B,$076B,$076A
.dw $076A,$0769,$0768,$0768,$0767,$0767,$0766,$0765,$0765,$0764,$0764,$0763,$0762,$0762,$0761,$0761
.dw $0760,$0760,$075F,$075E,$075E,$075D,$075D,$075C,$075B,$075B,$075A,$075A,$0759,$0759,$0758,$0757
.dw $0757,$0756,$0756,$0755,$0754,$0754,$0753,$0753,$0752,$0751,$0751,$0750,$0750,$074F,$074F,$074E
.dw $074D,$074D,$074C,$074C,$074B,$074A,$074A,$0749,$0749,$0748,$0748,$0747,$0746,$0746,$0745,$0745
.dw $0744,$0743,$0743,$0742,$0742,$0741,$0741,$0740,$073F,$073F,$073E,$073E,$073D,$073C,$073C,$073B
.dw $073B,$073A,$0739,$0739,$0738,$0738,$0737,$0737,$0736,$0735,$0735,$0734,$0734,$0733,$0732,$0732
.dw $0731,$0731,$0730,$0730,$072F,$072E,$072E,$072D,$072D,$072C,$072B,$072B,$072A,$072A,$0729,$0728
.dw $0728,$0727,$0727,$0726,$0726,$0725,$0724,$0724,$0723,$0723,$0722,$0721,$0721,$0720,$0720,$071F
.dw $071F,$071E,$071D,$071D,$071C,$071C,$071B,$071A,$071A,$0719,$0719,$0718,$0717,$0717,$0716,$0716
.dw $0715,$0715,$0714,$0713,$0713,$0712,$0712,$0711,$0710,$0710,$070F,$070F,$070E,$070E,$070D,$070C
.dw $070C,$070B,$070B,$070A,$0709,$0709,$0708,$0708,$0707,$0707,$0706,$0705,$0705,$0704,$0704,$0703
.dw $0702,$0702,$0701,$0701,$0700,$06FF,$06FF,$06FE,$06FE,$06FD,$06FD,$06FC,$06FB,$06FB,$06FA,$06FA
.dw $06F9,$06F8,$06F8,$06F7,$06F7,$06F6,$06F6,$06F5,$06F4,$06F4,$06F3,$06F3,$06F2,$06F1,$06F1,$06F0
.dw $06F0,$06EF,$06EE,$06EE,$06ED,$06ED,$06EC,$06EC,$06EB,$06EA,$06EA,$06E9,$06E9,$06E8,$06E7,$06E7
.dw $06E6,$06E6,$06E5,$06E5,$06E4,$06E3,$06E3,$06E2,$06E2,$06E1,$06E0,$06E0,$06DF,$06DF,$06DE,$06DD
.dw $06DD,$06DC,$06DC,$06DB,$06DB,$06DA,$06D9,$06D9,$06D8,$06D8,$06D7,$06D6,$06D6,$06D5,$06D5,$06D4
.dw $06D4,$06D3,$06D2,$06D2,$06D1,$06D1,$06D0,$06CF,$06CF,$06CE,$06CE,$06CD,$06CD,$06CC,$06CB,$06CB
.dw $06CA,$06CA,$06C9,$06C8,$06C8,$06C7,$06C7,$06C6,$06C5,$06C5,$06C4,$06C4,$06C3,$06C3,$06C2,$06C1
.dw $06C1,$06C0,$06C0,$06BF,$06BE,$06BE,$06BD,$06BD,$06BC,$06BC,$06BB,$06BA,$06BA,$06B9,$06B9,$06B8
.dw $06B7,$06B7,$06B6,$06B6,$06B5,$06B4,$06B4,$06B3,$06B3,$06B2,$06B2,$06B1,$06B0,$06B0,$06AF,$06AF
.dw $06AE,$06AD,$06AD,$06AC,$06AC,$06AB,$06AB,$06AA,$06A9,$06A9,$06A8,$06A8,$06A7,$06A6,$06A6,$06A5
.dw $06A5,$06A4,$06A3,$06A3,$06A2,$06A2,$06A1,$06A1,$06A0,$069F,$069F,$069E,$069E,$069D,$069C,$069C
.dw $069B,$069B,$069A,$069A,$0699,$0698,$0698,$0697,$0697,$0696,$0695,$0695,$0694,$0694,$0693,$0693
.dw $0692,$0691,$0691,$0690,$0690,$068F,$068E,$068E,$068D,$068D,$068C,$068B,$068B,$068A,$068A,$0689
.dw $0689,$0688,$0687,$0687,$0686,$0686,$0685,$0684,$0684,$0683,$0683,$0682,$0682,$0681,$0680,$0680
.dw $067F,$067F,$067E,$067D,$067D,$067C,$067C,$067B,$067A,$067A,$0679,$0679,$0678,$0678,$0677,$0676
.dw $0676,$0675,$0675,$0674,$0673,$0673,$0672,$0672,$0671,$0671,$0670,$066F,$066F,$066E,$066E,$066D
.dw $066C,$066C,$066B,$066B,$066A,$0669,$0669,$0668,$0668,$0667,$0667,$0666,$0665,$0665,$0664,$0664
.dw $0663,$0662,$0662,$0661,$0661,$0660,$0660,$065F,$065E,$065E,$065D,$065D,$065C,$065B,$065B,$065A
.dw $065A,$0659,$0659,$0658,$0657,$0657,$0656,$0656,$0655,$0654,$0654,$0653,$0653,$0652,$0651,$0651
.dw $0650,$0650,$064F,$064F,$064E,$064D,$064D,$064C,$064C,$064B,$064A,$064A,$0649,$0649,$0648,$0648
.dw $0647,$0646,$0646,$0645,$0645,$0644,$0643,$0643,$0642,$0642,$0641,$0640,$0640,$063F,$063F,$063E
.dw $063E,$063D,$063C,$063C,$063B,$063B,$063A,$0639,$0639,$0638,$0638,$0637,$0637,$0636,$0635,$0635
.dw $0634,$0634,$0633,$0632,$0632,$0631,$0631,$0630,$062F,$062F,$062E,$062E,$062D,$062D,$062C,$062B
.dw $062B,$062A,$062A,$0629,$0628,$0628,$0627,$0627,$0626,$0626,$0625,$0624,$0624,$0623,$0623,$0622
.dw $0621,$0621,$0620,$0620,$061F,$061E,$061E,$061D,$061D,$061C,$061C,$061B,$061A,$061A,$0619,$0619
.dw $0618,$0617,$0617,$0616,$0616,$0615,$0615,$0614,$0613,$0613,$0612,$0612,$0611,$0610,$0610,$060F
.dw $060F,$060E,$060E,$060D,$060C,$060C,$060B,$060B,$060A,$0609,$0609,$0608,$0608,$0607,$0606,$0606
.dw $0605,$0605,$0604,$0604,$0603,$0602,$0602,$0601,$0601,$0600,$05FF,$05FF,$05FE,$05FE,$05FD,$05FD
.dw $05FC,$05FB,$05FB,$05FA,$05FA,$05F9,$05F8,$05F8,$05F7,$05F7,$05F6,$05F5,$05F5,$05F4,$05F4,$05F3
.dw $05F3,$05F2,$05F1,$05F1,$05F0,$05F0,$05EF,$05EE,$05EE,$05ED,$05ED,$05EC,$05EC,$05EB,$05EA,$05EA
.dw $05E9,$05E9,$05E8,$05E7,$05E7,$05E6,$05E6,$05E5,$05E4,$05E4,$05E3,$05E3,$05E2,$05E2,$05E1,$05E0
.dw $05E0,$05DF,$05DF,$05DE,$05DD,$05DD,$05DC,$05DC,$05DB,$05DB,$05DA,$05D9,$05D9,$05D8,$05D8,$05D7
.dw $05D6,$05D6,$05D5,$05D5,$05D4,$05D4,$05D3,$05D2,$05D2,$05D1,$05D1,$05D0,$05CF,$05CF,$05CE,$05CE
.dw $05CD,$05CC,$05CC,$05CB,$05CB,$05CA,$05CA,$05C9,$05C8,$05C8,$05C7,$05C7,$05C6,$05C5,$05C5,$05C4
.dw $05C4,$05C3,$05C3,$05C2,$05C1,$05C1,$05C0,$05C0,$05BF,$05BE,$05BE,$05BD,$05BD,$05BC,$05BB,$05BB
.dw $05BA,$05BA,$05B9,$05B9,$05B8,$05B7,$05B7,$05B6,$05B6,$05B5,$05B4,$05B4,$05B3,$05B3,$05B2,$05B2
.dw $05B1,$05B0,$05B0,$05AF,$05AF,$05AE,$05AD,$05AD,$05AC,$05AC,$05AB,$05AA,$05AA,$05A9,$05A9,$05A8


tone2_noise_freq:
.db $0025,$0025,$0035,$0037,$0045,$0053,$0047,$0080,$0055,$0055,$0063,$0063,$0057,$0090,$0090,$0090
.db $0065,$0065,$0065,$0073,$0073,$0073,$0073,$0067,$0067,$0067,$00A0,$00A0,$00A0,$00A0,$00A0,$0075
.db $0075,$0075,$0075,$0075,$0075,$0075,$0083,$0083,$0083,$0083,$0083,$0083,$0083,$0077,$0077,$0077
.db $0077,$0077,$0077,$00B0,$00B0,$00B0,$00B0,$00B0,$00B0,$00B0,$00B0,$00B0,$00B0,$0085,$0085,$0085
.db $0085,$0085,$0085,$0085,$0085,$0085,$0085,$0085,$0085,$0085,$0085,$0093,$0093,$0093,$0093,$0093
.db $0093,$0093,$0093,$0093,$0093,$0093,$0093,$0093,$0093,$0087,$0087,$0087,$0087,$0087,$0087,$0087
.db $0087,$0087,$0087,$0087,$0087,$0087,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0
.db $00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$00C0,$0095,$0095,$0095,$0095,$0095,$0095
.db $0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095,$0095
.db $0095,$0095,$0095,$0095,$0095,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3
.db $00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3,$00A3
.db $00A3,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097
.db $0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$0097,$00D0,$00D0,$00D0,$00D0
.db $00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0
.db $00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0,$00D0
.db $00D0,$00D0,$00D0,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5
.db $00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5
.db $00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5
.db $00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00A5,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3
.db $00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3
.db $00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3
.db $00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3,$00B3
.db $00B3,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7
.db $00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7
.db $00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7
.db $00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00A7,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0
.db $00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0
.db $00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0
.db $00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0
.db $00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00E0
.db $00E0,$00E0,$00E0,$00E0,$00E0,$00E0,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5,$00B5
.db $00B5,$00B5,$00B5,$00B5,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3,$00C3
.db $00C3,$00C3,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7,$00B7
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1
.db $00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00E1,$00C5,$00C5,$00C5,$00C5
.db $00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5
.db $00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5
.db $00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5,$00C5


.org $3FFF
.db 0



