;* Hardware register equates.

INIDISP	EQU	$2100	;	Official Designations.
OBJSEL	EQU	$2101
OAMADDL	EQU	$2102
OAMADDH	EQU	$2103
OAMDATAW EQU	$2104
BG_MODE	EQU	$2105
MOSAIC	EQU	$2106
BG1SC	EQU	$2107
BG2SC	EQU	$2108
BG3SC	EQU	$2109
BG4SC	EQU	$210a
BG12NBA	EQU	$210b
BG34NBA	EQU	$210c
BG1HOFS	EQU	$210d
BG1VOFS	EQU	$210e
BG2HOFS	EQU	$210f
BG2VOFS	EQU	$2110
BG3HOFS	EQU	$2111
BG3VOFS	EQU	$2112
BG4HOFS	EQU	$2113
BG4VOFS	EQU	$2114
VMAINC	EQU	$2115
VMADDL	EQU	$2116
VMADDH	EQU	$2117
VMDATA1L EQU	$2118
VMDATA1H EQU	$2119
M7SEL	EQU	$211a
M7A	EQU	$211b
M7B	EQU	$211c
M7C	EQU	$211d
M7D	EQU	$211e
M7X	EQU	$211f
M7Y	EQU	$2120
CG_ADD	EQU	$2121
CG_DATA1 EQU	$2122
W12SEL	EQU	$2123
W34SEL	EQU	$2124
WOBJSEL	EQU	$2125
WH0	EQU	$2126
WH1	EQU	$2127
WH2	EQU	$2128
WH3	EQU	$2129
WBGLOG	EQU	$212a
WOBJLOG	EQU	$212b
TM	EQU	$212c
TS	EQU	$212d
TMW	EQU	$212e
TSW	EQU	$212f
CGSWSEL	EQU	$2130
CGADSUB	EQU	$2131
COLDATA	EQU	$2132
SETINI	EQU	$2133
MPYL	EQU	$2134
MPYM	EQU	$2135
MPYH	EQU	$2136
SLHV	EQU	$2137
OAMDATAR EQU	$2138
VMDATA2L EQU	$2139
VMDATA2H EQU	$213a
CGDATA2	EQU	$213b
OPHCT	EQU	$213c
OPVCT	EQU	$213d
STAT77	EQU	$213e
STAT78	EQU	$213f
APUIO0	EQU	$2140
APUIO1	EQU	$2141
APUIO2	EQU	$2142
APUIO3	EQU	$2143

WMDATA	EQU	$2180
WMADDL	EQU	$2181
WMADDM	EQU	$2182
WMADDH	EQU	$2183

NMITIMEN EQU	$4200
WRIO	EQU	$4201
WRMPYA	EQU	$4202
WRMPYB	EQU	$4203
WRDIVL	EQU	$4204
WRDIVH	EQU	$4205
WRDIVB	EQU	$4206
HTIMEL	EQU	$4207
HTIMEH	EQU	$4208
VTIMEL	EQU	$4209
VTIMEH	EQU	$420a
MDMAEN	EQU	$420b
HDMAEN	EQU	$420c
MEMSEL	EQU	$420d

RDNMI	EQU	$4210
TIMEUP	EQU	$4211
HVBJOY	EQU	$4212
RDIO	EQU	$4213
RDDIVL	EQU	$4214
RDDIVH	EQU	$4215
RDMPYL	EQU	$4216
RDMPYH	EQU	$4217
JOY1L	EQU	$4218
JOY1H	EQU	$4219
JOY2L	EQU	$421a
JOY2H	EQU	$421b
JOY3L	EQU	$421c
JOY3H	EQU	$421d
JOY4L	EQU	$421e
JOY4H	EQU	$421f

START   sei             ;STOP INTERRUPTS
	phk             ;GET THE CURRENT BANK AND STORE ON STACK
	plb             ;GET VALUE OFF STACK AND MAKE IT THE CURRENT
			;PROGRAMMING BANK
	clc             ;CLEAR CARRY BIT
	xce             ;NATIVE 16 BIT MODE (NO 6502 EMULATION!)

;#init.bin
	sep #$30
	lda #$8f
	sta INIDISP
	lda #$00
	sta $2101
	sta $2102
	sta $2103
	sta BG_MODE
	sta MOSAIC
	sta BG1SC
	sta $2108
	sta $2109
	sta $210a
	sta BG12NBA
	sta $210c
	sta BG1HOFS
	sta BG1HOFS
	sta $210e
	sta $210e
	sta $210f
	sta $210f
	sta $2110
	sta $2110
	sta $2111
	sta $2111
	sta $2112
	sta $2112
	sta $2113
	sta $2113
	sta $2114
	sta $2114
	lda #$80
	sta $2115
	lda #$00
	sta $2116
	sta $2117
	sta $211a
	sta $211b
	lda #$01
	sta $211b
	lda #$00
	sta $211c
	sta $211c
	sta $211d
	sta $211d
	sta $211e
	lda #$01
	sta $211e
	lda #$00
	sta $211f
	sta $211f
	sta $2120
	sta $2120
	sta CG_ADD
	sta $2123
	sta $2124
	sta $2125
	sta $2126
	sta $2127
	sta $2128
	sta $2129
	sta $212a
	sta $212b
	sta TM
	sta $212d
	sta $212e
	sta $212f
	lda #$30
	sta $2130
	lda #$00
	sta $2131
	lda #$e0
	sta $2132
	lda #$00
	sta $2133
	sta $4200
	lda #$ff
	sta $4201
	lda #$00
	sta $4202
	sta $4203
	sta $4204
	sta $4205
	sta $4206
	sta $4207
	sta $4208
	sta $4209
	sta $420a
	sta $420b
	sta $420c
	sta $420d

;===========================================================================
;                        END OF INIT ROUTINE
;===========================================================================
	rep     #$30    ; X,Y,A fixed -> 16 bit mode
	sep     #$20    ; Accumulator ->  8 bit mode

	lda     #$10            ; Screen map data @ VRAM location $1000
	sta     BG1SC           ; Plane 0 Map location register
	lda     #$02            ; Plane 0 Tile graphics @ $2000
	sta     BG12NBA         ; Plane 0 Tile graphics register
	lda     #$01            ; MODE 1 value
	sta     BG_MODE         ; Graphics mode register
	lda     #$01            ; Plane 0 value (bit one)
	sta     TM	        ; Plane enable register

	;======( SET COLORS )=========

	lda     #$00
	sta     CG_ADD          ; Set color number to 0 (background)


	ldx	#$0000		;16*2
ColorCLoop
	lda	colortab,x
	sta	CG_DATA1
	inx
	cpx     #$0020
	bne	ColorCLoop

	lda     #$01
	sta     $4200        ; ENABLE JOYPAD READ (bit one)

	; 	HORIZONTALES GRAFIK-OFFSET!
	lda	#$01
        sta     BG1HOFS
        lda     #$00
        sta     BG1HOFS

;---------------------------------------------------------------------------
; Store tiles-data in VRAM with general purpose DMA

	ldx     #$2000      ; Assign VRAM location to $2000
	stx     $2116

        stz     $420B       ; disable all DMA channels
        lda     #$01        ; set DMA transfer parameters
        sta     $4300
        lda     #$18        ; VRAM data address
        sta     $4301
        ldx     #charset    ; base address tiles
        stx     $4302
        stz     $4304       ; bank $00
        lda     #$39        ; number of bytes to transfer: $05E0
        sta     $4305
        lda     #$06
        sta     $4306

        lda     #$01        ; start DMA on channel 0
        sta     $420B

;-------------------------------------------------------------------------
; Store low bytes of screen map data in VRAM with general purpose DMA

	ldx     #$1000      ; Assign VRAM location to $1000
	stx     $2116

        stz     $2115       ; increase VRAM address after writing to $2118
        stz     $420B       ; disable all DMA channels
        stz     $4300       ; set DMA transfer parameters
        ldx     #screen     ; base address screen map data (low bytes only)
        stx     $4302
        stz     $4305       ; number of bytes to transfer: $0400
        lda     #$04
        sta     $4306
        lda     #$01        ; start DMA on channel 0
        sta     $420B
        lda     #$80        ; incrase VRAM address after writing to $2119
        sta     $2115

;-------------------------------------------------------------------------
; Store high bytes of screen map data in VRAM with general purpose DMA
; All zero's transfered !!!!!!!!!!!!

        ldx     #$1000      ; Assign VRAM location to $1000
        stx     $2116

        stz     $420B       ; disable all DMA channels
        lda     #$19        ; VRAM data address (high bytes)
        sta     $4301
        ldx     #zero       ; zero data
;	ldx	#$0100
        stx     $4302
        stz     $4305       ; number of bytes to transfer: $0400
        lda     #$04
        sta     $4306
        lda     #$01        ; start DMA on channel 0
        sta     $420B
        stz     $420B       ; disable all DMA channels

	jsr	FadeColorsIn

	lda     #$0f            ; SCREEN ENABLED, FULL BRIGHTNESS
	sta     INIDISP         ;
	cli                     ; Clear interrupt bit
runaround
;	jsr	WaitBeam

	lda $4210
	and #$80
	beq runaround		; no blank..  jump back!

joypad
	lda     $4212           ; is joypad ready to be read?
	and     #$01
	bne     joypad          ; no? go back until it is!
	lda     $4219           ; read joypad high byte
	and     #$10            ; leave only "start" bit
	bne     reset           ; "start" pressed? go to RESET
	jmp     runaround       ; if not then jump back to loop
reset
	jsr	FadeMosOut	; Mosaic out!


	sep     #$30
	lda     #$00
	pha                     ; push #$00 to stack
	plb                     ; pull #$00 from stack and make it the
				; the programming bank
	jmp.l   START           ; jump long to $008000


WaitBeam			; check for Vertical blank
	lda $4210
	and #$80
	beq WaitBeam		; no blank..  jump back!
	rts

;===========================( COLORS REINCYCLEN )==========================
FadeColorsIn

	php
	sep #$30
	ldy #$00
GetNextCol

	ldx #$05
	sty INIDISP

GetNextOne
	jsr WaitBeam

	cpx #$00
	beq CheckValue
	dex
	bra GetNextOne
CheckValue
	cpy #$0F
	beq ColorsSetted
	iny
	bra GetNextCol
ColorsSetted
	plp
	rts

;===========================( Bild als MOSAIC RAUSCYCLEN )==========================
FadeMosOut
	php
	sep #$30
	ldy #$01
MOS_BIG_LOOP
	ldx #$04
	sty MOSAIC
MOS_WBEAM
	jsr WaitBeam
	cpx #$00
	beq MOS_OK
	dex
	bra MOS_WBEAM
MOS_OK
	cpy #$F1
	beq MOS_READY
	tya
	adc #$10
	tay
	bra MOS_BIG_LOOP
MOS_READY
	plp
	rts


charset
#tweetie.bin

GrafikPos
	dc.b	$00

colortab
	dc.b	$00,$00	;0
	dc.b	$40,$40	;1
	dc.b	$66,$66	;2
	dc.b	$0f,$00	;3
	dc.b	$ff,$02	;4
	dc.b	$ff,$03	;5
	dc.b	$fa,$12	;6
	dc.b	$f0,$00	;7
	dc.b	$88,$88	;8
	dc.b	$13,$00	;9
	dc.b	$1a,$00	;10
	dc.b	$ff,$ff	;11
	dc.b	$ff,$ff	;12
	dc.b	$ff,$ff	;13
	dc.b	$ff,$ff	;14
	dc.b	$ff,$ff	;15

screen
;line 1
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 2
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 3
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 4
	 dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$01,$02,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 5
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$03,$04,$05,$06,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 6
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$07,$08,$09,$0A,$0B,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 7
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $0C,$0D,$0E,$0F,$10,$11,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 8
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $12,$13,$14,$15,$16,$17,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 9
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$18,$19,$1A,$1B,$1C,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 10
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$1D,$1E,$1F,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 11
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$20,$21,$22,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 12
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $23,$24,$25,$26,$27,$28,$29,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
;line 13
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $2A,$2B,$2C,$2D,$2E,$2F,$30,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
         dc.b    $00,$00,$00,$00,$00,$00,$00,$00
zero
