//**********************************************************************
// Sourcecode for Borland C++ 3.1

// WHATS NEW...
//---------------------------------------------------------------------
// - (!) optimized source code !
// - (!) dynamic CONSTANT list and detection of duplicate constants
// - (!) dynamic LABEL list and detection of duplicate labels
// - (!) very fast binary data include routine
//
//     Done by SoNiC (R) -AV [UTG]
//**********************************************************************

#include <stdio.h>
#include <conio.h>
#include <sys\stat.h>
#include <dos.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <io.h>
#include "snesasm.h"

//========== DYNAMIC CONSTANT-HANDLE! =========================
struct CONST_REC
{
	char	*Name;
	char	*Value;
	struct CONST_REC *Next;
};

//========== DYNAMIC LABEL-HANDLE! =========================
struct LABEL_REC
{
	char	*Name;
	long int Addr;
	struct LABEL_REC *Next;
};

#define ERR_UNDEF				1
#define ERR_LABEL2LONG		2
#define ERR_BADINST			3
#define ERR_OPCODE			4
#define ERR_WRONGOPCODE		5
#define ERR_UNKNOWNINST		6
#define ERR_CANTOPEN			7
#define ERR_BRANCHERROR		8
#define ERR_BANKOVERFLOW	9
#define ERR_NOTMEMORY		10
#define ERR_DUPCONSTANT		11
#define ERR_WRONGCONST		12

struct CONST_REC    *ConstStart;
struct LABEL_REC    *LabelStart;

int stype,label,branch,bank,
    dcbCount,dcbval[50],
    error=0,
    r16=0,a16=0,
    noinstr,DataInclude,EndOfFile,
    labeltel=0,
    bytestel,
    inptel,
    ix,xi,ind,dil,dixl,
    hek,x,y,lang,
    LineCount=0,
    inscode,operand1,operand2,operand3;

long int adrestel,volgadr;

char input[100],
     sFirst20Bytes[20],
     instr[4],
     ops[60];
FILE *ft,*fpuit,*ftemp;

main(int argc, char *argv[])
{
	int Count,tel1,handle,flengte;
	unsigned char *Diskbuffer;

	ConstStart=NULL;				// Init Global-Constant-Table ! (Dynamic)
	LabelStart=NULL;				// Init Global-Label-Table ! 	  (Dynamic)

// clrscr();
	printf("SNES ASSEMBLER BY INQUISITION, VERSION 1.01.\n");
	printf("IMPROVMENTS BY SoNiC (R) (C) 1993 V2.0\n\n");

	if (argc!=3)
	{
		printf("USAGE: SNESASM <SOURCE> <DESTINATION>\n");
		exit(1);
 	}

	ft=fopen(argv[1],"r");
	if (ft==NULL)
	{
 		printf("CAN'T OPEN FILE: %s\n",argv[1]);
		exit(1);
	}
	printf("ASSEMBLING FILE: %s.\n\n",argv[1]);
	adrestel=0x8000;
	bank=0;
	volgadr=0x0FFFF;
	printf("LOADING CONSTANTS/LABELS.........................................");

	do
	{
		LineCount++;
  		firstcheck();
		if (EndOfFile) break;

		if (DataInclude)
  		{
			handle=open(sFirst20Bytes,O_RDONLY);
   		if (handle<0) error=ERR_CANTOPEN;
   		else
   		{
				flengte=filelength(handle);
    			adrestel+=flengte;
    			close (handle);
   		}
  		}
  		if (error)
			break;

		adrestel+=bytestel;
  		if ( adrestel > volgadr )
			error=ERR_BANKOVERFLOW;

  		if (error)
			break;
 	}
	while(!EndOfFile);

	if (!error)
	{
		printf("OK.\n");
		printf("CREATING AND INITIALIZING OUTPUT FILE............................");
		handle=creat(argv[2],S_IREAD|S_IWRITE);
		if (handle<0)
		{
			printf("\nCAN'T CREAT FILE: %s\n",argv[2]);
			_dos_setfileattr(argv[2],_A_NORMAL);
   		exit(1);
  		}
		chsize(handle,(bank+1)*32768+512);
		close(handle);
		_dos_setfileattr(argv[2],_A_NORMAL);

		fpuit=fopen(argv[2],"rb+b");
		if (fpuit==NULL)
		{
			printf("\nCAN'T MAKE FILE: %s\n",argv[2]);
			fclose(ft);
			exit(1);
  		}

		operand1=(bank+1)*4;
		putc(operand1,fpuit);
		fseek(fpuit,33277,SEEK_SET);
		putc(0x80,fpuit);

		fseek(fpuit,512,SEEK_SET);
		adrestel=0x8000;
		bank=0;
		volgadr=0x0ffff;
		rewind(ft);
	}

	if (!error)
	{
		LineCount=0;
		printf("OK.\n");
		printf("CHECKING INSTRUCTIONS/OPCODES AND GENERATING CODE................");
	}

	if (!error)
		do
		{
			LineCount++;
			seccheck();
			if (error || EndOfFile) break;

	  		adrestel+=bytestel;

  			if (adrestel>volgadr) error=ERR_BANKOVERFLOW;
	  		if (error) 	break;

  			if (!noinstr)
	  		{
				zoek();
	   		if (error)
					break;
	   		else
   			{
					putc(inscode,fpuit);
   	 			if (bytestel==4) putc(operand3,fpuit);
    				if (bytestel>=3) putc(operand2,fpuit);
	    			if (bytestel>=2) putc(operand1,fpuit);
			   }
			}
  			else if (dcbCount)
			   for (tel1=0;tel1<dcbCount;tel1++) putc(dcbval[tel1],fpuit);
 			else if (DataInclude)
  			{
				if( (ftemp=fopen(sFirst20Bytes,"rb"))==NULL)
					error=ERR_CANTOPEN;
				else
				{
					fseek(ftemp,0L,SEEK_END);
					flengte=ftell(ftemp);		// Attention: INT
					fseek(ftemp,0L,SEEK_SET);
					if( (Diskbuffer=(unsigned char *) malloc(flengte+1))==NULL)
						error=ERR_NOTMEMORY;
					else
					{
						fread (Diskbuffer,flengte,1,ftemp);
						fwrite(Diskbuffer,flengte,1,fpuit);
     					adrestel+=flengte;
						free(Diskbuffer);
					}
					fclose(ftemp);
				}
  			}
		}	while(!EndOfFile && !error);

	if (error)
		errmsg();
	else
		printf("OK.\n\nEXECUTABLE FILE: %s.\n",argv[2]);

	fclose(ft);
	fclose(fpuit);

	return 1;
}
//=========================================================================

void firstcheck(void)
{
	int StrLen;
	char *EQUSTR="EQU";

	haalin();
	if (error || DataInclude || EndOfFile)
		return;

	if (!strcmp(sFirst20Bytes,"@BANK_UP") || !strcmp(sFirst20Bytes,"@bank_up"))
		return;

	StrLen=strlen(sFirst20Bytes);

	if ( StrLen )
	{

		// Check for ":"
		if ( sFirst20Bytes[StrLen-1] == ':')	// LABEL with ":" ???
		{
			if (!strcmp(instr,EQUSTR))
			{
				error=ERR_WRONGCONST;
				return;
			}
			else
				sFirst20Bytes[StrLen-1]='\0';
		}

		// PRE-CHECK!

		if (SearchConst(sFirst20Bytes) != NULL ||		// Name already used!?
			 SearchLabel(sFirst20Bytes) != -1L )
		{
			error=ERR_DUPCONSTANT;
			return;
		}

		if (!strcmp(instr,EQUSTR))
			AddConst(sFirst20Bytes , ops);
  		else
			AddLabel(sFirst20Bytes , adrestel);
 	}

	if (!label && !noinstr)
		haalops();
	else
		if (label)
 		{
			if (branch)
  			{
				if (!strcmp(instr,"BRL")) bytestel=3;
   			else bytestel=2;
  			}
  			else bytestel=3+lang;
 		}
}
//======================================================================

void seccheck(void)
{
	int tel2,convtel=0;
	long int positie,liAddrTemp;

	haalin();

	if (error || DataInclude || EndOfFile)
		return;

 	if (noinstr && (!strcmp(sFirst20Bytes,"@bank_up")||!strcmp(sFirst20Bytes,"@BANK_UP")))
 	{
		positie=512+((long int)bank)*32768;
  		fseek(fpuit,positie,SEEK_SET);
  		return;
 	}

 	if (label)
 	{
		error=ERR_OPCODE;
		if ((liAddrTemp=SearchLabel( ops )) != -1L)	// CHECK FOR LABEL
		{							  								// FOUND...
			error=0;
  			if (branch)
  			{
				if (!strcmp(instr,"BRL"))
   			{
					if(labs(liAddrTemp-(adrestel+3))>16384)
     				{
						error=ERR_BRANCHERROR;
     					return;
     				}
     				operand2=(liAddrTemp-(adrestel+3))&0x0000FF;
     				operand1=(liAddrTemp-(adrestel+3))&0x00FFFF;
     				operand1=operand1>>16;
     				operand1=operand1&0x00FF;
     				bytestel=3;
  				}
  				else
  				{
					if (labs(liAddrTemp-(adrestel+3))>128)
    				{
						error=ERR_BRANCHERROR;
     					return;
     				}
     				operand1=(liAddrTemp-(adrestel+2))&0x0000FF;
			      bytestel=2;
  				}
  			}
 			else
  			{
				if (lang)
  				{
					sprintf(ops,"%6.0lx",liAddrTemp);
     				for (tel2=0; tel2 < strlen(ops); tel2++)
     				if (isspace(ops[tel2]))
						ops[tel2]='0';

					getop(&convtel,&operand1);
			      getop(&convtel,&operand2);
     				getop(&convtel,&operand3);
  				}
  				else
  				{
					sprintf(ops,"%4.0x",liAddrTemp & 0x00FFFF);
     				getop(&convtel,&operand1);
     				getop(&convtel,&operand2);
  				}
  				bytestel=3+lang;
  			}
 		}
	}

	if ( !label && !noinstr )
		haalops();
}

void CheckBranch(void)
{
	int i;
	char *Branches[10]={ "CC","CS","EQ","MI","NE","RA","VC","VS","PL","RL" };
	for(i=0;i < 10;i++)
		if(instr[0]=='B' && !strcmp(&instr[1],Branches[i]))
		{
			branch=1;
			break;
		}
}

void haalops(void)
{
	int Count=0;
	if (ops[0]=='$')
	{
		Count++;
		getop(&Count,&operand1);
		getop(&Count,&operand2);
		getop(&Count,&operand3);
	}
	else
		if (ops[0]!='\0')
		{
			error=ERR_OPCODE;
 			return;
 		}

	if (!strcmp(instr,"REP"))
	{
		if (operand1&0x0020) a16=1;
		if (operand1&0x0010) r16=1;
	}

	if (!strcmp(instr,"SEP"))
	{
		if (operand1&0x0020) a16=0;
		if (operand1&0x0010) r16=0;
	}
}


void StrCpyPart(char *s1,char *s2,int Length)
{
	int Count=0;
	while ( Count<Length && *(s1+inptel) != '\0' &&
	!isspace(*(s1+inptel)))
		*(s2+Count++)=*(s1+inptel++);
	*(s2+Count)='\0';
}

void haalin(void)
{
	char *cptrTemp;
	int  i,j,StrLen;
	char ltempstr[30];
	unsigned char cTemp;

	label=lang=stype=dcbCount=inptel=noinstr=bytestel=0;
	hek=x=y=branch=EndOfFile=DataInclude=0;
	ix=xi=ind=dil=dixl=0;

	fgets(input,99,ft);		// READ ONE LINE (MAX. 99 CHARACTER!)

	if(feof(ft))
	{
		EndOfFile=1;
		return;
	}

	StrLen=strlen(input);

	// NEW!!!--> KILL TAB AND 0FF CHARACTER!
	j=0;
	for(i=0;i < StrLen;i++)
	{
		cTemp=input[i];
		if(cTemp==0x09 || cTemp==0xff)
			cTemp=' ';
		input[j++]=cTemp;
	}

	// NEW!!--> REMOVE RETURN!
	for(i=strlen(input)-1;i>=0;--i)
	{
		if(input[i]==0x0d || input[i]==0x0a)
			input[i]='\0';
		else
			break;
	}


	if(input[0]=='@'||input[0]=='#' || input[0]=='\0' || !isspace(input[0]))
	{
		if (input[0]==';' || input[0]=='\0')
  		{
			noinstr=1;
   		sFirst20Bytes[0]='\0';
   		return;
  		}

		StrCpyPart(input,sFirst20Bytes,19);	// INPTEL WIRD GEAENDERT!

		if (input[0]=='#')
		{
			strcpy(ltempstr,sFirst20Bytes+1);
			strcpy(sFirst20Bytes,ltempstr);
			DataInclude=1;
			noinstr=1;
			return;
		}

		if (!strcmp(sFirst20Bytes,"@bank_up")||!strcmp(sFirst20Bytes,"@BANK_UP"))
		{
			bank++;
			adrestel=0x8000;
			adrestel+=((long int)bank)<<16;
			volgadr=0xffff;
			volgadr+=((long int)bank)<<16;
			noinstr=1;
			return;
		}

		if (!(input[inptel]=='\0' || isspace(input[inptel])))
  		{
			error=ERR_LABEL2LONG;
   		return;
  		}
 	}
	else
		sFirst20Bytes[0]='\0';

	while (input[inptel]!='\0' && isspace(input[inptel]))
		inptel++;

	if (input[inptel]==';'|| input[inptel]=='\0')
	{
		noinstr=1;
		return;
	}

	StrCpyPart(input,instr,3);			// GET INSTRUCTION

	if (strlen(instr)==3)				// UPPER INSTRUCTION
	{
		instr[0]=toupper(instr[0]);
  		instr[1]=toupper(instr[1]);
  		instr[2]=toupper(instr[2]);
 	}

	if (!(strlen(instr)==3 && (input[inptel]=='\0' ||
     isspace(input[inptel])||(!strcmp(instr,"DC.")&&(input[inptel]=='B'||
     input[inptel]=='b'))||(input[inptel]=='.'&&(input[inptel+1]=='l'||
     input[inptel+1]=='L')))))
 	{
		error=ERR_BADINST;
  		return;
 	}

	if (input[inptel]=='.')
	{
		inptel+=2;
		lang=1;
 	}
	else
		if (input[inptel]=='B' || input[inptel]=='b')
			inptel++;

	if (!(!strcmp(instr,"EQU") || !strcmp(instr,"DC.")))
		bytestel++;
  	else
		noinstr=1;

	while (input[inptel]!='\0' && isspace(input[inptel]))
		inptel++;

	if (input[inptel]==';' || input[inptel]=='\0')
 	{
		ops[0]='\0';
  		return;
 	}

	if (strcmp(instr,"DC."))
		StrCpyPart(input,ops,59);

	if (!noinstr)
 	{
		if (ops[0]=='(')
		{
			strcpy(ltempstr,ops+1);
			strcpy(ops,ltempstr);
			if (!strcmp(ops+strlen(ops)-3,"),y")||
			    !strcmp(ops+strlen(ops)-3,"),Y"))
   		{
				ix=1;
    			ops[strlen(ops)-3]='\0';
   		}
			else
				if (!strcmp(ops+strlen(ops)-3,",x)") ||
					 !strcmp(ops+strlen(ops)-3,",X)"))
   			{
					xi=1;
    				ops[strlen(ops)-3]='\0';
   			}
   			else
					if (ops[strlen(ops)-1]==')')
   			{
					ind=1;
    				ops[strlen(ops)-1]='\0';
   			}
   			else
					error=ERR_OPCODE;
  		}
  		else
			if (ops[0]=='[')
  			{
				strcpy(ltempstr,ops+1);
   			strcpy(ops,ltempstr);
   			if (!strcmp(ops+strlen(ops)-3,"],y")||
				    !strcmp(ops+strlen(ops)-3,"],Y"))
   			{
//					printf("dixl detected!\n");

					dixl=1;
    				ops[strlen(ops)-3]='\0';
   			}
			   else
					if (ops[strlen(ops)-1]==']')
   				{
						dil=1;
    					ops[strlen(ops)-1]='\0';
   				}
   				else
						error=ERR_OPCODE;
  			}
  			else
				if (!strcmp(ops+strlen(ops)-2,",x")||
				    !strcmp(ops+strlen(ops)-2,",X"))
  				{
					x=1;
   				ops[strlen(ops)-2]='\0';
  				}
  				else
					if (!strcmp(ops+strlen(ops)-2,",y")||
						 !strcmp(ops+strlen(ops)-2,",Y"))
  					{
						y=1;
					   ops[strlen(ops)-2]='\0';
  					}

  		if (ops[0]=='#' && isalpha(ops[1]))
		{
			hek=1;
			strcpy(ltempstr,ops+1);
			strcpy(ops,ltempstr);
		}

		if (isalpha(ops[0]))
		{
			label=1;
			if ((cptrTemp=SearchConst( ops )) != NULL)	// CHECK FOR CONSTANT
			{
				strcpy(ops,cptrTemp);							// COPY VALUE TO OPS
				label=0;
			}
  		}

		if (ops[0]=='#' && ops[1]=='$')
		{
			hek=1;
			strcpy(ltempstr,ops+1);
 			strcpy(ops,ltempstr);
		}

  		if (label)
			CheckBranch();
	}
	else
		if (!strcmp(instr,"DC."))
 		{
			if (input[inptel]=='$')
  			{
				StrCpyPart(input,ops,59);

				i=1;
   			while (i < strlen(ops))
   			{
					if ( getop(&i,&dcbval[dcbCount]) )
    				{
//						printf("________>%02x<______\n",dcbval[dcbCount]);
//						getch();

						dcbCount++;
     					if (!(ops[i]=='\0'||
						     (ops[i++]==',' && ops[i++]=='$')))
     					{
							error=ERR_OPCODE;
      					return;
     					}
    				}
    				else
    				{
						error=ERR_OPCODE;
     					return;
				   }
   			}
  			}
  			else
				if (input[inptel]=='"')
  				{
					inptel++;
   				while (input[inptel]!='"' && input[inptel]!='\0')
    					ops[i++]=input[inptel++];
   				ops[i]='\0';
   				if (input[inptel]=='\0')
   				{
						error=ERR_OPCODE;
    					return;
   				}

					i=0;
   				while (ops[i]!='\0')
   				{
						dcbval[dcbCount++] = (ops[i++]) & 0x00FF;
    					bytestel++;
   				}
  				}
  				else
					error=ERR_OPCODE;
 		}
}


int getop(int *Count,int *opr)
{
	char hulp[4];
	if (isxdigit(ops[*Count]) && isxdigit(ops[(*Count)+1]))
	{
		hulp[0]='0';
		hulp[3]='\0';
		bytestel++;
		hulp[1]=ops[(*Count)++];
		hulp[2]=ops[(*Count)++];
		sscanf(hulp,"%x",opr);
		return 1;
	}
	return 0;
}

void errmsg(void)
{
	printf("\nERROR IN LINE %d : ",LineCount);
	switch(error)
	{
		case ERR_UNDEF			 : printf("UNDEFINED.");	break;
		case ERR_LABEL2LONG	 : printf("LABELNAME TOO LONG (MAX 14 CHARS.)."); break;
  		case ERR_BADINST		 : printf("BAD INSTRUCTION."); break;
  		case ERR_OPCODE		 : printf("TYPE MISTAKE IN OPCODE."); break;
		case ERR_WRONGOPCODE	 : printf("OPCODE IS INCORRECT."); break;
		case ERR_UNKNOWNINST	 : printf("UNKNOWN INSTRUCTION"); break;
		case ERR_CANTOPEN		 : printf("CAN'T OPEN FILE"); break;
		case ERR_BRANCHERROR	 : printf("BRANCH ERROR: DESTINATION TOO FAR"); break;
		case ERR_BANKOVERFLOW : printf("BANK OVERFLOW"); break;
		case ERR_NOTMEMORY	 : printf("OUT OF DOS-MEMORY"); break;
		case ERR_DUPCONSTANT	 : printf("DUPLICATE LABEL- AND/OR CONSTANTNAME!"); break;
		case ERR_WRONGCONST   : printf("COLON NOT ALLOWED"); break;
	}
 	printf("\n%s",input);
}

//======================================================================

void zoek(void)
{int hulp;
 hulp=strcmp(instr,"PER");
 if (hulp<0) zoek1();
 else if (hulp>0) zoek45();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x0062;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek1(void)
{int hulp;
 hulp=strcmp(instr,"CPY");
 if (hulp<0) zoek2();
 else if (hulp>0) zoek24();
 else
 {if (bytestel==2+r16&&hek&&!x&&!y) inscode=0x00C0;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x00C4;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00CC;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek2(void)
{int hulp;
 hulp=strcmp(instr,"BRK");
 if (hulp<0) zoek3();
 else if (hulp>0) zoek14();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0000;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek3(void)
{int hulp;
 hulp=strcmp(instr,"BEQ");
 if (hulp<0) zoek4();
 else if (hulp>0) zoek9();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x00F0;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek4(void)
{int hulp;
 hulp=strcmp(instr,"ASL");
 if (hulp<0) zoek5();
 else if (hulp>0) zoek7();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0006;
  else if(bytestel==1) inscode=0x000A;
  else if(bytestel==3&&!hek&&!x&&!y) inscode=0x000E;
  else if(bytestel==2&&!hek&&x&&!y) inscode=0x0016;
  else if(bytestel==3&&!hek&&x&&!y) inscode=0x001E;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek5(void)
{int hulp;
 hulp=strcmp(instr,"AND");
 if (hulp<0) zoek6();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x0021;
   else if (ix) inscode=0x0031;
   else if (ind) inscode=0x0032;
   else if (dil) inscode=0x0027;
   else if (dixl) inscode=0x0037;
   else if (!x) inscode=0x0025;
   else if (x) inscode=0x0035;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x0029;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x002D;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x002F;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x0039;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x003D;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x003F;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek6(void)
{int hulp;
 hulp=strcmp(instr,"ADC");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x0061;
   else if (ix) inscode=0x0071;
   else if (ind) inscode=0x0072;
   else if (dil) inscode=0x0067;
   else if (dixl) inscode=0x0077;
   else if (!x) inscode=0x0065;
   else if (x) inscode=0x0075;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x0069;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x006D;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x006F;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x0079;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x007D;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x007F;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek7(void)
{int hulp;
 hulp=strcmp(instr,"BCC");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek8();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0090;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek8(void)
{int hulp;
 hulp=strcmp(instr,"BCS");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x00B0;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek9(void)
{int hulp;
 hulp=strcmp(instr,"BNE");
 if (hulp<0) zoek10();
 else if (hulp>0) zoek12();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x00D0;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek10(void)
{int hulp;
 hulp=strcmp(instr,"BMI");
 if (hulp<0) zoek11();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0030;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek11(void)
{int hulp;
 hulp=strcmp(instr,"BIT");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0024;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x002C;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0034;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x003C;
  else if (bytestel==2&&hek&&!x&&!y) inscode=0x0089;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek12(void)
{int hulp;
 hulp=strcmp(instr,"BPL");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek13();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0010;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek13(void)
{int hulp;
 hulp=strcmp(instr,"BRA");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0080;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek14(void)
{int hulp;
 hulp=strcmp(instr,"CLD");
 if (hulp<0) zoek15();
 else if (hulp>0) zoek19();
 else
 {if (bytestel==1) inscode=0x00D8;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek15(void)
{int hulp;
 hulp=strcmp(instr,"BVC");
 if (hulp<0) zoek16();
 else if (hulp>0) zoek17();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0050;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek16(void)
{int hulp;
 hulp=strcmp(instr,"BRL");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x0082;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek17(void)
{int hulp;
 hulp=strcmp(instr,"BVS");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek18();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0070;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek18(void)
{int hulp;
 hulp=strcmp(instr,"CLC");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0018;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek19(void)
{int hulp;
 hulp=strcmp(instr,"CMP");
 if (hulp<0) zoek20();
 else if (hulp>0) zoek22();
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x00C1;
   else if (ix) inscode=0x00D1;
   else if (ind) inscode=0x00D2;
   else if (dil) inscode=0x00C7;
   else if (dixl) inscode=0x00D7;
   else if (!x) inscode=0x00C5;
   else if (x) inscode=0x00D5;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x00C9;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00CD;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x00CF;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x00D9;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x00DD;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x00DF;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek20(void)
{int hulp;
 hulp=strcmp(instr,"CLV");
 if (hulp<0) zoek21();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00B8;
  error=ERR_WRONGOPCODE;
 }
}

void zoek21(void)
{int hulp;
 hulp=strcmp(instr,"CLI");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0058;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek22(void)
{int hulp;
 hulp=strcmp(instr,"COP");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek23();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0002;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek23(void)
{int hulp;
 hulp=strcmp(instr,"CPX");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2+r16&&hek&&!x&&!y) inscode=0x00E0;
  else if(bytestel==2&&!hek&&!x&&!y) inscode=0x00E4;
  else if(bytestel==3&&!hek&&!x&&!y) inscode=0x00EC;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek24(void)
{int hulp;
 hulp=strcmp(instr,"JSR");
 if (hulp<0) zoek25();
 else if (hulp>0) zoek35();
 else
 {if (bytestel==3&&!hek&&xi) inscode=0x00FC;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x0020;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek25(void)
{int hulp;
 hulp=strcmp(instr,"INX");
 if (hulp<0) zoek26();
 else if (hulp>0) zoek31();
 else
 {if (bytestel==1) inscode=0x00E8;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek26(void)
{int hulp;
 hulp=strcmp(instr,"DEY");
 if (hulp<0) zoek27();
 else if (hulp>0) zoek29();
 else
 {if (bytestel==1) inscode=0x0088;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek27(void)
{int hulp;
 hulp=strcmp(instr,"DEX");
 if (hulp<0) zoek28();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00CA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek28(void)
{int hulp;
 hulp=strcmp(instr,"DEC");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x003A;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x00C6;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00CE;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x00D6;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x00DE;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek29(void)
{int hulp;
 hulp=strcmp(instr,"EOR");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek30();
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x0041;
   else if (ix) inscode=0x0051;
   else if (ind) inscode=0x0052;
   else if (dil) inscode=0x0047;
   else if (dixl) inscode=0x0057;
   else if (!x) inscode=0x0045;
   else if (x) inscode=0x0055;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x0049;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x004D;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x004F;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x0059;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x005D;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x005F;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek30(void)
{int hulp;
 hulp=strcmp(instr,"INC");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x001A;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x00E6;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00EE;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x00F6;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x00FE;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek31(void)
{int hulp;
 hulp=strcmp(instr,"JML");
 if (hulp<0) zoek32();
 else if (hulp>0) zoek33();
 else
 {if (bytestel==3&&!hek&&ind) inscode=0x00DC;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek32(void)
{int hulp;
 hulp=strcmp(instr,"INY");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00C8;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek33(void)
{int hulp;
 hulp=strcmp(instr,"JMP");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek34();
 else
 {if (bytestel==3&&!hek&&ind) inscode=0x006C;
  else if (bytestel==3&&!hek&&xi) inscode=0x007C;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x004C;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x005C;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek34(void)
{int hulp;
 hulp=strcmp(instr,"JSL");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==4&&!hek&&!x&&!y) inscode=0x0022;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek35(void)
{int hulp;
 hulp=strcmp(instr,"MVP");
 if (hulp<0) zoek36();
 else if (hulp>0) zoek41();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x0044;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek36(void)
{int hulp;
 hulp=strcmp(instr,"LDY");
 if (hulp<0) zoek37();
 else if (hulp>0) zoek39();
 else
 {if (bytestel==2+r16&&hek&&!x&&!y) inscode=0x00A0;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x00A4;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00AC;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x00B4;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x00BC;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek37(void)
{int hulp;
 hulp=strcmp(instr,"LDX");
 if (hulp<0) zoek38();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2+r16&&hek&&!x&&!y) inscode=0x00A2;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x00A6;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00AE;
  else if (bytestel==2&&!hek&&!x&&y) inscode=0x00B6;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x00BE;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek38(void)
{int hulp;
 hulp=strcmp(instr,"LDA");
/*
 printf("DEBUG-INFO:\n");
 printf("Input    [%s]\n",input);
 printf("bytestel %d\n",bytestel);
 printf("hek:     %d\n",hek);
 printf("xi:      %d\n",xi);
 printf("ix:      %d\n",ix);
 printf("ind:     %d\n",ind);
 printf("dil:     %d\n",dil);
 printf("dixl:    %d\n",dixl);
 printf("x:       %d\n",x);
 printf("y:       %d\n",y);
*/
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x00A1;
   else if (ix) inscode=0x00B1;
   else if (ind) inscode=0x00B2;
   else if (dil) inscode=0x00A7;
   else if (dixl) inscode=0x00B7;
   else if (!x) inscode=0x00A5;
   else if (x) inscode=0x00B5;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&& !x && !y) inscode=0x00A9;
  else if (bytestel==3 && !hek &&  x && !y) inscode=0x00BD;
  else if (bytestel==3 && !hek && !x && !y) inscode=0x00AD;
  else if (bytestel==4 && !hek && !x && !y) inscode=0x00AF;
  else if (bytestel==3 && !hek && !x &&  y) inscode=0x00B9;
  else if (bytestel==4 && !hek &&  x && !y) inscode=0x00BF;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek39(void)
{int hulp;
 hulp=strcmp(instr,"LSR");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek40();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x004E;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x005E;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x0046;
  else if (bytestel==1) inscode=0x004A;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0056;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek40(void)
{int hulp;
 hulp=strcmp(instr,"MVN");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x0054;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek41(void)
{int hulp;
 hulp=strcmp(instr,"ORA");
 if (hulp<0) zoek42();
 else if (hulp>0) zoek43();
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x0001;
   else if (ix) inscode=0x0011;
   else if (ind) inscode=0x0012;
   else if (dil) inscode=0x0007;
   else if (dixl) inscode=0x0017;
   else if (!x) inscode=0x0005;
   else if (x) inscode=0x0015;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x0009;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x000D;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x000F;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x0019;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x001D;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x001F;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek42(void)
{int hulp;
 hulp=strcmp(instr,"NOP");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00EA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek43(void)
{int hulp;
 hulp=strcmp(instr,"PEA");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek44();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x00F4;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek44(void)
{int hulp;
 hulp=strcmp(instr,"PEI");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x00D4;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek45(void)
{int hulp;
 hulp=strcmp(instr,"SEP");
 if (hulp<0) zoek46();
 else if (hulp>0) zoek69();
 else
 {if (bytestel==2&&hek&&!x&&!y) inscode=0x00E2;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek46(void)
{int hulp;
 hulp=strcmp(instr,"PLX");
 if (hulp<0) zoek47();
 else if (hulp>0) zoek58();
 else
 {if (bytestel==1) inscode=0x00FA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek47(void)
{int hulp;
 hulp=strcmp(instr,"PHX");
 if (hulp<0) zoek48();
 else if (hulp>0) zoek53();
 else
 {if (bytestel==1) inscode=0x00DA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek48(void)
{int hulp;
 hulp=strcmp(instr,"PHD");
 if (hulp<0) zoek49();
 else if (hulp>0) zoek51();
 else
 {if (bytestel==1) inscode=0x000D;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek49(void)
{int hulp;
 hulp=strcmp(instr,"PHB");
 if (hulp<0) zoek50();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x008B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek50(void)
{int hulp;
 hulp=strcmp(instr,"PHA");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0048;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek51(void)
{int hulp;
 hulp=strcmp(instr,"PHK");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek52();
 else
 {if (bytestel==1) inscode=0x004B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek52(void)
{int hulp;
 hulp=strcmp(instr,"PHP");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0008;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek53(void)
{int hulp;
 hulp=strcmp(instr,"PLB");
 if (hulp<0) zoek54();
 else if (hulp>0) zoek56();
 else
 {if (bytestel==1) inscode=0x00AB;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek54(void)
{int hulp;
 hulp=strcmp(instr,"PLA");
 if (hulp<0) zoek55();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0068;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek55(void)
{int hulp;
 hulp=strcmp(instr,"PHY");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x005A;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek56(void)
{int hulp;
 hulp=strcmp(instr,"PLD");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek57();
 else
 {if (bytestel==1) inscode=0x002B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek57(void)
{int hulp;
 hulp=strcmp(instr,"PLP");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0028;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek58(void)
{int hulp;
 hulp=strcmp(instr,"RTL");
 if (hulp<0) zoek59();
 else if (hulp>0) zoek64();
 else
 {if (bytestel==1) inscode=0x006B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek59(void)
{int hulp;
 hulp=strcmp(instr,"ROL");
 if (hulp<0) zoek60();
 else if (hulp>0) zoek62();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0026;
  else if (bytestel==1) inscode=0x002A;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x002E;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0036;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x003E;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek60(void)
{int hulp;
 hulp=strcmp(instr,"REP");
 if (hulp<0) zoek61();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&hek&&!x&&!y) inscode=0x00C2;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek61(void)
{int hulp;
 hulp=strcmp(instr,"PLY");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x007A;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek62(void)
{int hulp;
 hulp=strcmp(instr,"ROR");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek63();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0066;
  else if (bytestel==1) inscode=0x006A;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x006E;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0076;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x007E;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek63(void)
{int hulp;
 hulp=strcmp(instr,"RTI");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0040;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek64(void)
{int hulp;
 hulp=strcmp(instr,"SEC");
 if (hulp<0) zoek65();
 else if (hulp>0) zoek67();
 else
 {if (bytestel==1) inscode=0x0038;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek65(void)
{int hulp;
 hulp=strcmp(instr,"SBC");
 if (hulp<0) zoek66();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x00E1;
   else if (ix) inscode=0x00F1;
   else if (ind) inscode=0x00F2;
   else if (dil) inscode=0x00E7;
   else if (dixl) inscode=0x00F7;
   else if (!x) inscode=0x00E5;
   else if (x) inscode=0x00F5;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==2+a16&&hek&&!x&&!y) inscode=0x00E9;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x00ED;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x00EF;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x00F9;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x00FD;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x00FF;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek66(void)
{int hulp;
 hulp=strcmp(instr,"RTS");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0060;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek67(void)
{int hulp;
 hulp=strcmp(instr,"SED");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek68();
 else
 {if (bytestel==1) inscode=0x00F8;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek68(void)
{int hulp;
 hulp=strcmp(instr,"SEI");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0078;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek69(void)
{int hulp;
 hulp=strcmp(instr,"TSB");
 if (hulp<0) zoek70();
 else if (hulp>0) zoek81();
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0004;
  else if(bytestel==3&&!hek&&!x&&!y) inscode=0x000C;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek70(void)
{int hulp;
 hulp=strcmp(instr,"TAX");
 if (hulp<0) zoek71();
 else if (hulp>0) zoek76();
 else
 {if (bytestel==1) inscode=0x00AA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek71(void)
{int hulp;
 hulp=strcmp(instr,"STX");
 if (hulp<0) zoek72();
 else if (hulp>0) zoek74();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x008E;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x0086;
  else if (bytestel==2&&!hek&&!x&&y) inscode=0x0096;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek72(void)
{int hulp;
 hulp=strcmp(instr,"STP");
 if (hulp<0) zoek73();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00DB;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek73(void)
{int hulp;
 hulp=strcmp(instr,"STA");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!y)
  {if (xi) inscode=0x0081;
   else if (ix) inscode=0x0091;
   else if (ind) inscode=0x0092;
   else if (dil) inscode=0x0087;
   else if (dixl) inscode=0x0097;
   else if (!x) inscode=0x0085;
   else if (x) inscode=0x0095;
   else error=ERR_WRONGOPCODE;
  }
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x008D;
  else if (bytestel==4&&!hek&&!x&&!y) inscode=0x008F;
  else if (bytestel==3&&!hek&&!x&&y) inscode=0x0099;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x009D;
  else if (bytestel==4&&!hek&&x&&!y) inscode=0x009F;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek74(void)
{int hulp;
 hulp=strcmp(instr,"STY");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek75();
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x008C;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x0084;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0094;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek75(void)
{int hulp;
 hulp=strcmp(instr,"STZ");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==3&&!hek&&!x&&!y) inscode=0x009C;
  else if (bytestel==2&&!hek&&!x&&!y) inscode=0x0064;
  else if (bytestel==2&&!hek&&x&&!y) inscode=0x0074;
  else if (bytestel==3&&!hek&&x&&!y) inscode=0x009E;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek76(void)
{int hulp;
 hulp=strcmp(instr,"TCS");
 if (hulp<0) zoek77();
 else if (hulp>0) zoek79();
 else
 {if (bytestel==1) inscode=0x001B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek77(void)
{int hulp;
 hulp=strcmp(instr,"TCD");
 if (hulp<0) zoek78();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x005B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek78(void)
{int hulp;
 hulp=strcmp(instr,"TAY");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00A8;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek79(void)
{int hulp;
 hulp=strcmp(instr,"TDC");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek80();
 else
 {if (bytestel==1) inscode=0x007B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek80(void)
{int hulp;
 hulp=strcmp(instr,"TRB");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==2&&!hek&&!x&&!y) inscode=0x0014;
  else if (bytestel==3&&!hek&&!x&&!y) inscode=0x001C;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek81(void)
{int hulp;
 hulp=strcmp(instr,"TXY");
 if (hulp<0) zoek82();
 else if (hulp>0) zoek86();
 else
 {if (bytestel==1) inscode=0x009B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek82(void)
{int hulp;
 hulp=strcmp(instr,"TSX");
 if (hulp<0) zoek83();
 else if (hulp>0) zoek84();
 else
 {if (bytestel==1) inscode=0x00BA;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek83(void)
{int hulp;
 hulp=strcmp(instr,"TSC");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x003B;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek84(void)
{int hulp;
 hulp=strcmp(instr,"TXA");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek85();
 else
 {if (bytestel==1) inscode=0x008A;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek85(void)
{int hulp;
 hulp=strcmp(instr,"TXS");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x009A;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek86(void)
{int hulp;
 hulp=strcmp(instr,"WAI");
 if (hulp<0) zoek87();
 else if (hulp>0) zoek89();
 else
 {if (bytestel==1) inscode=0x00CB;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek87(void)
{int hulp;
 hulp=strcmp(instr,"TYX");
 if (hulp<0) zoek88();
 else if (hulp>0) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00BB;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek88(void)
{int hulp;
 hulp=strcmp(instr,"TYA");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x0098;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek89(void)
{int hulp;
 hulp=strcmp(instr,"XBA");
 if (hulp<0) error=ERR_UNKNOWNINST;
 else if (hulp>0) zoek90();
 else
 {if (bytestel==1) inscode=0x00EB;
  else error=ERR_WRONGOPCODE;
 }
}

void zoek90(void)
{int hulp;
 hulp=strcmp(instr,"XCE");
 if (hulp) error=ERR_UNKNOWNINST;
 else
 {if (bytestel==1) inscode=0x00FB;
  else error=ERR_WRONGOPCODE;
 }
}

//======================( STRINGBUFFER ALLOCATE AND COPY )================
char *DynamicStr(char *source)
{
	int i,slen;
	char *NewStr;
	slen=strlen(source);
	if( (NewStr=malloc(slen+1))==NULL)
	{
		error=ERR_NOTMEMORY;
		errmsg();
		exit(1);
	}

	for(i=slen;i>=0;i--)
		*(NewStr+i) = *(source+i);

	return(NewStr);
}

//========( Allocate Memory for one Constant! )===============================
struct CONST_REC *GetConstSpace(void)
{
	struct CONST_REC *AllocMem;

	if( (AllocMem=(struct CONST_REC *) malloc(sizeof(struct CONST_REC))) != NULL)
	{
		AllocMem->Name=NULL;
		AllocMem->Value=NULL;
		AllocMem->Next=NULL;
	}
	else
	{
		error=ERR_NOTMEMORY;
		errmsg();
		exit(1);
	}

	return(AllocMem);
}


// =====( Search CONSTANT and return VALUE )==============
char *SearchConst(char *SearchName)
{
	struct CONST_REC *ConstWork;

	if(ConstStart==NULL)
		return(NULL);

	ConstWork=ConstStart;		// INIT

	do
	{
		if( !strcmp(ConstWork->Name,SearchName) )	// Found???
			return(ConstWork->Value);					// Yep... RETURN VALUE-POINTER!

		ConstWork=ConstWork->Next;
	} while(ConstWork != NULL);

	return(NULL);
}

// =====( ADD Constant Name and Value! )==============
void AddConst(char *TheName, char *TheValue)
{
	struct CONST_REC *ConstWork;

	ConstWork=ConstStart;	  			  			// INIT
	if(ConstStart==NULL)					  			// First Element ???
		ConstWork=ConstStart=GetConstSpace();	// Yep
	else													// Otherwise...
	{
		while(ConstWork->Next != NULL)	// Searching last element!
			ConstWork=ConstWork->Next;

		ConstWork->Next=GetConstSpace();	// Alloc next element
		ConstWork=ConstWork->Next;
	}

	// ConstWork now the new element
	ConstWork->Name =DynamicStr( TheName  );
	ConstWork->Value=DynamicStr( TheValue );
}


//========( Allocate Memory for one Label! )===============================
struct LABEL_REC *GetLabelSpace(void)
{
	struct LABEL_REC *AllocMem;

	if( (AllocMem=(struct LABEL_REC *) malloc(sizeof(struct LABEL_REC))) != NULL)
	{
		AllocMem->Name=NULL;
		AllocMem->Addr=-1L;
		AllocMem->Next=NULL;
	}
	else
	{
		error=ERR_NOTMEMORY;
		errmsg();
		exit(1);
	}
	return(AllocMem);
}


// =====( Search Label and return Address )==============
long int SearchLabel(char *SearchName)
{
	struct LABEL_REC *LabelWork;

	if(LabelStart==NULL)
		return(-1L);

	LabelWork=LabelStart;		// INIT

	do
	{
		if( !strcmp(LabelWork->Name,SearchName) )	// Found???
			return(LabelWork->Addr);					// Yep... RETURN Address!

		LabelWork=LabelWork->Next;
	} while(LabelWork != NULL);

	return(-1L);
}

// =====( ADD LABEL Name and Address! )==============
void AddLabel(char *TheName, long int TheAddr)
{
	struct LABEL_REC *LabelWork;

	LabelWork=LabelStart;	  			  			// INIT
	if(LabelStart==NULL)					  			// First Element ???
		LabelWork=LabelStart=GetLabelSpace();	// Yep
	else													// Otherwise...
	{
		while(LabelWork->Next != NULL)	// Searching last element!
			LabelWork=LabelWork->Next;

		LabelWork->Next=GetLabelSpace();	// Alloc next element
		LabelWork=LabelWork->Next;
	}

	// ConstWork now the new element
	LabelWork->Name =DynamicStr( TheName  );
	LabelWork->Addr = TheAddr ;
}


