// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

int Width  = 128;
int Height = 128;

double frand1d(int x)
{
int s = 71 * x; s = s * 8192 ^ s;
return 1.0 - ((s*(s*s*15731+789221)+1376312589)& 0x7fffffff)/1073741824.0;
}

double Noise1D(double x)
{
int i;
double f,n0,n1;
i = floor(x);
f = x - i;
n0 = frand1d(i);
n1 = frand1d(i+1);
return n0 + (n1-n0)*f;
}

void lenz()
{

int x, y;
double dx, dy, d, a, f, v;
double ring,rmin,rmax,rmid,rwid;

double linear = 0.03;
double gauss  = 0.006;
double mix    = 0.150;

rmid = 27;
rwid = 2.6;
rmax = rmid + rwid;
rmin = rmid - rwid;

for (y=0; y<Height; y++)
{
dy = Height/2 - y;
for (x=0; x<Width; x++)
{
dx = x - Width/2;
d = sqrt(dx*dx + dy*dy) * 2.0;
a = exp(-d*d*gauss)*mix + exp(-d*linear)*(1-mix);
if (d<rmin || d>rmax) ring = 0;
else
{
ring = fabs(d-rmid)/rwid;
ring = 1 - ring*ring*(3 - 2*ring);
ring *= 0.10;
}
a += ring;
if(dy==0) v=pi;
else v = atan(dx/dy)+pi;

v = 1;

v = fabs(v);
v = v*v*v*v*v;
a += 0.10*v / (1 + d*0.1);
if (a>1) a = 1;
lnsimg2[x*4+y*512] = 255.0 * a;
lnsimg2[x*4+y*512+1] = 255.0 * a;
lnsimg2[x*4+y*512+2] = 255.0 * a;
lnsimg2[x*4+y*512+3] = 255.0 * a;
}
}
}

void prtlns(int xlf,int ylf,short sizelf,char r,char g,char b,unsigned char *limg)
{
        if (sizelf>=1)
{
        short frmspr=0,llp;
        short tospr=0;
        int newsize=sizelf/2;
        short size2=32768/sizelf;
        short yloop=sizelf;
        short xloop=sizelf;
        xlf-=newsize;
        ylf-=newsize;

        if((xlf+xloop)>319) xloop=320-xlf;
        if((ylf+yloop)>199) yloop=200-ylf;

        int xlflp=0-xlf;
        int ylflp=0-ylf;

        if(xlf<0) xloop-=xlflp,tospr=xlflp*size2,xlf=0;
        if(ylf<0) yloop-=ylflp,frmspr=ylflp*size2,ylf=0;

        if((xloop>0)&&(yloop>0))
{
_asm {  mov edi,ylf
        shl edi,6
        mov ebx,edi
        shl edi,2
        add edi,ebx
        add edi,xlf
        shl edi,2
        add edi,offset frame
        mov dx,size2
        xor ebx,ebx
        mov cx,yloop
        mov bx,frmspr
l2:     movzx esi,bh
        add bx,dx
        shl esi,9
        add esi,limg
        push bx
        push cx
        push edi
        mov bx,tospr
        mov ax,xloop
        mov llp,ax
l1:     movzx eax,bh
        mov eax,[eax*4+esi]
        mov cl,b
        shr al,cl
        add al,[edi]
        jnc ql3
        mov al,255
ql3:    mov [edi],al
        shr eax,8
        mov cl,g
        shr al,cl
        add al,[edi+1]
        jnc ql4
        mov al,255
ql4:    mov [edi+1],al
        shr eax,8
        mov cl,r
        shr al,cl
        add al,[edi+2]
        jnc ql5
        mov al,255
ql5:    mov [edi+2],al
        add bx,dx
        add edi,4
        dec llp
        jnz l1
        pop edi
        pop cx
        pop bx
        add edi,1280
        dec cx
        jnz l2
}
}
}
}

void prtzoom(int x,int y,int x1,int y1,int x2,int y2,int ycrd,char glsflg,unsigned char *image)
{
        int xinc,yinc,xclip=0,yclip=0,xmul;
        int st1,st2,st3,st4,ycrd2;

        xmul=x1*4,ycrd2=ycrd*x1*4;

        if(x2!=0) xinc=x1*65536/x2;
        else xinc=0;

        if(y2!=0) yinc=y1*65536/y2;
        else yinc=0;

        if((x+x2)>319) x2=320-x;
        if((y+y2)>199) y2=200-y;

        if(x<0) x2-=0-x,xclip=(0-x)*xinc,x=0;
        if(y<0) y2-=0-y,yclip=(0-y)*yinc,y=0;

        if((x2>0)&&(y2>0))
{
_asm {  mov edi,y
        shl edi,6
        mov ebx,edi
        shl edi,2
        add edi,ebx
        add edi,x
        shl edi,2
        add edi,offset frame
        mov ebx,yclip
        mov edx,yinc
        mov ecx,y2
l2:     mov st1,ebx
        mov st2,ecx
        mov st3,edi
        mov st4,edx
        shr ebx,16
        mov eax,ebx
        mul xmul
        add eax,image
        add eax,ycrd2
        mov esi,eax
        mov ebx,xclip
        mov edx,xinc
        mov ecx,x2
        cmp glsflg,1
        jz nogls
l1:     mov eax,ebx
        shr eax,16
        mov eax,[esi+eax*4]
        test eax,eax
        jz l3
        mov [edi],eax
l3:     add ebx,edx
        add edi,4
        dec ecx
        jnz l1
        jmp cont
nogls:  mov eax,ebx
        shr eax,16
        mov eax,[esi+eax*4]
        mov [edi],eax
        add ebx,edx
        add edi,4
        dec ecx
        jnz nogls
cont:   mov edx,st4
        mov edi,st3
        mov ecx,st2
        mov ebx,st1
        add edi,1280
        add ebx,edx
        dec ecx
        jnz l2
}
}
}

void decrimg(unsigned char *imagef,unsigned char *imaged,int len,int xpix,unsigned char outline)
{
_asm{   mov esi,imagef
        mov edi,imaged
        add edi,xpix
        add edi,4
        mov ebx,len
l1:     mov al,[esi]
        inc esi
        mov ecx,8
l2:     mov edx,0
        shl al,1
        jc l3
        mov edx,0xffffffff
l3:     or [edi],edx
        cmp byte ptr outline,0
        jz l33
        push ebp
        mov ebp,xpix
        and edx,0x7f7f7f7f
        or [edi-4],edx
        or [edi+4],edx
        or [edi+ebp],edx
        neg ebp
        or [edi+ebp],edx
        pop ebp
l33:    add edi,4
        dec ecx
        jnz l2
        dec ebx
        jnz l1
}
}

void blur(unsigned char *image,int xlen,int ylen,char len)
{
_asm{   mov cl,len
l3:     push ecx
        mov esi,xlen
        shl esi,2
        mov edi,image
        add edi,4
        mov ebx,ylen
        mov ecx,xlen
        dec ecx
        push ebp
        mov ebp,esi
        neg ebp
l2:     push ecx
        push edi
l1:     mov eax,[edi-4]
        shr eax,2
        and eax,0x3f3f3f3f
        mov edx,[edi+4]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov edx,[edi+esi]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov edx,[edi+ebp]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov [edi],eax
        add edi,4
        dec ecx
        jnz l1
        pop edi
        pop ecx
        add edi,esi
        dec ebx
        jnz l2
        pop ebp
        pop ecx
        dec cl
        jnz l3
}
}

void outbuf()
{
_asm {  mov edi,offset frame
        mov esi,edi
        xor eax,eax
        mov ecx,200
l2:     mov [edi],eax
        mov [edi+1276],eax
        add edi,1280
        dec ecx
        jnz l2
        mov edi,lfb
        mov ecx,64000
l1:     mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz l1
}
}