; ۲                                         ;
;۲ BLaCK  (c) 1996 by Shiva - 4k Hicolor Intro;
; ۲                                         ;

; See the includedinfo files for details
                                     
segment code                        
assume cs:code,ds:code
org 100h            
                       
.486                       
                      
start:    
    mov ah, 09h              
    mov dx, offset menu
    int 21h
                            
    mov ah, 08h                 
    int 21h                     
    cmp al, 32h
    jnz @Setkewl
        mov Showproc, offset showsux
        call SetVga 
        jmp @ShowSux
    @Setkewl:                            
        call VesaInstall                
    @Showsux:
    
    xor ax, ax
    mov gs, ax
    mov dx,cs 
    shl edx,10h
    mov dx,Offset KeyboardHandler
    xchg edx,gs:[24h]
    mov [Old_Key],edx                              
                                        
    call LoadFont

    call MakeSinusMap
                             
    call MakeSInCosTab     
    call SetupPolyBuffer   
                           
    mov di, offset pseg             
    push cs                
    pop es                 
    mov ax, cs             
    mov cx, 6             
    @LoadMemory:            
        add ax, 1000h      
        stosw              
    loop @LoadMemory       
                                        
    call RenderTunnel      
    finit  
    Mov es, TSeg           
    Call CreateWood                              
                      
    mov si, offset lightOne
    call SetLight     
                      
    mov si, offset LogoObject     
    call LoadObject         
                      
    mov si, offset blackscript

    call RunScript   
    jmp @EndPart
                      
    @QuickQuit:       
                                                               
    mov dx, offset Bye_msg           
    call Error     
                   
; Sets a light from si
SetLight proc   
   mov di, offset lightr
   mov cx, 9            
  @LightLoop:              
   lodsw                
   mov temp_int, ax     
   fild temp_int        
   fstp dword ptr [di]  
   add di, 4            
  loop @LightLoop       
   mov si, offset lightr
   call UnitVector      
   mov si, offset lightg
   call UnitVector      
   mov si, offset lightb
   call UnitVector      
ret                
endp               
                   
; Runs a 3d movement script
RunScript proc     
   lodsb                                
   cmp al, 0ffh    
   jz @EndPart
   cbw             
   mov cx, ax                                
   lodsb                                     
   cbw                                       
   mov dx, ax   
   lodsb        
   mov ef, al       
   lodsw       
   cmp ef, 3   
   jz @Looper                 
   mov bx, ax  
   @LooperBack:
   @Runloop:                                 
   add camz, dx                              
   pusha                                     
    mov si, bx                               
    call MoveAll                             
                                             
    mov es, rseg    
    @DoRSeg:        
    call clear                               
                                             
    mov dx, tunnel1                          
    mov es, gseg    
    @DoGSeg:         
    call DrawTunnel
    add tunnel1, 257                         
                                             
    mov dx, tunnel2                          
    mov es, bseg             
    @DoBSeg:            
    call DrawTunnel                          
    sub tunnel2, 513                         
                                             
    call Render    
                    
    cmp ef, 1      
    jz @WriteBMAP  
    cmp ef, 2      
    jz @SetPart2
    cmp ef, 6
    jz @SetPart3
    cmp ef, 4
    jz @Writeho
    cmp ef, 5                           
    jz @BLueAnimation
    cmp ef, 7                          
    jz @BLueAnimationCredit
                  
    @EffectBack:  
                               
    ;call ShowKewl
    call showproc
                  
    @EffectBack2:                         
                              
   popa               
                      
   loop @RunLoop          
  jmp RunScript           
  @WriteBMAP:             
      mov si, offset BMAP
      mov di, 320*156+30
      call WriteString  
  jmp @EffectBack       
  @SetPart2:   
      mov si, offset lighttwo
      call SetLight  
      mov word ptr [offset drawtunnel], 9090h
      mov si, offset BoyObject
      call LoadObject   
      mov camz, 120          
  jmp @EffectBack2
  @SetPart3:       
      mov si, offset lightthree
      call SetLight
      mov si, offset LogoObject
      call LoadObject
      dec nrscr
      mov camz, 140
  jmp @EffectBack2
  @Looper:                              
      cmp loopcount, 0                  
      jnz @Loopcont                     
          mov loopcount, ax             
          sub si, 15                    
          jmp @looperback               
      @loopcont:                        
      dec loopcount                     
      jz @looperback                    
      sub si,15                         
  jmp @LooperBack                       
  @WriteHo:                             
      mov si, offset hohoho             
      mov di, 320*15+60                 
      call WriteString                  
  jmp @EffectBack                       
  @BlueAnimation:                       
    pusha              
      call DrawJulia   
      call ShowJulia3d 
    popa               
  jmp @EffectBack     
  @BlueAnimationCredit:                       
    pusha                 
      call DrawJulia      
      call ShowJulia3d 
    popa
    mov si, offset credits
    mov di, 320*170+100
    call WriteString  
  jmp @EffectBack                        
RunScript endp         
                       
@EndPart:
     mov es, tseg
     call BallPattern
     

     mov bp, 40
     mov bloby, bp
     call RenderWavesMap

     mov es, rseg
     call clear
     mov es, gseg
     call clear

     mov cx, 350
     @WavesLoop:
     push cx

         mov es, rseg         
         call TransWaveSeg
         mov es, gseg
         add bx, 40
         call TransWaveSeg
         mov es, bseg
         add bx, 40
         call TranswaveSeg
         sub bx, 78
             
         cmp cx, 200
         ja @NoText
            pusha
            mov di, 320*170+200
            mov si, offset voteme
            call writestring
            mov bp, bloby
            sub bloby, 2  
            call RenderWavesMAp
            popa
         @NoText:
    
         push bx
         ;call Showkewl
         call Showproc
         pop bx
         
     pop cx
     loop @WavesLoop


jmp @QuickQuit

; Keyboard ESC check handler routine (by G.O.D, but optimized by Shiva
KeyboardHandler proc
  push ax
  mov al,20h
  out 20h,al
  in al,60h
  dec al
  jz @ESCpressed
  pop ax
  iret
  @ESCpressed:
  push cs
  pop ds
  jmp @QuickQuit
endp


; Create a ball pattern in es
BallPattern proc
   xor di, di
   xor bx, bx
   @PatternY:
     mov cx, 256
     @PatternX:
       mov temp_int, cx
       sub temp_int, 128
       fild temp_int
       fmul st(0), st(0)
       mov temp_int,bx
       sub temp_int, 128
       fild temp_int      
       fmul st(0), st(0)  
       faddp st(1), st(0)
       fsqrt
       cmp di, 0ffffh
       jz @NoSet
       fistp word ptr es:[di]
       shr word ptr es:[di], 1
       inc di
     loop @PatternX
   dec bl
   jnz @PatternY
   @NoSet:
ret
BallPattern endp
                                     
; Display RGB screen in 320x200 with 15bit
Showkewl proc              
  push ds               
    mov fs, gseg        
    mov gs, rseg        
    mov es, bseg        
    push 0a000h       
    pop ds       
    xor si, si   
    mov cx, 2    
    xor dx, dx       
                        
  @BankLoop:       
      mov di, -2                    
      mov ax, 4f05h    
      xor bx, bx            
      int 10h          
      inc dx                         
     push dx
      mov dx, 08000h             
      @DisplayLoop:            
        mov al, fs:[si]
        add al, al            
                
        inc di            
        and al, 11111000b     
        mov ah, gs:[si]
        add ah, ah
                      
        inc di            
        shr ah, 3         
        mov bl, es:[si]
        add bl, bl 
                                        
        shl ax, 2
        shr bl, 3     
        inc si       
        add al, bl     
        mov [di], ax  
      dec dx             
      jnz @DisplayLoop        
     pop dx           
  loop @BankLoop      
  pop ds                                       
ret                                         
Showkewl endp      

; Display RGB screen in 320x200 with 8bit (R:3:G:3:B:2>
Showsux proc                                   
  push ds                                       
    mov fs, gseg                                
    mov gs, rseg                                
    mov es, bseg                                
    push 0a000h                                 
    pop ds    
                                      
    xor si, si                                  
     
    mov cx, 64000
    @DisplayLoop2:    
        mov bl, gs:[si]
        and bl, 11100000b
        mov dl, fs:[si]
        and dl, 11100000b
        shr dl, 3
        add bl, dl
        mov al, es:[si]
        shr al, 6
        add al, bl

        mov [si], al
        inc si     
        dec cx
    jnz @DisplayLoop2                                                                                                                   
  pop ds                                       
ret                                         
showsux endp

; Setup a RGB 3:3:2 pallette
SetVga proc  
  pusha
   mov ax, 13h
   int 10h 
  
   mov dx, 3c8h   
   xor al, al     
   out dx, al                  
   inc dx         
                         
   mov cl, 8             
     @RLoop:             
     mov bh, 8
         @GLoop:         
            mov bl, 4    
            @BLoop:      
                mov al, 8
                sub al, cl
                shl al, 3
                out dx, al
                mov al, 8
                sub al, bh
                shl al, 3
                out dx, al
                mov al, 4
                sub al, bl
                shl al, 4
                out dx, al                         
            dec bl    
            jnz @BLoop
         dec bh      
         jnz @GLoop   
     dec cl           
     jnz @RLoop                           
  popa       
ret          
SetVga endp
                           
; Loads a packed whole objects list from ds:[si], with cx parts
LoadObject proc     
   mov cx, totalobjs    
   mov fstart, offset faces
   mov pstart, 0    
   mov ostart, offset obj
   @LoadLoop:       
   push cx          
     lodsb          
     cbw            
     mov r1,ax      
     lodsb          
     cbw                            
     mov r2,ax             
     lodsb          
     cbw              
     mov r3,ax                       
     mov ax, pstart    
    pusha                        
     mov es, pseg              
     mov si, fstart           
     mov di, ax              
     call makeBlob  
    popa            
                    
     mov di, ostart      
                      
     call InitObject      
                          
     mov word ptr [100+di], ax    ;start point offset 
     mov word ptr [104+di], 121   ;# of points
       
     push di               
     mov bl, 6      
     @DisOrgLoad:      
       lodsb                 
       cbw                   
       mov temp_int, ax      
       fild temp_int          
       fstp dword ptr [64+di]
       add di, 4    
     dec bl         
     jnz @DisOrgLoad                 
     pop di                
                    
     lodsw                   
     mov word ptr [108+di], ax
                     
     add ostart, 200 
     add fstart, 2240 
     add pstart, 1452
   pop cx           
   loop @LoadLoop 
                    
   call DoAllNormals
ret                 
LoadObject endp                     
                                      
; Use the movement table in si to advance animation
MoveAll proc                     
   mov di, offset obj
  mov cx, totalobjs
  @MoveLoop:      
   lodsb
   cmp al, 0ffh               
   jz @NoMoreMovement
   cbw                                   
   add [di+88], ax                       
   and word ptr [di+88], 011111111111b   
   lodsb                                 
   cbw                                   
   add [di+92], ax                       
   and word ptr [di+92], 011111111111b   
   lodsb                                 
   cbw                                   
   add [di+96], ax                       
   and word ptr [di+96], 011111111111b   
   add di, 200        
  loop @MoveLoop 
  @NoMoreMovement:     
ret                
MoveAll endp            
                            
; Setup VESA display driver                          
VesaInstall proc            
   mov ax,4f02h                             
   mov bx,010dh              
   int 10h                           
   mov dx, offset VESA_Err 
   cmp ax, 004fh                    
   jnz Error        
ret                     
VesaInstall endp            
                                    
; Error (Switch to textmode, display string & terminate)
Error proc
  xor ax, ax
  mov gs, ax
  mov eax, cs:[offset Old_Key]
  mov gs:[24h],eax
  mov ax, 03h                                             
  int 10h                                                 
  mov ah,09h              
  push cs                                                  
  pop ds                                                  
  int 21h                                                 
  mov ax,4C00h                                            
  int 21h                   
Error endp                   
                          
; Creates a Sinus table from FPU. 2048 values/1024 periode   
MakeSinCosTab proc
    mov di, offset sico              
    mov cx, 2048              
    fldz              
    @SicoLoop:     
       fld st(0)       
       fsin                 
       fstp dword ptr [di]     
       fadd float_rad    
       add di, 4        
    loop @SicoLoop 
    finit
ret                                                                  
MakeSinCosTab endp                      
                          
; Resets the polygon buffer
SetupPolyBuffer proc          
    mov di, offset polyx      
    push ds                                  
    pop es                           
    mov cx, 400               
    xor ax, ax                              
    dec ax         
    rep stosw                 
ret                          
SetupPolyBuffer endp                   
                           
; Blob! radius in r1,r2,r3, points at es:[di], faces at si
MakeBlob proc       
  pusha                 
    ;Create points: 119+2 = 121
    xor bx, bx
    @bx_Loop: 
        xor si, si
        @si_Loop:
         pusha
            shl bx, 8     
            shl si, 8
            add bx, offset sico
            add si, offset sico+256
            fld  dword ptr [si]     
            fmul dword ptr [bx+1024]
            fimul r1                 
            fstp dword ptr es:[di]  
            fld  dword ptr [si+1024]
            fimul r2                 
            fstp dword ptr es:[di+4]
            fld  dword ptr [si]
            fmul dword ptr [bx]
            fimul r3           
            fstp dword ptr es:[di+8]
         popa             
            add di, 12         
        inc si        
        cmp si, 7
        jnz @si_loop
    inc bx  
    cmp bx, 17
    jnz @bx_loop                        
    ;Tip points           
    fild r2       
    xor eax, eax
    stosd                    
    fst dword ptr es:[di]
    add di, 4                        
    stosd            
    fchs           
    stosd         
    fstp dword ptr es:[di]
    add di, 4                
    stosd                            
    ;faces                 
  popa                              
    mov cx, 96      
    xor dx, dx          
    add di, 05555h
    mov ax, di
    @Blob_Faces:
        mov word ptr [si], di   
        add di, 1*12 
        mov word ptr [si+2], di  
        add di, 7*12      
        mov word ptr [si+4], di  
        add si, 10   
        sub di, 8*12
        mov word ptr [si], di  
        add di, 8*12  
        mov word ptr [si+2], di
        sub di, 1*12      
        mov word ptr [si+4], di
        sub di, 6*12
        add si, 10  
        inc dl                
        cmp dl, 6   
        jnz @BF_NoJump
            xor dl, dl
            inc dh        
            add di, 12         
        @BF_NoJump:   
    loop @Blob_Faces
                  
    mov bx, ax
    add ax, 119*12   
                                        
    mov cx, 16            
    @Top_Faces:   
        mov [si], ax
        mov [si+2], bx       
        add bx, 7*12   
        mov [si+4], bx               
        add si, 10   
        add ax, 12 
        mov [si], ax          
        sub ax, 12    
        add bx, 6*12         
        mov [si+2], bx               
        sub bx, 7*12       
        mov [si+4], bx              
        sub bx, 6*12
                        
        add bx, 7*12
              
        add si, 10          
                    
    loop @Top_Faces  
ret                   
MakeBlob endp             
                      
; Assemble all relevant normals. [rseg] data is destroyed!
DoAllNormals proc 
    mov bp, offset faces     
    mov cx, totalfaces
    xor ax, ax 
    @NormalsLoop:         
      mov si, ds:[bp]         
      sub si, 05555h
      mov bx, ds:[bp+2]      
      sub bx, 05555h          
      mov di, ds:[bp+4]
      sub di, 05555h         
      push bp                
          mov bp, ax      
          call MakeFaceNormal  
      pop bp          
      add bp, 10    
      add ax, 12                             
    loop @NormalsLoop     
                          
    mov cx, totalpoints                 
    xor ax, ax            
    @PNormalsLoop:        
    pusha                 
      call PointNormal       
    popa                  
    add ax, 12                       
    loop @PNormalsLoop    
ret                
DoAllNormals endp 
                      
; Render a tunnel lookup   
RenderTunnel proc near               
  mov es, lseg               
  xor di, di                        
  mov cx, 100         
  @YLoop1:              
    mov dx, 320
    @XLoop2:                                
       finit         
       mov ax, dx
       sub ax, 160    
       mov temp_int, ax
       fild temp_int      
       mov temp_int, cx
       fild temp_int 
       fld st(1)
       fld st(1)           
       fpatan      
       fdiv xfac
       fistp temp_int     
       mov ax, temp_int       
       stosb    
       fmul st(0), st(0)
       fxch st(1)             
       fmul st(0), st(0)
       fadd st(0), st(1)
       fsqrt          
       fild yfac          
       fdiv st(0), st(1)       
       fistp temp_int 
       mov ax, temp_int                      
       stosb          
    dec dx            
    jnz @XLoop2       
  loop @YLoop1                          
  ret                     
endp                  
                      
; Draws the tunnel from the tunnel lookup to es with rotation from dx
DrawTunnel proc near
  jmp @DrawTunnelNot    
      jmp Clear      
  @DrawTunnelNot:  
  push ds                            
   mov fs, TSeg       
   mov ds, LSeg       
   mov cx, 2            
   mov bp, cx              
   xor si, si                
   xor di, di                        
   @Loop2:                   
   push cx                          
    mov cx, 16000     
    @Loop1:            
      mov bx, ds:[si] 
      add si, bp      
      add bx, dx  
      mov al,fs:[bx]  
      mov bx, ds:[si] 
      add bx, dx      
      mov ah,fs:[bx]      
      mov es:[di], ax      
      inc di         
      add si, bp  
      inc di          
    dec cx            
    jnz @Loop1        
    sub si, bp            
    neg bp                    
   pop cx             
   loop @Loop2        
  pop ds              
  ret                     
endp                  
                      
; Create Tiles Pattern in es
CreateWood proc near           
  xor cx, cx                  
  xor di, di                   
  @MakePatern:                          
    mov al, cl                 
    xor al, ch                 
    stosb                      
  loop @MakePatern             
  ret                          
endp                           
                                    
; Assemble point normal to point es:ax at es:ax+5555h
PointNormal proc                     
   mov fs, rseg
                
   mov di, ax                  
   add ax, 05555h              
                               
   mov cx, TotalFaces                
                        
   mov bx, offset faces             
   ;mov bp, offset fnormals
   xor bp, bp          
               
   xor edx, edx           
   mov si, offset temp_vect
   mov [si],   edx        
   mov [si+4], edx                          
   mov [si+8], edx        
                          
   mov es, pseg            
   @SearchLoop:                              
      cmp [bx], ax        
      jz @AddPoint        
      cmp [bx+2], ax      
      jz @AddPoint        
      cmp [bx+4], ax      
      jz @AddPoint            
      @Back:              
      add bx, 10          
      add bp, 12                                                     
   loop @Searchloop           
                             
   call UnitVector           
                             
   mov es, pseg                
   add di, 0aaaah            
   mov cl, 6                 
   rep movsw                            
                             
ret                          
   @AddPoint:          
       fld dword ptr fs:[bp] 
       fadd dword ptr [si]   
       fstp dword ptr [si]
       fld dword ptr fs:[bp+4]
       fadd dword ptr [si+4] 
       fstp dword ptr [si+4]         
       fld dword ptr fs:[bp+8]
       fadd dword ptr [si+8]        
       fstp dword ptr [si+8] 
   jmp @Back               
PointNormal endp             
                                     
; Set a vector at si to unit length
UnitVector proc                     
    fld dword ptr [si]       
    fst st(1)                
    fmul st, st                                      
    fld dword ptr [si+4]     
    fst st(3)                
    fmul st, st              
    fld dword ptr [si+8]                    
    fst st(5)                
    fmul st, st              
    faddp st(1), st          
    faddp st(1), st                          
    fsqrt                    
    fxch st(1)               
    fdiv st, st(1)           
    fstp dword ptr [si]      
    fxch st(1)               
    fdiv st, st(1)            
    fstp dword ptr [si+4]    
    fdivp st(1), st          
    fstp dword ptr [si+8]                                            
ret                           
UnitVector endp              
                             
; Compute the normal to a plane with vectors si,bx,di at rseg:bp.
MakeFaceNormal proc            
    push ds                
    mov es, rseg
                                        
    mov ds, pseg
    fld dword ptr [si+4]     
    fsub dword ptr [bx+4]    
    fld dword ptr [si+8]  
    fsub dword ptr [di+8]    
    fmulp st(1), st     
    fld dword ptr [si+8]     
    fsub dword ptr [bx+8]    
    fld dword ptr [si+4]             
    fsub dword ptr [di+4]    
    fmulp st(1), st                 
    fsubp st(1), st          
    fstp dword ptr es:[bp+0] 
                             
    fld dword ptr [si+8]             
    fsub dword ptr [bx+8]     
    fld dword ptr [si]              
    fsub dword ptr [di]      
    fmulp st(1), st          
    fld dword ptr [si]                               
    fsub dword ptr [bx]      
    fld dword ptr [si+8]     
    fsub dword ptr [di+8]    
    fmulp st(1), st                         
    fsubp st(1), st          
    fstp dword ptr es:[bp+4] 
                             
    fld dword ptr [si]                       
    fsub dword ptr [bx]
    fld dword ptr [si+4]
    fsub dword ptr [di+4]
    fmulp st(1), st    
    fld dword ptr [si+4]  
    fsub dword ptr [bx+4]     
    fld dword ptr [si] 
    fsub dword ptr [di]
    fmulp st(1), st                                                  
    fsubp st(1), st           
    fstp dword ptr es:[bp+8] 
    pop ds            
ret                 
MakeFaceNormal endp            
                                                
; Resets matrix in di to unit
InitMatrix proc                         
   pusha                       
    mov cx, 4                  
    @IM_XLoop:                 
        mov dl, 4               
        @IM_YLoop:                
            mov dword ptr [di], 0
            cmp dl, cl           
            jnz @NoSetOne        
                mov dword ptr [di], 3f800000h
            @NoSetOne:         
            add di, 4               
        dec dl          
        jnz @IM_YLoop      
    loop @IM_XLoop           
   popa                              
ret                      
InitMatrix endp                     
                               
; Transforms vector es:si by matrix bx and stores result vector in di
MatTrans proc                                        
   fld dword ptr es:[si+8]     
   fld dword ptr es:[si+4]     
   fld dword ptr es:[si+0]     
   mov al, 3                                
   @vLoop:                     
      fld dword ptr [bx]       
      fmul st,st(1)            
      fld dword ptr [bx+16]                  
      fmul st,st(3)            
      fld dword ptr [bx+32]          
      fmul st,st(5)            
      fadd dword ptr[bx+48]              
      add bx, 4                
      faddp st(1),st           
      faddp st(1),st           
      fstp dword ptr [di]      
      add di, 4                                                      
   dec al                      
   jnz @vLoop                  
   finit                       
ret                            
MatTrans endp                  
                               
; Inverse transform vector si by matrix bx and stores result vector in di
InvMatTrans proc                        
   pusha                       
    fld dword ptr [si+8]
    fld dword ptr [si+4]      
    fld dword ptr [si+0]      
    mov al, 3                
    @IMT_Loop:                  
        fld dword ptr [bx]   
        fmul st,st(1)        
        fld dword ptr [bx+4]         
        fmul st,st(3)          
        fld dword ptr [bx+8]        
        fmul st,st(5)        
        add bx, 16          
        faddp st(1),st         
        faddp st(1),st                          
        fstp dword ptr [di] 
        add di, 4                   
    dec al                     
    jnz @IMT_Loop               
    finit                                            
   popa                           
ret                            
InvMatTrans endp                                        
                                            
; Multiplies Matrix di with si and stores result in di
MatMul proc               
   pusha                       
     push di                                 
      mov bx, offset temp_mat
     push bx           
      mov ch, 4          
      @YLoop:             
          mov cl, 4             
          @XLoop:             
             mov al, 4
             fldz              
             push di     
             @MLoop:                
                fld dword ptr [si]                                   
                fmul dword ptr [di]
                faddp st(1),st
                add si, 16     
                add di, 4     
             dec al 
             jnz @MLoop                 
             pop di    
             sub si, 60
             fstp  dword ptr [bx]
             add bx, 4    
          dec cl   
          jnz @XLoop    
          sub si, 16         
          add di, 16   
      dec ch                         
      jnz @YLoop             
                                    
     pop si             
     pop di                
     push cs                 
     pop es                          
     mov cl, 32         
     rep movsw                      
   popa                 
ret                          
MatMul endp                                          
                      
; Resets a object at di to zero
InitObject proc     
    pusha          
    call InitMatrix                         
    push cs         
    pop es                 
    mov cx, 64           
    xor ax, ax                               
    rep stosw
    popa
ret              
InitObject endp
                              
; Size Optimizing related proc
PrepRot proc                  
   xchg di, si      
   call InitMatrix             
   xchg di, si           
   shl bx, 2                  
   fld sico[bx]                                                      
   fld sico[bx+1024]           
ret                   
endp                
                                        
; Creates a X-Rotation Matrix in si with angle bx
MakeXRotMat proc    
   call PrepRot        
   fst dword ptr [si+20]  
   fstp dword ptr [si+40]
   fst dword ptr [si+36]
   fchs              
   fstp dword ptr [si+24]
ret                                  
endp                
; Creates a Y-Rotation Matrix in si with angle bx
MakeYRotMat proc             
   call PrepRot                     
   fst dword ptr [si]        
   fstp dword ptr [si+40]            
   fst dword ptr [si+8] 
   fchs                             
   fstp dword ptr [si+32]
ret                           
endp                    
; Creates a Z-Rotation Matrix in si with angle bx
MakeZRotMat proc                                     
   call PrepRot       
   fst dword ptr [si]
   fstp dword ptr [si+20]
   fst dword ptr [si+16]                    
   fchs                    
   fstp dword ptr [si+4]  
ret                      
endp                                         
                 
; Transforms a object in di: Displace, Rotate, Set
TransformObj proc                    
    call InitMatrix           
    ;Set displacement
    push cs
    pop es
    push di                   
    add di, 48
    mov eax, [di+16]  
    stosd    
    mov eax, [di+16]           
    stosd   
    mov eax, [di+16]
    stosd                               
    pop di
    ;Make Rotation          
    mov si, offset temp_mat2
    mov bx, [di+88]       
    shr bx, 1     
    call MakeXRotMat                 
    call MatMul                      
    mov bx, [di+92]    
    shr bx, 1     
    call MakeYRotMat                 
    call MatMul                      
    mov bx, [di+96]     
    shr bx, 1              
    call MakeZRotMat                 
    call MatMul                      
    ;Add origin                        
    fld  dword ptr [di+48]           
    fadd dword ptr [di+76]            
    fstp dword ptr [di+48]           
    fld  dword ptr [di+52]            
    fadd dword ptr [di+80]            
    fstp dword ptr [di+52]           
    fld  dword ptr [di+56]               
    fadd dword ptr [di+84]            
    fstp dword ptr [di+56]                                      
ret                                    
TransformObj endp                    
                        
; Quicksort faces sort list. si=lowbound, dx=highbound (Index value!)
Quicksort proc                                       
    mov bx, si                
    mov di, dx                
    mov bp, di                
    add bp, bx                              
    shr bp, 1                  
    add bp, bp   
    mov cx, zlist[bp]                  
    add bx, bx                               
    add di, di   
    @QS_Outer:                         
        @QS_While1:                    
           cmp zlist[bx], cx           
           jnl @QS_While1Out           
               inc bx                  
               inc bx                   
               jmp @QS_While1          
        @QS_While1Out:                 
        @QS_While2:                    
           cmp cx, zlist[di]                                         
           jnl @QS_While2Out           
               dec di                  
               dec di                  
               jmp @QS_While2          
        @QS_While2Out:                 
        cmp bx, di             
        jg @QS_NoSwap                
            mov ax, zlist[bx]        
           xchg ax, zlist[di]
            mov zlist[bx], ax
            mov ax, ilist[bx]        
           xchg ax, ilist[di]
            mov ilist[bx], ax
            inc bx                     
            inc bx                     
            dec di                     
            dec di                     
        @QS_NoSwap:        
    cmp bx,di              
    jle @QS_Outer          
    sar bx, 1               
    sar di, 1              
    cmp si, di                
    jge @QS_nonew1                     
        pusha                
        mov dx, di                                   
        call Quicksort     
        popa                                   
    @QS_nonew1:                        
    cmp bx, dx                              
    jge @QS_nonew2                     
        mov si, bx         
        jmp Quicksort                  
    @QS_nonew2:                              
ret                                    
QuickSort endp            
                              
; Fills segment at es with zero
Clear proc       
    mov cx, 16000
    xor eax, eax                        
    xor di, di            
    rep stosd       
ret                   
Clear endp                    
                  
; Calculates phong for vector si and bx+ax in si, base color bp
Phong proc                                  
   push bx                  
    add bx, ax              
    fld dword ptr es:[si+0] 
    fmul dword ptr [bx+112] 
    fld dword ptr es:[si+4]          
    fmul dword ptr [bx+112+4]
    fld dword ptr es:[si+8]  
    fmul dword ptr [bx+112+8]        
    faddp st(1),st(0)       
    faddp st(1),st(0)                                   
    fabs                    
    fst st(1)               
    fimul crange                    
    fxch st(1)              
    fmul st(0), st(0)             
    fmul st(0), st(0)       
    fimul crange            
    faddp st(1), st(0)      
    fistp word ptr es:[si+bp+2-5555h]
   pop bx                  
ret                       
Phong endp
             
; Load BIOS Font 8x16 address
LoadFont proc near
    mov ah,11h
    mov al,30h                
    mov bh,06h   
    int 10h      
    mov fos,es   
    mov foo,bp            
  ret            
LoadFont endp             
                 
; Write Char at di, al segments with al=ASCII 
WriteChar proc near
    pusha        
    xor ah, ah                          
    shl ax, 4    
    mov si, foo  
    add si, ax   
    mov fs, fos        
    mov bx, 0ff0fh
    @YFLoop:            
       mov al, fs:[si]
       inc si      
       mov cl, 8  
       @XFLoop:  
         cmp al, 7fh
         jbe @Skip      
             mov es, rseg  
             mov es:[di], bh
             mov es, gseg            
             mov es:[di], bh
             mov es, bseg   
             mov es:[di], bh
         @Skip:             
         shl al, 1          
         inc di             
       loop @XFLoop         
       add di, 312          
    dec bl                  
    jnz @YFLoop             
    popa                    
  ret                       
Writechar endp    

; Write a string in ds:[si] at di
WriteString proc
    lodsb       
    mov cl, al
    xor ch, ch                
    @WriteLoop:    
       lodsb     
       Call WriteChar
       add di, 10         
    loop @WriteLoop
  ret                 
WriteString endp
                                            
; Renders the 3d enviroment to r,g,b screens
Render proc                                                                             
    mov di, offset obj                       
    mov cx, totalobjs                                                
    @ObjectsLoop:            
    push cx                    
    push di                 
        push di               
        call TransformObj    
        pop di              
        ;Check parent       
        mov ax, [di+108]       
        test ax, ax         
        jz @NoParent
           pusha        
             mov si, ax    
             call MatMul
           popa                      
        @NoParent:        
                       
        mov bx, di   
        pusha        
        add di, 112          
        mov si, offset lightr
        Call InvMatTrans   
        add di, 12         
        add si, 12                   
        Call InvMatTrans   
        add di, 12         
        add si, 12         
        Call InvMatTrans   
        popa                 
                                
        mov si, [bx+100]        
        mov cx, [bx+104]            
        mov di, offset temp_vect
                                
        mov es, pseg         
                            
        @PointsLoop:        
            pusha            
            call MatTrans   
            popa            
                                   
            fld dword ptr [di+8]
            fisub camz      
            fdiv float_256                  
            fld dword ptr [di]               
            fdiv st, st(1)  
            fiadd xcenter     
            fistp word ptr es:[si+5555h] 
            fld dword ptr [di+4]          
            fdiv st, st(1)                   
            fiadd ycenter                    
            fistp word ptr es:[si+4+5555h]                           
            fmul float_256                   
            fistp word ptr es:[si+8+5555h]
                              
            ;Point illumination
                                  
            add si, 0aaaah 
                    
            xor ax, ax               
            mov es:[si+2-5555h], ax
            mov es:[si+2-5555h+4], ax
            mov es:[si+2-5555h+8], ax
                  
            xor bp, bp      
            call phong       
            mov al, 12      
            mov bp, 4       
            call phong               
            mov al, 24      
            mov bp, 8       
            call phong      
                                    
            add si, 12-0aaaah              
        loop @PointsLoop                   
                                           
      pop di                               
      add di, 200 ;Object size
    pop cx                    
    dec cx
    jnz @ObjectsLoop
                                                                                                                    
    mov fs, pseg                                                    
                                                                                                     
    ;Make Backface reduced Z-List
    mov cx, totalfaces                 
    mov si, offset faces         
    mov di, offset iList         
    mov sort_len, 0
    @ZListLoop:                         
        pusha                    
          mov di, [si]           
          mov bx, [si+2]                     
          mov si, [si+4]    
          mov ds, pseg        
          fild word ptr [di+4]
          fisub word ptr [si+4]
          fild word ptr [bx]  
          fisub word ptr [di]  
          fmulp st(1), st(0)     
          fild word ptr [di]  
          fisub word ptr [si] 
          fild word ptr [bx+4]
          fisub word ptr [di+4]
          fmulp st(1), st(0)         
          fxch st(1)             
          fsubp st(1), st(0)    
          push cs           
          pop ds            
          fistp temp_int         
        popa                     
        cmp temp_int, 0          
        jg @NextValue       
          mov [di], si               
          mov bx, [si]      
          mov ax, fs:[bx+8] 
          mov bx, [si+2]    
          add ax, fs:[bx+8]     
          mov bx, [si+4]     
          add ax, fs:[bx+8] 
          mov [di+3600], ax 
          inc di                    
          inc di            
          inc sort_len        
        @NextValue:         
                            
        add si, 10          
    dec cx                  
    jnz @ZListLoop           
                            
    ;SortFaces                          
    xor si, si              
    mov dx, sort_len                      
    dec dx                    
    pusha                               
    call Quicksort          
    popa                    
                                             
    ;Drawfaces              
    mov bp, offset rseg       
                            
    mov cx, nrscr
    mov lsvar, 2
  @ScreensLoop:                
   push cx                  
    mov di, offset iList                             
    movzx ecx, sort_len     
    mov es, ds:[bp] ;rseg   
                            
    @LoopFaces:                      
        mov si, [di]        
        pusha               
                                                    
         mov di, [si]       
         mov bp, fs:[di]    
         mov bx, fs:[di+4]   
        push bx             
         add di, lsvar      
         mov dl, fs:[di]             
                            
         mov di, [si+2]     
         mov ax, fs:[di]    
         mov cx, fs:[di+4]  
         add di, lsvar       
         mov dh, fs:[di]    
                            
         call ScanGoraudeEdge       
                            
         mov di, [si+4]       
         mov bp, fs:[di]    
         mov bx, fs:[di+4]  
         add di, lsvar   
         mov dl, fs:[di]  
                         
         call ScanGoraudeEdge
                         
         mov di, [si]     
         mov ax, fs:[di] 
         mov cx, fs:[di+4]
         add di, lsvar                  
         mov dh, fs:[di]
                         
         call ScanGoraudeEdge 
                          
        pop bx                                            
        shl bx, 2                                         
        mov polyx [bx], 0ffffffffh
                         
        popa                      
        inc di                
        inc di                
                         
    loop @LoopFaces           
   inc bp                     
   inc bp                            
   add lsvar, 4           
   pop cx                
  loop @ScreensLoop           
                                                     
ret                                                  
Render endp                                          
                                        
; Scans along a edge from bp,bx to ax,cx; colors: dh, dl
ScanGoraudeEdge proc                 
pusha                 
   cmp bx, cx                       
   je @SFEf_AbortDraw                                                
   jl @SFEf_Skip                                                     
       xchg bx, cx                                                   
       xchg ax, bp        
       xchg dl, dh                                   
   @SFEf_Skip:                      
 push dx                  
                                                                     
   sub ax, bp             
   shl eax, 16                                                       
   sub cx, bx           
                                                                     
   push ax   
      xor al, al      
      mov ah, dh          
      sub ah, dl   
      cwd             
     idiv cx          
      mov imm16_dc, ax                  
   pop ax

   cdq                    
                                                                     
  idiv ecx                                                           
   shl ebp, 16                                                       
                                                                     
   mov imm32_dx, eax                                                 
                               
   mov si, cx             
   shl bx, 2              
                                     
 pop ax                    
   shl ax, 8              
                                                     
   @SFEf_ScanLoop:        
       mov edx, dword ptr [offset polyx+bx]                       
                          
       cmp edx, 0ffffffffh                
       jnz @SFEf_PutRightEdge                        
           mov polyx[bx],ebp  
           mov byte ptr polyc[bx],ah
           jmp @EndLoop
       @SFEf_PutRightEdge:           
         push ax               
           mov polyx [bx], 0ffffffffh
           mov al, byte ptr polyc [bx]
                          
           cmp bx,800        
           ja @SFEf_finished
                                     
           mov ecx, ebp             
                               
           sar ecx, 16         
           sar edx, 16         
           cmp cx, dx          
           jge @SFEf_NoSwap    
               xchg cx, dx         
               xchg ah, al     
           @SFEf_NoSwap:       
                               
              sub cx, dx       
              jz @SFEf_finished
                          
              push ax                   
                mov di, bx
                shl di, 6 
                add di, dx
                mov dx, bx    
                shl dx, 4 
                add di, dx
                          
                sub ah, al
                xor al, al     
                cwd  
               idiv cx
                mov dx, ax                 
                                           
              pop ax                       
              shl ax, 8                    
                                           
              @HLineLoop:                  
                  add ax, dx
                  mov es:[di], ah
                  inc di                   
              dec cx                       
              jnz @HLineLoop               
           @SFEf_finished:                 
         pop ax                      
       @EndLoop:          
       db 066h,081h,0c5h ;add ebp, imm32             
       imm32_dx dd 0       
       db 05h ; add ax, imm16 
       imm16_dc dw 0          
       add bx,4                                      
       dec si                                        
   jnz @SFEf_ScanLoop               
   @SFEf_AbortDraw:                
popa                                                
ret                                                  
ScanGoraudeEdge endp     

; Draws a Julia fractal and morphes it
DrawJulia proc    
    xor di, di        
    mov es, lseg      
                      
    mov bp, offset j_y
                      
    mov eax, j_xy0                      
    mov ds:[bp], eax                                             
    mov si, di                                             
    add si, 32000                                           
    mov bx, offset j_r
    mov ax, offset j_dum
                                                             
    mov dl, 50         
    @J_YLoop:                                                  
       mov cx, 320         
       fld j_xy0                                             
       fst st(4)                                             
       @J_XLoop:        
        fld dword ptr ds:[bp]
        xor dh, dh       
        @J_Iterate:      
             fld st(1)   
             fmul st(0),st(2)
             fld st(1)   
             fmul st(0),st(2)
             fsubp st(1), st(0)
             fadd j_cx   
             fstp st(4)  
             fld st(1)   
             fmul st(0), st(1)
             fadd st(0), st(0)
             fadd j_cy   
             fstp st(3)    
             fmul st(0), st(0)
             fxch st(1)  
             fmul st(0), st(0)
             faddp st(1), st(0)
             fistp word ptr [bx]
             fld st(1)           
             fld st(1)           
             inc dh              
        cmp word ptr [bx], 4    
        jge @J_PutPixel            
        cmp dh, 20               
        jbe @J_Iterate             
        @J_Putpixel:     
        push si          
          mov si, ax     
          fstp dword ptr [si]                 
          fstp dword ptr [si]
        pop si                          
        mov es:[di], dh         
        inc di           
        mov es:[si], dh  
        dec si           
        fld st(3)        
        fadd j_dx        
        fst st(4)        
      dec cx             
      jnz @J_XLoop         
      push si            
        mov si, ax       
        fstp dword ptr [si]
      pop si             
      fld dword ptr [bp] 
      fadd j_dy          
      fstp dword ptr [bp]
    dec dl               
    jnz @J_YLoop         
                         
  mov bx, offset j_cx   
  mov cl, 2              
  @J_NextBound:                  
  fld dword ptr [bx]          
  fadd dword ptr [bx-16]       
  fst dword ptr [bx]     
  fistp j_dum            
  sub bx, 16               
  mov eax, j_dum         
  cmp eax, 2             
  jl @J_NotUpperBound    
     fld dword ptr [bx]  
     fchs                
     fstp dword ptr [bx] 
  @J_NotUpperBound:           
  cmp eax, -2            
  jg @J_NotLowerBound    
     fld dword ptr [bx]  
     fchs                 
     fstp dword ptr [bx] 
  @J_NotLowerBound:      
  add bx, 20             
  dec cl                 
  jnz @J_NextBound                                 
ret                          
DrawJulia endp                          
                    
; Shows julia fractal in 3d
ShowJulia3d proc    
   xor si, si       
   mov es, lseg     
   mov fs, bseg         
   mov bp, 320
   @J_XLoop2: 
      mov dl, 199          
      mov ch, 100       
      @J_YLoop2:        
           xor ax, ax
           mov al, es:[si]
           add si, 320
           push bp          
           mov bp, ax 
           mov ah, J_htab[bp]
           pop bp     
           xchg ah, al
           mov dh, ch       
           inc dh           
           add dh, 100      
           sub dh, al 
           cmp dl, dh    
           jb @J_NoDraw    
           mov al, ch    
           shr al, 2       
           add al, ah 
           mov ah, al    
           xor bx, bx            
           mov bh, dh    
           mov di, bx   
           shr bx, 2    
           add di, bx         
           add di, bp   
           mov bx, di    
           add al, 170     
           push dx         
           @J_Loop:          
              mov fs:[di], al 
              add di, 320  
           inc dh           
           cmp dh, dl       
           jb @J_Loop        
              add ah, ah 
              add ah, 170
              mov fs:[bx], ah     
           pop dx                 
           xchg dl, dh            
         @J_NoDraw:               
      dec ch                
      jnz @J_YLoop2      
      sub si, 32000   
      inc si               
    dec bp
    jnz @J_XLoop2        
ret                      
ShowJulia3d endp

; Creates a sinus waves map
MakeSinusMap proc
     mov di, offset si1
     mov cx, 256
     fld1
     fldz
     @MakeSLoop:
          fld st(0)
          fmul floatpi1
          fsin
          fmul float_256
          fistp word ptr [di]
          fld st(0)
          fmul floatpi2
          fsin
          fmul float_256
          fistp word ptr [di+256*2]
          fadd st(0),st(1)
          inc di
          inc di
     loop @MakeSLoop
     finit
ret
MakeSinusMap endp         

; Renders a waves larusse map with amplitude in bp
RenderWavesMap proc
    xor cx, cx
    xor di, di
    mov bx, offset si2
    mov es, lseg
    @YrwLoop:
        mov si, offset si1
        mov cl, 128
        @XrwLoop:
            mov ax, [si]
            imul bp
            mov al, ah
            inc si
            xor ah, ah
            push ax
            mov ax, [bx]
            imul bp
            pop dx
            add dh, ah
            inc si
            mov es:[di], dx
            inc di
            inc di                        
        dec cl
        jnz @XrwLoop
        inc bx
        inc bx
    dec ch
    jnz @YrwLoop
ret
RenderWavesMap endp

; Translate a segment with a waves lookup to es at time bx
TransWaveSeg proc
     pusha   
     mov di, 30
     mov bp, di

     mov dx, bx
     add dx, 320
     add bl, bl

     mov gs, lseg         
     mov fs, tseg

     mov ch, 200
     @YwLoop:
         mov bh, dl
         mov cl, 128
         @XwLoop:
            mov si,gs:[bx]
            dec bh
            add si, bp
            inc di
            mov al,fs:[si]
            mov si,gs:[bx]
            dec bh
            add si, bp
            inc di
            mov ah,fs:[si]
            inc bp
            mov es:[di], ax
            inc bp            
         dec cl
         jnz @XwLoop
         inc bl
         inc bl
         add di, 319-0ffh
     dec ch
     jnz @YwLoop
     popa
ret
TransWaveSeg endp

                     
; Constants                      
    TotalFaces  equ (192+32)*TotalObjs
    TotalPoints equ 1024            
    TotalObjs   equ 8
                                   
; Important Data                     
    VESA_Err    db 'VESA Error!$',13,10
    bye_msg     db 'shiva!bm$',13,10
    BMAP        db 28,'black.maiden.art.productions'
    Credits     db 10,'code.shiva'
    hohoho      db 9,'ho.hohoho'
    voteme      db 8,'vote.now' 
    xfac        dd 1011472820    ;=pi/0ffh
    yfac        dw 6000    
    Float_rad   dd 0.0061359232  ;=pi/512
    Float_256   dd 256.0
    Floatpi1    dd 0.0490873
    Floatpi2    dd 0.0245436
                      
    xcenter     dw 160         
    ycenter     dw 100               
    cRange      dw 64   
                      
    camz        dw 620
                        
    ;Whole object definitions
                                               
    LogoObject  db 0,0,0, 0,0,0, 0,0,0       ;radX,Y,Z, disX,Y,Z, orgX,Y,Z
                dw 0                         ;parent offset
                db 8,40,8, 0,0,0, 58,0,0 
                dw offset obj            
                db 20,20,10, 0,0,0, -30,20,0
                dw offset obj+200            
                db 20,20,10, 0,0,0, -30,-20,0
                dw offset obj+200
                db 8,40,8, 0,0,0, -10,0,0
                dw offset obj     
                db 8,40,8, 0,0,0, -58,0,0
                dw offset obj
                db 5,25,8, 0,0,0, -16,-10,0
                dw offset obj+200*4        
                db 5,25,8, 0,0,0, 16,-10,0
                dw offset obj+200*5
                                           
    BoyObject   db 20,25,20, 0,0,0, 0,-10,0
                dw 0       
                db 12,13,12, 0,13,0, 0,26,0
                dw offset obj      
                db 6,2,3, 0,0,0, 7,4,12 
                dw offset obj+200         
                db 6,2,3, 0,0,0, -7,4,12
                dw offset obj+200  
                db 16,4,4, 8,0,0,  22,18,0
                dw offset obj      
                db 16,4,4, -8,0,0,  -22,18,0
                dw offset obj      
                db 14,3,3, 8,0,0, 22,0,0
                dw offset obj+200*4
                db 14,3,3, -8,0,0, -22,0,0
                dw offset obj+200*5
                                                         
    ;Movement definitions                                
                                   
    LogoMove0   db 00,16,00,   0ffh                        
    LogoMove1   db 00,32,00,   0ffh                                            
    LogoMove2   db 08,16,08,   0ffh  
    LogoMove3   db -08,16,-08, 0ffh
    LogoMove4   db 16,16,16,   0ffh
    LogoMove5   db 32,32,32,   0ffh
    LogoMove6   db -8,-8,-8,   0ffh
    LogoPrep    db 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,0, 0,0,126, 0,0,-126
                                                                            
    BoyPrep     db 00,00,00,  0,0,0, 0,0,0, 0,0,0, 0,0,110, 0,0,-110, 0,100,0, 0,-100,0
                                                                                       
    BoyRun      db 8,20,00,  -8,10,0, 0,0,2, 0,0,-2, 0,10,0, 0,10,0, 0,-5,0, 0,-8,0
    BoyRunBack  db -8,20,00, 8,-10,0, 0,0,-2, 0,0,2, 0,-10,0, 0,-10,0, 0,5,0, 0,8,0
    BoyLook     db 0,0,0, -6,-10,0, 0ffh
                     
    LogoMove8   db 2,10,32, 0ffh   
    LogoMove9   db -2,10,32, 0ffh   
    LogoMove10  db 1,5,16, 0ffh
                                   
    ;Script table                  
                                   
    BlackScript db 1,0,0           
                dw offset LogoPrep        
                db 75,-4,0         
                dw offset LogoMove0        
                db 45,-2,0         
                dw offset LogoMove1
                db 20,-1,0          
                dw offset LogoMove2
                db 40,-1,0           
                dw offset LogoMove3  
                db 25,-1,0           
                dw offset LogoMove2  
                db 40,0,0            
                dw offset LogoMove4  
                db 32,0,0            
                dw offset LogoMove5  
                db 25,0,0            
                dw offset LogoMove4  
                db 20,0,0            
                dw offset LogoMove6  
                db 60,0,1            
                dw offset LogoMove0+3
                db 80,14,0           
                dw offset Pseg       
                                     
       part2    db 1,0,2             
                dw offset Pseg       
                db 4,-1,0            
                dw offset BoyPrep    
                db 15,0,0            
                dw offset BoyRunBack 
                db 30,0,0            
                dw offset BoyRun     
                db 30,0,0            
                dw offset BoyRunBack 
                db 1,0,3             
                dw 3
                db 65,0,0            
                dw offset BoyLook    
                db 60,0,4            
                dw offset LogoMove0+3
                                        
        part3   db 1,0,6
                dw offset LogoMove0+3
                db 1,0,5
                dw offset LogoPrep
                db 100,0,5 
                dw offset LogoMove8
                db 60,0,7
                dw offset LogoMove9
                db 60,0,5
                dw offset LogoMove10
                db 20,0,0
                dw offset LogoMove0+3
                                     
                db 0ffh ;Terminator  
                                     
    LightOne   dw 0,1,1, 0,1,1, 1,1,1   
    LightTwo   dw 1,1,0, 0,1,0, 0,1,1  
    LightThree dw 1,1,1, 1,1,0, 1,1,0
                          
    j_dcx    dd 0.05      
    j_dcy    dd 0.05      
    j_dx     dd 0.0125    
    j_dy     dd 0.04      
    j_cx     dd 1.5                    
    j_cy     dd 1.0                    
    j_xy0    dd -2.0      
    j_htab   db 0,1,6,18,40,47,52,55,58,60,62,63,64,65,66,66,67,68,70,74,74,75
                          
    nrscr    dw 3

    loopcount dw 0 
                      
    menu     db 13,10              
             db 'Video?Ŀ',13,10
             db 'vesa     1',13,10    
             db 'vga(sux) 2',13,10
             db '$'
             
    showproc dw offset showkewl         
                                                                     
; Zero Data                                                        
  @zerodata:      
    Old_Key    dd ?
    pseg       dw ? ;points                                          
    rseg       dw ? ;red screen                                      
    gseg       dw ? ;green screen                                    
    bseg       dw ? ;blue screen                                     
    tseg       dw ? ;texture segment                                 
    lseg       dw ? ;lookup segment
    sico       dd 2048 dup (?)                     
    temp_mat   dd 16 dup (?)    
    temp_mat2  dd 16 dup (?)    
    temp_word  dw ?             
    temp_vect  dd 3 dup (?)  
    temp_int   dw ?          
    obj        dd 1600 dup (?)
    faces      dw 9000 dup (?) ;max 1800 faces
    ilist      dw 1800 dup (?)
    zlist      dw 1800 dup (?)
    safe_1     dd 200 dup (?)
    polyx      dd 200 dup (?)
    safe_2     dd 200 dup (?)
    polyc      dd 200 dup (?)
    safe_3     dd 200 dup (?)                         
    miny       dw ?          
    Sort_len   dw ?       
    lsvar      dw ?         
    lightr     dd 3 dup (?)  
    lightg     dd 3 dup (?)                  
    lightb     dd 3 dup (?)
    r1         dw ? 
    r2         dw ?    
    r3         dw ?       
    tunnel1    dw ?  
    tunnel2    dw ? 
    pstart     dw ?         
    fstart     dw ?           
    ostart     dw ?   
    fos        dw ?    
    foo        dw ?        
    ef         db ?
    j_y        dd ?
    j_dum      dd ?             
    j_r        dd ?
    si1        dw 256 dup (?)
    si2        dw 256 dup (?)
    bloby      dw ?
                                     
 code ends                    
end start                    
                             
