;----------------------------------------------------------------------------;
; These procedures are used to fill a 4 sides polygon. This methode is not   ;
; the best you could have, but it runs perfectly on my poor 386dx33. So use  ;
; it in your own piece of code.                                              ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;




;----------------------------------------------------------------------------;
; CheckCWise - Check if a side is visible or not. Check for clock wise...    ;
; INPUT : DS,SI,DX=x's BP,DS,ES=y's                                          ;
; OUTPUT: CX (>0 then visible)      DESTRUCT: Nothing                        ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
CheckCWise  proc near
    cmp     di,si
    jng     orderok1
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok1:
    cmp     di,si
    jng     orderok2
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok2:
    mov     ax,dx
    sub     ax,di
    mov     bx,ds
    sub     bx,bp
    imul    bx
    mov     cx,ax
    mov     ax,si
    sub     ax,di
    mov     bx,es
    sub     bx,bp
    imul    bx
    sub     cx,ax
    ret
CheckCWise  endp




;----------------------------------------------------------------------------;
; SetFTable - Sets the table used for drawing the veticals lines.            ;
; INPUT : AX=x  CX=y                                                         ;
; OUTPUT: Nothing                   DESTRUCT: Nothing                        ;
; - used by DoLine to set table -                                            ;
;----------------------------------------------------------------------------;
SetFTable   proc near
    cmp     cx,200
    jae     EndSetFTable
    push    ax
    mov     bx,cx
    shl     bx,1
    cmp     ax,cs:firstbyte[bx]
    jg      SetLine1
    mov     cs:firstbyte[bx],ax
SetLine1:
    cmp     ax,cs:lastbyte[bx]
    jng     SetLine2
    mov     cs:lastbyte[bx],ax
SetLine2:
    pop     ax
EndSetFTable:
    ret
SetFTable   endp




;----------------------------------------------------------------------------;
; DoLine - Proceed line to know the start and the end of each line.          ;
; INPUT : X1,Y1,X2,Y2...                                                     ;
; OUTPUT: Nothing                   DESTRUCT: AX CX Deltax                   ;
; - used by FillPoly - uses SetFTable -                                      ;
;----------------------------------------------------------------------------;
DoLine      proc near
    mov     cx,cs:y2
    cmp     cx,cs:y1
    jg      NoSwapCoords    ; Check if y2>y1 to have a positive substraction,
    xchg    cx,cs:y1        ; which is need for a correct DeltaX
    mov     cs:y2,cx
    mov     ax,cs:x2
    xchg    ax,cs:x1    
    mov     cs:x2,ax
NoSwapCoords:
    mov     cx,cs:y2
    sub     cx,cs:y1        ; CX=y2-y1
    cmp     cx,0
    je      EndDoLine       ; Check if CX<>0
CalcDX:
    mov     ax,cs:x2
    sub     ax,cs:x1
    cwd
    shl     ax,7            ; AX=64*(x2-x1)
    idiv    cx
    mov     bp,ax           ; bp=64*(x2-x1)/(y2-y1)=DeltaX
    
    mov     cx,cs:y1
    inc     cx
    mov     dx,cs:y2
    mov     ax,cs:x1        ; ax=x1
    shl     ax,7
DoLineLoop:
    push    ax
    shr     ax,7
    call    SetFTable
    pop     ax
    add     ax,bp
    inc     cx
    cmp     cx,dx           ; CoMPare y1 & y2
    jng     DoLineLoop
EndDoLine:
    ret
DoLine      endp




;----------------------------------------------------------------------------;
; FillIt - Draws the calculated table. Line per line...                      ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: BP CX SI DX AX CX          ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
FillIt      proc near
    cld
    mov     cx,200
FillItLoop:
    mov     bp,cx
    mov     si,cx
    dec     si
    add     si,si
    cmp     cs:firstbyte[si],320
    je      EndFill
    mov     dx,cs:firstbyte[si]
    mov     ax,bp
    imul    ax,320
    add     ax,dx
    mov     di,ax
    mov     cx,cs:lastbyte[si]
    sub     cx,dx
    cmp     cx,0
    je      EndFill2
    mov     dl,cs:color
FillTransj:
    mov     al,es:[di]
    add     al,dl               ; DL is cs:color...
    mov     es:[di],al
    inc     di
    loop    FillTransj

EndFill2:    
    mov     cs:lastbyte[si],-1
    mov     cs:firstbyte[si],320
    mov     cx,bp
EndFill:
    loop    FillItLoop
    ret
FillIt      endp




;----------------------------------------------------------------------------;
; FillPoly - Draws a 4 sides polygon                                         ;
; INPUT : xvars, yvars, ES must be initialized                               ;
; OUTPUT: Nothing                       DESTRUCT: BX CX AX                   ;
; - uses CheckCWise, DoLine & FillIt -                                       ;
;----------------------------------------------------------------------------;
FillPoly    proc near
    
;    push    ds                 ; Get out this to see only the front sides.
;    push    es
;    mov     di,cs:xvars[0]
;    mov     si,cs:xvars[2]
;    mov     dx,cs:xvars[4]
;    mov     bp,cs:yvars[0]
;    mov     ds,cs:yvars[2]
;    mov     es,cs:yvars[4]
;    call    CheckCWise
;    pop     es
;    pop     ds
;    cmp     cx,0
;    jng     EndFillPoly
    
    mov     bx,0        ; 4*2 ...
    mov     cx,4        ; 4 sides...
FillPolyLoop:
    mov     ax,cs:xvars[bx]
    mov     cs:x1,ax
    mov     ax,cs:yvars[bx]
    mov     cs:y1,ax
    mov     ax,cs:xvars[bx+2]
    mov     cs:x2,ax
    mov     ax,cs:yvars[bx+2]
    mov     cs:y2,ax
    push    bx
    push    cx
    call    DoLine
    pop     cx
    pop     bx
    add     bx,2
    Loop    FillPolyLoop
    Call    FillIt
EndFillPoly:
    ret
FillPoly    endp




;-------------------------------------------------------------Global variables




firstbyte   dw 200 dup (320)    ; The famous table, used to have the start and
lastbyte    dw 200 dup (-1)     ; the end of the line to draw.

color       db  0

deltax      dw  0               ; For DoLine...

x1          dw  0               ; Temporary coordinates for DoLine.
y1          dw  0
x2          dw  0
y2          dw  0

xvars       dw  0,0,0,0,0
yvars       dw  0,0,0,0,0




