;----------------------------------------------------------------------------;
; Some stuff needed in classics assembler sources *;) Classics procedures    ;
; for a daily use of it.                                                     ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;




SetPix      proc near
    push    es
    imul    bx,320
    add     bx,ax
    mov     ax,0A000h
    mov     es,ax
    mov     es:[bx],dl
    pop     es
    ret
SetPix      endp


;----------------------------------------------------------------------------;
; WaitRetrace - Wait for vertical and horizontal retrace                     ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: AX DX                      ;
;----------------------------------------------------------------------------;
WaitRetrace proc near
    push    dx
    push    ax
    mov     dx,3DAh
@@waitr1:
    in      al,dx
    test    al,8
    jne     @@waitr1
@@waitr2:
    in      al,dx
    test    al,8
    je      @@waitr2
    pop     ax
    pop     dx
    ret
WaitRetrace endp




;----------------------------------------------------------------------------;
; ClearVideo - Clear the video screen at ESh:0000                            ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: AX DX                      ;
;----------------------------------------------------------------------------;
ClearVideo  proc near
    mov     cx,16000
    xor     di,di
    xor     eax,eax
    rep     stosd
    ret
ClearVideo  endp



;----------------------------------------------------------------------------;
; CopyVideo - Copy the video screen from DS:0000 to ES:0000                  ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: AX DX                      ;
;----------------------------------------------------------------------------;
CopyVideo   proc near
    mov     cx,16000
    xor     di,di
    xor     si,si
    rep     movsd
    ret
CopyVideo   endp



;----------------------------------------------------------------------------;
; TestESC - Test the ESCAPE key.                                             ;
; INPUT : Nothing                                                            ;
; OUTPUT: set carry if pressed...       DESTRUCT: AX                         ;
;----------------------------------------------------------------------------;
TestESC     proc near
    mov     ah,11h
    int     16h         ; has a key been pressed? Z flag is set if not
    jnz     GetESCKey
    clc                 ; we continue
    ret                 ; get back main prog ...
GetESCKey:
    mov     ah,10h      ; a key has been pressed, 
    int     16h         ; get it in AX (al= ascii, ah=scan code)

    cmp     al,27       ; was it the ESCAPE key?
    jne     NotESCk
    stc                 ; we signal a quit
    ret                 ; get back ... with Z flag on ...

NotESCk:
    clc                 ; no valid keypress... Continue
    ret                 ; get back to ...
TestESC     endp




