;----------------------------------------------------------------------------;
; These procedures are used to fill a square polygon. This methode is not    ;
; the best you could have, but it runs perfectly on my poor 386dx33. So use  ;
; it in your own piece of code. These procedures make vertical clipping.     ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;




;----------------------------------------------------------------------------;
; CheckCWise - Check if a side is visible or not. Check for clock wise...    ;
; INPUT : DI,SI,DX=x's BP,DS,ES=y's                                          ;
; OUTPUT: CX (>0 then visible)      DESTRUCT: Nothing                        ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
CheckCWise  proc near
    cmp     di,si
    jng     orderok1
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok1:
    cmp     di,si
    jng     orderok2
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok2:
    mov     ax,dx
    sub     ax,di
    mov     bx,ds
    sub     bx,bp
    imul    bx
    mov     cx,ax
    mov     ax,si
    sub     ax,di
    mov     bx,es
    sub     bx,bp
    imul    bx
    sub     cx,ax
    ret
CheckCWise  endp




;----------------------------------------------------------------------------;
; SetFTable - Sets the table used for drawing the veticals lines.            ;
; INPUT : AX=x  CX=y                                                         ;
; OUTPUT: Nothing                   DESTRUCT: Nothing                        ;
; - used by DoLine to set table -                                            ;
;----------------------------------------------------------------------------;
SetFTable   proc near
    cmp     cx,200
    jae     EndSetFTable
    
    mov     bx,cx
    shl     bx,1
    cmp     ax,cs:[si+bx]
    jg      SetLine1
    mov     cs:[si+bx],ax
SetLine1:
    cmp     ax,cs:[di+bx]
    jng     SetLine2
    mov     cs:[di+bx],ax
SetLine2:
    
EndSetFTable:
    ret
SetFTable   endp




;----------------------------------------------------------------------------;
; DoLine - Proceed line to know the start and the end of each line.          ;
; INPUT : X1,Y1,X2,Y2...                                                     ;
; OUTPUT: Nothing                   DESTRUCT: AX CX Deltax                   ;
; - used by FillPoly - uses SetFTable -                                      ;
;----------------------------------------------------------------------------;
DoLine      proc near
    mov     cx,cs:y2
    cmp     cx,cs:y1
    jg      NoSwapCoords    ; Check if y2>y1 to have a positive substraction,
    xchg    cx,cs:y1        ; which is need for a correct DeltaX
    mov     cs:y2,cx
    mov     ax,cs:x2
    xchg    ax,cs:x1    
    mov     cs:x2,ax
NoSwapCoords:
    mov     cx,cs:y2
    sub     cx,cs:y1        ; CX=y2-y1
    cmp     cx,0
    je      EndDoLine
CalcDX:
    mov     ax,cs:x2
    sub     ax,cs:x1
    cwd
    shl     ax,7            ; AX=128*(x2-x1)
    idiv    cx
    mov     bp,ax           ; bp=128*(x2-x1)/(y2-y1)=DeltaX

    mov     si,offset cs:firstbyte
    mov     di,offset cs:lastbyte
    
    mov     cx,cs:y1
    inc     cx              ; dec cx=y1
    mov     dx,cs:y2
    mov     ax,cs:x1        ; ax=x1
    shl     ax,7
DoLineLoop:
    push    ax
    shr     ax,7
    call    SetFTable
    pop     ax
    add     ax,bp           ; Add DeltaX to the abscissa.
    inc     cx
    cmp     cx,dx
    jng     DoLineLoop
EndDoLine:
    ret
DoLine      endp




;----------------------------------------------------------------------------;
; FillIt - Draws the calculated table. Line per line...                      ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: BP CX SI DX AX CX          ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
FillIt      proc near
    cld
    mov     cx,200
FillItLoop:
    mov     bp,cx
    mov     si,cx
    dec     si
    add     si,si
    cmp     cs:firstbyte[si],320
    je      EndFill
    mov     dx,cs:firstbyte[si]
    mov     ax,bp
    dec     ax
    mov     bx,ax
    shl     ax,6
    shl     bx,8
    add     ax,bx
    add     ax,dx
    mov     di,ax
    mov     cx,cs:lastbyte[si]
    sub     cx,dx
    mov     al,cs:color
    rep     stosb
    mov     cs:lastbyte[si],-1      ; IMPORTANT !
    mov     cs:firstbyte[si],320    ; the tables must be re-initialized.
    mov     cx,bp
EndFill:
    dec     cx
    jnz     FillItLoop
    ret
FillIt      endp




;----------------------------------------------------------------------------;
; FillPoly - Draws a 4 sides polygon                                         ;
; INPUT : xvars, yvars, ES must be initialized                               ;
; OUTPUT: Nothing                       DESTRUCT: BX CX AX                   ;
; - uses CheckCWise, DoLine & FillIt -                                       ;
;----------------------------------------------------------------------------;
FillPoly    proc near
    
    push    ds
    push    es
    mov     di,cs:xvars[0]
    mov     si,cs:xvars[2]
    mov     dx,cs:xvars[4]
    mov     bp,cs:yvars[0]
    mov     ds,cs:yvars[2]
    mov     es,cs:yvars[4]
    call    CheckCWise
    pop     es
    pop     ds
    cmp     cx,0
    jng     EndFillPoly     ; Put JNL instead JNG and see inside the cube...
    
    mov     bx,0
    mov     cx,4            ; 4 sides...
FillPolyLoop:
    mov     ax,cs:xvars[bx]
    mov     cs:x1,ax
    mov     ax,cs:yvars[bx]
    mov     cs:y1,ax
    mov     ax,cs:xvars[bx+2]
    mov     cs:x2,ax
    mov     ax,cs:yvars[bx+2]
    mov     cs:y2,ax
    push    bx
    push    cx
    call    DoLine
    pop     cx
    pop     bx
    add     bx,2
    dec     cx
    jnz     FillPolyLoop
    Call    FillIt
EndFillPoly:
    ret
FillPoly    endp




;-------------------------------------------------------------Global variables




firstbyte   dw 200 dup (320)    ; The famous table, used to have the start and
lastbyte    dw 200 dup (-1)     ; the end of the line to draw.

color       db  0               ; he ? what is it ?

deltax      dw  0               ; For DoLine...

x1          dw  0               ; Temporary coordinates for DoLine.
y1          dw  0
x2          dw  0
y2          dw  0

xvars       dw  0,0,0,0,0       ; couples coordinates of the polygon.
yvars       dw  0,0,0,0,0





;----------------------------------------------------------------------------;
; NOTES:                                                                     ;
; The coordinates of the square  polygon must be initialized in CS:XVARS and ;
; CS:YVARS tables. Five couples of coordinates must be set. The last one is  ;
; same as the first one. The color of the square polygon must be set in the  ;
; byte CS:COLOR. The Extra Segment have to be initialized before the call of ;
; the FILLPOLY procedure, ES contains the segment address of the destination ;
; where the polygon is drawing.                                                 ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;
