;----------------------------------------------------------------------------;
; Here is some simple and classics 3D routines. You could make rototions and ;
; 3D transformations with them. Use this shitty piece of code as many as you ;
; want in your own productions. Hey, coordinates (50,50,50) are small here!  ;
; You should use bigger coords for your objects, like (300,300,300).         ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;




;----------------------------------------------------------------------------;
; RotateX - Rotation of point around the X axis.                             ;
; INPUT : CX=y BP=z                                                          ;
; OUTPUT: CX=y BP=z                     DESTRUCT: AX BX CX DX DI SI          ;
;----------------------------------------------------------------------------;
RotateX     proc near
    push    es
    mov     ax,0
    mov     al,cs:anglex
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    cx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    cx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     bp,di
    mov     cx,es
    
    pop     es
    ret
RotateX     endp



;----------------------------------------------------------------------------;
; RotateY - Rotation of point around the Y axis.                             ;
; INPUT : BX=x BP=z                                                          ;
; OUTPUT: BX=x BP=z                     DESTRUCT: AX BX CX DX DI SI          ;
;----------------------------------------------------------------------------;
RotateY     proc near
    push    es
    mov     ax,0
    mov     al,cs:angley
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     bp,di
    mov     bx,es

    pop     es
    ret
RotateY     endp



;----------------------------------------------------------------------------;
; RotateZ - Rotation of point around the Z axis.                             ;
; INPUT : BX=x CX=y                                                          ;
; OUTPUT: BX=x CX=y                     DESTRUCT: AX BX CX DX DI SI          ;
;----------------------------------------------------------------------------;
RotateZ     proc near
    push    es
    mov     ax,0
    mov     al,cs:anglez
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    cx
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    cx
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     cx,di
    mov     bx,es
    
    pop     es
    ret
RotateZ     endp




;----------------------------------------------------------------------------;
; Rotate - Rotation of point around all axis.                                ;
; INPUT : BX=x CX=y BP=z                                                     ;
; OUTPUT: BX=x CX=y BP=z                DESTRUCT: AX BX CX DX DI SI          ;
;----------------------------------------------------------------------------;
Rotate      proc near
    push    es
    mov     ax,0
    mov     al,cs:anglex
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    cx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    cx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     bp,di
    mov     cx,es
    
    mov     ax,0
    mov     al,cs:angley
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    bp
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     bp,di
    mov     bx,es


    mov     ax,0
    mov     al,cs:anglez
    mov     si,ax
    add     si,si

    mov     ax,cs:cosine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax
    
    mov     ax,cs:sine[si]
    imul    cx
    shl     edx,16
    mov     dx,ax
    sub     edi,edx
    sar     edi,14
    mov     es,di           ; preserve

    mov     ax,cs:sine[si]
    imul    bx
    mov     di,dx
    shl     edi,16
    mov     di,ax

    mov     ax,cs:cosine[si]
    imul    cx
    shl     edx,16
    mov     dx,ax
    add     edi,edx
    sar     edi,14
    
    mov     cx,di
    mov     bx,es
    
    pop     es
    ret
Rotate      endp



;----------------------------------------------------------------------------;
; Transform - Transforme a 3D (x,y,z) point in a 2D (xp,yp) point.           ;
; INPUT : CX=x BX=y BP=z                                                     ;
; OUTPUT: AX=x BX=y                         DESTRUCT: AX CX BX DX            ;
;----------------------------------------------------------------------------;
Transform   proc near
    push    di
    mov     di,128
    add     bp,cs:addz
;    add     bx,cs:addy
    mov     ax,bx
    imul    di
    idiv    bp              
    add     ax,cs:ycenter   
    mov     bx,ax           ; bx=y?
    
;    add     cx,cs:addx
    mov     ax,cx
    imul    di
    idiv    bp              ; BP already initialized
    add     ax,cs:xcenter   ; ax=x

    pop     di
    ret
Transform   endp



;------------------------------------------------------------Globals Variables


include \demo\asm\include\sincos.inc ; 16384*(co)sine table. 256 angles.

xcenter dw  160     ; 2D center point of the screen.
ycenter dw  100

;addx    dw  0
;addy    dw  0
addz    dw  800     ; Try another value to see the effect...

anglex  db  0       ; Angles to increment for the rotation.
angley  db  0       
anglez  db  0





                  db '3D procedures - (c)opyright Trantor of Zen, May 1996.',0
