.286
.model small
.stack 100h

public  copper_routine

.data
xpage   db 0

palette db 0,0,0
    i = 63
    rept 50
        db i/2,i/3,i
        db i/2,i/3,i
    i = i-1
    endm
    rept 50
        db i/2,i/3,i
        db i/2,i/3,i
    i = i+1
    endm
    i = 10
    rept 10
        db i,i/2,i/3
    i = i+5
    endm
    rept 10
        db i,i/2,i/3
    i = i-5
    endm
    rept 7
        db i/3,i*3/2,i
    i = i+5
    endm
    i = 35
    rept 7
        db i/3,i*3/2,i
    i = i-5
    endm
    db 23*3 dup (0)

current dw 0

sintbl  dw         0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
costbl  dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128
        dw       128 , 128 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,126
        dw       126 , 126 , 126 , 126 , 125 , 125 , 125 , 125 , 124 ,124
        dw       124 , 124 , 123 , 123 , 123 , 122 , 122 , 122 , 121 ,121
        dw       120 , 120 , 120 , 119 , 119 , 118 , 118 , 118 , 117 ,117
        dw       116 , 116 , 115 , 115 , 114 , 114 , 113 , 113 , 112 ,112
        dw       111 , 110 , 110 , 109 , 109 , 108 , 108 , 107 , 106 ,106
        dw       105 , 104 , 104 , 103 , 102 , 102 , 101 , 100 , 100 , 99
        dw        98 ,  97 ,  97 ,  96 ,  95 ,  95 ,  94 ,  93 ,  92 , 91
        dw        91 ,  90 ,  89 ,  88 ,  87 ,  87 ,  86 ,  85 ,  84 , 83
        dw        82 ,  82 ,  81 ,  80 ,  79 ,  78 ,  77 ,  76 ,  75 , 74
        dw        74 ,  73 ,  72 ,  71 ,  70 ,  69 ,  68 ,  67 ,  66 , 65
        dw        64 ,  63 ,  62 ,  61 ,  60 ,  59 ,  58 ,  57 ,  56 , 55
        dw        54 ,  53 ,  52 ,  51 ,  50 ,  49 ,  48 ,  47 ,  46 , 45
        dw        44 ,  43 ,  42 ,  41 ,  40 ,  39 ,  37 ,  36 ,  35 , 34
        dw        33 ,  32 ,  31 ,  30 ,  29 ,  28 ,  27 ,  26 ,  24 , 23
        dw        22 ,  21 ,  20 ,  19 ,  18 ,  17 ,  16 ,  15 ,  13 , 12
        dw        11 ,  10 ,   9 ,   8 ,   7 ,   6 ,   4 ,   3 ,   2 ,  1
        dw         0 ,  -1 ,  -2 ,  -3 ,  -4 ,  -6 ,  -7 ,  -8 ,  -9 ,-10
        dw       -11 , -12 , -13 , -15 , -16 , -17 , -18 , -19 , -20 ,-21
        dw       -22 , -23 , -24 , -26 , -27 , -28 , -29 , -30 , -31 ,-32
        dw       -33 , -34 , -35 , -36 , -37 , -39 , -40 , -41 , -42 ,-43
        dw       -44 , -45 , -46 , -47 , -48 , -49 , -50 , -51 , -52 ,-53
        dw       -54 , -55 , -56 , -57 , -58 , -59 , -60 , -61 , -62 ,-63
        dw       -64 , -65 , -66 , -67 , -68 , -69 , -70 , -71 , -72 ,-73
        dw       -74 , -74 , -75 , -76 , -77 , -78 , -79 , -80 , -81 ,-82
        dw       -82 , -83 , -84 , -85 , -86 , -87 , -87 , -88 , -89 ,-90
        dw       -91 , -91 , -92 , -93 , -94 , -95 , -95 , -96 , -97 ,-97
        dw       -98 , -99 ,-100 ,-100 ,-101 ,-102 ,-102 ,-103 ,-104 ,-104
        dw      -105 ,-106 ,-106 ,-107 ,-108 ,-108 ,-109 ,-109 ,-110 ,-110
        dw      -111 ,-112 ,-112 ,-113 ,-113 ,-114 ,-114 ,-115 ,-115 ,-116
        dw      -116 ,-117 ,-117 ,-118 ,-118 ,-118 ,-119 ,-119 ,-120 ,-120
        dw      -120 ,-121 ,-121 ,-122 ,-122 ,-122 ,-123 ,-123 ,-123 ,-124
        dw      -124 ,-124 ,-124 ,-125 ,-125 ,-125 ,-125 ,-126 ,-126 ,-126
        dw      -126 ,-126 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128 ,-128
        dw      -128 ,-128 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-127 ,-126
        dw      -126 ,-126 ,-126 ,-126 ,-125 ,-125 ,-125 ,-125 ,-124 ,-124
        dw      -124 ,-124 ,-123 ,-123 ,-123 ,-122 ,-122 ,-122 ,-121 ,-121
        dw      -120 ,-120 ,-120 ,-119 ,-119 ,-118 ,-118 ,-118 ,-117 ,-117
        dw      -116 ,-116 ,-115 ,-115 ,-114 ,-114 ,-113 ,-113 ,-112 ,-112
        dw      -111 ,-110 ,-110 ,-109 ,-109 ,-108 ,-108 ,-107 ,-106 ,-106
        dw      -105 ,-104 ,-104 ,-103 ,-102 ,-102 ,-101 ,-100 ,-100 ,-99
        dw       -98 , -97 , -97 , -96 , -95 , -95 , -94 , -93 , -92 ,-91
        dw       -91 , -90 , -89 , -88 , -87 , -87 , -86 , -85 , -84 ,-83
        dw       -82 , -82 , -81 , -80 , -79 , -78 , -77 , -76 , -75 ,-74
        dw       -74 , -73 , -72 , -71 , -70 , -69 , -68 , -67 , -66 ,-65
        dw       -64 , -63 , -62 , -61 , -60 , -59 , -58 , -57 , -56 ,-55
        dw       -54 , -53 , -52 , -51 , -50 , -49 , -48 , -47 , -46 ,-45
        dw       -44 , -43 , -42 , -41 , -40 , -39 , -37 , -36 , -35 ,-34
        dw       -33 , -32 , -31 , -30 , -29 , -28 , -27 , -26 , -24 ,-23
        dw       -22 , -21 , -20 , -19 , -18 , -17 , -16 , -15 , -13 ,-12
        dw       -11 , -10 ,  -9 ,  -8 ,  -7 ,  -6 ,  -4 ,  -3 ,  -2 , -1
        dw        0 ,   1 ,   2 ,   3 ,   4 ,   6 ,   7 ,   8 ,   9 , 10
        dw        11 ,  12 ,  13 ,  15 ,  16 ,  17 ,  18 ,  19 ,  20 , 21
        dw        22 ,  23 ,  24 ,  26 ,  27 ,  28 ,  29 ,  30 ,  31 , 32
        dw        33 ,  34 ,  35 ,  36 ,  37 ,  39 ,  40 ,  41 ,  42 , 43
        dw        44 ,  45 ,  46 ,  47 ,  48 ,  49 ,  50 ,  51 ,  52 , 53
        dw        54 ,  55 ,  56 ,  57 ,  58 ,  59 ,  60 ,  61 ,  62 , 63
        dw        64 ,  65 ,  66 ,  67 ,  68 ,  69 ,  70 ,  71 ,  72 , 73
        dw        74 ,  74 ,  75 ,  76 ,  77 ,  78 ,  79 ,  80 ,  81 , 82
        dw        82 ,  83 ,  84 ,  85 ,  86 ,  87 ,  87 ,  88 ,  89 , 90
        dw        91 ,  91 ,  92 ,  93 ,  94 ,  95 ,  95 ,  96 ,  97 , 97
        dw        98 ,  99 , 100 , 100 , 101 , 102 , 102 , 103 , 104 ,104
        dw       105 , 106 , 106 , 107 , 108 , 108 , 109 , 109 , 110 ,110
        dw       111 , 112 , 112 , 113 , 113 , 114 , 114 , 115 , 115 ,116
        dw       116 , 117 , 117 , 118 , 118 , 118 , 119 , 119 , 120 ,120
        dw       120 , 121 , 121 , 122 , 122 , 122 , 123 , 123 , 123 ,124
        dw       124 , 124 , 124 , 125 , 125 , 125 , 125 , 126 , 126 ,126
        dw       126 , 126 , 127 , 127 , 127 , 127 , 127 , 127 , 127 ,128
        dw       128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 , 128 ,128

bar1    db 28,14,12
bar1s   dw 360,0,360
bar2    db 14,28,12
bar2s   dw 360,360,0

.386
.code
        mov     ax,@data
        mov     ds,ax
        call    copper_routine

        mov     ax,0003h
        int     10h
        mov     ax,4c00h
        int     21h

proc    copper_routine
        mov     ax,@data
        mov     ds,ax
        mov     ax,0012h
        int     10h
        mov     ax,0013h
        int     10h
        push    0a000h
        pop     es
        mov     dx,3c4h
        mov     ax,0604h
        out     dx,ax
        mov     dx,3d4h
        mov     ax,0014h
        out     dx,ax
        mov     ax,0e317h
        out     dx,ax
        mov     ax,109h
        out     dx,ax

        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        mov     cx,768
clear_pal:
        xor     al,al
        out     dx,al
        loop    clear_pal

        mov     cx,64        
        mov     current,0
fade_in_loop:
        push    cx
        call    copper_bars
        call    flip_page
        call    fade
        inc     current
        pop     cx
        loop    fade_in_loop

        mov     cx,400
copper_loop:
        push    cx
        call    copper_bars
        call    flip_page
        pop     cx
        loop    copper_loop

        mov     cx,64
fade_out_loop:
        push    cx
        call    copper_bars
        call    flip_page
        call    fade
        dec     current
        pop     cx
        loop    fade_out_loop
        ret
endp    copper_routine

proc    copper_bars
        mov     cx,8
        mov     ax,bar1s[0]
        push    ax
        mov     ax,bar1s[2]
        push    ax
        mov     ax,bar1s[4]
        push    ax
back_bar:
        push    cx
        call    add_bar_one
        call    add_bar_one
        call    add_bar_one
        mov     bx,bar1s[0]
        mov     ax,sintbl[bx]
        mov     bx,bar1s[2]
        add     ax,costbl[bx]
        mov     bx,bar1s[4]
        sub     ax,sintbl[bx]
        neg     ax
        sar     ax,2
        add     ax,100
        call    draw_bar_one
        pop     cx
        loop    back_bar
        pop     ax
        mov     bar1s[4],ax
        pop     ax
        mov     bar1s[2],ax
        pop     ax
        mov     bar1s[0],ax
        call    add_bar_one

        mov     ax,bar2s[0]
        push    ax
        mov     ax,bar2s[2]
        push    ax
        mov     ax,bar2s[4]
        push    ax
        mov     cx,7
foreground_bar:
        push    cx
        call    add_bar_two
        call    add_bar_two
        call    add_bar_two
        call    add_bar_two
        mov     bx,bar2s[0]
        mov     ax,costbl[bx]
        mov     bx,bar2s[2]
        sub     ax,sintbl[bx]
        mov     bx,bar2s[4]
        add     ax,costbl[bx]
        neg     ax
        sar     ax,3
        add     ax,100-7
        call    draw_bar_two
        pop     cx
        loop    foreground_bar
        pop     ax
        mov     bar2s[4],ax
        pop     ax
        mov     bar2s[2],ax
        pop     ax
        mov     bar2s[0],ax
        call    add_bar_two
        ret
draw_bar_one:
        call    get_page
        mov     dx,80
        mul     dx
        or      ax,ax
        jns     no_negative
        xor     ax,ax
no_negative:
        add     di,ax
        mov     eax,0c9c9c9c9h
        mov     cx,19
bar_one_height_loop:
        push    cx
        mov     cx,20
        rep     stosd
        inc     ah
        inc     al
        add     eax,000010000h
        add     eax,001000000h
        pop     cx
        loop    bar_one_height_loop
        ret
draw_bar_two:
        call    get_page
        mov     dx,80
        mul     dx
        add     di,ax
        mov     eax,0ddddddddh
        mov     cx,13
bar_two_height_loop:
        push    cx
        mov     cx,20
        rep     stosd
        inc     ah
        inc     al
        add     eax,000010000h
        add     eax,001000000h
        pop     cx
        loop    bar_two_height_loop
        ret
add_bar_one:
        xor     ah,ah
        mov     al,bar1[0]
        add     bar1s[0],ax
        cmp     bar1s[0],2*720
        jb      bar1s0ok
        sub     bar1s[0],2*720
bar1s0ok:
        mov     al,bar1[1]
        add     bar1s[2],ax
        cmp     bar1s[2],2*720
        jb      bar1s2ok
        sub     bar1s[2],2*720
bar1s2ok:
        mov     al,bar1[2]
        add     bar1s[4],ax
        cmp     bar1s[4],2*720
        jb      bar1s4ok
        sub     bar1s[4],2*720
bar1s4ok:
        ret
add_bar_two:
        xor     ah,ah
        mov     al,bar2[0]
        add     bar2s[0],ax
        cmp     bar2s[0],2*720
        jb      bar2s0ok
        sub     bar2s[0],2*720
bar2s0ok:
        mov     al,bar2[1]
        add     bar2s[2],ax
        cmp     bar2s[2],2*720
        jb      bar2s2ok
        sub     bar2s[2],2*720
bar2s2ok:
        mov     al,bar2[2]
        add     bar2s[4],ax
        cmp     bar2s[4],2*720
        jb      bar2s4ok
        sub     bar2s[4],2*720
bar2s4ok:
        ret
endp    copper_bars

proc    get_page
        cmp     xpage,1
        jz      page_one
        mov     di,16000
        ret
page_one:
        xor     di,di
        ret
endp    get_page

proc    flip_page
        cmp     xpage,0
        jz      page_two
        mov     xpage,0
        xor     bx,bx
        call    set_offset
        mov     di,16000
        call    clear_other_page
        jmp     pages_flipped
page_two:
        mov     xpage,1
        mov     bx,16000
        call    set_offset
        xor     di,di
        call    clear_other_page
pages_flipped:
        ret
clear_other_page:
        mov     dx,3c4h
        mov     ax,0f02h
        out     dx,ax
        xor     eax,eax
        mov     cx,200
background_colors:
        push    cx
        mov     cx,20
        rep     stosd
        inc     ah
        inc     al
        add     eax,000010000h
        add     eax,001000000h
        pop     cx
        loop    background_colors
        ret
endp    flip_page

proc    set_offset
        pusha
        mov     dx,3d4h
        mov     al,0ch
        mov     ah,bh
        out     dx,ax
        inc     al
        mov     ah,bl
        out     dx,ax
        mov     dx,3dah
        in      al,dx
        test    al,8
        jnz     $-3
        in      al,dx
        test    al,8
        jz      $-3
        popa
        ret
endp    set_offset

proc    fade
        pusha
        mov     cx,(256-22)*3
        mov     dx,3c8h
        xor     al,al
        out     dx,al
        inc     dx
        lea     si,palette
        mov     bx,current

fade_all_5:
        push    cx
        lodsb
        cmp     bl,al
        jae     no_fade
        mov     al,bl
no_fade:
        out     dx,al
        pop     cx
        loop    fade_all_5
        popa
        ret
endp    fade
end
