;
;
; Objectos en 3D slidos!!!
; Versin 3.50
;
; Copyright Chc/Chc!Productions
; Also named: Jorge Cabezas Garcia
;
; Version 1.00 : 24,25,26 de Diciembre de 1993 y 1 de Enero de 1994
; Version 2.00 : 2,3,4,5 y 6 de Junio de 1994
; Version 3.00 : 19,20 y 21 de Julio de 1995
; Version 3.50 : 30 y 31 de Agosto, 1 y 2 de Septiembre
;
;
;
;ESTRUCTURA OBJECTO:
;
;  NAME   OFFSET              LONG     DESCRIPCION
;
; verts     0                  2     Nmero de vrtices que tiene el objecto
; plans     2                  2     Nmero de planos que tiene el objecto
; -----     4               12*verts Coordenada x,y,z para cada vrtice (32 bits)
; -----  4+12*verts         12*verts Normal en el punto correspondiente
; pverts 4+24*verts            2     Nmero de vrtices en este plano                
; pcol   6+24*verts            2     Color del plano                                   Para cada
; -----  8+24*verts         2*pverts Indices a cada uno de los vrtices del plano *    uno de los
; pvis   8+24+verts+2*pverts   2     COMANDO                                           planos...
;   .             .            .                         .                           
;   .             .            .                         .
;   .             .            .                         .
;                                   
;
; * ) el primero de los indices apunta al vector normal usado en caso de
;     sombreado...
;
;
;
; VERSION 2.00 :
;
;       - El cdigo ya no es para utilizar desde Turbo Pascal y esto me permite
;         meterlo TODO en el segmento de datos, por lo cual ya no tengo que usar
;         prefijos de segmento en NINGUNA instruccin (ms velocidad)
;
;       - He hecho algunas optimizaciones de instrucciones, como en el caso
;         del paso final (dibujar poligonos) en el cual la rutina ahora va
;         un 300% ms rpida que la anterior...como mnimo... ;-)
;
;       - Ahora la rutina slo soporta 32 bits para hacer los clculos, y a la
;         hora de dibujar las coordenadas X e Y de los polgonos deben de ser
;         de 16 bits... (eso no parece un problema...supongo que ser difcil
;         que salga una X  Y REAL en la pantalla mayor de 32768...)
;
;       - La rutina de rotaciones es todava de 12 multiplicaciones, pero la
;         he optimizado bastante (le he quitado ms de 12 instrucciones)
;
;
;
; VERSION 3.00 :
;
;         - El mtodo de ordenacin ha variado un poquitn
;
;         - Ms velocidad al usar modo 256 no-tweaked
;
;         - Ahora realiza la totalidad de los clculos de rotacin a travs
;           de una matriz de rotacion en los tres ngulos, con lo que cual
;           se gana mucha velocidad (y 3 multiplicaciones!)
;
;         - Ahora recoge sin problemas objetos de 3D Studio 3.0 desde el
;           conversor ASC2R3D (.ASC to .R3D)
;
;         - COMANDO ahora es:
;
;                       0 -> siempre visible
;                       1 -> testeo de visibilidad
;
;         - Ahora ya soporta PHONG a una velocidad muy razonable...
;
;
;
; VERSION 3.50 :
;
;         - Utiliza ahora el mtodo FastSortingConstant (TM)(Copyright)
;           Este mtodo me permite ordenar polgonos con coste constante a
;           travs de dos listas doblemente enlazadas...
;
;         - Adaptado especificamente slo para tringulos
;
;         - COMANDO ya no sirve de nada, simplemente se ignora
;
;

                CENTROX equ 240
                CENTROY equ 100

; posicin de cada vrtice

X1 EQU 0
Y1 EQU 4
Z1 EQU 8
XX EQU 12
YY EQU 14

; para la visibilidad de los objetos

XX1 EQU 0
YY1 EQU 2
XX2 EQU 8
YY2 EQU 10
XX3 EQU 16
YY3 EQU 18

;
;Macro que testea la visibilidad de un plano,mediante el mtodo
;del vector normal al plano (slo se calcula la componente Z)
;si la componente es negativa (o positiva, depende del sistema de referencia)
;el plano no se ve...
;

VISIBILITY  MACRO

            ;calcula V1 y V2 (slo componentes X e Y)

            mov bx,OFFSET coordsnew     ;coordenadas recin calculadas
            mov ax,fs:[si]              ;carga ndice del vrtice actual
            shl ax,4                    ;16 bytes por vertice
            add bx,ax                   ;posicin del vrtice

            mov cx,[bx+12]              ;X real
            mov dx,[bx+14]              ;Y real

            mov bx,OFFSET coordsnew     ;coordenadas recin calculadas
            mov ax,fs:[si+2]            ;carga ndice del vrtice actual
            shl ax,4                    ;16 bytes por vertice
            add bx,ax                   ;posicin del vrtice

            sub cx,[bx+12]
            sub dx,[bx+14]
            movsx ecx,cx
            mov [v1x],ecx               ;V1(x,y) = P0(x,y) - P1(x,y)
            movsx edx,dx
            mov [v1y],edx

            mov cx,[bx+12]
            mov dx,[bx+14]
            neg cx
            neg dx

            mov bx,OFFSET coordsnew     ;coordenadas recin calculadas
            mov ax,fs:[si+4]            ;carga ndice del vrtice actual
            shl ax,4                    ;16 bytes por vertice
            add bx,ax                   ;posicin del vrtice

            add cx,[bx+12]              ;X real
            add dx,[bx+14]              ;Y real

            movsx ecx,cx
            mov [v2x],ecx               ;V2(x,y) = P2(x,y) - P1(x,y)
            movsx edx,dx
            mov [v2y],edx

            ;calcula ahora la componente Z del vector normal

            mov eax,[v1x]
            imul dword ptr [v2y]
            mov ecx,eax
            mov eax,[v1y]
            neg eax                ;z = (V1x*V2y - V1y*V2x)
            imul dword ptr [v2x]
            add ecx,eax

            ENDM

; Realiza algunos clculos para optimizar las rotaciones
;
; Esta es la mejora que se deriva de los anteriores clculos que
; realizaba en la version 2.00 . La matriz de giro es algo tal que
; as:
;                                             
;       c2*c3             c2*s3          s2   
;  -s1*s2*c3-c1*s3   -s1*s2*s3+c1*c3    s1*c2 
;  -c1*s2*c3+s1*s3   -c1*s2*s3-s1*c3    c1*c2 
;                                             
;
; s1 = sin(Xangle)      c1 = cos(Xangle)
; s2 = sin(Yangle)      c2 = cos(Yangle)
; s3 = sin(Zangle)      c3 = cos(Zangle)
;
; NOTA: no he tomado en consideracin si el giro es o no en la direccin
;       correcto, ya que no me interesa que sea correcto...en fin...que
;       me da igual... ;-)
;

CALCMATRIX  MACRO

            ; preclculos y ms preclculos... ;-)

            cli

            mov si,[xan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cos1],eax
            mov eax,dword ptr seno[si]
            mov [sin1],eax

            mov si,[yan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cos2],eax
            mov eax,dword ptr seno[si]
            mov [sin2],eax

            mov si,[zan]
            shl si,2
            mov eax,dword ptr coseno[si]
            mov [cos3],eax
            mov eax,dword ptr seno[si]
            mov [sin3],eax

            sti

            ; ahora realiza los verdaderos preclculos

            mov eax,[cos2]            ;c2*c3
            imul dword ptr [cos3]
            shrd eax,edx,9
            mov [M0],eax

            mov eax,[cos2]            ;c2*s3
            imul dword ptr [sin3]
            shrd eax,edx,9
            mov [M1],eax

            mov eax,[sin2]            ;s2
            mov [M2],eax

            ;

            mov eax,[cos3]            ;-s1*s2*c3
            neg eax
            imul dword ptr [sin1]
            mov ebx,eax
            mov ecx,edx
            imul dword ptr [sin2]
            add ebx,eax
            adc ecx,edx

            mov eax,[sin3]            ;-s3*c1
            neg eax
            imul dword ptr [cos1]
            shld edx,eax,9
            shl eax,9
            add ebx,eax
            adc ecx,edx
            shrd ebx,ecx,18
            mov [M3],ebx

            mov eax,[sin1]            ;-s1*s2*s3
            neg eax
            imul dword ptr [sin2]
            mov ebx,eax
            mov ecx,edx
            imul dword ptr [sin3]
            add ebx,eax
            adc ecx,edx

            mov eax,[cos1]            ;c1*c3
            imul dword ptr [cos3]
            shld edx,eax,9
            shl eax,9
            add ebx,eax
            adc ecx,edx
            shrd ebx,ecx,18
            mov [M4],ebx

            mov eax,[cos2]            ;s1*c2
            imul dword ptr [sin1]
            shrd eax,edx,9
            mov [M5],eax

            :

            mov eax,[cos1]            ;-c1*s2*c3
            neg eax                   ;MUST be negative
            imul dword ptr [cos3]
            mov ebx,eax
            mov ecx,edx
            imul dword ptr [sin2]
            add ebx,eax
            adc ecx,edx

            mov eax,[sin1]            ;s1*s3
            imul dword ptr [sin3]
            shld edx,eax,9
            shl eax,9
            add ebx,eax
            adc ecx,edx
            shrd ebx,ecx,18
            mov [M6],ebx

            ;

            mov eax,[cos1]            ;-c1*s2*s3
            neg eax
            imul dword ptr [sin2]
            mov ebx,eax
            mov ecx,edx
            imul dword ptr [sin3]
            add ebx,eax
            adc ecx,edx

            mov eax,[cos3]            ;-c3*s1
            neg eax
            imul dword ptr [sin1]
            shld edx,eax,9
            shl eax,9
            add ebx,eax
            adc ecx,edx
            shrd ebx,ecx,18
            mov [M7],ebx

            ;

            mov eax,[cos1]            ;c1*c2
            imul dword ptr [cos2]
            shrd eax,edx,9
            mov [M8],eax

            ;

            ENDM

; Macro que realiza la rotacin de cada uno de los vrtices del objeto


ROTAXYZ     MACRO


            ;Xf = x(c2c3) + y(c2s3) + z(s2)

            mov  eax,[M0]
            imul eax,dword ptr fs:[si+X1]
            mov  ebx,eax
            mov  eax,[M1]
            imul eax,dword ptr fs:[si+Y1]
            add  ebx,eax
            mov  eax,[M2]
            imul eax,dword ptr fs:[si+Z1]
            add  ebx,eax
            sar  ebx,9
            add  ebx,[desplx]
            mov  [di+X1],ebx

            ;Yf = x(-s1s2c3 - c1s3) + y(- s1s2s3 + c1c3) + z(s1c2)

            mov  eax,[M3]
            imul eax,dword ptr fs:[si+X1]
            mov  ebx,eax
            mov  eax,[M4]
            imul eax,dword ptr fs:[si+Y1]
            add  ebx,eax
            mov  eax,[M5]
            imul eax,dword ptr fs:[si+Z1]
            add  ebx,eax
            sar  ebx,9
            add  ebx,[desply]
            mov  [di+Y1],ebx

            ;Zf = x(-c1s2c3 + s1s3) + y(-c1s2s3 - c3s1) + z(c1c2)

            mov  eax,[M6]
            imul eax,dword ptr fs:[si+X1]
            mov  ebx,eax
            mov  eax,[M7]
            imul eax,dword ptr fs:[si+Y1]
            add  ebx,eax
            mov  eax,[M8]
            imul eax,dword ptr fs:[si+Z1]
            add  ebx,eax
            sar  ebx,9
            add  ebx,[dist]              ;smale la distancia
            mov  [di+Z1],ebx

            ENDM

; Rota una normal, idem. que la anterior, pero sin desplazamientos...

ROTANORMAL  MACRO

            push ecx

            ;Xf = x(c2c3) + y(c2s3) + z(s2)

            mov  eax,[M0]
            imul dword ptr fs:[si+X1]
            mov  ebp,eax
            mov  ecx,edx
            mov  eax,[M1]
            imul dword ptr fs:[si+Y1]
            add  ebp,eax
            add  ecx,edx
            mov  eax,[M2]
            imul dword ptr fs:[si+Z1]
            add  ebp,eax
            add  ecx,edx
            shrd ebp,ecx,9
            mov  [bx+X1],ebp

            ;Yf = x(-s1s2c3 - c1s3) + y(- s1s2s3 + c1c3) + z(s1c2)

            mov  eax,[M3]
            imul dword ptr fs:[si+X1]
            mov  ebp,eax
            mov  ecx,edx
            mov  eax,[M4]
            imul dword ptr fs:[si+Y1]
            add  ebp,eax
            add  ecx,edx
            mov  eax,[M5]
            imul dword ptr fs:[si+Z1]
            add  ebp,eax
            add  ecx,edx
            shrd ebp,ecx,9
            mov  [bx+Y1],ebp

            ;Zf = x(-c1s2c3 + s1s3) + y(-c1s2s3 - c3s1) + z(c1c2)

;            mov  eax,[M6]
;            imul eax,dword ptr fs:[si+X1]
;            mov  ebx,eax
;            mov  ecx,edx
;            mov  eax,[M7]
;            imul eax,dword ptr fs:[si+Y1]
;            add  ebx,eax
;            adc  ecx,edx
;            mov  eax,[M8]
;            imul eax,dword ptr fs:[si+Z1]
;            add  ebx,eax
;            adc  ecx,edx
;            shrd ebx,ecx,9
;            mov  [di+Z1],ebx

            pop ecx

            ENDM

; realiza la transformacion de las coordenadas

TRANSFORMA  MACRO

            ;ahora realiza la transformacin de X e Y

            mov eax,[di+X1]
            cdq                         ;convierte DWORD a cuadruple word
            shld edx,eax,8
            shl eax,8                   ;multiplica por 256 (distancia)
            mov ecx,[di+Z1]             ;coge la Z
            idiv ecx                    ;divide por la Z
            add eax,CENTROX             ;cntralo en la pantalla
            mov [di+XX],ax              ;X real en la pantalla

            mov eax,[di+Y1]
            cdq                         ;convierte DWORD a cuadruple word
            shld edx,eax,8
            shl eax,8                   ;multiplica por 256 (distancia)
            idiv ecx                    ;divide por la Z
            add eax,CENTROY             ;cntralo en la pantalla
            mov [di+YY],ax              ;Y real en la pantalla


            ENDM

            include poly.asm

; Rutina de dibujar el objeto en la pantalla

            ALIGN 4

DrawObject  PROC NEAR

            mov [nextfree],0
            mov [color],0
            mov [objeto],si

            CALCMATRIX
            mov word ptr [planos],0         ;numero de caras a dibujar

            ;rotacin de los vrtices del objecto


            mov di,OFFSET coordsnew     ;aqu guardo las coordenadas rotadas
            mov si,[objeto]             ;SI al objeto
            mov cx,fs:[si]              ;nmero de vrtices a rotar
            push cx

            add si,4
@@rota_all: push cx
            mov [aux],si
            ROTAXYZ                     ;transforma el vrtice
            TRANSFORMA
            mov si,[aux]
            add si,12
            add di,16                   ;siguiente vrtice
            pop cx
            dec cx
            jnz @@rota_all

            pop cx

            ;idem. que antes pero como son normales no necesitan transformarse
            ;a coordenadas 2d

            mov [normales],si

            mov eax,07fffffffh
@@transall: mov [di+X1],eax
            add di,8                    ;siguiente vrtice
            dec cx
            jnz @@transall

            ; ahora crea los planos...

            mov si,[objeto]

            mov cx,fs:[si]              ;numero de vertices
            shl cx,4                    ;16*vertice YA rotado
            mov [normals],cx            ;sirve de apuntador a las normales
            add [normals],OFFSET coordsnew

            ;calcula ahora posicin inicial de los datos de los polgonos

            mov cx,fs:[si+2]            ;nmero de planos
            mov ax,fs:[si]              ;nmero de vrtices
            mov bx,12
            mul bx                      ;12 bytes por vrtice
            shl ax,1
            add si,ax
            add si,4

            mov di,OFFSET vertices      ;adonde guardas los vertices de los planos
@@next_plane:
            push cx

            mov [sort_place],di         ;para computos posteriores
            mov [zsort_dist],0          ;para calcular la media de Z's

            mov cx,fs:[si]              ;nmero de vrtices en cada plano
            dec cx                      ;(no contamos el vector normal)
            mov [di],cx                 ;gurdalo

            mov dx,fs:[si+2]            ;color base del polgono
            mov [di+2],dx

            add si,6                    ;inicio de la tabla indexada
                                        ;salta color,vertices y normal...

            VISIBILITY                  ;testea la visibilidad del plano

            or ecx,ecx
            jge @@no_visible            ;no es visible, DI sigue apuntando
                                        ;donde antes, por tanto los datos
                                        ;se reescribirn...ya que no nos sirven

            add di,4                    ;apunta al inicio de la tabla

            ; ahora comprueba la visibilidad y si no es visible no entres

            DSPL = 0

            REPT 3
            LOCAL @@dontcalculate,@@calculate

            mov bx,OFFSET coordsnew     ;coordenadas recin calculadas
            mov ax,fs:[si+DSPL]         ;carga ndice del vrtice actual
            shl ax,4                    ;16 bytes por vertice
            add bx,ax                   ;posicin del vrtice

            ; esto sirve para despus la ordenacion

            mov eax,[bx+Z1]             ;coge la Z
            add [zsort_dist],eax        ;distancia ms lejana en el polgono

            ; ahora coge X e Y ya transformadas

            mov ax,[bx+12]              ;guarda X real
            mov [di],ax
            mov ax,[bx+14]              ;guarda Y real
            mov [di+2],ax

            ;componentes X e Y del vector normal en ese punto
            ;normalizado a 65536...
            ;si es necesario se ha de calcular...

            mov bx,fs:[si+DSPL]
            shl bx,3
            add bx,[normals]

            cmp [bx+X1],07fffffffh
            jne @@dontcalculate

            push si

            mov ax,fs:[si+DSPL]
            mov dx,12
            mul dx
            mov si,ax
            add si,[normales]
            ROTANORMAL
            pop si

@@dontcalculate:
            mov eax,[bx+X1]
            mov [di+4],ax
            mov eax,[bx+Y1]
            mov [di+6],ax
@@calculate:

            add di,8                    ;siguiente coordenada a guardar

            DSPL = DSPL + 2
            ENDM

            ; realiza el clculo de la media de Z's
            ; al restringir el resultado a 11 bits tenemos que el mximo
            ; es 2048 unidades

            ; en el futuro, esto deber ordenar sqrt(X^2 + Y^2 + Z^2)
            ; y ordenar a partir de eso, pero de momento se queda as
            ; mientras slo lo vaya a usar para intros/demos... ;-)

            push si di
            mov bx,[sort_place]

            mov cx,[bx]                 ;nmero de vrtices en el plano
            movzx ecx,cx                ;siempre positivo

            mov eax,[zsort_dist]        ;distancia del plano...
            cdq
            idiv ecx

            mov di,ax
            inc byte ptr [di + OFFSET sort_list]
            cmp byte ptr [di + OFFSET sort_list],1
            je @@first

            shl di,2
            mov ax,bx
            mov bx,[nextfree]           ;siguiente posicion libre
            mov [bx + OFFSET rsort_list],ax

            mov si,[di + OFFSET fsort_list + 2]
            mov [si + OFFSET rsort_list + 2],bx
            mov [di + OFFSET fsort_list + 2],bx

            jmp @@common

            ;el primero es un caso especial

@@first:    shl di,2
            mov ax,bx
            mov bx,[nextfree]
            mov [bx + OFFSET rsort_list],ax

            mov [di + OFFSET fsort_list + 2],bx
            mov [di + OFFSET fsort_list],bx

@@common:
            add [nextfree],4            ;siguiente posicion libre
            inc word ptr [planos]       ;un plano ms a dibujar
            pop di si

            ; si no es visible continua a por el siguiente

@@no_visible:
            add si,8
            pop cx
            dec cx
            jnz @@next_plane

            ; dibuja los planos que se deban dibujar
            ; Gracias a la ordenacin rpida dibujarlos es lineal
            ; al nmero de planos

            mov cx,[planos]             ;nmero de planos a dibujar
            test cx,0ffffh
            jz @@ninguno                ;no hay planos que dibujar...

            mov di,2047                 ;final de la tabla
@@planes:

            cmp byte ptr [di+OFFSET sort_list],0
            je  next

            shl di,2
            mov bx,[di + OFFSET fsort_list]
            shr di,2
@@ninguno0:
            mov si,[bx + OFFSET rsort_list]

            push cx bx di
            mov ax,[si+2]
            mov [color],al
            call DPoly                  ;dibuja el polgono
            pop di bx cx

            mov bx,[bx+ 2 + OFFSET rsort_list]

            dec cx
            dec byte ptr [di+OFFSET sort_list]
            jnz  @@ninguno0

next:
            or cx,cx
            jz @@ninguno

            dec di
            jns @@planes
@@ninguno:
            ret

            ENDP

