/*
 * main.c
 *
 * Copyright  2013-2014 by 240-185
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 */

//La librairie principale OSLib

#define VERSION "v2.0"
#define DATE "09/03/2014"

// v0.99 RC1 first release
// v1.00 First release: refined ball detection
// v1.01 Added compatibility with PPSSPP - Corrected a small graphical bug
// v1.011 Corrected a bug in which the ball could be stuck after a mini-game
// v1.012 Testing a mini-game under PPSSPP
// v1.013 Reverted to previous state
// v1.02  Fixed a graphical bug on enemy's latest ults in 2 player mode
//        Fixed a bug where the psi sound could be heard after dying
//		  Fixed a confusing issue where the lightning sound was played even if shielded
// v1.021 Now, the ults won't trigger if the screen is black
//		  Improved stability with PPSSPP
// v1.03  Fixed a flaw in the gameplay in which the player had to stick near the pie to win.
//		  Improved PPSSPP compatibility
// v1.04  The scene becomes more and more red as the pie's HP decreases
//		  Fixed a case where the psi sound could be continued to play during ShootDaWhoop's sequence
//		  The poles won't hurt the player if a mini-game is being launched or if the mad hatter is on screen
//		  Game can't be paused any more when the pie is dying
// v1.041 Sonic.exe pic from Sammi-Psycho removed due to DeviantART account closing. Replaced by another pic, credited as such.
// v1.2   Final version.
//			- When Kim Jong Eun's face appears, the game does something now.
//			- Shoop da Whoop's sequence has been changed. Instead of mashing buttons, you must now protect the planet by moving left or right.
//			- New mini-game added.
//			- New defeat animation.
//		  Fixed a glitch where you could still send stars after the pie had died.
//		  SONIC.EXE mini-game made harder.
//		  The source code is now provided with the game! Try to understand it and make your own mod!
// v2.0	  Final final version!
//		  PC Version! Download at: http://www.latelier240.fr/Vrac/psp/PastaCrocketPC.zip
//		  You now gain health after completing a mini-game. This should make the 'Hell' difficulty winnable.
//		  The game now detects if you cheated after having beaten the pie
//		  The game enjoins you to complete harder difficulties if you think 'Easy' was already a nightmare.
//		  The SONIC.EXE mini-game now runs under PPSSPP

#define _16bit OSL_PF_8888
#define spr_draw oslDrawImageXY

#define STALLMAN Stupid_Toe_Cheese_Eater_Hippie
#define GPL Shitty_Confusing_License
#define BSD3CLAUSE Actual_License_Of_This_Program

#define ESPAC_HORIZ 64
#define HAUT_FIELD 138
#define GRAVITY -0.05

#define DEBUG 0

//#include <libc/stdio.h>
#include <oslib/oslib.h>
#include <psputils.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspmpeg.h>
//#include <libc/string.h>
//#include <libc/time.h>

//les callbacks
PSP_MODULE_INFO("PastaSquash", 0, 1, 1);
PSP_MAIN_THREAD_ATTR(THREAD_ATTR_USER | THREAD_ATTR_VFPU);

struct ball {
	float speed_h;
	float speed_v;
	float speed_z;
	int angle;
	int x2d;
	int y2d;
	int z3d;
	short poisoned;
};

struct pie_entity {
	int pie_hp;
	int pie_facemode; //mode sarko-JLM-autre?
	int pie_direction;
	int pie_x;
	int pie_y;
};

SceKernelUtilsMt19937Context ctx;


OSL_IMAGE *court, *benj;
OSL_FONT *gothic;

unsigned long int counter=0;


int exit_callback(int arg1, int arg2, void *common) {
          sceKernelExitGame();
          return 0;
}

/* Callback thread */
int CallbackThread(SceSize args, void *argp) {
          int cbid;

          cbid = sceKernelCreateCallback("Exit Callback", exit_callback, NULL);
          sceKernelRegisterExitCallback(cbid);

          sceKernelSleepThreadCB();

          return 0;
}

/* Sets up the callback thread and returns its thread id */
int SetupCallbacks(void) {
          int thid = 0;

          thid = sceKernelCreateThread("update_thread", CallbackThread, 0x11, 0xFA0, 0, 0);
          if(thid >= 0) {
                    sceKernelStartThread(thid, 0, 0);
          }

          return thid;
}
// End Callback functs

int random(int max)
{
	//return (int)oslRandf(0,max);

	   u32 rand_val = sceKernelUtilsMt19937UInt(&ctx);
	   rand_val = rand_val % (max);
	   return (int)rand_val;
}

int swirl_collide(int px, int py, int gudule, int mgsy)
{
	if ((px-(gudule))*(px-(gudule))+(py-(mgsy))*(py-(mgsy)) <= 512) return 1; else return 0;
}




struct ball initball(struct ball ball_arg)
{
	struct ball abadgh = ball_arg;

	 abadgh.x2d=random(320)+80; //x
	 abadgh.y2d=170;     //y
	 abadgh.speed_v=-1;  //vy
	 abadgh.speed_h=0;   //vx
	 abadgh.speed_z=2;  //vz
	 abadgh.angle=0;	//
	 abadgh.z3d=2;		//z
	 abadgh.poisoned=0;

	 return abadgh;
}

struct pie_entity initpie(struct pie_entity pie_arg)
{
	struct pie_entity abadgh = pie_arg;
    abadgh.pie_facemode=0;
    abadgh.pie_direction=0;
    abadgh.pie_x=128;
    abadgh.pie_y=136;
	return abadgh;
}

struct ball apply_impulse(struct ball ball_arg, float v, float v2, float angle)
{
	struct ball this = ball_arg;

	this.speed_h = v;
	this.speed_v = -v2;

	return this;
}


void mackey2()
{
	int i=0,j;
	OSL_IMAGE *mackey = oslLoadImageFilePNG("./gfx/mackey2.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *mkayyy = oslLoadSoundFile("./sfx/mackey.wav", OSL_FMT_NONE);;
	oslSetSoundLoop(mkayyy, 1);
	oslPlaySound(mkayyy, 0);

	while(1<2)
	{
		j=random(9)+1;
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		while(i<272)
		{
			oslDrawFillRect(0,i,480,i+j, RGB(random(255),random(255),255));
			i += j;
		}
		i=0;
		spr_draw(mackey,0,0);
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
	}
}


void mackey()
{
	int i=0,j;
	OSL_IMAGE *mackey = oslLoadImageFilePNG("./gfx/mackey.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *mkayyy = oslLoadSoundFile("./sfx/mackey.wav", OSL_FMT_NONE);;
	oslSetSoundLoop(mkayyy, 1);
	oslPlaySound(mkayyy, 0);

	while(1<2)
	{
		j=random(9)+1;
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		while(i<272)
		{
			oslDrawFillRect(0,i,480,i+j, RGB(random(255),random(255),255));
			i += j;
		}
		i=0;
		spr_draw(mackey,0,0);
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
	}
}

void noppsspp()
{
	int check=0;

	if (((long int)oslGetRamStatus().maxAvailable) > 21117447)
	{
		check=1;
	}

	if (check==1)
	{
		mackey();
	}
}

void cleanbuffer()
{
	oslDisableTransparentColor();
	oslStartDrawing();
    oslDrawFillRect(0,0,480,272, RGB(255,0,255));
    oslEndDrawing();
    oslSetTransparentColor(RGB(255,0,255));
}

void cleanbuffer2(int color)
{
	oslStartDrawing();
    oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
    oslDrawFillRect(0,0,480,272, color);

    oslSetTransparentColor(RGB(255,0,255));
}

void frame_debug(int frame)
{
	char buffer[20];
	oslStartDrawing();
	oslSetTransparentColor(RGB(255,0,255));
	oslSetBkColor(RGB(255,0,255));
	oslSetTextColor(RGB(255, 255, 0));

	sprintf(buffer,"Frm %d",frame);

	oslDrawString(0, 0, buffer);
	oslEndDrawing();
}

void fadein(OSL_IMAGE *image)
{
	int i;
	OSL_IMAGE *temp;

	temp=oslCreateImage(480, 272, OSL_IN_RAM, OSL_PF_5551);
	oslCopyImageTo(temp, image);

	for (i=0; i<400; i++)
	{
		    oslStartDrawing();
		    oslSetDrawBuffer(OSL_SECONDARY_BUFFER);
		    oslSetAlpha(OSL_FX_ALPHA,i/2);
		    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		    oslEndDrawing();
		    oslWaitVSync();
	}

	oslSetAlpha(OSL_FX_DEFAULT,0);
	spr_draw(temp,0,0);
	oslSetDrawBuffer(OSL_DEFAULT_BUFFER);

	oslDeleteImage(temp);
}

void fadeout(OSL_COLOR u)
{
	int i;
	for (i=0; i<80; i++)
	{
		    oslStartDrawing();
			oslSetDrawBuffer(OSL_SECONDARY_BUFFER);
			oslSetAlpha(OSL_FX_ALPHA,i*2);
			oslDrawFillRect(0,0,480,272, u);
		    oslEndDrawing();
		    oslWaitVSync();
	}
	oslSetAlpha(OSL_FX_DEFAULT,0);
	oslDrawFillRect(0,0,480,272, u);
	oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
}

void rndsft()
{
	int frame=0, i=0, j=0, k=0, l=0, m=0, n=0;
	OSL_IMAGE *rndsft, *px;
	OSL_SOUND *rndtheme;

	rndsft = oslLoadImageFilePNG("./gfx/rndsft.png",OSL_IN_RAM, OSL_PF_5551);
	px = oslLoadImageFilePNG("./gfx/pixel.png", OSL_IN_VRAM, OSL_PF_5551);
	rndtheme = oslLoadSoundFileMOD("./muzaxx/rndsft.xm", OSL_FMT_NONE);


	oslSetImageRotCenter(rndsft);

	oslPlaySound(rndtheme, 5);

	while(frame<470)
	{
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));

		if (frame >= 161)
		{
			if (frame-160 < 35)	oslSetImageTile(rndsft,0,0,282,frame-160); else oslSetImageTile(rndsft,0,0,282,35);
			spr_draw(rndsft,240,138);
		}

		if ((frame >= 200) && (frame <= 220))
		{
			if (frame==200) i=random(360);

			if (!(frame%2))
			{
				oslDrawFillRect(0,0,480,272, RGB(0,0,0));

				for (j=0; j<13; j++)
				{
					oslDrawFillRect(i+j*16, 60, i+j*16+8, 272, RGB(255,127,0));
				}
			}
		}

		if ((frame >= 259) && (frame <= 295))
		{

			if (frame == 259)
			{
				i=random(32)+24;
				k=random(9)+6;
				oslSetTextColor(RGB(0, 224, 0));
				m=random(127);
				n=random(44);
			}

			oslSetTransparentColor(RGB(255,0,255));
			oslSetBkColor(RGB(255,0,255));

			for(j=0; j<k; j++)
			{
				for (l=0; l<i; l++)
				{

					oslDrawString(m+l*6, n+j*12, "@");
				}
			}
		}

		if ((frame >= 336) && (frame <= 345))
		{
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(rndsft,random(480),random(272));
		}

		if (frame >= 369)
		{

				for(i=0; i<48; i++)
				{
					for (j=0; j<17;  j++)
					{
						oslSetAlpha(OSL_FX_TINT, RGB(random(255), random(255), random(255)));
						spr_draw(px, i*10, j*16);
					}
				}

			if ((frame == 369) || (!(frame%4))) k=random(360);
			oslDrawFillRect(k,0,k+32,272, RGB(0,254,255));


		}

	    oslEndDrawing();
	    oslSwapBuffers();
		frame++;
	    oslWaitVSync();

	}

    oslDeleteImage(rndsft);
    oslDeleteImage(px);
    oslDeleteSound(rndtheme);

    oslSetAlpha(OSL_FX_DEFAULT,0);
    fadeout(RGB(0,0,0));

}

void ben()
{
	OSL_IMAGE *noise[9];
	OSL_SOUND *ben_mzx =  oslLoadSoundFile("./sfx/ben.wav", OSL_FMT_NONE);;
	char buffer[20];
	int i, j, frame=0;

	noise[0]=oslLoadImageFilePNG("./gfx/ben.png",OSL_IN_RAM, OSL_PF_5551);

	for (i=1; i<9; i++)
	{
		sprintf(buffer,"./gfx/gfx-0%d.png",i+661);
		noise[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
		noise[i]->stretchX = 480;
		noise[i]->stretchY = 272;
	}

	oslPlaySound(ben_mzx, 0);

	while(frame<704)
	{
		oslStartDrawing();
		oslSetAlpha(OSL_FX_DEFAULT,0);
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		spr_draw(noise[(frame%8)+1],0,0);

		if (frame<192)
		{
			oslSetAlpha(OSL_FX_ALPHA, frame);
		}
		else if (frame>512) oslSetAlpha(OSL_FX_ALPHA,704-frame);
		else oslSetAlpha(OSL_FX_ALPHA,192);

		i=0;
		while(i<272)
		{
			j=random(27)+13;
			oslSetImageTile(noise[0],0,i,425,i+j);
			spr_draw(noise[0],random(55),i);
			i += j;
		}

		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
		frame++;
	}

	for(i=0; i<9; i++)
	{
	    oslDeleteImage(noise[i]);
	}
    oslDeleteSound(ben_mzx);
}

void creepypasta(int cpn)
{
	int i, j, k, l, frame=0;
	char buffer[20];
	OSL_IMAGE *suicidemouse[18];
	OSL_SOUND *creepysfx, *w4c;
	OSL_SOUND *sfx =  oslLoadSoundFile("./sfx/dummy.wav", OSL_FMT_NONE);
	int bok[4][16];
	const char *text[7]={"y wud u do dis","acually is dolan","fak u","FAGGT","u litl SHIZNIT", "gooby pls", "i wuz ins al a long"};


	w4c = oslLoadSoundFile("./sfx/sfx-0005.wav", OSL_FMT_NONE);
	oslSetSoundLoop(w4c, 1);
	w4c -> volumeLeft = w4c -> volumeRight = 0x2000;

	if ((cpn != 5) && (cpn < 17)) oslPlaySound(w4c, 0);

	switch(cpn)
	{

	case 0:

		for (i=0; i<18; i++)
		{
			sprintf(buffer,"./gfx/gfx-%d.png",i+1160);
			suicidemouse[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);

			suicidemouse[i]->stretchX = 363;
			suicidemouse[i]->stretchY = 272;
			oslSetImageRotCenter(suicidemouse[i]);
		}

		creepysfx = oslLoadSoundFile("./sfx/sfx-0065.wav", OSL_FMT_NONE);
		oslSetSoundLoop(creepysfx, 1);
		oslPlaySound(creepysfx, 0);

		i=0;

		cleanbuffer2(RGB(0,0,0));

		while (frame < 620)
		{

			if (!(frame%6)) i++;
			oslStartDrawing();

			spr_draw(suicidemouse[i%18],240,138);
		    oslDrawFillRect(0,0,480,272, RGB(255,0,255));
			oslEndDrawing();
			//frame_debug((int)oslGetRamStatus().maxAvailable);
		    oslSwapBuffers();

			oslWaitVSync();
		    frame++;
		}

		for (i=0; i<18; i++)
		{
			if (suicidemouse[i]) oslDeleteImage(suicidemouse[i]);
		}

		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		break;



	case 1:
		suicidemouse[0]=oslLoadImageFilePNG("./gfx/gfx-1038.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1]=oslLoadImageFilePNG("./gfx/gfx-1039.png",OSL_IN_RAM, OSL_PF_5551);

		oslSetImageRotCenter(suicidemouse[0]);

		creepysfx = oslLoadSoundFile("./sfx/sfx-0058.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);

		while (frame < 45)
		{
			oslStartDrawing();
			oslSetAlpha(OSL_FX_DEFAULT, 0);
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			 oslSetAlpha(OSL_FX_ALPHA, frame*4);
			spr_draw(suicidemouse[0],240,271);
			oslEndDrawing();
			//frame_debug(frame);
			oslSwapBuffers();

			suicidemouse[0]->stretchX +=2;
			suicidemouse[0]->stretchY +=2;

			oslSetImageRotCenter(suicidemouse[0]);
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			frame++;
			oslWaitVSync();
		}
		oslSetAlpha(OSL_FX_DEFAULT, 0);
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslClearImage(OSL_SECONDARY_BUFFER, RGB(0,0,0));

		for (i=0; i<4; i++)
		{
		oslStartDrawing();
		spr_draw(suicidemouse[1],0,0);
		oslEndDrawing();
		oslSwapBuffers();
		}
		fadeout(RGB(0,0,0));
		while (oslGetSoundChannel(creepysfx) == 0);

		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(sfx);


	break;

	case 2:

		j = random(2);

		if (!j)	suicidemouse[0] = oslLoadImageFilePNG("./gfx/endisneigh.png",OSL_IN_RAM, OSL_PF_5551);
		else suicidemouse[0] = oslLoadImageFilePNG("./gfx/endisneigh2.png",OSL_IN_RAM, OSL_PF_5551);

		if (!j) creepysfx = oslLoadSoundFile("./sfx/sfx-0083.wav", OSL_FMT_NONE);
		else creepysfx = oslLoadSoundFile("./sfx/sfx-0109.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);

		for (i=0; i<10; i++)
		{
			oslStartDrawing();
			spr_draw(suicidemouse[0],0,0);
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
		fadeout(RGB(0,0,0));
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);
		break;


	case 3:
		suicidemouse[0] = oslLoadImageFilePNG("./gfx/safe.png",OSL_IN_RAM, OSL_PF_5551);
		oslSetImageRotCenter(suicidemouse[0]);
		creepysfx = oslLoadSoundFile("./sfx/sfx-0026.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);

		for (i=0; i<3; i++)
		{
			oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
			oslWaitVSync();
		}

		oslClearImage(OSL_SECONDARY_BUFFER, RGB(0,0,0));



		for (i=0; i<200; i++)
			{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(suicidemouse[0],239,135);
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			}

		fadeout(RGB(0,0,0));
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);
		break;

	case 4:
		for (i=0; i<4; i++)
		{
			sprintf(buffer,"./gfx/bnours%d.png",i+1);
			suicidemouse[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
		}
		creepysfx = oslLoadSoundFile("./sfx/sfx-0149.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);

		i=0;

		while (frame < 600)
				{

					if (!(frame%4)) i++;
					oslStartDrawing();

					spr_draw(suicidemouse[i%4],0,0);

					oslEndDrawing();

				    oslSwapBuffers();

				    cleanbuffer();


				    frame++;
					oslWaitVSync();
				}

				fadeout(RGB(0,0,0));
				oslDeleteSound(creepysfx);
				for (i=0; i<4; i++)
				{
					if (suicidemouse[i]) oslDeleteImage(suicidemouse[i]);
				}
				oslDeleteSound(sfx);
		break;

	case 5:
		suicidemouse[0] = oslLoadImageFilePNG("./gfx/court_joy.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] = oslLoadImageFilePNG("./gfx/gfx-0717.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/sfx-0147.wav", OSL_FMT_NONE);
		oslDeleteSound(sfx);
		sfx=oslLoadSoundFile("./sfx/sfx-0011.wav", OSL_FMT_NONE);

		oslPlaySound(sfx, 6);

		for (j=0; j<256; j+=3)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(255,255,255));

			oslSetAlpha(OSL_FX_ALPHA, j);
			spr_draw(suicidemouse[0],0,0);
			spr_draw(suicidemouse[1],177,215);

			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}

		oslSetAlpha(OSL_FX_DEFAULT,0);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);

		while (frame < 292)
		{
			oslStartDrawing();
			spr_draw(suicidemouse[0],0,0);
			spr_draw(suicidemouse[1],177,215);
			oslEndDrawing();

			oslSwapBuffers();

			frame++;
			oslWaitVSync();
		}

		fadeout(RGB(0,0,0));
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		break;

	case 6:
		oslStopSound(w4c);
		creepysfx = oslLoadSoundFile("./sfx/sfx-0060.wav", OSL_FMT_NONE);
		suicidemouse[0] = oslLoadImageFilePNG("./gfx/oag1.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] = oslLoadImageFilePNG("./gfx/oag2.png",OSL_IN_RAM, OSL_PF_5551);

		oslStartDrawing();
		spr_draw(suicidemouse[0],0,0);
		oslEndDrawing();

		oslSwapBuffers();

		while (frame < 5000)
		{
			if (frame==3000)
			{
				oslSetSoundLoop(creepysfx, 0);
				oslPlaySound(creepysfx, 0);
			}

			if (frame >= 3000)
			{

				oslStartDrawing();
			    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
				spr_draw(suicidemouse[1],173,26);
				oslEndDrawing();
				//frame_debug(frame);
				oslSwapBuffers();
			}
			else if (frame < 3000)
			{
				oslStartDrawing();
				spr_draw(suicidemouse[0],0,0);
				oslEndDrawing();
				//frame_debug(frame);
				oslSwapBuffers();
			}


			frame++;
		}

		fadeout(RGB(0,0,0));
		cleanbuffer();
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(sfx);
		break;

	case 7:
		creepysfx = oslLoadSoundFile("./sfx/sfx-0148.wav", OSL_FMT_NONE);
		suicidemouse[0] = oslLoadImageFilePNG("./gfx/smurf_village.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] = oslLoadImageFilePNG("./gfx/smurf_sprite.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[2] = oslLoadImageFilePNG("./gfx/smurf_papazombie.png",OSL_IN_RAM, OSL_PF_5551);

		oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
	    spr_draw(suicidemouse[0],0,0);
		oslEndDrawing();



		i=0;
		j=-32;
		frame=0;

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);
		oslSetImageRotCenter(suicidemouse[2]);
		oslSetBilinearFilter(1);
		//fadein(suicidemouse[0]);

		while (frame < 400)
		{

			if (!(frame%2))
			{
				if (j < 222) j+=4;
			}
			if (!(frame%3))
			{
				i++;
			}

				oslStartDrawing();
				spr_draw(suicidemouse[0],0,0);
				oslSetImageTileSize(suicidemouse[1],(i%8)*32,0,32,42);
				suicidemouse[1]->stretchX = 64;
				suicidemouse[1]->stretchY = 84;
				spr_draw(suicidemouse[1], j, 181);
				oslEndDrawing();

			if (j >= 222)
			{
				oslStartDrawing();
				spr_draw(suicidemouse[0],0,0);
				oslSetImageTileSize(suicidemouse[1],256,0,32,42);
				suicidemouse[1]->stretchX = 64;
				suicidemouse[1]->stretchY = 84;
				spr_draw(suicidemouse[1], j, 181);

				oslEndDrawing();


				if (frame > 248)
				{
					oslStartDrawing();
				    oslSetAlpha(OSL_FX_ALPHA,155);
				    oslDrawFillRect(0,0,480,272, RGB(255,0,0));
					oslSetAlpha(OSL_FX_DEFAULT,0);
				    spr_draw(suicidemouse[2],238,136);
					if (!(frame%2))
						{
							suicidemouse[2]->stretchX+=16;
							suicidemouse[2]->stretchY+=16;
						}
					oslEndDrawing();
				}
			}

			//frame_debug(frame);

			oslSwapBuffers();
			frame++;
			oslWaitVSync();
		}

		oslSetBilinearFilter(1);
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteImage(suicidemouse[2]);
		oslDeleteSound(sfx);

		break;

	case 8:
		creepysfx = oslLoadSoundFile("./sfx/sfx-0151.wav", OSL_FMT_NONE);
		suicidemouse[0] = oslLoadImageFilePNG("./gfx/squiward_suicide.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] = oslLoadImageFilePNG("./gfx/bikini_hell.png",OSL_IN_RAM, OSL_PF_5551);

		oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
	    spr_draw(suicidemouse[1],0,0);
		oslEndDrawing();


		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 0);
		oslSetImageRotCenter(suicidemouse[0]);
		oslSetImageRotCenter(suicidemouse[1]);



		frame=0;

		while((suicidemouse[0]->stretchX) >= 0)
		{
			if (!(frame%2))
			{
			oslStartDrawing();
			spr_draw(suicidemouse[0],240,136);
			if (!(frame%4) && (frame < 282))
				{
					suicidemouse[0]->stretchX++;
					suicidemouse[0]->stretchY++;
					suicidemouse[0]->angle += 6;
				}
			if (frame >= 282)
				{
					suicidemouse[0]->stretchX-=3;
					suicidemouse[0]->stretchY-=3;
					suicidemouse[0]->angle -= 11;
				}
			oslEndDrawing();
			//frame_debug(frame);
			oslSwapBuffers();
			}
			else
			{
				oslStartDrawing();
					spr_draw(suicidemouse[1],240,136);
				oslEndDrawing();
			}
			oslWaitVSync();
			frame++;
		}

		oslStartDrawing();
		spr_draw(suicidemouse[1],240,136);
		oslEndDrawing();
		oslSwapBuffers();

		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
	    oslSetTransparentColor(RGB(255,0,255));
		oslDeleteSound(sfx);
		break;


	case 9:
		creepysfx = oslLoadSoundFile("./sfx/sfx-0152.wav", OSL_FMT_NONE);

		j=0;
		i=0;

		frame=0;

		oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		oslEndDrawing();

		for (k=0; k<16; k++)
		{
			suicidemouse[k] = oslLoadImageFilePNG("./gfx/creepycircle.png",OSL_IN_RAM, OSL_PF_5551);
			oslSetImageRotCenter(suicidemouse[k]);
		}

		while (frame<16*2)
		{
			if (!(frame%2))
			{
			bok[0][i]=(2*(random(24)+1))-24;


			bok[1][i]= random(128)+127;
			bok[2][i]= random(128)+127;
			bok[3][i]= random(128)+127;




			oslStartDrawing();
			if (bok[0][i] > 0) suicidemouse[i]->stretchX = bok[0][i]; else suicidemouse[i]->stretchX = 1;
			if (bok[0][i] > 0) suicidemouse[i]->stretchY = bok[0][i]; else suicidemouse[i]->stretchY = 1;

			spr_draw(suicidemouse[i],(i%4)*40+172, (i/4)*40+64);

			oslEndDrawing();
			i++;
			}
			else
			{
				oslWaitVSync();
			}
			frame++;
		}

		oslSwapBuffers();
		//oslWaitKey();


		i=0;
		j=0;
		k=0;
		frame=0;

		while(k < 100)
		{

			if (!(frame%4))
			{



					oslStartDrawing();
					oslDrawFillRect(0,0,480,272, RGB(0,0,0));

					for (j=0; j<16; j++)
					{

						if (bok[0][j] > -24) bok[0][j]--;

						if (bok[0][j] <= -24)
							{
								k++;
								bok[0][j]=24;
								i=0;
								while (oslGetSoundChannel(creepysfx) == i)
								{
									i++;
								}
								if (i < 8) oslPlaySound(creepysfx, i); else oslPlaySound(creepysfx, 7);

								bok[1][j]= random(128)+127;
								bok[2][j]= random(128)+127;
								bok[3][j]= random(128)+127;
							}

						if (bok[0][j] > 1) suicidemouse[j]->stretchX = suicidemouse[j]->stretchY = bok[0][j];

					    oslSetAlpha(OSL_FX_TINT, RGB(bok[2][j], bok[3][j], bok[1][j]));
						if (bok[0][j] > 21)  oslSetAlpha(OSL_FX_TINT, RGB(255, 255, 255));

						spr_draw(suicidemouse[j],(j%4)*40+172, (j/4)*40+64);
					}
					oslEndDrawing();
					//frame_debug(frame);
					oslSwapBuffers();
					//oslWaitKey();



			}
			else
			{
				oslWaitVSync();
			}

			frame++;
		}

		for(i=0; i<16; i++) oslDeleteImage(suicidemouse[i]);
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		break;


	case 10:
	case 15:
		creepysfx = oslLoadSoundFile("./sfx/sfx-0057.wav", OSL_FMT_NONE);

		if (cpn == 15)
		{
			oslDeleteSound(sfx);
			sfx = oslLoadSoundFile("./sfx/bark.wav", OSL_FMT_NONE);
		}

		suicidemouse[0] = oslLoadImageFilePNG("./gfx/gfx-0253.png",OSL_IN_RAM, OSL_PF_5551);
	    oslSetImageRotCenter(suicidemouse[0]);



		for (i=1; i<9; i++)
		{
			sprintf(buffer,"./gfx/gfx-0%d.png",i+661);
			suicidemouse[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
			suicidemouse[i]->stretchX = 480;
			suicidemouse[i]->stretchY = 272;
		}

		frame=0;
		j=0;
		oslStopSound(w4c);

		oslSetSoundLoop(creepysfx, 1);
		oslPlaySound(creepysfx, 0);

		while (frame < 750)
		{

			if (!(frame%16))
			{
				suicidemouse[0]->stretchX++;
				suicidemouse[0]->stretchY = (int)(1.27*(suicidemouse[0]->stretchX));
			}

			if (!(frame%4))
			{
				oslStartDrawing();
			    oslSetAlpha(OSL_FX_DEFAULT,0);
			    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			    spr_draw(suicidemouse[(j%8)+1],0,0);
			    oslSetAlpha(OSL_FX_ALPHA,75);
			    spr_draw(suicidemouse[0],240,136);
			    oslEndDrawing();
			    oslSwapBuffers();
			}
			else
			{
				oslWaitVSync();
				j++;
			}

			frame++;
		}

		if (cpn == 15)
		{
			suicidemouse[0]->stretchX = 480;
			suicidemouse[0]->stretchY = 610;
			oslStartDrawing();
		    oslSetAlpha(OSL_FX_DEFAULT,0);
		    spr_draw(suicidemouse[0],240,136);
		    oslEndDrawing();
		    oslSwapBuffers();
		    oslPlaySound(sfx, 1);
		    while (oslGetSoundChannel(sfx) == 1);
		}

		oslDeleteSound(creepysfx);
		for (i=0; i<9; i++)
		{
			oslDeleteImage(suicidemouse[i]);
		}
		oslDeleteSound(sfx);
		fadeout(RGB(0,0,0));
		break;


	case 11:
	case 16:
		oslStopSound(w4c);
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/dolan.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/dolan.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		i=272;
		frame=0;
		j=random(7);

		while(frame < 1200)
		{
			if (!(frame%2))
			{
				if (i>72)
				{
				oslStartDrawing();
			    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			    spr_draw(suicidemouse[0], 332, i);
				oslEndDrawing();
				oslSwapBuffers();
				i--;
				}
				if ((frame > 800) && (i<73))
				{
					if (cpn == 16)
					{
						oslSetImageRotCenter(suicidemouse[0]);
						suicidemouse[0]->stretchX = 480;
						suicidemouse[0]->stretchY = 648;
						oslStartDrawing();
					    oslSetAlpha(OSL_FX_DEFAULT,0);
					    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
					    spr_draw(suicidemouse[0],240,136);
					    oslEndDrawing();
					    oslSwapBuffers();
					    if (frame == 812) oslPlaySound(creepysfx, 1);
					}
					else
					{
						oslStartDrawing();
						oslDrawFillRect(0,0,480,272, RGB(0,0,0));
						spr_draw(suicidemouse[0], 332, i+1);
						oslSetTransparentColor(RGB(255,0,255));
						oslSetBkColor(RGB(255,0,255));
						oslSetTextColor(RGB(255, 255, 255));
						k = oslGetStringWidth(text[j]);
						oslDrawString((480 - k)/2, 32, text[j]);
						oslEndDrawing();
						oslSwapBuffers();
					}
				}

			}
			else
			{
				oslWaitVSync();
			}
			frame++;
		}

	    while (oslGetSoundChannel(creepysfx) == 1);
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);

		break;


	case 12:
		oslStopSound(w4c);
		k=random(42);
		j=random(25);

		sprintf(buffer,"./sfx/sfx-0%d.wav",j+121);
		creepysfx = oslLoadSoundFile(buffer, OSL_FMT_NONE);

		j=random(25);
		oslDeleteSound(sfx);
		sprintf(buffer,"./sfx/sfx-0%d.wav",j+121);
		sfx = oslLoadSoundFile(buffer, OSL_FMT_NONE);

		sprintf(buffer,"./gfx/pasta%d.png",k+1);
		suicidemouse[0] =  oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 1);
		oslSetImageRotCenter(suicidemouse[0]);

		frame=0;

		oslSetBilinearFilter(1);

		while (oslGetSoundChannel(creepysfx) == 1)
		{
			oslStartDrawing();
		    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		    spr_draw(suicidemouse[0], 240, 136);
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			if (!(frame%4)) suicidemouse[0] -> stretchX++;
			suicidemouse[0] -> stretchY = (int)((float)(suicidemouse[0] -> sizeY)/(suicidemouse[0] -> sizeX)*suicidemouse[0]->stretchX);
			frame++;
		}

		oslSetSoundLoop(sfx, 0);
		oslPlaySound(sfx, 1);
		while (oslGetSoundChannel(sfx) == 1)
		{
				oslStartDrawing();
			    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			    spr_draw(suicidemouse[0], 240, 136);
				oslEndDrawing();
				oslSwapBuffers();
				oslWaitVSync();
				if (!(frame%4))	suicidemouse[0] -> stretchX++;
				suicidemouse[0] -> stretchY = (int)((float)(suicidemouse[0] -> sizeY)/(suicidemouse[0] -> sizeX)*suicidemouse[0]->stretchX);
				frame++;
		}

		oslSetBilinearFilter(0);

		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);

		break;

	case 13:
		oslStopSound(w4c);
		creepysfx = oslLoadSoundFile("./sfx/sfx-0150.wav", OSL_FMT_NONE);

		oslSetSoundLoop(creepysfx, 0);
		oslPlaySound(creepysfx, 1);
		creepysfx -> volumeLeft = creepysfx -> volumeRight = 0xFFFF;

		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,255));
		oslSetTextColor(RGB(255, 255, 255));
		oslMoveTo(0,0);
		oslConsolePrint("I regret to inform you your psp has just crashed\n");
		oslConsolePrint(" \n");
		oslConsolePrint("Shit happens... :-(\n");
		oslConsolePrint("Exception Details:\n");
		oslConsolePrint("Exception - Bus error (death)\n");
		oslConsolePrint("EPC       - 08A1C208\n");
		oslConsolePrint("Cause     - 07H30P13\n");
		oslConsolePrint("Status    - D34D0L0L\n");
		oslConsolePrint("BadVAddr  - 0012AC40\n");
		oslConsolePrint("zr:000Y0000 at:0008OF00 v0:000U0000 v1:00000012\n");
		oslConsolePrint("a0:0000A001 a1:000R002E a2:09FFE768 a3:09FF06BC\n");
		oslConsolePrint("t0:00D0E6BC t1:000E07D4 t2:0000A032 t3:8804D000\n");
		oslConsolePrint("t4:09FFY5F8 t5:000O0E00 t6:08A2U658 t7:00008600\n");
		oslConsolePrint("t8:000S0000 t9:000U8368 s0:08AC0000 s1:08AFK53C\n");
		oslConsolePrint("s2:08BA0C20 s3:08BT453C s4:08A30000 s5:08A30000\n");
		oslConsolePrint("s6:000T00EC s7:0000H0F9 k0:09FFIF00 k1:0000S000\n");
		oslConsolePrint("gp:08AGD390 sp:000AFF00 fp:08A3M000 ra:0896E4BC\n");
		oslConsolePrint(" \n");
		oslConsolePrint("Will exit to PSP menu in 10 seconds\n\n\n");
		oslEndDrawing();
		oslSwapBuffers();
		while (oslGetSoundChannel(creepysfx) == 1);
		oslDeleteSound(creepysfx);
		oslSetDrawBuffer(OSL_SECONDARY_BUFFER);
		oslStartDrawing();
		oslConsolePrint("Admit it: this blue screen is almost plausible, eh?");
		oslEndDrawing();
		oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
		oslDeleteSound(sfx);

	break;


	case 14:
		oslStopSound(w4c);
		if (random(2)) suicidemouse[0] =  oslLoadImageFilePNG("./gfx/smilechu.png",OSL_IN_RAM, OSL_PF_5551); else suicidemouse[0] =  oslLoadImageFilePNG("./gfx/smilechu2.png",OSL_IN_RAM, OSL_PF_5551);
		oslSetImageRotCenter(suicidemouse[0]);

		i=0;
		j=0;
		frame=0;

			while (i < 12)
			{
				if (!(frame%3))
				{
					if (!j)
					{
						k=random(70);
						suicidemouse[0] -> stretchX = 10+random(150);
						l=82+random(36);
					}
					else k++;
					oslStartDrawing();
					oslDrawFillRect(0,0,480,272, RGB(0,0,0));
					if (k>44)
					{
						j=1;

						if (k < 74)
						{
							suicidemouse[0] -> stretchX += 13;
							suicidemouse[0] -> stretchY = (int)(1.18 * (suicidemouse[0] -> stretchX));

							spr_draw(suicidemouse[0],240,138);
						}

						if (k==l)
						{
							i++;
							j=0;
						}
					}
					//frame_debug(k);
					oslEndDrawing();
					oslSwapBuffers();
				}
				else
				{
					oslWaitVSync();
				}
				frame++;
			}

		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);
	break;


	case 17:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/nigel.png",OSL_IN_RAM, OSL_PF_8888);
		oslSetImageRotCenter(suicidemouse[0]);

		creepysfx = oslLoadSoundFile("./sfx/smashing.wav", OSL_FMT_NONE);

		frame=0;

		oslPlaySound(creepysfx, 1);

		while (frame<512)
		{
				oslStartDrawing();
			    oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			    for(i=0; i<8; i++)
			    {
			    		j=random(10)-20;
					    oslDrawFillRect(i*60,120+j,(i*60)+60,152+(-1*j), RGB(96,96,0));
			    		oslDrawFillRect(i*60,128+j,(i*60)+60,144+(-1*j), RGB(128,128,0));
			    		oslDrawFillRect(i*60,136+j,(i*60)+60,136+(-1*j), RGB(160,160,0));
			    }

			    if (frame >= 480)
			    {

				    spr_draw(suicidemouse[0],240,138);

				    	suicidemouse[0] -> stretchX += 16;
				    	suicidemouse[0] -> stretchY = (int)(1.33*(suicidemouse[0] -> stretchX));
			    }
				oslEndDrawing();
				oslSwapBuffers();
				oslWaitVSync();
				frame++;
		}

		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(sfx);

	break;

	case 18:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/caaat.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] =  oslLoadImageFilePNG("./gfx/caaat_ns.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/caaat.wav", OSL_FMT_NONE);
		oslSetImageRotCenter(suicidemouse[0]);
		oslSetImageRotCenter(suicidemouse[1]);

		oslPlaySound(creepysfx, 1);

		frame=0;

		while(oslGetSoundChannel(creepysfx) == 1)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			if (frame<150)
			{
				spr_draw(suicidemouse[1],240,138);
			}
			else
			{
				spr_draw(suicidemouse[0],240,138);
			}

			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			frame++;
		}
		oslDeleteSound(creepysfx);
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(sfx);
	break;

	case 19:
		for (i=0; i<9; i++)
				{
					sprintf(buffer,"./gfx/pona0%d.png",i);
					suicidemouse[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);

					suicidemouse[i]->stretchX = 480;
					suicidemouse[i]->stretchY = 272;
					oslSetImageRotCenter(suicidemouse[i]);
				}

		frame=0;

		creepysfx = oslLoadSoundFile("./sfx/pona.wav", OSL_FMT_NONE);
		oslPlaySound(creepysfx, 0);

		i=0;

		while (frame < 333)
		{

			oslStartDrawing();
		    oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			oslSetBilinearFilter(1);

			if (frame < 110)
		    {
		    	spr_draw(suicidemouse[frame/14],240,138);
		    }

		    if ((frame >= 110) && (frame <= 140))
		    {
		    	spr_draw(suicidemouse[8],240,138);
		    }
		    oslSetBilinearFilter(0);
		    oslEndDrawing();
			//frame_debug((int)oslGetRamStatus().maxAvailable);
		    oslSwapBuffers();

			oslWaitVSync();
		    frame++;
		}

		oslDeleteSound(creepysfx);
		for (i=0; i<9; i++)
		{
			oslDeleteImage(suicidemouse[i]);
		}
		oslDeleteSound(sfx);

		break;

	case 20:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/pookey1.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] =  oslLoadImageFilePNG("./gfx/pookey2.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/pookeymon.wav", OSL_FMT_NONE);
		oslSetImageRotCenter(suicidemouse[0]);
		oslSetImageRotCenter(suicidemouse[1]);

		oslPlaySound(creepysfx, 1);

		frame=0;

		while(frame < 550)
		{
			oslStartDrawing();
		    oslDrawFillRect(0,0,480,272, RGB(0,0,0));

		    if ((frame >= 375) && (frame < 389)) spr_draw(suicidemouse[0], 240, 136);
		    if ((frame >= 389) && (frame < 401)) spr_draw(suicidemouse[1], 240, 136);

		    oslEndDrawing();
		    oslSwapBuffers();

			oslWaitVSync();

			frame++;
		}

		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		break;

	case 21:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/gfx-0825.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/sfx-0030.wav", OSL_FMT_NONE);
		oslSetImageRotCenter(suicidemouse[0]);

		oslPlaySound(creepysfx, 1);

		frame=0;

		suicidemouse[0] -> stretchX = i = 396;
		suicidemouse[0] -> stretchY = (int)(1.68*suicidemouse[0] -> stretchX);

		while(frame < 480)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));


			i=suicidemouse[0] -> stretchX;

			if ((suicidemouse[0] -> stretchX) > -72)
			{

				if (suicidemouse[0] -> stretchX >= 0)
				{
					oslSetAlpha(OSL_FX_DEFAULT, 0);
					spr_draw(suicidemouse[0], 240, 136);
				}

				if (suicidemouse[0] -> stretchX >= -36)
				{
					suicidemouse[0] -> stretchX += 36;
					suicidemouse[0] -> stretchY = (int)(1.68* (suicidemouse[0] -> stretchX));


					oslSetAlpha(OSL_FX_ALPHA, 128);
					spr_draw(suicidemouse[0], 240, 136);
				}


				suicidemouse[0] -> stretchX += ((suicidemouse[0] -> stretchX < -36)?72:36);
				suicidemouse[0] -> stretchY = (int)(1.68* (suicidemouse[0] -> stretchX));

				oslSetAlpha(OSL_FX_ALPHA, 64);
				spr_draw(suicidemouse[0], 240, 136);
			}

			suicidemouse[0] -> stretchX = i;

			if (!(frame%5))
			{
				suicidemouse[0] -> stretchX = i - 18;
			}

			suicidemouse[0] -> stretchY = (int)(1.68*suicidemouse[0] -> stretchX);

			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			frame++;
		}

		oslSetAlpha(OSL_FX_DEFAULT, 0);

		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		break;

	case 22:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/lavender.png",OSL_IN_RAM, OSL_PF_5551);
		creepysfx = oslLoadSoundFile("./sfx/lavender.wav", OSL_FMT_NONE);

		oslSetImageTileSize(suicidemouse[0],0,0,48,48);
		oslSetImageRotCenter(suicidemouse[0]);
		oslPlaySound(creepysfx, 1);

		frame=0;

		while(frame < 420)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			if (frame <= 341)
			{
				oslSetAlpha(OSL_FX_ALPHA, random(128));
				suicidemouse[0]->stretchX = suicidemouse[0]->stretchY = 96;
			}
			else
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				oslSetImageTileSize(suicidemouse[0],48,0,48,48);
				oslSetImageRotCenter(suicidemouse[0]);
				suicidemouse[0]->stretchX = suicidemouse[0]->stretchY = 640;
			}

			if (frame < 395) spr_draw(suicidemouse[0], 240+((frame>341)?0:random(4)), 136+((frame>341)?104:random(4)));

			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			frame++;
		}


		oslDeleteImage(suicidemouse[0]);
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);
		break;

	case 23:
		frame=0;
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/c64.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] =  oslLoadImageFilePNG("./gfx/c64-ar.png",OSL_IN_RAM, OSL_PF_5551);

		while (frame < 360)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			oslDrawFillRect(60, 0, 420, 272, RGB(165,165,255));
			oslDrawFillRect(80, 46, 400, 226, RGB(66,66,231));

			if (frame < 150)
			{
				for(i=0; i<1000; i++)
				{
					 spr_draw(suicidemouse[1], (i%40)*8+80, ((int)(i/40))*8+38);
				}
			}
			else
			{
				 spr_draw(suicidemouse[0], 80, 46);
				 if ((frame%60) < 30)
				 {
					 oslDrawFillRect(80, 94, 88, 102, RGB(165,165,255));
				 }
			}
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			frame++;
		}
		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(sfx);
		break;

	case 24:
		suicidemouse[0] =  oslLoadImageFilePNG("./gfx/sncell.png",OSL_IN_RAM, OSL_PF_5551);
		suicidemouse[1] =  oslLoadImageFilePNG("./gfx/sncpnt.png",OSL_IN_RAM, OSL_PF_5551);
		oslSetImageRotCenter(suicidemouse[0]);
		creepysfx = oslLoadSoundFile("./sfx/nuls.wav", OSL_FMT_NONE);

		oslPlaySound(creepysfx, 1);

		while(oslGetSoundChannel(creepysfx)==1)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(suicidemouse[0], 236+random(7), 132+random(7));
			spr_draw(suicidemouse[1], 224+random(7), 132+random(7));
			spr_draw(suicidemouse[1], 246+random(7), 132+random(7));
			oslSwapBuffers();
			oslWaitVSync();
		}

		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		oslEndDrawing();
		oslSwapBuffers();
		fadeout(RGB(0, 0, 0));

		oslDeleteImage(suicidemouse[0]);
		oslDeleteImage(suicidemouse[1]);
		oslDeleteSound(creepysfx);
		oslDeleteSound(sfx);

		break;

	}




	oslDeleteSound(w4c);
	fadeout(RGB(0,0,0));
}

void draw_benj(OSL_IMAGE *benj, int px, int py, short shielded, OSL_IMAGE *shield)
{

	float court_zoom = 0.00192*(py+32) + 0.562;
	shield->stretchX = (int)(48*(float)court_zoom);
	shield->stretchY = (int)(48*(float)court_zoom);

	//oslSetBilinearFilter(1);
	if ((benj -> angle) == -90)
	{
		spr_draw(benj, px-16, py+88);
	}
	else if ((benj -> angle) == 90)
	{
		spr_draw(benj, px+64, py+32);
	}
	else if ((benj -> angle) == 0) spr_draw(benj, px, py);

	if (shielded)
	{
		oslSetAlpha(OSL_FX_ALPHA, 128);
		spr_draw(shield, px+4, py+16);
		oslSetAlpha(OSL_FX_DEFAULT, 0);
	}
	//oslSetBilinearFilter(0);
}


int warning_onepilepsy()
{
	int i, w, frame=0, quit=0, red=0, accept=0;
	const char *text[8] = {"This game contains flashing patterns that may cause","epileptic seizures when players attempt to see them.","It also contains strange pictures that may cause some players","to have brief but intense adrenaline surges in their body."," ","Consult a doctor if you experience","unusual symptoms while playing games!","Press START to play or X to quit"};
	OSL_IMAGE *warning = oslLoadImageFilePNG("./gfx/warning.png",OSL_IN_RAM, OSL_PF_8888);
	OSL_SOUND *theme = oslLoadSoundFileMOD("./muzaxx/giygas.xm", OSL_FMT_NONE);
	warning->stretchX = 360;

	oslSetImageRotCenter(warning);

	oslPlaySound(theme, 5);

	//oslSetBilinearFilter(1);

	while (!quit)
	{
	    oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));

		oslSetTransparentColor(RGB(255,0,255));
		oslSetBkColor(RGB(255,0,255));


	for (i=0; i<7; i++)
	{
		if (i<5) oslSetTextColor(RGB(255, 255, 255));
		if (i>4) oslSetTextColor(RGB(255, 255, 0));
		w = oslGetStringWidth(text[i]);
		oslDrawString((480 - w)/2, 92+i*20, text[i]);
	}

	warning->angle = (int)(7*sin((0.25*frame)/3.14));

	spr_draw(warning, 240, 32);

	oslSetTextColor(RGB(red, 0, 0));
	w = oslGetStringWidth(text[7]);
	oslDrawString((480 - w)/2, 256, text[7]);
	red -= 3;
	if (red < 0) red=255;

    oslEndDrawing();
    oslSwapBuffers();

    oslReadKeys();
    if (osl_keys->pressed.start)
    	{
    		accept=1;
    		quit=1;
    	}
    if (osl_keys->pressed.cross)
    	{
    		accept=0;
    		quit=1;
    	}

    oslWaitVSync();
    frame++;
	}

	oslFlushKey();

	//oslSetBilinearFilter(0);
    fadeout(RGB(0,0,0));
    oslDeleteImage(warning);
    oslStopSound(theme);
    oslDeleteSound(theme);

    return accept;
}

short sonicexe2(int diff)
{
	int i, rects=1, sc=0, bx=240, frame=0, bouss=0;

	short reussi=0;
	OSL_IMAGE *bg, *pass, *buttons, *sexe2, *slyexe;
	OSL_SOUND *oof = oslLoadSoundFile("./sfx/sfx-0009.wav", OSL_FMT_NONE);
	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);
	OSL_SOUND *kte = oslLoadSoundFile("./sfx/kte.wav", OSL_FMT_NONE);
	OSL_SOUND *sallyexe = oslLoadSoundFile("./sfx/sallyexe.wav", OSL_FMT_NONE);

	sexe2 = oslLoadImageFilePNG("./gfx/sonicexe2.png",OSL_IN_RAM, OSL_PF_5551);
	bg = oslLoadImageFilePNG("./gfx/gfx-0776.png",OSL_IN_RAM, OSL_PF_5551);
	pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);
	buttons = oslLoadImageFilePNG("./gfx/arrows.png",OSL_IN_RAM, OSL_PF_8888);
	slyexe = oslLoadImageFilePNG("./gfx/sallyexe.png",OSL_IN_RAM, OSL_PF_8888);

	benj -> stretchX = 64;
	benj -> stretchY = 96;

	oslSetImageRotCenter(sexe2);
	oslSetImageRotCenter(buttons);
	oslSetImageRotCenter(pass);



	oslSetSoundLoop(kte, 1);
	oslPlaySound(kte, 1);

	while ((sc < 90*diff) && (rects < 240))
	{
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0, 0, 0));
		oslSetAlpha(OSL_FX_ALPHA, 160);
		spr_draw(bg, 0, 0);
		oslSetAlpha(OSL_FX_TINT, RGBA(255,0,0,48));
		spr_draw(bg, 0, 0);

		oslReadKeys();

		if (((osl_pad.analogX < -32) || (osl_keys->held.left)) && (bx > rects))
		{
			oslSetImageTileSize(benj,(abs(frame%32)/4)*32,144,32,48);
			bx -= 4;
			if (bouss==0)
			{
				bouss=1;
				sc++;
			}
		}
		else if (((osl_pad.analogX > 32) || (osl_keys->held.right)) && (bx < (448-(rects+1))))
		{
			oslSetImageTileSize(benj,(abs(frame%32)/4)*32,48,32,48);
			bx += 4;
			if (bouss==1)
			{
				bouss=0;
				sc++;
			}
		}
		else
		{
			oslSetImageTileSize(benj,0,192,32,48);
		}

		oslSetAlpha(OSL_FX_DEFAULT, 0);
		spr_draw(sexe2, 240+4*sin(0.0625*frame), 64);
		spr_draw(buttons, 240, 136);

		benj -> stretchX = 64;
		benj -> stretchY = 96;
		oslSetAlpha(OSL_FX_TINT, RGBA(0,0,0,255));
		spr_draw(benj, bx, 176);

		oslSetAlpha(OSL_FX_DEFAULT, 0);
		oslDrawFillRect(0, 0, rects+1, 272, RGB(0,0,0));
		oslDrawFillRect(480, 0, 480-(rects+1), 272, RGB(0,0,0));
		oslDrawFillRect(0, 0, 480, rects+1, RGB(0,0,0));

		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
		frame++;
		if (!(frame%(20-((diff-1)*5)))) rects++;
		if (bx < rects) bx=rects+4;
		if (bx > (448-(rects+1))) bx=443-rects;
	}


	if (sc >= 90*diff)
	{
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslPlaySound(passs, 2);
		for (i=135; i<=272; i+=24)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(pass,240,136);
			pass -> stretchX = pass -> stretchY = i;
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
		reussi=1;
	}
	else
	{
		oslPlaySound(sallyexe, 1);
		while(oslGetSoundChannel(sallyexe)==1)
		{
			oslStartDrawing();
			oslSetAlpha(OSL_FX_DEFAULT, 0);
			spr_draw(slyexe, 0, 0);
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
	}


	oslDeleteSound(kte);
	oslDeleteImage(sexe2);
	oslDeleteImage(bg);
	oslDeleteImage(pass);
	oslDeleteSound(oof);
	oslDeleteSound(passs);
	oslDeleteSound(sallyexe);
	oslDeleteImage(slyexe);
	return reussi;
}

short sonicexe(int diff)
{
	SceUID check;
	short reussi=0;
	int i, j=0, k=0, l=100, benj_frame=0, bgx=0, flx=0, bb, by, sedx=80, sedy=16;
	OSL_IMAGE *iamgod, *sonicexebg, *sonicexefloor, *sonicexe_d, *buttons, *pass;
	OSL_SOUND *drowning;

	check = sceIoDopen("flash1:/");

	if (check < 0)
	{
		drowning = oslLoadSoundFile("./sfx/sfx-0146.wav", OSL_FMT_NONE);
	}
	else
	{
		drowning = oslLoadSoundFile("./sfx/sfx-0146.wav", OSL_FMT_STREAM);
	}

	OSL_SOUND *oof = oslLoadSoundFile("./sfx/sfx-0009.wav", OSL_FMT_NONE);
	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);

	char buffer[20];

	oslClearImage(OSL_SECONDARY_BUFFER, RGB(0,0,0));

	i=random(4)+1;
	bb=random(4);
	sprintf(buffer,"./gfx/iamgod%d.png",i);
	iamgod = oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
	oslSetImageRotCenter(iamgod);
	sonicexebg = oslLoadImageFilePNG("./gfx/gfx-0973.png",OSL_IN_RAM, OSL_PF_5551);
	sonicexefloor = oslLoadImageFilePNG("./gfx/gfx-0974.png",OSL_IN_RAM, OSL_PF_5551);
	buttons = oslLoadImageFilePNG("./gfx/buttons.png",OSL_IN_RAM, OSL_PF_8888);
	sonicexe_d = oslLoadImageFilePNG("./gfx/sonicexe.png",OSL_IN_RAM, OSL_PF_5551);
	pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);
	oslSetImageRotCenter(pass);



	oslPlaySound(drowning, 2);

	while ((oslGetSoundChannel(drowning) == 2) && (j < 23*diff))
	{
		if (k > 96) l = 18;
		if (k > 188) l = 16;
		if (k > 262) l = 14;
		if (k > 342) l = 12;
		if (k > 390) l = 10;
		if (k > 462) l = 8;
		if (k > 516) l = 6;
		if (k > 600) l = 4;

		if (k%l < (l/2)) by=0; else by=32;
		if (!(k%10))
		{
			sedx++;
			sedy++;
		}

		oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));

		spr_draw(sonicexebg, bgx, 8);
		spr_draw(sonicexefloor, flx, 248);
		spr_draw(sonicexebg, bgx+480, 8);
		spr_draw(sonicexefloor, flx+480, 248);
		spr_draw(sonicexe_d, sedx, sedy);

		oslSetImageTileSize(benj,(benj_frame%8)*32,48,32,48);
		oslSetImageTileSize(buttons,bb*32,by,32,32);
		benj -> stretchX = 64;
		benj -> stretchY = 96;
		buttons -> stretchX = buttons -> stretchY = 64;

		spr_draw(benj, 360, 152);
		spr_draw(buttons, 368, 82);

		/*sprintf(buffer,"%d %d", l, (int)oslGetRamStatus().maxAvailable);
		oslDrawString(0,8,buffer);*/
		oslEndDrawing();
		oslSwapBuffers();

		oslReadKeys();

		if (((bb==0) && (osl_keys -> pressed.circle)) || ((bb==1) && (osl_keys -> pressed.cross)) || ((bb==2) && (osl_keys -> pressed.square)) || ((bb==3) && (osl_keys -> pressed.triangle)))
		{
			j++;
		}

		oslWaitVSync();
		if (!(k%24)) benj_frame++;
		bgx -= 4;
		flx -= 8;
		if (bgx == -480) bgx=0;
		if (flx == -480) flx=0;
		k++;
	}

	if (j >= 23*diff)
	{
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslPlaySound(passs, 2);
		for (i=135; i<=272; i+=24)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(pass,240,136);
			pass -> stretchX = pass -> stretchY = i;
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
		reussi=1;
	}
	else
	{

		k=255;
		for (i=sedx; i<360; i+=5)
		{
			oslStartDrawing();
			oslSetAlpha(OSL_FX_DEFAULT, 0);
			bgx--;
			flx -= 2;
			spr_draw(sonicexebg, bgx, 8);
			spr_draw(sonicexefloor, flx, 248);
			spr_draw(sonicexebg, bgx+480, 8);
			spr_draw(sonicexefloor, flx+480, 248);
			spr_draw(benj, 360, 152);
			oslSetAlpha(OSL_FX_ALPHA, k);
			spr_draw(sonicexe_d, i, sedy);
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			k -= 8;
			if (k<0) k=0;
			if (sedy < 168) sedy++;
		}
		oslSetAlpha(OSL_FX_DEFAULT, 0);

		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));

		oslPlaySound(oof, 2);
		oslStartDrawing();
	    oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		spr_draw(iamgod,240,136);
		oslEndDrawing();
		oslSwapBuffers();
		fadeout(RGB(0,0,0));
	}

	oslDeleteImage(iamgod);
	oslDeleteImage(sonicexebg);
	oslDeleteImage(sonicexefloor);
	oslDeleteImage(sonicexe_d);
	oslDeleteImage(buttons);
	oslDeleteImage(pass);
	oslDeleteSound(oof);
	oslDeleteSound(drowning);
	oslDeleteSound(passs);

	return reussi;
}

short mincer(int diff)
{
	short reussi=0, floor=-1, score=0;
	int i, skipframe=0, by=-36, bgy=0, my=404, minced=0, bb=random(4);
	OSL_IMAGE *mincer[3];
	OSL_IMAGE *benj_mincer;
	OSL_IMAGE *buttons = oslLoadImageFilePNG("./gfx/buttons.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);

	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);
	OSL_SOUND *mincing = oslLoadSoundFile("./sfx/sfx-0081.wav", OSL_FMT_NONE);
	OSL_SOUND *rightwrong[2];

	mincer[0] = oslLoadImageFilePNG("./gfx/mincer_bg.png",OSL_IN_RAM, OSL_PF_5551);
	mincer[1] = oslLoadImageFilePNG("./gfx/mincer.png",OSL_IN_RAM, OSL_PF_5551);
	mincer[2] = oslLoadImageFilePNG("./gfx/mincer_fg.png",OSL_IN_RAM, OSL_PF_5551);

	rightwrong[0] = oslLoadSoundFile("./sfx/right.wav",OSL_FMT_NONE);
	rightwrong[1] = oslLoadSoundFile("./sfx/wrong.wav",OSL_FMT_NONE);

	benj_mincer = oslLoadImageFilePNG("./gfx/benj_mincer.png",OSL_IN_RAM, OSL_PF_5551);

	oslSetImageRotCenter(pass);

	oslSetImageTileSize(benj_mincer,0,0,29,34);
	benj_mincer -> stretchX = benj_mincer -> stretchY = 58;

	oslSetFrameskip(0);
	oslSetMaxFrameskip(3);

	while ((floor <= (-2*diff+12)) && (score < (2*diff+3)))
	{
		if (!skipframe)
		{
			oslStartDrawing();
			oslSetImageTileSize(buttons,bb*32,0,32,32);
			buttons -> stretchX = buttons -> stretchY = 64;

			if (floor == -1)
			{
				oslDrawFillRect(0,0,480,272, RGB(0,0,32));
				spr_draw(mincer[0], 80, 0);
				spr_draw(mincer[0], 80, 240);
				spr_draw(benj_mincer, 215, by);
				by += 4;

				if (by==136) floor=0;
			}
			else if (floor >= 0)
			{
				oslDrawFillRect(0,0,480,272, RGB(0,0,32));
				spr_draw(mincer[0], 80, bgy);
				spr_draw(mincer[0], 80, bgy+240);


				if (floor >= (-2*diff+9))
				{
					spr_draw(mincer[1], 182, my);
				}

				spr_draw(mincer[0], 80, bgy+480);


				if (my < -108)
				{
					oslSetImageTileSize(benj_mincer,29,0,29,34);
					benj_mincer -> stretchX = benj_mincer -> stretchY = 58;
				}

				spr_draw(benj_mincer, 215, 136);

				if (bgy<=-240)
					{
						floor++;
						bgy=0;
					}

				if ((my <= 48) && (my >= -180))
				{
					oslFlushKey();
					if ((!minced) && (oslGetSoundChannel(mincing) != 2))
						{
							oslPlaySound(mincing, 2);
							score=0;
						}

					switch(minced)
					{
						case 0:
						case 2:
						{
							bgy -= 2;
							if (floor >= (-2*diff+9))
								{
									oslSetImageTileSize(mincer[0],0,0,101,240);
									spr_draw(mincer[0], 80, my-164);
									oslSetImageTileSize(mincer[0],226,0,94,240);
									spr_draw(mincer[0], 306, my-164);
									spr_draw(mincer[2], 182, my+158);
									oslSetImageTileSize(mincer[0],0,0,320,240);
									my -= 2;
								}

							if ((my == -96) && (!minced)) minced=1;
							break;
						}

						case 1:
						{
							bgy += 2;
							if (floor >= (-2*diff+9))
								{
									oslSetImageTileSize(mincer[0],0,0,101,240);
									spr_draw(mincer[0], 80, my-164);
									oslSetImageTileSize(mincer[0],226,0,94,240);
									spr_draw(mincer[0], 306, my-164);
									spr_draw(mincer[2], 182, my+158);
									my += 2;
									oslSetImageTileSize(mincer[0],0,0,320,240);
								}
							if (my == -12) minced=2;
							break;
						}
					}

				}
				else
				{
					bgy -= 4;
					if (floor >= (-2*diff+9))
					{
						spr_draw(mincer[2], 182, my+158);
						my -= 4;
					}

					oslReadKeys();

					if (my > 48)
					{
						spr_draw(buttons, 326, 136);

						if (((bb==0) && (osl_keys -> pressed.circle)) || ((bb==1) && (osl_keys -> pressed.cross)) || ((bb==2) && (osl_keys -> pressed.square)) || ((bb==3) && (osl_keys -> pressed.triangle)))
							{
								score++;
								bb=random(4);
								oslPlaySound(rightwrong[0], 3);
							}


						else if (((bb!=0) && (osl_keys -> pressed.circle)) || ((bb!=1) && (osl_keys -> pressed.cross)) || ((bb!=2) && (osl_keys -> pressed.square)) || ((bb!=3) && (osl_keys -> pressed.triangle)))
							{
								bb=random(4);
								oslPlaySound(rightwrong[1], 3);
								score--;
							}
					}
				}
			}

			oslEndDrawing();
			oslEndFrame();
			skipframe=oslSyncFrame();
		}
	}

	if (score == (2*diff+3))
	{
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslPlaySound(passs, 2);
		for (i=135; i<=272; i+=24)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(pass,240,136);
			pass -> stretchX = pass -> stretchY = i;
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
		reussi=1;
	}

	for (i=0; i<3; i++) oslDeleteImage(mincer[i]);
	oslDeleteImage(benj_mincer);
	oslDeleteSound(mincing);
	oslDeleteSound(rightwrong[0]);
	oslDeleteSound(rightwrong[1]);
	oslDeleteImage(buttons);
	oslDeleteImage(pass);
	oslDeleteSound(passs);



	return reussi;
}

short shoot_teevees(int diff, int *health, int round)
{
	short reussi=1, enemyx=random(2), enemyy=random(3), fired=13, hasdied=0;
	int i, j, u, frame=0, skipframe=0, hgx=208;

	int teevees[3][4]; //angle-ecran-y-fallspeed

	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);
	OSL_SOUND *dead = oslLoadSoundFile("./sfx/sfx-0025.wav", OSL_FMT_NONE);
	OSL_SOUND *pew = oslLoadSoundFile("./sfx/sfx-0100.wav", OSL_FMT_NONE);
	OSL_SOUND *oof = oslLoadSoundFile("./sfx/sfx-0101.wav", OSL_FMT_NONE);
	OSL_SOUND *ambient = oslLoadSoundFile("./sfx/sfx-0017.wav", OSL_FMT_NONE);
	OSL_IMAGE *pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *bg = oslLoadImageFilePNG("./gfx/gfx-0776.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *teevee = oslLoadImageFilePNG("./gfx/teevee.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *teevee_targets = oslLoadImageFilePNG("./gfx/teevee_targets.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *numberz = oslLoadImageFilePNG("./gfx/numberz.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *handgun = oslLoadImageFilePNG("./gfx/handgun.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *explode = oslLoadImageFilePNG("./gfx/explode.png",OSL_IN_RAM, OSL_PF_5551);

	OSL_IMAGE *temp = oslCreateImage(128, 96, OSL_IN_VRAM, OSL_PF_5551);

	oslSetImageRotCenter(pass);
	oslSetImageRotCenter(temp);
	oslSetSoundLoop(ambient, 1);

	oslClearImage(temp, RGB(0, 0, 0));

	for (i=0; i<3; i++)
	{
			teevees[i][0]=random(180)-90;
			teevees[i][1]=random(2);
			teevees[i][2]=-1*random(128)-128;
			teevees[i][3]=diff+1+random(3);
	}

	oslSetImageTileSize(handgun, 0, 0, 64, 64);
	oslPlaySound(ambient, 1);

	while (frame < 900*diff)
	{
		if (!skipframe)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			spr_draw(bg, 0, 0);

			oslSetTransparentColor(RGB(255,0,255));
			oslSetBkColor(RGB(255,0,255));
			oslSetTextColor(RGB(255, 255, 255));
			oslDrawString(160, 2, "Shoot the TVs with that screen:");
			oslSetImageTileSize(teevee_targets, 99*enemyx, 71*enemyy, 99, 71);
			oslSetBilinearFilter(1);
			teevee_targets -> stretchX = 50;
			teevee_targets -> stretchY = 35;
			spr_draw(teevee_targets, 215, 14);
			oslSetBilinearFilter(0);

			teevee_targets -> stretchX = 99;
			teevee_targets -> stretchY = 71;


			explode -> stretchX = 128;
			explode -> stretchY = 96;


			oslSetImageTileSize(numberz,160,0,16,16);
			spr_draw(numberz, 2, 2);


			for (i=0; i<3; i++)
			{
					oslSetDrawBuffer(temp);
					oslSetImageTileSize(teevee_targets, teevees[i][1]*99, 71*enemyy, 99, 71);
					spr_draw(teevee, 0, 0);
					spr_draw(teevee_targets, 14, 10);

					oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
					temp -> angle = teevees[i][0];

					spr_draw(temp, 160*i+80, teevees[i][2]);
					teevees[i][2] += teevees[i][3];

					if (teevees[i][2] > (336+((int)128*(sin(teevee -> stretchX)*3.14/180))))
					{
						if (teevees[i][1]==enemyx)
							{
								*health -= 12*diff;
								if ((*health <= 0) && (!hasdied))
								{
									oslPlaySound(dead, 2);
									hasdied=1;
									frame=900*diff-131;
								}
							}
						teevees[i][0]=random(180)-90;
						teevees[i][1]=random(2);
						teevees[i][2]=-1*random(128)-128;
						teevees[i][3]=diff+1+random(3);
					}
			}

			if (*health > 0) spr_draw(handgun, hgx, 211+((int)3*sin(0.0625*frame))); else spr_draw(handgun, hgx, 211+((int)3*sin(frame)));

			oslReadKeys();
			if  (((osl_keys -> held.left) || (osl_pad.analogX<-16)) && (hgx > 8) && (*health > 0)) hgx-=8;
			if  (((osl_keys -> held.right) || (osl_pad.analogX>16)) && (hgx < 408) && (*health > 0)) hgx+=8;

			if (fired < 13)
			{
				fired--;

				if ((teevees[hgx/160][1]==enemyx)  && (teevees[hgx/160][2] > 140))
				{
					spr_draw(explode, 160*i+80, teevees[hgx/160][2]);
				}

				if (fired > 9)
				{
					oslSetImageTileSize(handgun, 64, 0, 64, 64);
					spr_draw(handgun, hgx, 211+((int)3*sin(0.0625*frame)));
				}
				else
				{
					oslSetImageTileSize(handgun, 0, 0, 64, 64);

						if (fired==8)
						{
							if ((teevees[hgx/160][1]==enemyx)  && (teevees[hgx/160][2] > 140))
							{
								teevees[hgx/160][0]=random(180)-90;
								teevees[hgx/160][1]=random(2);
								teevees[hgx/160][2]=-1*random(128)-128;
								teevees[hgx/160][3]=diff+1+random(3);
								*health += 2*(4-diff);
								if (*health >= 100) *health=100;
							}
						}
				}

			}

			if (!fired)
			{
				fired=13;
				oslSetImageTileSize(handgun, 0, 0, 64, 64);

			}

			if (((osl_keys -> pressed.circle) || (osl_keys -> pressed.cross) || (osl_keys -> pressed.triangle) || (osl_keys -> pressed.square)) && (fired==13) && (*health > 0))
			{
				fired--;
				oslPlaySound(pew, 3);

				if ((teevees[hgx/160][1]!=enemyx) && (teevees[hgx/160][2] > 140))
				{
					*health -= 6*diff;
					oslPlaySound(oof, 4);
				}
			}

			i=random(15);
			u=18;

			if (*health <= 0)
			{
				*health=0;
			}

			if (*health < 25) j=16; else j=0;

				if (*health / 100)
				{
					oslSetImageTileSize(numberz,((round==2)?((i<12)?16:random(144)):16),0,16,16);
					spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
					u += 16;
				}

				if (*health > 9)
				{
					if (round==2)
						{
							if (i<12)
								{
									oslSetImageTileSize(numberz,((*health%100)/10)*16,j,16,16);
								}
							else
								{
									oslSetImageTileSize(numberz,random(128),j,16,16);
								}
						}
					else oslSetImageTileSize(numberz,((*health%100)/10)*16,j,16,16);
				spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
				u += 16;
				}

				if (round==2)
					{
						if (i<12)
							{
								oslSetImageTileSize(numberz,(*health%10)*16,j,16,16);
							}
						else
							{
								oslSetImageTileSize(numberz,random(128),j,16,16);
							}
					}
				else oslSetImageTileSize(numberz,(*health%10)*16,j,16,16);
				spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));

			frame++;
			oslEndDrawing();
			oslEndFrame();
		}
		skipframe=oslSyncFrame();
	}

		oslClearImage(OSL_SECONDARY_BUFFER, RGB(0,0,0));

		if (*health > 0)
		{
			oslStopSound(ambient);
			for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
			oslPlaySound(passs, 2);
			for (i=135; i<=272; i+=24)
			{
				oslStartDrawing();
				oslDrawFillRect(0,0,480,272, RGB(0,0,0));
				spr_draw(pass,240,136);
				pass -> stretchX = pass -> stretchY = i;
				oslEndDrawing();
				oslSwapBuffers();
				oslWaitVSync();
			}
		}
		else reussi=0;

		oslDeleteImage(bg);
		oslDeleteImage(pass);
		oslDeleteImage(teevee);
		oslDeleteImage(teevee_targets);
		oslDeleteImage(handgun);
		oslDeleteImage(temp);
		oslDeleteImage(numberz);
		oslDeleteImage(explode);
		oslDeleteSound(passs);
		oslDeleteSound(dead);
		oslDeleteSound(pew);
		oslDeleteSound(ambient);
		oslDeleteSound(oof);

	return reussi;
}

short flappy_cacodemon(int diff)
{
	short reussi=1, bunk=0, bgx=0, ghgx=0, dead=0, cacoy=32, pressed=26, mess=0;
	int i, frame=0, skipframe=0, growl=random(360)+35, postree=0;

	int walls[7]={0,0,0,0,0,0,random(100)};

	OSL_IMAGE *pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *cacod = oslLoadImageFilePNG("./gfx/cacodemon.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *pot = oslLoadImageFilePNG("./gfx/pot.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *pot_edge = oslLoadImageFilePNG("./gfx/pot_edge.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *flappy_bg = oslLoadImageFilePNG("./gfx/flappy_bg.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *flappy_redhill = oslLoadImageFilePNG("./gfx/flappy_redhill.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);
	OSL_SOUND *ambient = oslLoadSoundFile("./sfx/sfx-0017.wav", OSL_FMT_NONE);
	OSL_SOUND *caco_sfx[2];

	caco_sfx[0]= oslLoadSoundFile("./sfx/cacogrowl.wav", OSL_FMT_NONE);
	caco_sfx[1]= oslLoadSoundFile("./sfx/cacodie.wav", OSL_FMT_NONE);

	oslSetImageTileSize(cacod, 0, 0, 64, 64);
	oslSetImageRotCenter(cacod);
	oslSetImageRotCenter(pass);
	oslSetSoundLoop(ambient, 1);

	oslPlaySound(ambient, 1);

	while ((frame < 300*diff+300) && (dead < 5))
	{
		if (!(frame%growl))
		{
			growl=random(360)+35;
			oslPlaySound(caco_sfx[0], 4);
		}
		if (!skipframe)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));

				for (i=0; i<5; i++)	spr_draw(flappy_bg, bgx+i*138, 128);

			if (!bunk)
			{
				for (i=6; i>=0; i--)
				{
					if (walls[i])
					{
						pot -> stretchY = walls[i];
						spr_draw(pot, i*80-(postree%80), 230-walls[i]);
						spr_draw(pot_edge, i*80-(postree%80), 230-walls[i]);

						pot -> stretchY = 94-walls[i];
						spr_draw(pot, i*80-(postree%80), 0);
						spr_draw(pot_edge, i*80-(postree%80), 94-walls[i]);

					}
				}

			}

			if ((!bunk) && (!dead))
			{
				if ((postree%80) == (80-((diff==1)?1:((diff==2)?2:4))))
				{
					for (i=0; i<7; i++)
					{
						if (i < 6)
						{
							if (walls[i+1]) walls[i]=walls[i+1];
						}
						else
						{
							walls[6]=walls[5]+(random(2)?1:-1)*random(32);
							if (walls[6] < 32) walls[6]=32;
							if (walls[6] > 110) walls[6]=110;
						}
					}
				}
			}

			for(i=0; i<32; i++)
			{
				spr_draw(flappy_redhill, ghgx+i*16, 224);
			}

			if (!bunk)
			{
				if (!(frame%2))
				{
					cacod -> angle = 8*sin(0.15*frame);
				}
				spr_draw(cacod, 40, cacoy);
			}
			else
			{
				if (!(frame%9)) dead++;
				oslSetImageTileSize(cacod, 64*dead, 0, 64, 64);
				oslSetImageRotCenter(cacod);
				spr_draw(cacod, 40, cacod -> y);
				if (dead==1)
				{
					oslPlaySound(caco_sfx[1], 4);
				}
			}

			if (!mess) oslDrawString(200, 18, "MAKE HIM FLY!");

			oslReadKeys();
			if (((osl_keys -> pressed.circle) || (osl_keys -> pressed.cross) || (osl_keys -> pressed.triangle) || (osl_keys -> pressed.square)))
			{
				pressed=0;
				if (!mess) mess=1;
			}

				pressed++;
				if ((cacoy > 35) && (pressed < (-4*diff+28))) cacoy -= diff;
				if (pressed > (-4*diff+28)) cacoy += diff;


			if (!bunk)
			{
				if (!(frame%2)) bgx -= diff+1;
				ghgx -= (diff+1);

				if (bgx <= -138) bgx=0;
				if (ghgx <= -16) ghgx=0;

			}

			if ((cacod -> y > 192) && (!bunk))
			{
				bunk=1;
				frame=0;
			}

			if ((walls[1]) && ((cacod -> y)-24 <= 102-walls[1]) && (!bunk) && (postree%80 < 40))
			{
				bunk=1;
				frame=0;
			}

			if ((walls[1]) && ((cacod -> y)+24 >= 230-walls[1]) && (!bunk) && (postree%80 < 40))
			{
				bunk=1;
				frame=0;
			}

			oslEndDrawing();
			oslEndFrame();
		}
		frame++;

		if (!bunk)
		{
			postree += ((diff==1)?1:((diff==2)?2:4));
		}

		skipframe=oslSyncFrame();
	}

	while (oslGetSoundChannel(caco_sfx[1])==4);

	if (!bunk)
	{
		oslStopSound(ambient);
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslPlaySound(passs, 2);
		for (i=135; i<=272; i+=24)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(pass,240,136);
			pass -> stretchX = pass -> stretchY = i;
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
	}
	else reussi=0;

	oslDeleteImage(cacod);
	oslDeleteImage(flappy_bg);
	oslDeleteImage(flappy_redhill);
	oslDeleteImage(pot);
	oslDeleteImage(pot_edge);
	oslDeleteSound(ambient);
	oslDeleteImage(pass);
	oslDeleteSound(passs);
	oslDeleteSound(caco_sfx[0]);
	oslDeleteSound(caco_sfx[1]);
	return reussi;
}


short love_boat(int diff)
{
	short reussi=1, alive=1, bx=240, boat_x=random(320)+80, sens;
	int i, frame, a=0;

	OSL_IMAGE *boat = oslLoadImageFilePNG("./gfx/boat.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *boat_blood = oslLoadImageFilePNG("./gfx/boat_blood.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *boat_sfx = oslLoadSoundFile("./sfx/boat.wav",OSL_FMT_NONE);
	OSL_SOUND *sflartch = oslLoadSoundFile("./sfx/beng-0037.wav",OSL_FMT_NONE);
	OSL_IMAGE *pass = oslLoadImageFilePNG("./gfx/gfx-0718.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *passs = oslLoadSoundFile("./sfx/sfx-0053.wav", OSL_FMT_NONE);
	OSL_SOUND *ambient = oslLoadSoundFile("./sfx/sfx-0061.wav", OSL_FMT_NONE);
	oslSetImageRotCenter(pass);
	oslSetImageRotCenter(boat);
	oslSetImageRotCenter(boat_blood);
	oslSetSoundLoop(ambient, 1);
	oslPlaySound(ambient, 1);

	frame = -1*random(540)-240;

	if (diff == 3)
	{
		if (boat_x%4)
		{
			boat_x += 4-(boat_x%4);
		}
	}

	while (frame < 255)
	{
		if (!frame) oslPlaySound(boat_sfx, 4);

		oslStartDrawing();
		oslSetAlpha(OSL_FX_DEFAULT, 0);
		oslDrawFillRect(0,0,480,272, RGB(16,0,0));

		if (diff==3)
		{
			if (frame == 92)
			{
				a = bx+32;
			}
			else if (frame > 92)
			{
				if (boat_x > a) boat_x -= 4;
				if (boat_x < a) boat_x += 4;
			}
		}
		else if (diff==2)
		{
			sens=random(2);
			if ((sens) && (boat_x < (400-(boat->stretchX)/2))) boat_x += 4;
			if ((!sens) && (boat_x > (boat->stretchX)/2)) boat_x -=4;
		}

		if (frame >= 0)
		{
			oslSetAlpha(OSL_FX_ALPHA, frame);
			boat -> stretchX = frame*2;
			boat -> stretchY = (int)((float)1.5*(boat -> stretchX));
			spr_draw(boat, boat_x, 96);
		}


		oslSetAlpha(OSL_FX_DEFAULT, 0);
		oslReadKeys();
		if (((osl_pad.analogX < -32) || (osl_keys->held.left)) && (bx > 0))
		{
			oslSetImageTileSize(benj,(abs(frame%32)/4)*32,144,32,48);
			bx -= 4;
		}
		else if (((osl_pad.analogX > 32) || (osl_keys->held.right)) && (bx < 448))
		{
			oslSetImageTileSize(benj,(abs(frame%32)/4)*32,48,32,48);
			bx += 4;
		}
		else
		{
			oslSetImageTileSize(benj,0,192,32,48);
		}

		benj -> stretchX = 64;
		benj -> stretchY = 96;

		if (alive) spr_draw(benj, bx, 176);

		if (((boat->stretchX) >= 200))
		{
			if ((alive) && ((bx+32) >= (boat_x-((boat->stretchX)/4))) && ((bx+32) <= (boat_x+((boat->stretchX)/4))))
			{
				alive=0;
				oslDrawFillRect(0,0,480,272, RGB(255, 255, 255));
				oslPlaySound(sflartch, 3);
			}
		}

		if (!alive)
		{
			spr_draw(boat_blood, 240, 136);
		}

		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
		frame++;
	}

	if (alive)
	{
		for (i=0; i<10; i++) oslClearImage(OSL_SECONDARY_BUFFER, RGB(255, 255, 255));
		oslPlaySound(passs, 2);
		for (i=135; i<=272; i+=24)
		{
			oslStartDrawing();
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(pass,240,136);
			pass -> stretchX = pass -> stretchY = i;
			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
		}
	}
	else reussi=0;

	oslDeleteImage(boat);
	oslDeleteImage(boat_blood);
	oslDeleteSound(boat_sfx);
	oslDeleteImage(pass);
	oslDeleteSound(passs);
	oslDeleteSound(sflartch);
	oslDeleteSound(ambient);
	return reussi;
}

void draw_ball(struct ball ball_ent, OSL_IMAGE *ball_gfx, OSL_IMAGE *ball_shad)
{

	float yr = pow((ball_ent.y2d - 160) / HAUT_FIELD, 1.4f) * HAUT_FIELD + 160;
	float x_pr_centre = ball_ent.x2d - 240;
	float x_percent = x_pr_centre / 240;
	float y_percent = (272-yr)/HAUT_FIELD;
	float x_mult = 240 - ESPAC_HORIZ*y_percent;
	float xr = x_percent * x_mult + 240;

	ball_gfx -> stretchX = ball_gfx -> stretchY = 8*(1-0.266f*y_percent);
	ball_shad -> stretchX = ball_shad -> stretchY = 8*(1-0.266f*y_percent);

	spr_draw(ball_gfx, ball_ent.x2d, ball_ent.y2d-ball_ent.z3d);
	spr_draw(ball_shad, ball_ent.x2d, ball_ent.y2d);
}

void redness (int round, int diff, int hp)
{
	if (round == 2)
	{
		if (hp == 100*round*diff)
		{
			oslSetAlpha(OSL_FX_DEFAULT, 0);
		}
		else
		{
			oslSetAlpha(OSL_FX_COLOR, RGBA(255, 0, 0, (int)(-2.55/(round*diff))*hp+255));
		}
	}
	else
	{
		oslSetAlpha(OSL_FX_DEFAULT, 0);
	}
}

int shoop_da_whoop(int health, int round, int diff)
{
	int i=480, f=0, ta=0, j, u, k=0, sc=0, a=0, b=0;
	short sens=0, by=0;

	OSL_IMAGE *starsky = oslLoadImageFilePNG("./gfx/starsky.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *firin = oslLoadSoundFile("./sfx/sdw.wav", OSL_FMT_NONE);
	oslPlaySound(firin, 1);

	oslSetImageRotCenter(starsky);

		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(255,255,255));
		oslEndDrawing();
		oslSwapBuffers();

	OSL_SOUND *sdwh  = oslLoadSoundFile("./sfx/sdw2.wav", OSL_FMT_NONE);
	OSL_SOUND *expl_sound = oslLoadSoundFile("./sfx/sfx-0018.wav", OSL_FMT_NONE);
	OSL_IMAGE *buttons = oslLoadImageFilePNG("./gfx/arrows.png",OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *sdw = oslLoadImageFilePNG("./gfx/sdw.png",OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *sdw_sh = oslLoadImageFilePNG("./gfx/sdw_sh.png",OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *planet = oslLoadImageFilePNG("./gfx/planet.png",OSL_IN_RAM, OSL_PF_5551);

	oslStartDrawing();
	oslDrawFillRect(0,0,480,272, RGB(0,0,0));
	spr_draw(starsky, 240, 136);
	oslEndDrawing();
	oslSwapBuffers();

	OSL_IMAGE *numberz = oslLoadImageFilePNG("./gfx/numberz.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *explode = oslLoadImageFilePNG("./gfx/explode.png",OSL_IN_RAM, OSL_PF_5551);

	OSL_IMAGE *temp = oslCreateImage(480, 272, OSL_IN_VRAM, OSL_PF_5551);
	OSL_IMAGE *shoot = oslCreateImage(160, 60, OSL_IN_VRAM, OSL_PF_5551);

	oslSetImageRotCenter(temp);
	oslSetImageRotCenter(sdw);
	oslSetImageRotCenter(sdw_sh);
	oslSetImageRotCenter(planet);
	oslSetImageRotCenter(buttons);




	oslDisableTransparentColor();
	oslClearImage(temp, RGB(255, 0, 255));
	oslClearImage(shoot, RGB(255, 0, 255));
	oslSetTransparentColor(RGB(255, 0, 255));



	for (i=480; i>=128; i-=4)
	{
		planet -> stretchX = planet -> stretchY = i;
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		spr_draw(starsky, 240, 136);
		spr_draw(planet, 240, 136);
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
	}

	for (i=480; i>=360; i-=4)
	{
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0,0,0));
		spr_draw(starsky, 240, 136);
		spr_draw(planet, 240, 136);
		spr_draw(sdw, i, 136);
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
	}



	for (k=0; k<(diff+1); k++)
	{
		f=0;

		sc=0;

		while ((f < 270) && (health > 0))
		{
			if ((f%30) >= 15) by=32; else by=0;

			oslStartDrawing();
			spr_draw(sdw_sh, 240, 136);

			if (f < 120)
			{
				if (!(f%20)) sens=random(2);

				temp -> angle = 0;
				oslDisableTransparentColor();
				oslClearImage(temp, RGB(255, 0, 255));
				oslSetTransparentColor(RGB(255, 0, 255));


				oslSetDrawBuffer(temp);
				spr_draw(sdw, 360, 136);

				ta += (sens)?6:-6;

				if (ta < 0) ta += 360;
				if (ta > 359) ta = ta%360;

				temp -> angle = ta;

				oslReadKeys();


				if (osl_keys -> held.left)
				{
					sdw_sh -> angle -= 12;
				}

				if (osl_keys -> held.right)
				{
					sdw_sh -> angle += 12;
				}

				if ((sdw_sh -> angle) < 0)
				{
					(sdw_sh -> angle) += 360;
				}

				if ((sdw_sh -> angle) > 359)
				{
					sdw_sh -> angle = ((sdw_sh -> angle))%360;
				}


				/*if (((bb==0) && (osl_keys -> pressed.circle)) || ((bb==1) && (osl_keys -> pressed.cross)) || ((bb==2) && (osl_keys -> pressed.square)) || ((bb==3) && (osl_keys -> pressed.triangle)))
				{
					sc++;
				}*/
			}

			if (((sdw_sh -> angle - 60) < (temp -> angle)) && ((sdw_sh -> angle + 60) > (temp -> angle)) && (f==119)) sc = 2*diff+2;


					if ((f >= 120) && (f <= 150))
					{
						temp -> angle = 0;
						shoot -> angle = 0;
						oslDisableTransparentColor();
						oslClearImage(shoot, RGB(255, 0, 255));
						oslSetTransparentColor(RGB(255, 0, 255));

						oslSetDrawBuffer(shoot);
						oslDrawFillRect(160, 0, (-16/3)*f+800, 60, RGB(0,0,255));
						oslDrawFillRect(160, 10, (-16/3)*f+800, 50, RGB(0,128,255));
						oslDrawFillRect(160, 20, (-16/3)*f+800, 40, RGB(0,255,255));
						oslDrawFillRect(160, 23, (-16/3)*f+800, 37, RGB(128,255,255));
						oslDrawFillRect(160, 26, (-16/3)*f+800, 33, RGB(255,255,255));

						oslSetDrawBuffer(temp);
						spr_draw(shoot, 208, 116);

						temp -> angle = ta;
					}

				if (sc == 2*diff+2)
				{
					if (f >= 150)
					{
					oslSetDrawBuffer(temp);
					spr_draw(sdw, 360, 136);
					if (f == 150) oslPlaySound(sdwh, 1);

						if (!(f%15))
						{
							oslPlaySound(expl_sound, 6);
							a=330+random(35);
							b=72+random(64);
						}

						if ((f%10) < 5)
						{
							explode -> stretchX = 64;
							explode -> stretchY = 96;
							spr_draw(explode, a, b);
						}
						else
						{
							explode -> stretchX = 32;
							explode -> stretchY = 48;
							spr_draw(explode, a+16, b+24);
						}
					}
					if (f > 180) f=333;
				}

			oslSetDrawBuffer(OSL_DEFAULT_BUFFER);
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));
			spr_draw(starsky, 240, 136);
			spr_draw(temp, 240, 136);
			spr_draw(planet, ((f > 150) && (sc < 2*diff+1))?(238+random(5)):240, ((f > 150) && (sc < 2*diff+1))?(134+random(5)):136);
			spr_draw(buttons, 240, 136);
			spr_draw(sdw_sh, 240, 136);

			//if (f < 120) spr_draw(buttons, 208, 118);
			if ((f >= 180) && (f <= 240) && (sc < 2*diff+1))
			{
				if (f > 180)
				{
					if (!(f%3)) health--;
				}

				if (!(f%15))
				{
					oslPlaySound(expl_sound, 6);
					a=180+random(128);
					b=68+random(128);
				}

				if ((f%10) < 5)
				{
					explode -> stretchX = 64;
					explode -> stretchY = 96;
					spr_draw(explode, a, b);
				}
				else
				{
					explode -> stretchX = 32;
					explode -> stretchY = 48;
					spr_draw(explode, a+16, b+24);
				}
			}

			i=random(15);
			u=18;

			if (health <= 0)
			{
				health=0;
			}

			oslSetImageTileSize(numberz,160,0,16,16);
			spr_draw(numberz, 2, 2);

			if (health < 25) j=16; else j=0;

				if (health / 100)
				{
					oslSetImageTileSize(numberz,((round==2)?((i<12)?16:random(144)):16),0,16,16);
					spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
					u += 16;
				}

				if (health > 9)
				{
					if (round==2)
						{
							if (i<12)
								{
									oslSetImageTileSize(numberz,((health%100)/10)*16,j,16,16);
								}
							else
								{
									oslSetImageTileSize(numberz,random(128),j,16,16);
								}
						}
					else oslSetImageTileSize(numberz,((health%100)/10)*16,j,16,16);
				spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
				u += 16;
				}

				if (round==2)
					{
						if (i<12)
							{
								oslSetImageTileSize(numberz,(health%10)*16,j,16,16);
							}
						else
							{
								oslSetImageTileSize(numberz,random(128),j,16,16);
							}
					}
				else oslSetImageTileSize(numberz,(health%10)*16,j,16,16);
				spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));


			oslEndDrawing();
			oslSwapBuffers();
			oslWaitVSync();
			f++;
		}
	}

	oslDeleteSound(firin);
	oslDeleteSound(sdwh);
	oslDeleteSound(expl_sound);
	oslDeleteImage(buttons);
	oslDeleteImage(sdw);
	oslDeleteImage(planet);
	oslDeleteImage(starsky);
	oslDeleteImage(temp);
	oslDeleteImage(shoot);
	oslDeleteImage(explode);
	oslDeleteImage(sdw_sh);
	return health;
}

void sad()
{
	int f=0;
	OSL_IMAGE *gr = oslLoadImageFilePNG("./gfx/sad.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *ss = oslLoadSoundFile("./sfx/sfx-0027.wav", OSL_FMT_NONE);
	OSL_SOUND *dummy = oslLoadSoundFile("./sfx/dummy.wav", OSL_FMT_NONE);
	oslSetImageRotCenter(gr);
	oslSetSoundLoop(ss, 1);

	for (f=0; f<8; f++) oslPlaySound(dummy, f);
	oslPlaySound(ss, 2);

	f=0;

	while(f < 90)
	{
		oslStartDrawing();
		oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
		gr -> stretchX = gr -> stretchY = random(200)+64;
		spr_draw(gr, 240, 136);
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
		f++;
	}

	oslDeleteImage(gr);
	oslDeleteSound(ss);
	oslDeleteSound(dummy);
}

int game(int round, int diff, int nbp)
{
	int i, j, a=0, stun=0, u, global_fr=0, fs=0, quit=0, px=239, py=180, giyg_flag=0, mort=0, health, pbouss=0, benj_frame=0, skipframe=0, tvnoise_ev=0, att_ch_timer=80;
	int cursor2p=0, mgcd=0, ko_frame=0, mgsy=0, ultlvl=0, ultrectshine=4, frappe=-1, shldlvl=60, racket_devnull=0, stary=0, suppo=0, suppox, suppoy, whineface=0, kx=0, ky=0;

	short cheat=0, lightsoff=0, paused=0, bulbfell=0, bulbfs=0, shielded=0, darkness=0, chair=0, attf=0, putin=0, ulted=0, rckchscr=0, nbult=0, returned=0;

	int giyg_bg_angles[3] = {0, 0, 0};
	float court_zoom=1, reddv=0;
	char buffer[20];

	int pie_attacks[8][5]; //numeroattaque-duree(frames)-x-y?
	int att_cooldowns[15];
	int stars_ult[5];

	int meteors[3][3];

	struct pie_entity pie_ent;
	struct ball ball_ent;

	SceUID check;

	ball_ent=initball(ball_ent);
	pie_ent=initpie(pie_ent);

    pie_ent.pie_hp=100*round*diff;

	oslStartDrawing();
	oslDrawFillRect(0,0,480,272, RGB(0,0,0));
	oslSetTextColor(RGB(255, 255, 255));
	oslDrawString(20, 230, "PREPARING THE PHUCKPHEST");
	oslEndDrawing();
	oslSwapBuffers();

	OSL_IMAGE *pie, *tvnoise[5], *numberz = oslLoadImageFilePNG("./gfx/numberz.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *minigametime = oslLoadSoundFile("./sfx/sfx-0080.wav", OSL_FMT_NONE);
	OSL_SOUND *tvnoisesound;
	OSL_SOUND *giygas[3];
	OSL_SOUND *quitter = oslLoadSoundFile("./sfx/quitter.wav", OSL_FMT_NONE);
	OSL_SOUND *ko_sfx = oslLoadSoundFile("./sfx/sfx-0045.wav", OSL_FMT_NONE);
	OSL_SOUND *expl_sound = oslLoadSoundFile("./sfx/sfx-0018.wav", OSL_FMT_NONE);
	OSL_SOUND *pew = oslLoadSoundFile("./sfx/sfx-0100.wav", OSL_FMT_NONE);
	OSL_SOUND *paf = oslLoadSoundFile("./sfx/beng-0011.wav", OSL_FMT_NONE);
	OSL_SOUND *meteor_fall = oslLoadSoundFile("./sfx/sfx-0040.wav", OSL_FMT_NONE);
	OSL_SOUND *expl_sound2 = oslLoadSoundFile("./sfx/sfx-0036.wav", OSL_FMT_NONE);
	OSL_SOUND *bulbsfx[7];
	OSL_SOUND *stun_sound =  oslLoadSoundFile("./sfx/sfx-0038.wav", OSL_FMT_NONE);
	OSL_SOUND *elec =  oslLoadSoundFile("./sfx/elec.wav", OSL_FMT_NONE);
	OSL_SOUND *thunder =  oslLoadSoundFile("./sfx/thunder.wav", OSL_FMT_NONE);
	OSL_SOUND *psis_sfx = oslLoadSoundFile("./sfx/sfx-0043.wav", OSL_FMT_NONE);
	OSL_SOUND *dictators_sfx[4] = {
			oslLoadSoundFile("./sfx/putin.wav", OSL_FMT_NONE),
			oslLoadSoundFile("./sfx/kjun.wav", OSL_FMT_NONE),
			oslLoadSoundFile("./sfx/hitler.wav", OSL_FMT_NONE),
			oslLoadSoundFile("./sfx/skeletor.wav", OSL_FMT_NONE),
	};

	OSL_SOUND *mouth_sfx[2] = {
			oslLoadSoundFile("./sfx/sfx-0021.wav", OSL_FMT_NONE),
			oslLoadSoundFile("./sfx/sfx-0022.wav", OSL_FMT_NONE),
	};

	OSL_SOUND *whine = oslLoadSoundFile("./sfx/sfx-0097.wav", OSL_FMT_NONE);
	OSL_SOUND *bounce = oslLoadSoundFile("./sfx/racketbounce.wav", OSL_FMT_NONE);
	OSL_SOUND *seegaa = oslLoadSoundFile("./sfx/seegaa.wav", OSL_FMT_NONE);

	OSL_IMAGE *sega = oslLoadImageFilePNG("./gfx/sega.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *tryharder = oslLoadImageFilePNG("./gfx/tryharder.png",OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *lightning =  oslLoadImageFilePNG("./gfx/lightning.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *premess =  oslLoadImageFilePNG("./gfx/premess.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *giyg_bg, *starsky = oslLoadImageFilePNG("./gfx/starsky.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *sleepwell = oslLoadImageFilePNG("./gfx/sleepwell.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *ball_gfx = oslLoadImageFilePNG("./gfx/ball.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *ball_shad = oslLoadImageFilePNG("./gfx/ball_shadow.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *ko = oslLoadImageFilePNG("./gfx/ko.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *mgswirl = oslLoadImageFilePNG("./gfx/mgswirl.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *explode = oslLoadImageFilePNG("./gfx/explode.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *rckch[2];
    OSL_IMAGE *psycho = oslLoadImageFilePNG("./gfx/gfx-0672.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *paused_gfx = oslLoadImageFilePNG("./gfx/paused.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *ultgauge = oslLoadImageFilePNG("./gfx/ultgauge.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *shlgauge = oslLoadImageFilePNG("./gfx/shlgauge.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *visor = oslLoadImageFilePNG("./gfx/visor.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *bulbasaur = oslLoadImageFilePNG("./gfx/bulbasaur.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *recipe = oslLoadImageFilePNG("./gfx/darkness.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *shield = oslLoadImageFilePNG("./gfx/shield.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *meteor = oslLoadImageFilePNG("./gfx/gfx-0471.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *stunning = oslLoadImageFilePNG("./gfx/creepycircle.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *psis = oslLoadImageFilePNG("./gfx/psis.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *dictators = oslLoadImageFilePNG("./gfx/dictators.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *mouth = oslLoadImageFilePNG("./gfx/gfx-0102.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *powerball = oslLoadImageFilePNG("./gfx/powerball.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *star = oslLoadImageFilePNG("./gfx/star.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *juche = oslLoadImageFilePNG("./gfx/juche.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *suppo_gfx = oslLoadImageFilePNG("./gfx/suppo.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *attch = oslLoadImageFilePNG("./gfx/attchoice.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *cp2 = oslLoadImageFilePNG("./gfx/cursor2p.png",OSL_IN_RAM, OSL_PF_5551);

	OSL_SOUND *benj_sfx[11];




	benj_sfx[0] = oslLoadSoundFile("./sfx/beng-0000.wav", OSL_FMT_NONE);
	benj_sfx[1] = oslLoadSoundFile("./sfx/beng-0001.wav", OSL_FMT_NONE);
	benj_sfx[2] = oslLoadSoundFile("./sfx/beng-0002.wav", OSL_FMT_NONE);
	benj_sfx[3] = oslLoadSoundFile("./sfx/beng-0003.wav", OSL_FMT_NONE);
	benj_sfx[4] = oslLoadSoundFile("./sfx/beng-0004.wav", OSL_FMT_NONE); //hurt
	benj_sfx[5] = oslLoadSoundFile("./sfx/beng-0013.wav", OSL_FMT_NONE);
	benj_sfx[6] = oslLoadSoundFile("./sfx/beng-0016.wav", OSL_FMT_NONE);
	benj_sfx[7] = oslLoadSoundFile("./sfx/beng-0020.wav", OSL_FMT_NONE); //pass
	benj_sfx[8] = oslLoadSoundFile("./sfx/beng-0009.wav", OSL_FMT_NONE);
	benj_sfx[9] = oslLoadSoundFile("./sfx/beng-0015.wav", OSL_FMT_NONE); //ult
	benj_sfx[10] = oslLoadSoundFile("./sfx/beng-0006.wav", OSL_FMT_NONE); //shield

    rckch[0] = oslLoadImageFilePNG("./gfx/rocking_chair.png",OSL_IN_RAM, OSL_PF_5551);
    rckch[1] = oslLoadImageFilePNG("./gfx/rocking_chair2.png",OSL_IN_RAM, OSL_PF_5551);



	pie=oslLoadImageFilePNG("./gfx/pie.png",OSL_IN_RAM, OSL_PF_5551);
	oslSetImageRotCenter(pie);
	oslSetImageRotCenter(starsky);
	oslSetImageRotCenter(sleepwell);
	rckch[0] -> centerX = 32;
	rckch[0] -> centerY = 47;
	oslSetImageRotCenter(rckch[1]);
	oslSetImageRotCenter(recipe);
	oslSetImageRotCenter(paused_gfx);
	oslSetImageRotCenter(visor);
	oslSetImageRotCenter(mouth);
	oslSetImageRotCenter(stunning);
	oslSetImageRotCenter(powerball);
	oslSetImageRotCenter(star);
	oslSetImageRotCenter(tryharder);
	oslSetImageRotCenter(sega);

	ball_gfx -> centerX = 3;
	ball_gfx -> centerY = 7;


	oslSetImageTileSize(powerball, 0, 0, 32, 32);
	giyg_bg=oslLoadImageFilePNG("./gfx/dummy.png",OSL_IN_RAM, OSL_PF_5551);
	tvnoisesound = oslLoadSoundFile("./sfx/dummy.wav", OSL_FMT_NONE);

	mouth -> stretchX = 10;
	mouth -> stretchY = 16;


	for (i=0; i<8; i++)
	{
		for (j=0; j<5; j++)
		{
			pie_attacks[i][j]=0;
			stars_ult[j]=-32;
		}
	}



	for (i=0; i<7; i++)
	{
		sprintf(buffer,"./sfx/sfx-0%d.wav",i+114);
		bulbsfx[i]=oslLoadSoundFile(buffer,OSL_FMT_NONE);
	}

	for (i=0; i<15; i++)
	{
		att_cooldowns[i]=(random((8-(diff*2)))*100+random(3*diff)*100+800);
		att_cooldowns[i] += (((i==0) || (i==3) || (i==4))?9*att_cooldowns[i]:0) + 2*random((int)(((i!=0)?1.5:3.5)*att_cooldowns[i]));
		if ((i!=0) && (i!=3) && (i!=4)) att_cooldowns[i]=att_cooldowns[i]/(0.5*round+0.5);
	}

	oslSetSoundLoop(psis_sfx, 1);

	if (round == 2)
	{
		giygas[0] = oslLoadSoundFile("./sfx/sfx-0006.wav", OSL_FMT_NONE);
		giygas[1] = oslLoadSoundFile("./sfx/sfx-0007.wav", OSL_FMT_NONE);
		giygas[2] = oslLoadSoundFile("./sfx/sfx-0008.wav", OSL_FMT_NONE);

		for (i=0; i<5; i++)
		{
			sprintf(buffer,"./gfx/gfx-0%d.png",i+642+random(11));
			tvnoise[i]=oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
			tvnoise[i] -> stretchX = 480;
			tvnoise[i] -> stretchY = 272;
		}

		oslDeleteSound(tvnoisesound);
		oslDeleteImage(giyg_bg);

		tvnoisesound = oslLoadSoundFile("./sfx/sfx-0028.wav", OSL_FMT_NONE);
		tvnoisesound -> volumeLeft = tvnoisesound -> volumeRight = 0x2000;
		oslSetSoundLoop(tvnoisesound, 1);


		giyg_bg=oslLoadImageFilePNG("./gfx/gfx-0103.png",OSL_IN_RAM, OSL_PF_5551);
		oslSetImageRotCenter(giyg_bg);
		giyg_bg -> stretchX = giyg_bg -> stretchY = 512;
	}
	else
	{
		giygas[0] = oslLoadSoundFile("./sfx/sfx-0155.wav", OSL_FMT_NONE);
		giygas[1] = oslLoadSoundFile("./sfx/sfx-0153.wav", OSL_FMT_NONE);
		giygas[2] = oslLoadSoundFile("./sfx/dummy.wav", OSL_FMT_NONE);

		for (i=0; i<5; i++)
		{
			tvnoise[i]=oslLoadImageFilePNG("./gfx/dummy.png",OSL_IN_RAM, OSL_PF_5551);
		}
	}




    oslSetTransparentColor(RGB(255,0,255));


	for (i=0; i<3; i++)
	{
		oslSetSoundLoop(giygas[i], 1);
	}

    oslPlaySound(giygas[0], 0);
    health=100;
    oslSetFrameskip(0);
    oslSetMaxFrameskip(3);

    while(!quit)
    {
    	if (!skipframe)
			{

			oslStartDrawing();


			oslSetAlpha(OSL_FX_DEFAULT, 0);
			oslDrawFillRect(0,0,480,272, RGB(0,0,0));

			if (pie_ent.pie_hp < 1)
			{
				pie_ent.pie_y = 136+5*sin(0.5*global_fr);
			}

			spr_draw(starsky,239,136);

			if ((whineface) && (health > 0) && (pie_ent.pie_hp > 0))
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				spr_draw(pie,pie_ent.pie_x, pie_ent.pie_y);
				oslSetImageTileSize(dictators, 160, 80, 80, 80);
				oslSetImageRotCenter(dictators);
				spr_draw(dictators, pie_ent.pie_x, pie_ent.pie_y-22);
				oslSetAlpha(OSL_FX_TINT, RGBA(255,0,0,whineface*8));
				whineface--;
			}
			else
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}


			spr_draw(pie,pie_ent.pie_x, pie_ent.pie_y);


			oslSetAlpha(OSL_FX_DEFAULT, 0);

			for (i=0; i<((2*diff)+2); i++)
			{
				if ((pie_attacks[i][0]==12) && (health > 0))
				{
					oslSetImageTileSize(dictators, 80*(pie_ent.pie_facemode%2), 80*(pie_ent.pie_facemode/2),80 ,80);
					oslSetImageRotCenter(dictators);

					if (pie_attacks[i][1] > (240*diff-255))
					{
						oslSetAlpha(OSL_FX_ALPHA, (240*diff - pie_attacks[i][1]));
					}
					else
					{
						oslSetAlpha(OSL_FX_DEFAULT, 0);
					}

					if (pie_attacks[i][1] < 0)
					{
						oslSetAlpha(OSL_FX_ALPHA, 255+pie_attacks[i][1]);
					}

					if (!whineface) spr_draw(dictators, pie_ent.pie_x, pie_ent.pie_y-22);

					pie_attacks[i][1]--;

					if (pie_attacks[i][1] == -255)
					{
						pie_attacks[i][0]=0;
						pie_ent.pie_facemode=0;
						putin=0;
					}

					oslSetAlpha(OSL_FX_DEFAULT, 0);

					if ((pie_ent.pie_facemode == 2) && (pie_attacks[i][1]==90))
					{
						for (i=0; i<15; i++)
						{
							if ((i!=0) && (i!=3) && (i!=4) && (i != 11) && (i!=6)) att_cooldowns[i]=random(250);
						}
					}

					if (pie_ent.pie_facemode == 0)
					{
						if (pie_attacks[i][1] > -255) putin=1; else putin=0;
					}
					if (pie_ent.pie_facemode == 1)
					{
						spr_draw(juche, pie_attacks[i][2], 40+30*sin(0.0625*pie_attacks[i][2]));
						pie_attacks[i][2] -= 3;
					}
				}
			}

			if (health <= 0)
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				oslSetImageTileSize(dictators, 160, 0, 80, 80);
				oslSetImageRotCenter(dictators);
				spr_draw(dictators, pie_ent.pie_x, pie_ent.pie_y-22);
			}
			else if (pie_ent.pie_hp < 1)
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				oslSetImageTileSize(dictators, 160, 80, 80, 80);
				oslSetImageRotCenter(dictators);
				spr_draw(dictators, pie_ent.pie_x, pie_ent.pie_y-22);
			}

			spr_draw(court,0,0);


			if (!paused)
			{
				if (pie_ent.pie_hp > 0)
				{
					if (!(pie_ent.pie_direction))
					{
							pie_ent.pie_x++;
							pie->angle+=((round==2)?(giyg_flag+1):1)*4;

						if (pie_ent.pie_x>=351) pie_ent.pie_direction=1;

					}
					else
					{
							pie_ent.pie_x--;
							pie->angle-=((round==2)?(giyg_flag+1):1)*4;


						if (pie_ent.pie_x<=128) pie_ent.pie_direction=0;
					}
				}


				if (round==2) starsky->angle=starsky->angle-(giyg_flag+1)*((random(10))-1);

				if (counter >= 240)
				{

					if (diff != 3) a=diff; else a=2;

					if (counter == 240) ball_ent=apply_impulse(ball_ent, -1*a, -1*a, 30*3.14/180);

					if (ultlvl > 239) ultlvl=239;

					if ((!mgcd) && (!lightsoff) && (!rckchscr) && (mouth -> stretchX == 10))
					{
						ball_ent.x2d += ball_ent.speed_h;
						ball_ent.y2d += ball_ent.speed_v;

						/*ball_ent.speed_z += GRAVITY;
						ball_ent.z3d += ball_ent.speed_z;

						if (ball_ent.z3d < 0)
						{
							ball_ent.speed_z = -1*(ball_ent.speed_z);
							ball_ent.z3d=0;
						}*/

						ball_ent.z3d = abs(16*sin(0.0625*global_fr));
					}

					if (ball_ent.y2d < 138)
						{
								ball_ent.speed_v = -1*(ball_ent.speed_v);
								ball_ent.y2d = 140;

								returned=0;

								if ((ball_ent.x2d >= pie_ent.pie_x-128) && (ball_ent.x2d <= pie_ent.pie_x+128))
								{
									pie_ent.pie_hp -= (4-diff);
									ultlvl += 5-diff;
									oslPlaySound(whine, 3);
									whineface=31;
								}
								else
								{
									if ((!suppo) && ((health) || (pie_ent.pie_hp)))
									{
										suppo = 150;
										suppox = px - 32;
										suppoy = py + 48;
									}
								}


								if (ball_ent.speed_v > 0)
								{
									a=random(100);
									//if (a > 85) ball_ent.poisoned=1; else ball_ent.poisoned=0;
								}

						}

					if (ball_ent.y2d > 288)
						{
								ball_ent.speed_v = -1*(ball_ent.speed_v);
								ball_ent.y2d = 286;

								ball_ent.poisoned=0;

								if (!shielded)
								{
									stun=616;
									health -= diff+1;
									oslPlaySound(thunder, 3);
								}


								returned=1;
						}

					if ((ball_ent.x2d >= 480 - 16/2) || (ball_ent.x2d < 4))
					{
						ball_ent.speed_h = -1*(ball_ent.speed_h);
						if (ball_ent.x2d < 4) ball_ent.x2d = 6; else ball_ent.x2d = 478 - 16/2;
					}


				}

			}




			oslSetAlpha(OSL_FX_DEFAULT, 0);
			oslReadKeys();

			if (((osl_keys->pressed.L) || (osl_keys->pressed.R)) && (nbp==2))
			{
				att_ch_timer=0;
				if ((osl_keys->pressed.L) && (cursor2p > 0)) cursor2p--;
				if ((osl_keys->pressed.R) && (cursor2p < 13)) cursor2p++;
			}

			if ((osl_keys->pressed.start) && (pie_ent.pie_hp) && (health) && (!mgcd) && (counter > 256))
				{
					if (!paused)
					{
						paused=1;
						if (oslGetSoundChannel(quitter) == 5)
						{
							health -= 5;
							if (putin) health -=2;
							oslStopSound(quitter);
						}
						if (oslGetSoundChannel(tvnoisesound) == 5) oslStopSound(tvnoisesound);
						if (oslGetSoundChannel(psis_sfx) > -1) oslStopSound(psis_sfx);
					}
					else paused=0;

					if (!lightsoff) oslPauseSound(giygas[giyg_flag%3], -1);
				}


			if ((osl_keys->held.L) && (paused))
			{
				if ((osl_keys->held.R) && (osl_keys->held.L))
					{
						if ((osl_keys->held.cross) && (osl_keys->held.R) && (osl_keys->held.L))
							{
								paused=0;
								health=0;
								mort=2;
							}

						if ((osl_keys->held.triangle) && (osl_keys->held.R) && (osl_keys->held.L))
							{
								paused=0;
								pie_ent.pie_hp=0;
								pie_ent.pie_facemode=0;
								cheat=1;
							}
					}
			}


			counter++;
			global_fr++;
			if (nbp==2) att_ch_timer++; else att_ch_timer=4;

			if ((att_ch_timer >= 81) && (att_cooldowns[cursor2p] == 1) && (nbp==2))
			{
				att_cooldowns[cursor2p]=0;
			}


			benj->stretchX = 32;
			benj->stretchY = 48;
			benj->angle = 0;

			if (stun > 600)
			{
				oslSetAlpha(OSL_FX_ALPHA, (stun%600)*16);
				oslSetImageTileSize(lightning,0,0,32,py+64);
				spr_draw(lightning, px, 0);
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}


			if (health > 0)
			{
				oslSetAlpha(OSL_FX_ALPHA, 128);
				oslSetImageTileSize(benj,32,192,32,48);
				spr_draw(benj, px+8, py+26);
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}

			oslSetImageTileSize(benj,0,192,32,48);

			if ((osl_keys->pressed.triangle) && (pie_ent.pie_hp > 0) && (health>0) && (!mgcd) && (!paused) && (frappe<7) && (!stun) && (counter > 300) && (stary <= 0))
			{
				oslPlaySound(benj_sfx[(random(2)+8)], 3);
				racket_devnull++;

				stary=py+48;

				if ((ultlvl > 59) && (ultlvl < 120))
				{
					stars_ult[0]=px+32;
					nbult=1;
				}

				else if ((ultlvl > 119) && (ultlvl < 239))
				{
						stars_ult[0]=px-48;
						stars_ult[1]=px+32;
						stars_ult[2]=px+112;
						nbult=3;
				}

				else if (ultlvl==239)
				{
					stars_ult[0]=px-48;
					stars_ult[1]=px-8;
					stars_ult[2]=px+32;
					stars_ult[3]=px+72;
					stars_ult[4]=px+112;
					nbult=5;
				}


			if (ultlvl > 59) ultlvl -= ((diff==1)?60:((diff==2)?(ultlvl%60+60):ultlvl));

			}

			if ((osl_keys -> pressed.cross) && (health>0) && (!mgcd) && (!paused) && (shldlvl > 2) && (!stun))
			{
				if (!(racket_devnull%2)) oslPlaySound(benj_sfx[10], 3);
				racket_devnull++;
			}

			if (((osl_keys -> pressed.square) || (osl_keys -> pressed.circle)) && (health>0) && (!mgcd) && (!paused) && (frappe<7) && (!stun))
			{
				if (!(racket_devnull%2)) oslPlaySound(benj_sfx[random(3)+5], 3);
				racket_devnull++;
				frappe=1;
			}

			if (((osl_pad.analogY < -32) || (osl_keys->held.up)) && (py >= 102) && (health>0) && (!mgcd) && (!paused) && (frappe == -1) && (!stun) && (mouth->stretchX == 10))
			{
				if (pie_ent.pie_facemode != 1)
				{
					pbouss=0;
					oslSetImageTileSize(benj,(benj_frame%8)*32,0,32,48);
					if (osl_pad.analogY > -108)
						{
							if (pie_ent.pie_facemode == 3) py-=2; else py--;
							fs=6;
						}
					else
						{
							if (pie_ent.pie_facemode != 3) py-=4; else py-=2;
							fs=3;
						}
				}
				else
				{
					pbouss=2;
					oslSetImageTileSize(benj,(benj_frame%8)*32,96,32,48);
					if (osl_pad.analogY > -108)
					{
						if (pie_ent.pie_facemode != 3) py+=2; else py++;
						fs=6;
					}
					else
					{
						if (pie_ent.pie_facemode != 3) py+=4; else py+=2;
						fs=3;
					}
					if (py > 224) py=216;
				}

				oslSetImageTileSize(powerball, 32, 0, 32, 32);
				if (!(counter%fs)) benj_frame++;
			}
			if (((osl_pad.analogX < -32) || (osl_keys->held.left)) && (px >= (-0.492*py+94.184)) && (px <= (0.492*py+321.792)) && (health>0) && (!mgcd) && (!paused) && (frappe < 4) && (!stun) && (mouth->stretchX == 10))
			{
				if (pie_ent.pie_facemode != 1)
				{
					pbouss=3;
					oslSetImageTileSize(benj,(benj_frame%8)*32,pbouss*48,32,48);
					if (osl_pad.analogX > -108)
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px-=2; else px--;
						}
						fs=6;
					}
					else
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px-=4; else px-=2;
						}
						fs=3;
					}
				}
				else
				{
					pbouss=1;
					oslSetImageTileSize(benj,(benj_frame%8)*32,48,32,48);
					if (osl_pad.analogX > -108)
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px+=2; else px++;
						}
							fs=6;
					}
					else
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px+=4; else px+=2;
						}
							fs=3;
					}
					if (px > (0.492*py+321.792)) px = (0.492*py+321.792);
				}

					oslSetImageTileSize(powerball, 32, 0, 32, 32);
					if (!(counter%fs)) benj_frame++;
			}
			if (((osl_pad.analogX > 32) || (osl_keys->held.right)) && (px >= (-0.492*py+94.184)) && (px <= (0.492*py+321.792)) && (health>0) && (!mgcd) && (!paused) && (frappe < 4) && (!stun) && (mouth->stretchX == 10))
			{
				if (pie_ent.pie_facemode != 1)
				{
					pbouss=1;
					oslSetImageTileSize(benj,(benj_frame%8)*32,48,32,48);
					if (osl_pad.analogX < 108)
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px+=2; else px++;
						}
							fs=6;
					}
					else
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px+=4; else px+=2;
						}
							fs=3;
					}
				}
				else
				{
					pbouss=3;
					oslSetImageTileSize(benj,(benj_frame%8)*32,pbouss*48,32,48);
					if (osl_pad.analogX < 108)
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px-=2; else px--;
						}
						fs=6;
					}
					else
					{
						if (frappe < 4)
						{
							if (pie_ent.pie_facemode != 3) px-=4; else px-=2;
						}
						fs=3;
					}

					if (px < (-0.492*py+94.184)) px = (-0.492*py+94.184);
				}
					oslSetImageTileSize(powerball, 0, 0, 32, 32);
					if (!(counter%fs)) benj_frame++;
			}
			if (((osl_pad.analogY > 32) || (osl_keys->held.down)) && (py <= 224) && (health>0) && (!mgcd) && (!paused) && (frappe == -1) && (!stun) && (mouth->stretchX == 10))
			{
				if (pie_ent.pie_facemode != 1)
				{
					pbouss=2;
					oslSetImageTileSize(benj,(benj_frame%8)*32,96,32,48);
					if (osl_pad.analogY < 108)
					{
						if (pie_ent.pie_facemode != 3) py+=2; else py++;
						fs=6;
					}
					else
					{
						if (pie_ent.pie_facemode != 3) py+=4; else py+=2;
						fs=3;
					}
				}
				else
				{
					pbouss=0;
					oslSetImageTileSize(benj,(benj_frame%8)*32,0,32,48);
					if (osl_pad.analogY < 108)
						{
							if (pie_ent.pie_facemode == 3) py-=2; else py--;
							fs=6;
						}
					else
						{
							if (pie_ent.pie_facemode != 3) py-=4; else py-=2;
							fs=3;
						}
					if (py < 102) py=110;
				}

					oslSetImageTileSize(powerball, 0, 0, 32, 32);
					if (!(counter%fs)) benj_frame++;
			}

			if ((osl_keys->held.square) && (health>0) && (!mgcd) && (!paused) && (frappe<7) && (!stun))
			{

				if ((!(counter%3))) frappe++;
				oslSetImageTileSize(benj,(frappe)*32,240,32,48);


				if ((osl_pad.analogX > 108) && (frappe > -1))
					{
						if (frappe>3) benj -> angle = 90;
						oslSetImageTileSize(benj,(frappe)*32,432,32,48);

					}
				else if ((osl_pad.analogX < -108) && (frappe > -1))
					{
						if (frappe>3) benj -> angle = -90;
						oslSetImageTileSize(benj,(frappe)*32,384,32,48);
					}

				if (((px+32-(ball_ent.x2d))*(px+32-(ball_ent.x2d))+(py+48-(ball_ent.y2d))*(py+48-(ball_ent.y2d)) <= 256) && (!returned) && (py >= 142))
				{
					if (diff != 3) a=diff; else a=2;
					ball_ent = apply_impulse(ball_ent, a, a, (180-15*frappe)*3.14/180);
					if (oslGetSoundChannel(bounce) != 2) oslPlaySound(bounce, 2);
					frappe=-1;
					returned=1;
				}
			}


			if ((osl_keys->held.circle) && (health>0) && (!mgcd) && (!paused) && (frappe<7) && (!stun))
			{

				if ((!(counter%3))) frappe++;
				oslSetImageTileSize(benj,(frappe)*32,288,32,48);


				if ((osl_pad.analogX > 108) && (frappe > -1))
					{
						if (frappe>3) benj -> angle = 90;
						oslSetImageTileSize(benj,(frappe)*32,432,32,48);
					}
				else if ((osl_pad.analogX < -108) && (frappe > -1))
					{
						if (frappe>3) benj -> angle = -90;
						oslSetImageTileSize(benj,(frappe)*32,384,32,48);
					}

				if (((px+32-(ball_ent.x2d))*(px+32-(ball_ent.x2d))+(py+48-(ball_ent.y2d))*(py+48-(ball_ent.y2d)) <= 256) && (!returned) && (py >= 142))
				{
					if (diff != 3) a=diff; else a=2;
					ball_ent = apply_impulse(ball_ent, -1*a, a, (15*frappe)*3.14/180);
					if (oslGetSoundChannel(bounce) != 2) oslPlaySound(bounce, 2);
					frappe=-1;
					returned=1;
				}
			}

			if ((osl_keys->held.triangle) && (health>0) && (!mgcd) && (!paused) && (frappe<7) && (!stun) && (counter > 300))
			{

				if ((!(counter%3))) frappe++;
				oslSetImageTileSize(benj,(frappe)*32,336,32,48);



			}

			if ((osl_keys->held.cross) && (health>0) && (!mgcd) && (!paused) && (shldlvl > 0) && (!stun))
			{
				if ((!(counter%(4-diff)))) shldlvl--;
				shielded=1;
			}


			if ((osl_keys->released.circle)  ||  (osl_keys->released.triangle) ||  (osl_keys->released.square))
			{
				frappe=-1;
			}

			if ((osl_keys->released.cross) || (!shldlvl))
			{
				shielded=0;
			}

			if (stun)
			{
				frappe=-1;
				oslSetImageTileSize(benj,64,192,32,48);
				stun--;
				if (!(stun%200)) stun=0;
			}

			if (px < (-0.492*py+94.184)) px = (-0.492*py+94.184);
			if (px > (0.492*py+321.792)) px = (0.492*py+321.792);

			if (((osl_pad.analogX==0) && (osl_pad.analogY==0)) || ((osl_keys->released.down) || (osl_keys->released.up) || (osl_keys->released.left) || (osl_keys->released.right)))
			{
				benj_frame=0;
			}


			if (frappe >= 7) frappe=7;

			court_zoom = 0.00192*py + 0.562;

			benj->stretchX = (int)(64*(float)court_zoom);
			benj->stretchY = (int)(96*(float)court_zoom);

			shield->stretchX = (int)(48*(float)court_zoom);
			shield->stretchY = (int)(48*(float)court_zoom);



			ball_gfx -> stretchX = (int)(8*(float)court_zoom);
			ball_gfx -> stretchY = ball_gfx -> stretchX;

			powerball -> stretchX = powerball -> stretchY = (int)(32*(float)(court_zoom));


			if (health > 0)
			{
				if (stary > 0)
				{



					for(u=0; u<nbult; u++)
					{
						spr_draw(star, stars_ult[u], stary);

						if (stary <= 136)
						{
							if ((stars_ult[u] >= (pie_ent.pie_x-128)) && (stars_ult[u] <= (pie_ent.pie_x+128))) pie_ent.pie_hp -= 10;
							stary=-64;
							stars_ult[u]=-32;
							nbult=0;
						}

					}
					star -> angle -= 5;
					stary -= 4;

				}

				if (ball_ent.poisoned) oslSetAlpha(OSL_FX_TINT, RGB(0, 0, 255));
				if (pie_ent.pie_hp > 0) draw_ball(ball_ent, ball_gfx, ball_shad);
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				draw_benj(benj, px, py, shielded, shield);
				if (((pbouss == 3) || (pbouss == 0)) && (pie_ent.pie_facemode == 3)) spr_draw(powerball, px+64, py+48);
				if (((pbouss == 1) || (pbouss == 2)) && (pie_ent.pie_facemode == 3)) spr_draw(powerball, px, py+48);
				if (ball_ent.poisoned) oslSetAlpha(OSL_FX_TINT, RGB(0, 0, 255));
				oslSetAlpha(OSL_FX_DEFAULT, 0);


			}



			if (suppo)
			{
				if (!paused) suppo--;
				if (suppo<40)
				{
					oslSetImageTileSize(suppo_gfx, suppo/10*32, 0, 32, 32);
				}

				if (suppo>110)
				{
					oslSetImageTileSize(suppo_gfx, (150-suppo)/10*32, 0, 32, 32);
				}

				court_zoom = 0.00192*suppoy + 0.562;
				suppo_gfx->stretchX = (int)(32*(float)court_zoom);
				suppo_gfx->stretchY = (int)(32*(float)court_zoom);

				spr_draw(suppo_gfx, suppox, suppoy);
				spr_draw(suppo_gfx, suppox+64, suppoy);

				if ((suppo>65) && (suppo<85))
				{
					if ((px>=suppox) && (px<=suppox+64) && (py>=suppoy-64) && (py <= suppoy))
					{
						oslSetAlpha(OSL_FX_TINT, RGBA(0, 128, 128, 255));
						if ((suppo%4) < 2)
						{
							draw_benj(benj, px, py, shielded, shield);
						}

						if ((suppo == 67) && (!mgcd) && (!rckchscr))
						{
							health -= diff;
							oslPlaySound(elec, 3);
						}
						oslSetAlpha(OSL_FX_DEFAULT, 0);
					}
				}
			}

			if ((pie_ent.pie_hp > 25*round*diff) && (!giyg_flag) && (pie_ent.pie_hp <= 50*round*diff))
			{
				giyg_flag=1;
				oslStopSound(giygas[0]);
				oslPlaySound(giygas[1], 0);
			}



			if (round==2)
			{
				oslSetAlpha(OSL_FX_ALPHA, random(64));
				spr_draw(giyg_bg, 240, 138);

				giyg_bg_angles[0] = random(10)-5;

				giyg_bg -> angle += giyg_bg_angles[0];

				if (pie_ent.pie_hp <= 50*round*diff)
				{
					giyg_bg_angles[1] = 2*(random(10)-5);
					giyg_bg -> angle += giyg_bg_angles[1];
					oslSetAlpha(OSL_FX_ALPHA, random(64)+64);
					spr_draw(giyg_bg, 240, 138);

				}

				if (pie_ent.pie_hp <= 25*round*diff)
				{
					giyg_bg_angles[2] = 4*(random(10)-5);
					giyg_bg -> angle += giyg_bg_angles[2];
					oslSetAlpha(OSL_FX_ALPHA, random(64)+128);
					spr_draw(giyg_bg, 240, 138);

					if ((giyg_flag < 2))
					{
						giyg_flag=2;
						oslStopSound(giygas[1]);
						oslPlaySound(giygas[2], 0);
					}

				}

				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}

			if ((counter >= 640))
			{

				//initializing attacks
				for (i=0; i<14; i++)
				{
					if ((nbp==1) && (!paused)) att_cooldowns[i]--;
					if ((nbp==2) && (!paused) && (att_cooldowns[i]>1)) att_cooldowns[i]--;

					if ((i==7) && (bulbfell > 0)) att_cooldowns[7]++;

					if ((att_cooldowns[i] <= 0) && (pie_ent.pie_hp > 0))
					{

						attf=0;
						for (j=0; j<((2*diff)+2); j++)
						{
							if (pie_attacks[j][0] == (i+1)) attf=1;
						}

							for (j=0; j<((2*diff)+2); j++)
							{
								if ((!(pie_attacks[j][0])) && (!attf))
								{
									pie_attacks[j][0]=i+1;

									switch(i+1)
									{
										case 1:
											pie_attacks[j][1]=140;
										break;

										case 2:
											pie_attacks[j][1]=(py-(pie_ent.pie_y))/(px-pie_ent.pie_x);
											pie_attacks[j][2]=(pie_ent.pie_y)-pie_attacks[j][1]*pie_ent.pie_x;
											pie_attacks[j][3]=pie_ent.pie_x;
											pie_attacks[j][4]=px;
											mgsy=pie_attacks[i][1]*pie_attacks[i][3]+pie_attacks[i][2];
										break;

										case 3:
											darkness=0;
											for (u=0; u<((2*diff)+2); u++)
											{
												if (pie_attacks[u][0]==7) darkness=1;
											}

											if (!darkness)
											{
												pie_attacks[j][1]=360-(15*diff);
												pie_attacks[j][2]=random(160)+80;
												pie_attacks[j][3]=random(112)+160;
												pie_attacks[j][4]=2*diff+3;
											}
											else pie_attacks[j][0]=0;
										break;

										case 4:
											pie_attacks[j][1]=diff*166;
											pie_attacks[j][2]=random(2);
											lightsoff=1;
										break;

										case 5:
											pie_attacks[j][1]=-218;
											pie_attacks[j][2]=255;
										break;

										case 6:
											pie_attacks[j][1]=225*diff;
											pie_attacks[j][2]=random(416);
											pie_attacks[j][3]=random(100)+108;

											if ((diff > 1) && (pie_attacks[j][2]%diff))
											{
												pie_attacks[j][2] += (diff)-(pie_attacks[j][2]%diff);
											}

											if ((diff > 1) && (pie_attacks[j][3]%diff))
											{
												pie_attacks[j][3] += (diff)-(pie_attacks[j][3]%diff);
											}
										break;

										case 7:
											chair=0;
											for (u=0; u<((2*diff)+2); u++)
											{
												if (pie_attacks[u][0]==3) chair=1;
											}

											if (!chair)
											{

											if (px+16 < 240) pie_attacks[j][1]=0; else pie_attacks[j][1]=1;
											pie_attacks[j][2]=random(400)+600;
											if (pie_attacks[j][1]) pie_attacks[j][3]=400-random(160); else  pie_attacks[j][3]=random(160)+80;
											if (pie_attacks[j][1]) pie_attacks[j][4]=480; else  pie_attacks[j][4]=0;

											mouth -> stretchX = 10;
											mouth -> stretchY = 16;
											}
											else  pie_attacks[j][0]=0;

										break;

										case 8:
											pie_attacks[j][1]=diff+2;
											pie_attacks[j][2]=random(4); //sens bulbasaur
											pie_attacks[j][3]=random(320)+80; //bulb_x
											pie_attacks[j][4]=-64; //bulb_y
											bulbfell=1;
											if (!lightsoff) oslPlaySound(bulbsfx[(random(2)?1:6)], 6);
										break;

										case 9:
											pie_attacks[j][1]=120*diff+120;
											if (px < 240) pie_attacks[j][2]=1; else pie_attacks[j][2]=0;
											pie_attacks[j][3]=py;

											for (u=0; u<3; u++)
											{
												meteors[u][0]=0;
												meteors[u][1]=0;
												meteors[u][2]=0;
											}
										break;

										case 10:
											pie_attacks[j][1]=96;
											if ((!shielded) && (!stun)) stun=96;
											break;

										case 11:
											pie_attacks[j][1]=1;
											pie_attacks[j][2]=30;
											if (!lightsoff) oslPlaySound(psis_sfx, 4);
											break;

										case 12:
											pie_attacks[j][1]=240*diff;
											pie_ent.pie_facemode=random(4);
											if ((!lightsoff) && (health > 0)) oslPlaySound(dictators_sfx[pie_ent.pie_facemode], 7);
											if (pie_ent.pie_facemode==1)
											{
												pie_attacks[j][2]=560;
											}
											break;

										case 13:
											if ((round==2) && (pie_ent.pie_hp < 20*round*diff) && (!ulted) && (!lightsoff))
											{
												oslStopSound(giygas[giyg_flag]);
												oslStopSound(psis_sfx);
												oslEndDrawing();
												health=shoop_da_whoop(health, round, diff);
												oslStartDrawing();
												ulted=1;
												oslPlaySound(giygas[giyg_flag], 0);
												oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
											}
											pie_attacks[j][0]=0;
											break;

										case 14:
											if ((round==2) && (pie_ent.pie_hp < 10*round*diff) && (ulted==1) && (!lightsoff))
											{
												oslStopSound(giygas[giyg_flag]);
												oslStopSound(psis_sfx);
												oslEndDrawing();
												sad();
												oslStartDrawing();
												ulted=2;
												oslPlaySound(giygas[giyg_flag], 0);
												oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
											}
											pie_attacks[j][0]=0;
											break;


										default:
											break;
									}

									j=2*diff+3; //break;
								}
							}


							//att_cooldowns[i]=(random((8-(diff*2)))*100+random(3*diff)*100+800)*(2*i+11);
								att_cooldowns[i]=(random((8-(diff*2)))*100+random(3*diff)*100+800);
								att_cooldowns[i] += (((i==0) || (i==3) || (i==4))?9*att_cooldowns[i]:0) + 2*random((int)(((i!=0)?1.5:3.5)*att_cooldowns[i]));
								if ((i!=0) && (i!=3) && (i!=4)) att_cooldowns[i]=att_cooldowns[i]/(0.5*round+0.5);
								if (i == 11) att_cooldowns[i] += 1792;

					}
				}


				//programming attacks


				if (!paused) {

					for (i=0; i<((2*diff)+2); i++)
					{
						switch(pie_attacks[i][0])
						{
							case 1:
							{
								if ((mgcd < 1) && (health > 0) && (!lightsoff))
								{
									oslSetAlpha(OSL_FX_TINT, RGBA(0, 128, 128, 255));
									if (pie_attacks[i][1] > 115)
									{
										oslSetImageTileSize(ko,0,0,120,96);
										spr_draw(ko, (int)(9.6*(140-pie_attacks[i][1])-120), 88);
									}

									if ((pie_attacks[i][1] <= 115) && (pie_attacks[i][1] >= 90))
									{
										oslSetImageTileSize(ko,0,0,120,96);
										spr_draw(ko, 120, 88);
										oslSetImageTileSize(ko,120,0,120,96);
										spr_draw(ko, (int)(-9.6*(140-pie_attacks[i][1])+720), 88);
									}

									if ((pie_attacks[i][1] > 0) && (pie_attacks[i][1] < 90))
									{
										oslSetImageTileSize(ko,0,0,240,96);
										spr_draw(ko, 120, 88);
									}

									if ((pie_attacks[i][1] <= 0))
									{
										pie_attacks[i][0]=0;
									}

									if (pie_attacks[i][1] > 80)
									{
										if ((pie_attacks[i][1]%6) < 3)
										{
											explode -> stretchX = 64;
											explode -> stretchY = 96;
											spr_draw(explode, px, py);
										}
										else
										{
											explode -> stretchX = 32;
											explode -> stretchY = 48;
											spr_draw(explode, px+16, py+24);
										}
									}

									pie_attacks[i][1]--;
									oslSetAlpha(OSL_FX_DEFAULT, 0);
								}
								break;
							}

							case 2:
							{
								//frame_debug(j);

								if ((!mgcd) && (!lightsoff))
								{
									oslSetAlpha(OSL_FX_ALPHA,128);

									if (pie_attacks[i][4] < pie_attacks[i][3])
										{
											pie_attacks[i][4]-=3;
											pie_attacks[i][3]-=3;
										}
									else
										{
											pie_attacks[i][4]+=3;
											pie_attacks[i][3]+=3;
										}

									if (mgsy < py)	mgsy += random(8)+2;	else mgsy -= random(8)+2;

									court_zoom = 0.00192*(mgsy) + 0.562;

									mgswirl->stretchX = (int)(128*(float)court_zoom);
									mgswirl->stretchY = (int)(128*(float)court_zoom);

									spr_draw(mgswirl, pie_attacks[i][3], mgsy);

									oslSetAlpha(OSL_FX_DEFAULT, 0);
								}

								if ((swirl_collide(px, py, pie_attacks[i][3], mgsy)) && (health>0))
								{

										if (!mgcd)
										{

											if (oslGetSoundChannel(minigametime) != 7)
											{
												oslStopSound(giygas[giyg_flag%3]);
												oslPlaySound(minigametime, 7);
												if (oslGetSoundChannel(tvnoisesound) == 5) oslStopSound(tvnoisesound);
												if (oslGetSoundChannel(meteor_fall) == 6) oslStopSound(meteor_fall);
												oslStopSound(psis_sfx);
												sleepwell -> stretchX = sleepwell -> stretchY = 272;
											}

										}

										mgcd++;

										if (mgcd >= 1)
										{

												oslStopSound(psis_sfx);
												oslSetAlpha(OSL_FX_DEFAULT, 0);
												if (mgcd < 9) oslDrawFillRect(0,0,480,272, RGB(255,255,255)); else
												{
													oslDrawFillRect(0,0,480,272, RGB(0,0,0));
													oslSetAlpha(OSL_FX_ALPHA, 255-(int)(mgcd*2.55));
													sleepwell -> stretchX+=18;
													sleepwell -> stretchY+=36;
													spr_draw(sleepwell,240,138);
													oslSetAlpha(OSL_FX_DEFAULT, 0);
												}


										}

								}

								if ((pie_attacks[i][3] <= -128) || (pie_attacks[i][3] >= 544))
								{
									pie_attacks[i][0]=0;
									mgcd=0;
								}


								break;
							}

							case 3:
							{
								if ((mgcd < 1) && (health > 0) && (!lightsoff))
										{

										if (pie_attacks[i][4] > 0)
										{
												pie_attacks[i][1]--;

												if (pie_attacks[i][1] > 90)
												{

													if (pie_attacks[i][1] < 180) rckch[0] -> angle = (int)(6*sin(0.5*counter));
													else rckch[0] -> angle = 0;

													court_zoom = 0.00192*(pie_attacks[i][3]+15) + 0.562;
													rckch[0]->stretchX = (int)(64*(float)court_zoom);
													rckch[0]->stretchY = (int)(64*(float)court_zoom);

													spr_draw(rckch[0], pie_attacks[i][2], pie_attacks[i][3]+15);

													if ((((px-pie_attacks[i][2])*(px-pie_attacks[i][2])+(py-pie_attacks[i][3])*(py-pie_attacks[i][3])) <= 3000) & (frappe >= 1))
													{
														oslSetAlpha(OSL_FX_TINT, RGBA(255,255,0,255));
														spr_draw(rckch[0], pie_attacks[i][2], pie_attacks[i][3]+15);
														oslSetAlpha(OSL_FX_DEFAULT, 0);
														if (frappe == 1)
														{
															if ((osl_keys -> held.square) || (osl_keys -> held.circle)) pie_attacks[i][4]--;
															if (osl_keys -> held.triangle) pie_attacks[i][4]=0;
															oslPlaySound(paf, 7);
															ultlvl += 5-diff;
														}
													}

													if (pie_attacks[i][4] <= 0) pie_attacks[i][1]=20;
												}
												else
												{
													if (pie_attacks[i][1] > 59)
													{
														rckch[1] -> stretchX = (90-pie_attacks[i][1])*16;
														rckch[1] -> stretchY = (int)(0.567 * (rckch[1] -> stretchX));
														rckch[1] -> angle = ((pie_attacks[i][1]-30)*12);
													}
													if (pie_attacks[i][1] == 59)
													{
														rckch[1] -> angle = 0;
														rckch[1] -> stretchX = 480;
														rckch[1] -> stretchY = 272;
														rckchscr=1;
														oslPlaySound(quitter, 5);
													}
													spr_draw(rckch[1], 240+random(8)-4, 136+random(8)-4);
													if (!(pie_attacks[i][1]%36) && (!shielded))
													{
														health--;
														if (putin) health--;
													}
												}

												if (pie_attacks[i][1] <= -180)
												{

													oslStopSound(quitter);
													pie_attacks[i][0]=0;
													rckchscr=0;

												}

												if (py > ((pie_attacks[i][3]-62)*court_zoom))
												{
													oslSetAlpha(OSL_FX_DEFAULT, 0);
													draw_benj(benj, px, py, shielded, shield);
												}


											}
										else
											{
												if (pie_attacks[i][1]==20) oslPlaySound(expl_sound2, 6);
												explode -> stretchX = explode -> stretchY = 20 - pie_attacks[i][1];
												spr_draw(explode, pie_attacks[i][2], pie_attacks[i][3]);
												pie_attacks[i][1]--;
												if (pie_attacks[i][1]==0)
												{
													pie_attacks[i][0]=0;
												}

											}
										}


								break;
							}

							case 4:
							{
								if ((mgcd < 1) && (health > 0))
								{
									if ((pie_attacks[i][1] == diff*166) || (pie_attacks[i][1] == 0))
									{
										 oslPauseSound(giygas[giyg_flag%3], -1);
										 if (pie_attacks[i][2]) oslPlaySound(seegaa, 5);
									}
									if (lightsoff)
									{
										oslSetAlpha(OSL_FX_DEFAULT,0);
										oslDrawFillRect(0,0,480,272, RGB(0,0,0));



										draw_benj(benj, px, py, shielded, shield);


										for (u=0; u<(2*diff+2); u++)
										{
											if (pie_attacks[u][0] != 4)
												{
													pie_attacks[u][0]=0;
												}
										}

										if (pie_attacks[i][2]) spr_draw(sega, 240, 136);
									}
								}

								 if (!pie_attacks[i][1])
									 {
										lightsoff=0;
										pie_attacks[i][0]=0;
									 }

								pie_attacks[i][1]--;
								break;
							}

							case 5:
							{
								if ((mgcd < 1) && (health > 0))
								{
									if (pie_attacks[i][1] < (px-108))
										{
											spr_draw(psycho, pie_attacks[i][1], abs(32*sin(0.0125*3.14*pie_attacks[i][1]))+8);
										}
									else
										{

											if (pie_attacks[i][2] > 2) pie_attacks[i][2]-=2; else pie_attacks[i][0]=0;
											oslSetAlpha(OSL_FX_ALPHA,pie_attacks[i][2]);
											oslDrawFillRect(0,0,480,272, RGB(255,255,255));
											oslSetAlpha(OSL_FX_DEFAULT, 0);
										}
									pie_attacks[i][1]+=4;
								}
								break;
							}

							case 6:
							{
								if ((mgcd < 1) && (health > 0))
								{

									if (pie_attacks[i][1] < 51)
									{
										if ((pie_attacks[i][1])%4 < 3) oslSetAlpha(OSL_FX_TINT, RGBA(0, 0, 255, 192)); else oslSetAlpha(OSL_FX_DEFAULT, 0);
									}
									else
									{
										oslSetAlpha(OSL_FX_DEFAULT, 0);
									}

									if (pie_attacks[i][1] > 0) spr_draw(visor, pie_attacks[i][2], pie_attacks[i][3]);



									if (px+32 < pie_attacks[i][2])
										{
											pie_attacks[i][2] -= diff;
										}
									else if (px+32 > pie_attacks[i][2])
										{
											pie_attacks[i][2] += diff;
										}

									if (py+48 < pie_attacks[i][3])
										{
											pie_attacks[i][3] -= diff;
										}
									else if (py+48 > pie_attacks[i][3])
										{
											pie_attacks[i][3] += diff;
										}


									pie_attacks[i][1]--;
									oslSetAlpha(OSL_FX_DEFAULT, 0);

									if (!pie_attacks[i][1])
									{
										oslPlaySound(pew, 6);
										if ((pie_attacks[i][2] >= px-16) && (pie_attacks[i][2] <= px+80) && (pie_attacks[i][3] >= py+24) && (pie_attacks[i][3] <= py+72) && (!shielded))
										{
											health -= 2*diff+6;
											if (putin) health -= 3;
											oslPlaySound(benj_sfx[random(5)], 3);
										}
									}

									if (pie_attacks[i][1] < 0)
									{
										explode -> stretchX = explode -> stretchY = 20 + 2*pie_attacks[i][1];
										spr_draw(explode, pie_attacks[i][2], pie_attacks[i][3]);

										if (pie_attacks[i][1] == -10) pie_attacks[i][0]=0;
									}
								}
								break;
							}



							case 8:
							{
								if ((mgcd < 1) && (health > 0))
								{
									if (bulbfell==1)
									{
										oslSetImageTileSize(bulbasaur, 0, 128, 64, 64);
										court_zoom = 0.00192*pie_attacks[i][4] + 0.562;
										bulbasaur->stretchX = (int)(64*(float)court_zoom);
										bulbasaur->stretchY = (int)(64*(float)court_zoom);

										spr_draw(bulbasaur, pie_attacks[i][3], pie_attacks[i][4]);
										pie_attacks[i][4] += 8;
										if (pie_attacks[i][4] >= 136)
										{
											pie_attacks[i][4]=136;
											bulbfell=2;
										}

										if (py > ((pie_attacks[i][4])*court_zoom))
										{
											oslSetAlpha(OSL_FX_DEFAULT, 0);
											draw_benj(benj, px, py, shielded, shield);
										}
									}

									else if (bulbfell==2)
									{
										if (pie_attacks[i][2] != 4)
										{
											oslSetImageTileSize(bulbasaur, bulbfs*64, pie_attacks[i][2]*64, 64, 64);
										}
										else
										{

											if (abs(pie_attacks[i][3]-px) > abs(pie_attacks[i][4]-py))
											{
												if (pie_attacks[i][3] > px)
												{
													oslSetImageTileSize(bulbasaur, 0, 192, 64, 64);
												}
												else
												{
													oslSetImageTileSize(bulbasaur, 0, 64, 64, 64);
												}
											}
											else
											{
												if (pie_attacks[i][4] > py)
												{
													oslSetImageTileSize(bulbasaur, 0, 0, 64, 64);
												}
												else
												{
													oslSetImageTileSize(bulbasaur, 0, 128, 64, 64);
												}
											}
										}

										court_zoom = 0.00192*pie_attacks[i][4] + 0.562;
										bulbasaur->stretchX = (int)(64*(float)court_zoom);
										bulbasaur->stretchY = (int)(64*(float)court_zoom);

										spr_draw(bulbasaur, pie_attacks[i][3], pie_attacks[i][4]);

										if (!(counter%52) && ((counter%416) < 364))
										{
											pie_attacks[i][2]=random(4);
										}
										else
										{
											switch(pie_attacks[i][2])
											{
												case 0:
												if (pie_attacks[i][4] > 128) pie_attacks[i][4] -= 2; else pie_attacks[i][2]=2;
												break;

												case 1:
												if (pie_attacks[i][3] < 400) pie_attacks[i][3] += 2; else pie_attacks[i][2]=3;
												break;

												case 2:
												if (pie_attacks[i][4] < 240) pie_attacks[i][4] += 2; else pie_attacks[i][2]=0;
												break;

												case 3:
												if (pie_attacks[i][3] > 80) pie_attacks[i][3] -= 2; else pie_attacks[i][2]=1;
												break;
											}
										}



										if ((counter%416) >= 364)
										{
											pie_attacks[i][2]=4;

											if ((counter%416) == 364) oslPlaySound(bulbsfx[random(3)+3], 6);

											if (pie_attacks[i][3] > px) pie_attacks[i][3] -= 4; else pie_attacks[i][3] += 4;
											if (pie_attacks[i][4] > py) pie_attacks[i][4] -= 2; else if (pie_attacks[i][4] < 238) pie_attacks[i][4] += 2;

										}



										if ((((px-pie_attacks[i][3])*(px-pie_attacks[i][3])+(py-pie_attacks[i][4])*(py-pie_attacks[i][4])) <= 64) && (pie_attacks[i][2]==4) && (!shielded))
										{
											if (!stun) stun=200+3*diff;
											pie_attacks[i][2]=random(4);
											health -= diff+1;
											if (putin) health -= diff;
											oslPlaySound(benj_sfx[random(5)], 3);
											counter += (counter%417)+1;
											oslPlaySound(bulbsfx[0],6);
										}

										if ((((px-pie_attacks[i][3])*(px-pie_attacks[i][3])+(py-pie_attacks[i][4])*(py-pie_attacks[i][4])) <= 1500) && (frappe >= 1))
										{
											oslSetAlpha(OSL_FX_TINT, RGBA(255,255,0,255));
											spr_draw(bulbasaur, pie_attacks[i][3], pie_attacks[i][4]);
											ultlvl += 5-diff;
											oslSetAlpha(OSL_FX_DEFAULT, 0);
											if (frappe == 1)
											{
												if ((osl_keys -> held.square) || (osl_keys -> held.circle)) pie_attacks[i][1]--;
												if (osl_keys -> held.triangle) pie_attacks[i][4]=0;
												oslPlaySound(paf, 6);
											}
										}

										bulbfs=(counter%20)/5;

										if (py > ((pie_attacks[i][4])*court_zoom))
										{
											oslSetAlpha(OSL_FX_DEFAULT, 0);
											draw_benj(benj, px, py, shielded, shield);
										}
									}

									if (pie_attacks[i][1] <= 0)
									{
										bulbfell=0;
										if (!pie_attacks[i][1]) oslPlaySound(bulbsfx[2], 6);
										pie_attacks[i][2]=4;
										pie_attacks[i][1]--;

										if (pie_attacks[i][1] == -35)
										{
											pie_attacks[i][0]=0;
										}

										bulbfs=((abs(pie_attacks[i][1]))%36)/9;
										oslSetImageTileSize(bulbasaur, bulbfs*64, pie_attacks[i][2]*64, 64, 64);
										spr_draw(bulbasaur, pie_attacks[i][3], pie_attacks[i][4]);

									}

								}
								break;

							case 9:
							{

								if ((mgcd <1) && (!lightsoff))
								{
									if (pie_attacks[i][1] == 120*diff+120)
									{


										for(u=0; u<3; u++)
										{
											meteors[u][1] = random(176);
											if (pie_attacks[i][2]) meteors[u][0]=-48; else meteors[u][0]=480;
											meteors[u][2] = random(3)+1;
										}

										oslPlaySound(meteor_fall, 5);
									}
									else
									{
										if (oslGetSoundChannel(meteor_fall) != 5) oslPlaySound(meteor_fall, 5);

										for(u=0; u<3; u++)
										{

											oslSetImageTileSize(meteor, u*48, 0, 48, 48);
											meteor -> stretchX = meteor -> stretchY = 12*meteors[u][2];
											spr_draw(meteor, meteors[u][0], meteors[u][1]);

											if (pie_attacks[i][2]) meteors[u][0]+=random(9)+1; else meteors[u][0]-=random(9)+1;

											meteors[u][1]+=4;

											if ((meteors[u][1] < pie_attacks[i][3]+32) && (meteors[u][1] >= pie_attacks[i][3]))
											{
												explode -> stretchX = explode -> stretchY = 48;
												spr_draw(explode, meteors[u][0], meteors[u][1]);
												oslPlaySound(expl_sound2, 4);
											}

											if (meteors[u][1] >= pie_attacks[i][3]+32)
											{
												if (((px-meteors[u][0])*(px-meteors[u][0])+(py+32-meteors[u][1])*(py+32-meteors[u][1]) <= 196) && (!shielded))
												{
													if (oslGetSoundChannel(expl_sound2) != 7) oslPlaySound(expl_sound2, 7);
													health -= round;
													if (putin) health -= round;
													oslPlaySound(benj_sfx[random(5)], 3);
												}

												if (pie_attacks[i][1] <= 0) meteors[u][2]=0; else meteors[u][2] = random(3)+1;
												meteors[u][1]=random(176);
												if (pie_attacks[i][2]) meteors[u][0]=-48; else meteors[u][0]=480;

											}
										}
									}

									pie_attacks[i][1]--;

									if (pie_attacks[i][1] == 0)
										{
											oslStopSound(meteor_fall);
										}

									if (meteors[0][2]+meteors[1][2]+meteors[2][2] == 0) pie_attacks[i][0]=0;
									}
								}
								break;

							case 10:
							{
								if ((mgcd <1) && (!lightsoff))
								{
									if (!shielded)
									{

										if (pie_attacks[i][1] == 96)
										{
											stunning->stretchX = stunning->stretchY = 24;
											oslPlaySound(stun_sound, 3);
										}


										for (u=0; u<135; u++)
										{
											oslSetAlpha(OSL_FX_TINT, RGBA(0,255,255,192));
											if (stunning->stretchX > 4) spr_draw(stunning, (u%15)*32+12, ((int)(u/15))*32+12);
											oslSetAlpha(OSL_FX_DEFAULT, 0);
										}
									}

									pie_attacks[i][1]--;

									if (!((pie_attacks[i][1])%8))
									{
										if (stunning->stretchX > 4)
										{
											stunning->stretchX -= 4;
											stunning->stretchY -= 4;
										}
									}

									if (!(pie_attacks[i][1]))
									{
										pie_attacks[i][0]=0;
									}
								}
								break;
							}

							case 11:
							{
								if ((mgcd <1) && (!lightsoff) && (health > 0))
								{
									if (pie_attacks[i][2] > 0)
									{
										oslSetImageTileSize(psis, ((int)(counter%18)/6)*16, 0, 16, 32);
										oslSetImageRotCenter(psis);

										psis -> angle = pie_attacks[i][1];

										court_zoom = 0.00192*(py+24) + 0.562;
										psis->stretchX = (int)(16*(float)court_zoom);
										psis->stretchY = (int)(32*(float)court_zoom);

										spr_draw(psis, px+32+pie_attacks[i][2]*cos(pie_attacks[i][1]*3.14/180), py+48+pie_attacks[i][2]*sin(pie_attacks[i][1]*3.14/180));
										spr_draw(psis, px+32+pie_attacks[i][2]*cos((pie_attacks[i][1]+180)*3.14/180), py+48+pie_attacks[i][2]*sin((pie_attacks[i][1]+180)*3.14/180));

										pie_attacks[i][1] += 16;

										if (pie_attacks[i][1] > 360)
										{
											pie_attacks[i][1] = pie_attacks[i][1]%360;
											pie_attacks[i][2]-=2;
										}
									}
									else if (pie_attacks[i][2] <= 0)
									{
											explode -> stretchX = explode -> stretchY = 40 + 4*pie_attacks[i][2];
											spr_draw(explode, px, py);

											if (!(pie_attacks[i][2])) oslPlaySound(expl_sound, 6);

											if ((!shielded) && (counter%2))
											{
												health -= diff;
												if (putin) health -= diff;
												oslPlaySound(benj_sfx[random(5)], 3);
											}
											pie_attacks[i][2]--;

											if (pie_attacks[i][2] == -10)
											{
												oslStopSound(psis_sfx);
												pie_attacks[i][0]=0;
											}
									}
								}
								break;
							}

							case 7:
							{
								if ((mgcd < 1) && (health > 0) && (!lightsoff))
								{
									if (!(pie_attacks[i][1]))
									{
										oslSetImageTileSize(recipe,0, 0, 32, 136);
									}
									else
									{
										oslSetImageTileSize(recipe, 32, 0, 32, 136);
									}

									if (pie_attacks[i][2] > 0)
									{
										oslSetAlpha(OSL_FX_ALPHA, 128);
										oslDrawFillRect(pie_attacks[i][4], 0, (pie_attacks[i][1])?480:0, 272, RGB(0, 0, 0));

										for(u=0; u<4; u++)
										{
											spr_draw(recipe, pie_attacks[i][4]+((pie_attacks[i][1])?0:32), u*136-(global_fr%137));
										}

										oslSetAlpha(OSL_FX_DEFAULT, 0);

										if (((pie_attacks[i][1]) && (pie_attacks[i][2] <= (480-pie_attacks[i][3]))) ||
												((!(pie_attacks[i][1])) && (pie_attacks[i][2] <= pie_attacks[i][3])))
										{


											if (((pie_attacks[i][1]) && (px+32 >= pie_attacks[i][4])) || (!(pie_attacks[i][1]) && (px+32 <= pie_attacks[i][4])))
											{
												if (oslGetSoundChannel(mouth_sfx[0]) != 2) oslPlaySound(mouth_sfx[0], 2);
												oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
												spr_draw(mouth, 240, 136);

												pie_attacks[i][2]++;
												mouth -> stretchX += 6;
												mouth -> stretchY = 1.63 * mouth -> stretchX;

												if (mouth -> stretchY >= 420)
												{
													if (oslGetSoundChannel(mouth_sfx[1]) != 2) oslPlaySound(mouth_sfx[1], 2);
													oslDrawFillRect(0, 0, 480, 272, RGB(255, 0, 0));
												}

												if (mouth -> stretchY >= 450)
												{
													health -= 2*diff+4;
													if (putin) health -= 2;
													pie_attacks[i][0]=0;
													mouth -> stretchX = 10;
													mouth -> stretchY = 16;
												}

											}
										else
											{
												if (!(pie_attacks[i][1]))
												{
													pie_attacks[i][4]--;

												}
												else
												{
													pie_attacks[i][4]++;

												}
											}
										}
										else
										{
											if (!(pie_attacks[i][1]))
											{
												if (pie_attacks[i][4] < pie_attacks[i][3]) pie_attacks[i][4]++;
												if (pie_attacks[i][4] > 512)
												{
													darkness=0;
													pie_attacks[i][0]=0;
												}
											}
											else
											{
												if (pie_attacks[i][4] > pie_attacks[i][3]) pie_attacks[i][4]--;
												if (pie_attacks[i][4] < -64)
												{
													darkness=0;
													pie_attacks[i][0]=0;
												}
											}
										}
										pie_attacks[i][2]--;


									}
									else
									{
										darkness=0;
										pie_attacks[i][0]=0;
									}

									if (pie_attacks[i][2] <= 0)
									{
										pie_attacks[i][0]=0;
									}
								}
								break;
							}


							}
						}
					}
				}

				if (oslGetSoundChannel(minigametime) != 7 && (oslGetSoundChannel(tvnoisesound) != 1) && (!paused))
					{
						tvnoise_ev=random((3800/(100*round*diff))*pie_ent.pie_hp+4200);
					}

				if ((tvnoise_ev <= 4000) && (tvnoise_ev > 3940) && (round==2)  && (health>0) && (!lightsoff) && (!paused))
				{
					i=random(4);
					oslSetBilinearFilter(1);
					spr_draw(tvnoise[i], 0, 0);
					oslSetBilinearFilter(0);
					if (oslGetSoundChannel(tvnoisesound) != 1) oslPlaySound(tvnoisesound, 1);
					tvnoise_ev--;
				}
				else
				{
					oslStopSound(tvnoisesound);
				}
			}

			if ((pie_ent.pie_hp) && (!mgcd))
			{
				reddv = (-0.64/(round*diff))*pie_ent.pie_hp+64;

				oslSetAlpha(OSL_FX_ALPHA, (int)(reddv*1.5));
				oslDrawFillRect(0, 0, 480, 272, RGB(255, 0, 0));
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}



			if ((health < 1) || (pie_ent.pie_hp < 1))
			{
				oslStopSound(psis_sfx);
				ball_ent.speed_v=0;
				oslSetAlpha(OSL_FX_DEFAULT, 0);
				if (pie_ent.pie_hp < 1)
				{
					if (!ko_frame)
					{
						a=pie_ent.pie_x-128+random(256);

						for (i=0; i<8; i++)
							{
								for (j=0; j<5; j++)
								{
									pie_attacks[i][j]=0;
								}
								bulbfell=0;
							}
					}

					mort=1;


					if (round==2)
					{
						if (!(ko_frame%9))
						{
							oslPlaySound(expl_sound, 6);
							kx=pie_ent.pie_x-128+random(256);
							ky=random(136);
						}

						if ((ko_frame%6) < 3)
						{
							explode -> stretchX = 64;
							explode -> stretchY = 96;
							spr_draw(explode, kx, ky);
						}
						else
						{
							explode -> stretchX = 32;
							explode -> stretchY = 48;
							spr_draw(explode, kx+16, ky+24);
						}
					}
				}

				if (ko_frame == 0)
				{
					oslPlaySound(ko_sfx, 7);
					oslPlaySound(expl_sound, 6);
					u=0;
				}

				if (health < 1)
				{
					if (ko_frame < 60)
					{
						if ((ko_frame%6) < 3)
						{
							explode -> stretchX = 64;
							explode -> stretchY = 96;
							spr_draw(explode, px, py);
						}
						else
						{
							explode -> stretchX = 32;
							explode -> stretchY = 48;
							spr_draw(explode, px+16, py+24);
						}
					}
				}


				if (ko_frame < 25)
				{
					oslSetImageTileSize(ko,0,0,120,96);
					spr_draw(ko, (int)(9.6*ko_frame-120), 88);
				}

				if ((ko_frame >= 25) && (ko_frame <= 50))
				{
					oslSetImageTileSize(ko,0,0,120,96);
					spr_draw(ko, 120, 88);
					oslSetImageTileSize(ko,120,0,120,96);
					spr_draw(ko, (int)(-9.6*ko_frame+720), 88);
				}

				if (ko_frame > 50)
				{
					oslSetImageTileSize(ko,0,0,240,96);
					spr_draw(ko, 120, 88);
				}

				if (ko_frame >= 140) quit=1;


				ko_frame++;
			}

			if (health < 0) health=0;

			if (!mgcd)
			{
					oslSetAlpha(OSL_FX_DEFAULT, 0);
					oslSetImageTileSize(numberz,160,0,16,16);
					spr_draw(numberz, 2, 2);

					u=random(5);

					oslSetImageTileSize(ultgauge,0,0,64,8);
					spr_draw(ultgauge, 2+((round==2)?u:0), (round==2)?20+u:21);
					oslSetImageTileSize(ultgauge,(int)((ultlvl/60)*6),9,6,6);
					spr_draw(ultgauge, 69+((round==2)?u:0), (round==2)?21+u:22);
					spr_draw(shlgauge, 2+((round==2)?u:0), (round==2)?28+u:30);

					if (ultlvl > 1) oslDrawFillRect(4+((round==2)?u:0), (round==2)?22+u:23, ultlvl%60+4+((round==2)?u:0), (round==2)?25+u:26, RGB(0,0,255));
					if (shldlvl > 1) oslDrawFillRect(4+((round==2)?u:0), (round==2)?31+u:32, shldlvl+4+((round==2)?u:0), (round==2)?34+u:35, RGB(255,150,255));

					if ((ultlvl%60) > 15)
					{
						if ((ultrectshine+16) <= ultlvl%60)
						{
							oslDrawFillRect(ultrectshine+((round==2)?u:0), (round==2)?22+u:23, ultrectshine+13+((round==2)?u:0), (round==2)?25+u:26, RGB(0,255,255));
						}
						else
						{
							oslDrawFillRect(ultrectshine+((round==2)?u:0), (round==2)?22+u:23, ultlvl%60+3+((round==2)?u:0), (round==2)?25+u:26, RGB(0,255,255));
						}

						if ((ultrectshine+8) <= ultlvl%60)
						{
							oslDrawFillRect(ultrectshine+4+((round==2)?u:0), (round==2)?22+u:23, ultrectshine+9+((round==2)?u:0), (round==2)?25+u:26, RGB(255,255,255));
						}
						else
						{
							oslDrawFillRect(ultrectshine+4+((round==2)?u:0), (round==2)?22+u:23, ultlvl%60+3+((round==2)?u:0), (round==2)?25+u:26, RGB(255,255,255));
						}

						ultrectshine++;

						if (ultrectshine > ultlvl%60)
						{
							ultrectshine=0;
						}
					}

					i=random(15);

					u=18;

					if (health < 25) j=16; else j=0;

						if (health / 100)
						{
							oslSetImageTileSize(numberz,((round==2)?((i<12)?16:random(144)):16),0,16,16);
							spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
							u += 16;
						}

						if (health > 9)
						{
							if (round==2)
								{
									if (i<12)
										{
											oslSetImageTileSize(numberz,((health%100)/10)*16,j,16,16);
										}
									else
										{
											oslSetImageTileSize(numberz,random(128),j,16,16);
										}
								}
							else oslSetImageTileSize(numberz,((health%100)/10)*16,j,16,16);
						spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
						u += 16;
						}

						if (round==2)
							{
								if (i<12)
									{
										oslSetImageTileSize(numberz,(health%10)*16,j,16,16);
									}
								else
									{
										oslSetImageTileSize(numberz,random(128),j,16,16);
									}
							}
						else oslSetImageTileSize(numberz,(health%10)*16,j,16,16);
						spr_draw(numberz, u + ((round==2)?random(3):0), ((round==2)?1+random(3):2));
				}



			if ((paused) && (health))
			{
				oslSetAlpha(OSL_FX_ALPHA,224);
				oslDrawFillRect(0,0,480,272, RGB(0,8,0));
				spr_draw(paused_gfx, 240, 136);
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}

			if ((!(counter%6)) && (shldlvl<60) && (!shielded) && (!paused)) shldlvl++;


			if (counter < 256)
			{
				if (counter < 128)
				{
					oslSetImageTileSize(premess,0,0,256,64);

					if (counter < 32) premess -> stretchY = counter*2;
					else if (counter > 96) premess -> stretchY = 128-counter*2;
					else premess -> stretchY = 64;

					spr_draw(premess, 112, 136-(premess -> stretchY)/2);
				}

				else if (counter >= 128)
				{
					oslSetImageTileSize(premess,0,64,256,64);
					if (counter < 160) premess -> stretchY = (counter-128)*2;
					else if (counter > 224) premess -> stretchY = 256-counter*2;
					else premess -> stretchY = 64;

					spr_draw(premess, 112, 136-(premess -> stretchY)/2);
				}

				if (counter==255) oslDeleteImage(premess);
			}



			if ((nbp==1) && (DEBUG))
			{
				if (osl_keys->held.R)
				{
					for (i=0; i<16; i++)
					{
						sprintf(buffer,"%d",(i<15)?att_cooldowns[i]:(int)reddv);
						u = oslGetStringWidth(buffer);

						oslSetTransparentColor(RGB(255,0,255));
						oslSetBkColor(RGB(255,0,255));
						oslSetTextColor(RGB(255, 255, 255));
						oslDrawString(480-u, i*12, buffer);
					}
				}


				if (osl_keys->held.L)
				{
					for (i=0; i<10; i++)
					{
						sprintf(buffer,"%d", (i<8)?pie_attacks[i][0]:
														(i==8)?(pie_ent.pie_hp):
																(int)(-2.55/(round*diff)*(pie_ent.pie_hp)+255));
						u = oslGetStringWidth(buffer);

						oslSetTransparentColor(RGB(255,0,255));
						oslSetBkColor(RGB(255,0,255));
						oslSetTextColor(RGB(255, 255, 255));
						oslDrawString(480-u, i*12, buffer);
					}
				}
			}

			if ((att_ch_timer < 80) && (nbp==2) && (health > 0) && (pie_ent.pie_hp > 0) && (!paused))
			{
				spr_draw(attch, 32, 33);
				spr_draw(cp2, 40 + cursor2p*32, 68);
				for (i=0; i<15; i++)
				{
					if (att_cooldowns[i] > 1)
					{
						sprintf(buffer, "%d", att_cooldowns[i]/60);
						oslSetAlpha(OSL_FX_ALPHA, 128);
						oslDrawFillRect(32+i*32, 33, 32+(i+1)*32, 67, RGB(1, 1, 1));
						oslSetAlpha(OSL_FX_DEFAULT, 0);
						if (i < 12) oslDrawString(36+i*32, 42, buffer);
						if ((i==12) && (pie_ent.pie_hp > 25*round*diff) && (ulted == 0) && (att_cooldowns[12] > 1))
						{
							oslDrawLine(32+i*32, 33, 32+(i+1)*32, 66, RGB(255, 0, 0));
						}
						if ((i==13) && (pie_ent.pie_hp > 10*round*diff) && (ulted != 1) && (att_cooldowns[13] > 1))
						{
							oslDrawLine(32+i*32, 33, 32+(i+1)*32, 66, RGB(255, 0, 0));
						}
					}
				}
			}

			if (nbp == 2)
			{
				oslSetAlpha(OSL_FX_ALPHA, 255-(global_fr%64)*4);
				oslDrawString(270, 2, "OTHER MORTAL, USE L OR R TO ATTACK!");
				oslSetAlpha(OSL_FX_DEFAULT, 0);
			}

			oslEndDrawing();
			}






    	oslEndFrame();
		skipframe=oslSyncFrame();

		if (mgcd==100)
			{
				u=random(6);
				check = sceIoDopen("flash1:/");

				while ((check < 0) && (u==2))
				{
					u=random(6);
				}


				switch(u)
				{
					case 0:
					i=sonicexe(diff);
					break;

					case 1:
					i=mincer(diff);
					break;

					case 2:
					i=shoot_teevees(diff, &health, round);
					break;

					case 3:
					i=flappy_cacodemon(diff);
					break;

					case 4:
					i=love_boat(diff);
					break;

					case 5:
					i=sonicexe2(diff);
					break;
				}
				if (i)
					{
					 oslPlaySound(giygas[giyg_flag%3], 0);

					 health += 5*(4-diff)+10;

					 if (health > 100) health=100;

					} else health=0;


				for (i=0; i<8; i++)
					{
						for (j=0; j<5; j++)
						{
							pie_attacks[i][j]=0;
						}
						bulbfell=0;
					}

				pie_ent.pie_facemode=0;
				mgcd=0;
				mouth -> stretchX = 10;
				if (diff != 3) a=diff; else a=2;
				ball_ent = apply_impulse(ball_ent, random(2)?a:-1*a, random(2)?a:-1*a, (180-15*frappe)*3.14/180);
				frappe=-1;
				rckchscr=0;
			}



    }


    if ((mort==1) && (round==2))
   	{
    	oslStopSound(tvnoisesound);
    	oslDeleteSound(paf);
    	paf = oslLoadSoundFile("./sfx/sfx-0029.wav", OSL_FMT_NONE);

   		oslPlaySound(tvnoisesound, 0);

    	for(i=0; i<((diff==3)?420:540); i++)
    	{
    		oslStartDrawing();
    		oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
				u=random(4);
				oslSetBilinearFilter(1);
				spr_draw(tvnoise[u], 0, 0);
				spr_draw(tvnoise[u], random(480), random(272));
				spr_draw(tvnoise[u], random(480)-240, random(272)-136);
				spr_draw(tvnoise[u], random(240)-120, random(136)-68);
				oslSetBilinearFilter(0);

				if ((i > 300) && (diff < 3)) spr_draw(tryharder, 220+random(40), 112+random(48));

			oslEndDrawing();
			oslWaitVSync();
			oslSwapBuffers();

			if ((i == 310) && (cheat)) mackey2();
    	}

    	oslStopSound(tvnoisesound);
    	oslPlaySound(paf, 0);

    	for(i=0; i<=135; i+=2)
    	{
    		oslStartDrawing();
    		oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
    		oslDrawFillRect(0, i, 480, 272-i, RGB(255, 255, 255));
    		oslEndDrawing();
    		oslWaitVSync();
    		oslSwapBuffers();
    	}

    	fadeout(RGB(0, 0, 0));
   	}


    for (i=0; i<3; i++) oslDeleteSound(giygas[i]);

	for (i=0; i<4; i++) oslDeleteSound(dictators_sfx[i]);

 	for (i=0; i<5; i++) oslDeleteImage(tvnoise[i]);

 	for (i=0; i<7; i++) oslDeleteSound(bulbsfx[i]);

 	for (i=0; i<11; i++) oslDeleteSound(benj_sfx[i]);

	oslDeleteSound(tvnoisesound);
	oslDeleteImage(giyg_bg);
    oslDeleteSound(ko_sfx);
	oslDeleteSound(quitter);
	oslDeleteSound(pew);
	oslDeleteSound(paf);
	oslDeleteSound(psis_sfx);
	oslDeleteImage(numberz);
	oslDeleteImage(starsky);
	oslDeleteImage(lightning);
	oslDeleteImage(pie);
	oslDeleteImage(sleepwell);
	oslDeleteImage(ko);
	oslDeleteImage(explode);
	oslDeleteImage(ball_gfx);
	oslDeleteImage(ball_shad);
	oslDeleteImage(mgswirl);
	oslDeleteImage(powerball);
	oslDeleteSound(minigametime);
	oslDeleteSound(expl_sound);
	oslDeleteSound(expl_sound2);
	oslDeleteSound(meteor_fall);
	oslDeleteSound(stun_sound);
	oslDeleteSound(elec);
	oslDeleteSound(thunder);
	oslDeleteSound(whine);
	oslDeleteSound(mouth_sfx[0]);
	oslDeleteSound(mouth_sfx[1]);
	oslDeleteSound(bounce);
	oslDeleteImage(rckch[0]);
	oslDeleteImage(rckch[1]);
	oslDeleteImage(psycho);
	oslDeleteImage(paused_gfx);
	oslDeleteImage(ultgauge);
	oslDeleteImage(shlgauge);
	oslDeleteImage(visor);
	oslDeleteImage(bulbasaur);
	oslDeleteImage(recipe);
	oslDeleteImage(shield);
	oslDeleteImage(meteor);
	oslDeleteImage(stunning);
	oslDeleteImage(juche);
	oslDeleteImage(psis);
	oslDeleteImage(dictators);
	oslDeleteImage(mouth);
	oslDeleteImage(star);
	oslDeleteImage(suppo_gfx);
	oslDeleteImage(attch);
	oslDeleteImage(cp2);
	oslDeleteImage(sega);
	oslDeleteSound(seegaa);
	oslDeleteImage(tryharder);

    return mort;
}

void text(int nbt)
{
	int frame=0, k;
	const char *texts[12] = {"YOUR HEAD IS ALREADY OFF", "YOU WON'T SEE THE MOCK TURTLE", "MOTHER", "YOU'RE NOT EVEN TRYING", "AEIOU", "UNHAPPY UNBIRTHDAY", "YOU'RE LATE YOU'RE LATE YOU'RE LATE",
							 "NO TIME TO SAY GOODBYE", "PAINTING YOUR BOWELS RED", "HOW DOTH THE LITTLE OF YOU LIVE", "I HAVE A VERY GOOD ADVICE", "THE WALRUS ATE THE CARPENTER"};

	OSL_SOUND *wind = oslLoadSoundFile("./sfx/sfx-0019.wav", OSL_FMT_NONE);

	k = oslGetStringWidth(texts[nbt]);

	oslPlaySound(wind, 0);

	while(frame<282)
	{
		oslStartDrawing();
		oslDrawFillRect(0,0,480,272, RGB(0, 0, 0));


		if (frame < 82)
		{
			oslSetTextColor(RGB(frame*3, frame*3, frame*3));
			oslDrawString((480 - k)/2, 130, texts[nbt]);
		}
		if ((frame >= 82) && (frame <= 200))
		{
			oslSetTextColor(RGB(255, 255, 255));
			oslDrawString((480 - k)/2, 130, texts[nbt]);
		}
		else if (frame > 200)
		{
			oslSetTextColor(RGB((282-frame)*3, (282-frame)*3, (282-frame)*3));
			oslDrawString((480 - k)/2, 130, texts[nbt]);
		}
		oslEndDrawing();
		oslSwapBuffers();
		oslWaitVSync();
		frame++;
	}

	oslDeleteSound(wind);
}

void amigatext(const char *arg, int x, int y, OSL_IMAGE *amigafont, int width, int height)
{
	int i, l=strlen(arg), tx=x, placex=(amigafont -> sizeX)/width;



	for(i=0; i<l; i++)
	{
		if (arg[i] <= 'Z')
		{
			oslSetImageTileSize(amigafont, ((arg[i]-32)%placex)*width, ((arg[i]-32)/placex)*height, width, height);
			spr_draw(amigafont, tx, y);
		}

		tx += width;
	}
}

void credz()
{
	int frame=0, a=0, b=480, c=0, d=32, e=136, trans=0, skipframe=0, f=7, i;
	short quit=0;
	char buffer[39];

	const char *texts[23] = {VERSION, "Released on 11/23/2014 for", "","", " 2014 by",
							"Code, some GFX and .XM music by", "Ball physics and OSLib by",
							"Inspired by", "THE NONE", "Musics ingame ripped from", "EARTHBOUND",
							"Powered by", "OSLIB MOD V2", "Coding started on", "JULY 2013", "Hours of work", "COUNTLESS",
							"Most pictures were found on", "GOOGLE PICS", "Number of defeat animations", "25", " ", " "};

	const char *greeted[25] = {"ICEMAN", "PRINCEPS-BONUS", "ODIE_ONE", "MAGEDRAXGONVAMPIRE", "XELTEKSEN", "FEI", "SHYKOOPA77", "XIRIUS_THIR", "GOBOLZ",
							 "MEZ", "ORION_", "ZEROSQUARE", "BRUNNI", "MATMOOK", "JEFFR3Y", "DR.DEIMOS", "GODZIL", "ARETHIUS", "TENDERNESS", "KEYDEE GAMER BOY",
							 "OBO", "BARONLESTAT666", "ISOBEL", "LUNA240681", "...AND MANY OTHERS"};

	OSL_SOUND *theme = oslLoadSoundFileMOD("./muzaxx/credz.xm", OSL_FMT_NONE);
	OSL_IMAGE *aipc = oslLoadImageFilePNG("./gfx/credz/aipc.png", OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *twt = oslLoadImageFilePNG("./gfx/credz/twitter.png", OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *gml = oslLoadImageFilePNG("./gfx/credz/gmail.png", OSL_IN_RAM, OSL_PF_8888);
	OSL_IMAGE *amiga = oslLoadImageFilePNG("./gfx/credz/amiga.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *giygas = oslLoadImageFilePNG("./gfx/credz/giygas.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *sonicexe = oslLoadImageFilePNG("./gfx/sonicexe.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *flappy_redhill = oslLoadImageFilePNG("./gfx/flappy_redhill.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *_1in24, *aa = oslLoadImageFilePNG("./gfx/pookey1.png", OSL_IN_RAM, OSL_PF_5551), *bb = oslLoadImageFilePNG("./gfx/pona08.png", OSL_IN_RAM, OSL_PF_5551);
	OSL_IMAGE *iamgod[4];

	for (i=1; i<=4; i++)
	{
		sprintf(buffer,"./gfx/iamgod%d.png",i);
		iamgod[i-1] = oslLoadImageFilePNG(buffer,OSL_IN_RAM, OSL_PF_5551);
	}

	sprintf(buffer,"./gfx/pasta%d.png",random(42)+1);
	_1in24 = oslLoadImageFilePNG(buffer, OSL_IN_RAM, OSL_PF_5551);

	OSL_IMAGE *temp = oslCreateImage(480, 272, OSL_IN_VRAM, OSL_PF_8888);

	oslClearImage(temp, RGB(0, 0, 0));

	oslSetImageRotCenter(giygas);

	oslPlaySound(theme, 7);

    oslSetFrameskip(0);
    oslSetMaxFrameskip(4);

	while ((frame < 10600) && (!quit))
	{
		if (!skipframe)
		{
			oslStartDrawing();
			oslSetAlpha(OSL_FX_DEFAULT, 0);
			oslDrawFillRect(0, 0, 480, 272, RGB(0, 0, 0));
			if (frame < 684)
			{
				oslDrawGradientRect(0, 0, 480, 272, RGB(0, 0, 64), RGB(0, 0, 64), RGB(0, 0, 192), RGB(0, 0, 192));
				for(a=0; a<16; a++)
				{
					oslDrawFillRect(a*32+c, 0, a*32+c+4, 272, RGB(94, 126, 255));
					if (a<11) oslDrawFillRect(0, a*32+c, 480, a*32+c+4, RGB(94, 126, 255));
				}

				oslSetImageTileSize(benj, ((frame%48)/4)*32, 48,32,48);
				benj -> stretchX = 96;
				benj -> stretchY = 144;
				if (frame < 492) oslSetAlpha(OSL_FX_ALPHA, 192); else oslSetAlpha(OSL_FX_ALPHA, 684-frame);
				spr_draw(benj, 78, 90);
				if (frame < 428) oslSetAlpha(OSL_FX_DEFAULT, 0); else oslSetAlpha(OSL_FX_ALPHA, 684-frame);

				oslSetImageTileSize(aipc, 0, 0, (frame<76)?frame*4:304, 34);
				spr_draw(aipc, 10, 10);
				if (c > -32) c--; else c=0;

				if (frame > 180)
				{
					if (frame < 428)
					{
						if (d > 255) oslSetAlpha(OSL_FX_DEFAULT, 0); else oslSetAlpha(OSL_FX_ALPHA, d);
					}
					else
					{
						oslSetAlpha(OSL_FX_ALPHA, 684-frame);
					}
					oslSetTextColor(RGB(255, 255, 255));
					for (a=0; a<5; a++)	oslDrawString(b, 100+a*20, texts[a]);
					amigatext("A.C. 2014", b, 132, amiga, 16, 22);
					amigatext("240-185", b, 192, amiga, 16, 22);
					if (b > 264) b -= 4;
					if (d < 255) d += 2;
				}

			}

			if ((frame >= 684) && (frame < 1368))
			{
				oslSetAlpha(OSL_FX_DEFAULT, 0);

				if ((frame==684) || (frame == 1032))
				{
					d=-12;
					trans=0;
				}

				oslDrawGradientRect(0, 0, 480, 272, RGB(0, 0, 64), RGB(0, 0, 64), RGB(0, 0, 192), RGB(0, 0, 192));
				for(a=0; a<16; a++)
				{
					oslDrawFillRect(a*32+c, 0, a*32+c+4, 272, RGB(94, 126, 255));
					if (a<11) oslDrawFillRect(0, a*32+c, 480, a*32+c+4, RGB(94, 126, 255));
				}
				if (c > -32) c--; else c=0;

				oslSetAlpha(OSL_FX_ALPHA, trans);

				if (trans < 252) trans+=4;

				if (frame < 1032)
				{
					b=oslGetStringWidth(texts[5]);
					oslDrawString((480-b)/2, d, texts[5]);
					amigatext("240-185", 184, d+32, amiga, 16, 22);
				}
				else
				{
					b=oslGetStringWidth(texts[6]);
					oslDrawString((480-b)/2, d, texts[6]);
					amigatext("BRUNNI", 192, d+32, amiga, 16, 22);
				}

				if (d < 66) d += 2;
			}


			if ((frame >= 1368) && (frame <= 2735))
			{
				temp -> stretchX = 480;
				temp -> centerX = 0;
				temp -> centerY = 0;

				oslSetDrawBuffer(temp);
				oslDisableTransparentColor();
				oslDrawFillRect(0, 0, 480, 272, RGB(255, 0, 255));
				oslSetTransparentColor(RGB(255, 0, 255));

				oslSetImageRotCenter(temp);


				if (f < 21)
				{
					b=oslGetStringWidth(texts[f]);
					oslDrawString(240+(240-b)/2, 120, texts[f]);

					b=strlen(texts[f+1])*16;
					amigatext(texts[f+1], 240+(240-b)/2, 144, amiga, 16, 22);
					spr_draw(giygas, 120, 136);
				}

				temp -> stretchX = d;
				temp -> stretchY = (int)((float)(0.57)*d);

				oslSetDrawBuffer(OSL_DEFAULT_BUFFER);

				if (frame == 1368)
				{
					d=0;
					e=136;
				}

				spr_draw(temp, 240, e);

				if (temp -> stretchX > 1280) e += 8; else e=136;
				if (temp -> stretchX < 1536) d += 8; else
				{
					f += 2;
					d=0;
				}


			}

			if ((frame >= 2736) && (frame < 3422))
			{
				if (frame == 2736)
				{
					a=0;
					b=1;
					c=0;
				}

				spr_draw(sonicexe, 204, 20+16*sin(0.0625*frame));

				switch(c)
				{
				case 0:
					oslDrawString(198, 136, "SONIC.EXE by");
					amigatext("CRIMSON THE BAT", (480-strlen("CRIMSON THE BAT")*16)/2, 150, amiga, 16, 22);
					break;

				case 1:
					amigatext("SYMBIOTICFEDORAGEEK", (480-strlen("SYMBIOTICFEDORAGEEK")*16)/2, 150, amiga, 16, 22);
					break;

				case 2:
					amigatext("SHADOWNINJA976", (480-strlen("SHADOWNINJA976")*16)/2, 150, amiga, 16, 22);
					break;

				case 3:
					amigatext("HICHIGO1989", (480-strlen("HICHIGO1989")*16)/2, 150, amiga, 16, 22);
					break;

				default:
					break;
				}

				if (c>0) oslDrawString((480-strlen("SONIC.EXE DeviantArts by:")*6)/2, 136, "SONIC.EXE DeviantArts by:");

				for(i=0; i<32; i++)
				{
					spr_draw(flappy_redhill, a+i*16, 224);
				}

				a--;

				if (a == -16) a=0;

				b++;
				if ((!(b%172)) && (c<3)) c++;
			}

			if ((frame >= 3422) && (frame < 3764))
			{
				oslSetImageRotCenter(_1in24);
				_1in24 -> angle = 16*sin(0.0625*frame);
				spr_draw(_1in24, 240, 136);

				oslDrawString(0, 0, "Weird movies stills taken from:");
				amigatext("STUART <ASHENS> ASHEN", 0, 30, amiga, 16, 22);
				amigatext("1IN24.TUMBLR.COM", 0, 60, amiga, 16, 22);
			}

			if ((frame >= 3764) && (frame < 4105))
			{
				if (frame == 3764)
				{
					oslSetImageRotCenter(aa);
				}

				aa -> angle = 16*sin(0.0625*frame);
				spr_draw(aa, 240, 136);

				oslDrawString(0, 0, "High-pitched Pookeymon Theme by");
				amigatext("DAN <LOUSY PANDAH> TOMLINSON", 0, 24, amiga, 16, 22);
				oslDrawString(0, 60, "Taken from animation 'POKMON SHOWDOWN'");
			}

			if ((frame >= 4105) && (frame < 4447))
			{
				if (frame == 4105)
				{
					oslSetImageRotCenter(bb);
				}

				bb -> angle = 16*sin(0.0625*frame);
				spr_draw(bb, 240, 136);

				oslDrawString(0, 0, "Scene from 'Pikachu on Acid' taken from:");
				amigatext("HIGH5TOONS", 0, 24, amiga, 16, 22);
			}

			if ((frame >= 4447) && (frame < 5473))
			{
				if (frame == 4447)
				{
					c=0;
				}

				oslSetAlpha(OSL_FX_ALPHA, 64);
				oslDrawGradientRect(0, 0, 480, 272, RGB(0, 0, 64), RGB(0, 0, 64), RGB(0, 0, 192), RGB(0, 0, 192));
				for(a=0; a<16; a++)
				{
					oslDrawFillRect(a*32+c, 0, a*32+c+4, 272, RGB(94, 126, 255));
					if (a<11) oslDrawFillRect(0, a*32+c, 480, a*32+c+4, RGB(94, 126, 255));
				}

				oslSetImageTileSize(benj, ((frame%48)/4)*32, 48, 32, 48);
				benj -> stretchX = 96;
				benj -> stretchY = 144;
				oslSetAlpha(OSL_FX_ALPHA, 16);
				spr_draw(benj, 192, 90);
				oslSetAlpha(OSL_FX_DEFAULT, 0);

				if (c > -32) c--; else c=0;

				if (frame <= 5090)
				{
				amigatext("SO, THERE WE ARE. I HAD TO", 0, 20, amiga, 16, 22);
				amigatext("TRAVEL FOR 700 KMS IN ORDER TO", 0, 42, amiga, 16, 22);
				amigatext("PRESENT MY SECOND HOMEBREW ON", 0, 64, amiga, 16, 22);
				amigatext("PSP.", 0, 86, amiga, 16, 22);
				amigatext("LITTLE DID I KNOW I HAD TO", 0, 130, amiga, 16, 22);
				amigatext("DEAL WITH A 2 PLAYER MODE ON A", 0, 152, amiga, 16, 22);
				amigatext("PORTABLE CONSOLE! LUCKILY, I", 0, 174, amiga, 16, 22);
				amigatext("WAS ADDICTED TO A MOBA GAME", 0, 196, amiga, 16, 22);
				amigatext("CALLED <SMITE>...", 0, 218, amiga, 16, 22);
				}
				else
				{
				amigatext("...AND THE IMPLEMENTATION OF", 0, 24, amiga, 16, 22);
				amigatext("A MOBA UI WAS A BREEZE. ", 0, 46, amiga, 16, 22);
				amigatext("THE MORAL OF THE STORY IS TO", 0, 90, amiga, 16, 22);
				amigatext("NEVER PREPARE YOUR PRODUCTION", 0, 112, amiga, 16, 22);
				amigatext("WAAAAAAAAAAY BEFORE THE CON", 0, 134, amiga, 16, 22);
				amigatext("BEGINS!", 0, 156, amiga, 16, 22);
				}
			}

			if ((frame >= 5473) && (frame < 8894))
			{
				if (frame == 5473)
				{
					d=480;
					i=0;
				}

				oslDrawGradientRect(0, 0, 480, 272, RGB(0, 0, 64), RGB(0, 0, 64), RGB(0, 0, 192), RGB(0, 0, 192));
				for(a=0; a<16; a++)
				{
					oslDrawFillRect(a*32+c, 0, a*32+c+4, 272, RGB(94, 126, 255));
					if (a<11) oslDrawFillRect(0, a*32+c, 480, a*32+c+4, RGB(94, 126, 255));
				}

				oslSetImageTileSize(benj, ((frame%48)/4)*32, 48, 32, 48);
				benj -> stretchX = 96;
				benj -> stretchY = 144;
				oslSetAlpha(OSL_FX_ALPHA, 192);
				spr_draw(benj, 192, 90);
				oslSetAlpha(OSL_FX_DEFAULT, 0);

				if (c > -32) c--; else c=0;

				oslDrawString(201, 4, "Greetings to:");
				amigatext(greeted[i], d, 136+32*sin(0.0625*frame), amiga, 16, 22);

				d=(int)(d-5.5);

				if ((d <= -288) && (i<23))
				{
					d=480;
					i++;
				}

			}

			if (frame >= 8894)
			{
				if (frame < 10260) oslSetAlpha(OSL_FX_DEFAULT, 0); else oslSetAlpha(OSL_FX_ALPHA, trans);
				a = 54+32*sin(0.0625*frame);
				b = 296+32*cos(0.0625*frame);

				spr_draw(gml, a, 32);
				spr_draw(twt, b, 32);

				amigatext("@240185", 304+32*cos(0.0625*frame), 187, amiga, 16, 22);
				amigatext("ROUNDSOFTSTUDIO", 0, 172, amiga, 16, 22);
				amigatext("@ GMAIL.COM", 32+32*sin(0.0625*frame), 202, amiga, 16, 22);

				if (frame >= 9582)
				{
					if (frame == 9582)
					{
						c=480;
						trans=255;
					}
					oslDrawString(c, 256, "See you @ A.C. 2015 for my next project for PSP: THE FIFTH AXIS! Discover a twisted theory about time travel!");

					c -= 2;
				}

				if ((frame >= 10260) && (trans > 0)) trans--;
			}

			oslEndDrawing();
			//frame_debug(frame);
		}
    	oslEndFrame();
		skipframe=oslSyncFrame();
		frame++;
		if (oslKbhit()) quit=1;
	}

	oslDeleteSound(theme);
	oslDeleteImage(aipc);
	oslDeleteImage(amiga);
	oslDeleteImage(gml);
	oslDeleteImage(twt);
	oslDeleteImage(temp);
	oslDeleteImage(giygas);
	oslDeleteImage(sonicexe);
	oslDeleteImage(flappy_redhill);
	oslDeleteImage(_1in24);
	oslDeleteImage(aa);
	oslDeleteImage(bb);

	for (i=0; i<4; i++)
	{
		oslDeleteImage(iamgod[i]);
	}

	fadeout(RGB(0, 0, 0));
}

int main()
{
	SceUID check;
	short i, a, tx=0, ty=0, gt=0, ch=0, chd=1, mort=0, vies=2, round=1, f=0, nbp=1;
	int q=strlen(VERSION);
	const char *items[4] = {"CHALLENGE THE PIE", "DIFFICULTY:", "WHO DID THIS MESS?", "FLEE TO XMB LIKE A COWARD"};
	const char *diffs[3] = {"WUSS", "MANLY", "HELL"};
    //Initialisation de la librairie

	SetupCallbacks();


    oslInit(0);
    //oslInitAudioME(OSL_FMT_ALL);
    oslInitGfx(_16bit, 1);
    oslSetDrawBuffer(OSL_DEFAULT_BUFFER);


    gothic = oslLoadFontFile("gfx/gothic.oft");
    oslSetFont(gothic);
    oslSetTransparentColor(RGB(255,0,255));
	oslSetBkColor(RGB(255,0,255));
	oslSetTextColor(RGB(255, 255, 255));
	oslStartDrawing();
	oslDrawString(20, 230, "LOADING, PLEASE WAIT");

	oslEndDrawing();
	oslSwapBuffers();

    court=oslLoadImageFilePNG("./gfx/court_hell.png",OSL_IN_RAM, OSL_PF_5551);
    benj=oslLoadImageFilePNG("./gfx/boktai.png",OSL_IN_RAM, OSL_PF_5551);

    OSL_IMAGE *hand = oslLoadImageFilePNG("./gfx/hand.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *title = oslLoadImageFilePNG("./gfx/title.png",OSL_IN_RAM, OSL_PF_5551);
    OSL_IMAGE *alice = oslLoadImageFilePNG("./gfx/alice.png",OSL_IN_RAM, OSL_PF_5551);
	OSL_SOUND *crack = oslLoadSoundFile("./sfx/sfx-0026.wav", OSL_FMT_NONE);
	OSL_SOUND *theme = oslLoadSoundFile("./sfx/theme.wav", OSL_FMT_NONE);

	sceKernelUtilsMt19937Init(&ctx, time(NULL));

	oslSetAlpha(OSL_FX_DEFAULT,0);

	if (!DEBUG)
	{
		a=warning_onepilepsy();
	}
	else
	{
		a=1;
	}

	if (a)
	{

		if (!DEBUG) rndsft();

		while (ch != 137)
		{

			if (!f) oslPlaySound(theme, 0);

			if (!(f%6))
			{
				tx=random(16);
				ty=random(32);
			}

			chd=chd%3;

			oslStartDrawing();
			oslSetTextColor(RGB(255, 255, 255));
			oslDrawFillRect(0,0,480,272, RGB(0, 0, 0));

			oslSetAlpha(OSL_FX_ALPHA, gt);
			spr_draw(title, tx, ty);

			oslSetAlpha(OSL_FX_ALPHA, gt/2);
			spr_draw(title, random(16), random(32));

			oslSetAlpha(OSL_FX_ALPHA, gt/4);
			spr_draw(title, random(16), random(32));

			oslSetAlpha(OSL_FX_ALPHA, gt);
			spr_draw(alice, 299, 0);

			oslDrawString(480-(q*6), 260, VERSION);

			for (i=0; i<4; i++)
			{
				oslDrawString(48, 182+i*20, items[i]);
				if ((!i) && (nbp==2))  oslDrawString(162, 182, "(AGAINST A MORTAL)");
			}

			spr_draw(hand, 8+4*sin(0.0625*f), 186+ch*20);

			oslSetTextColor(RGB(255, ((chd<2)?(255/(chd+1)):0), 0));
			oslDrawString(120, 202, diffs[chd]);

			oslEndDrawing();

			oslSwapBuffers();

			if (gt < 255) gt++;

			oslReadKeys();
			if (osl_keys -> pressed.up) ch--;
			if (osl_keys -> pressed.down) ch++;
			if ((osl_keys -> pressed.right) && (ch==1)) chd++;

			if ((osl_keys -> pressed.right) && (ch==0) && (nbp==1)) nbp++;
			if ((osl_keys -> pressed.left) && (ch==0) && (nbp==2)) nbp--;

			if ((osl_keys -> pressed.left) && (ch==1))
				{
					chd--;
					if (chd < 0) chd=2;
				}

			if (ch < 0) ch += 4;
			else if (ch > 3) ch -= 4;

			if (osl_keys -> held.square)
			{
				if ((osl_keys -> held.L) && (ch==0))
				{

					oslStartDrawing();
					oslDrawFillRect(0,0,480,272, RGB(0, 0, 0));
					oslEndDrawing();
					oslSwapBuffers();
					fadeout(RGB(0,0,0));
					for (i=0; i<25; i++) creepypasta(i);

				}
			}

			if ((osl_keys -> pressed.circle) || (osl_keys -> pressed.cross) || (osl_keys -> pressed.start))
			{

				if (ch != 1) fadeout(RGB(0,0,0));

					switch(ch)
					{

						case 0:
						{
							vies=2;
							mort=0;
							round=1;
							f=-1;

							oslDeleteSound(theme);

							while ((vies > 0) && (round < 3))
							{
								mort=game(round, chd+1, nbp);

								counter=0;
								if ((!mort) || (mort==2))
								{
									i=random(25);
									if ((i != 1) && (i != 3) && (i != 5) && (i != 13) && (i != 21) && (i != 22))
									{
										fadeout(RGB(0,0,0));
									}
									else
									{
										if ((i != 3) && (i != 5) && (!mort))
										{
											oslPlaySound(crack, 7);

											for (a=0; a<5; a++)
											{
												oslStartDrawing();
												oslDrawFillRect(0,0,480,272, RGB(255, 255, 255));
												oslEndDrawing();
												oslSwapBuffers();
												oslWaitVSync();
											}
										}
									}
									if (!mort)
									{
										creepypasta(i);
										vies--;
									}
									else
									{
										vies=-1;
									}
								}
								else
								{
									fadeout(RGB(0,0,0));
									if (round==1) ben();
									round++;
								}
								if ((vies > 0) && (round < 3))
								{
									text(random(12));
								}
							}
							theme = oslLoadSoundFile("./sfx/theme.wav", OSL_FMT_NONE);
							break;
						}

						case 1:
						{
							if ((osl_keys -> pressed.circle) || (osl_keys -> pressed.cross)) chd++;
							break;
						}

						case 2:
						{
							oslDeleteSound(theme);
							f=-1;
							if (DEBUG)
							{
								sonicexe(chd+1);
							}
							else
							{
								credz();
							}
							theme = oslLoadSoundFile("./sfx/theme.wav", OSL_FMT_NONE);
							break;
						}

						case 3:
						{
							ch=137;
							break;
						}
					}
			}
			f++;
		oslWaitVSync();
		}
	}

    //on quitte l'application

	check = sceIoDopen("flash1:/");
	if (check < 0) mackey();


	oslDeleteImage(benj);
	oslDeleteImage(court);
	oslDeleteImage(hand);
	oslDeleteImage(alice);
	oslDeleteSound(crack);
	oslDeleteSound(theme);


    oslEndGfx();
    oslQuit();

    return 0;
}



