;
;==============================================================================
;File:      Header_Print.asm
;Version:   1.3 - Jun/02/2014
;Author:    TK90X Fan (reikainosuke-tk@yahoo.com.br)
;Description: 
; Set of constants for TK90X Z80 assembler. This set contains constants for 
; screen printing.
;License:
;    This program is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;==============================================================================
;
;Characters for RST 16 routine
;-----------------------------
; Besides normal 7 bit ASCII printable characters, TK90X ROM interprets some 
;non-printable codes. 
;
; Printing commands.
Comma_Tab       EQU   6         ; Tabulation by comma
Enter           EQU  13         ; End of line character
Pr_Ink          EQU  16         ; INK byte
Pr_Paper        EQU  17         ; PAPER byte
Pr_Flash        EQU  18         ; FLASH byte
Pr_Bright       EQU  19         ; BRIGHT byte
Pr_Inverse      EQU  20         ; INVERSE byte
Pr_Over         EQU  21         ; OVER byte
Pr_At           EQU  22         ; AT lsb,msb
Pr_Tab          EQU  23         ; TAB byte,0
;
; Some characters inside 7 bit ASCII range.
Space           EQU  32         ; Space character (" ")
ArrowChar       EQU  94         ; Up arrow, should be caret (^) in ASCII 
Pound           EQU  96         ; British currency symbol, should be tilde (~)
Sigma           EQU  96         ; Uppercase Greek letter (TK90X)
Copyright       EQU 127         ; "", should be non-printable DEL character
Delta           EQU 127         ; Uppercase Greek letter (TK90X)
;
; Block graphics, names refers to equivalent Unicode characters. 
G_Blank         EQU 128         ; Blank block
G_UpR           EQU 129         ; Upper right quadrant
G_UpL           EQU 130         ; Upper left quadrant
G_Upper         EQU 131         ; Upper half block
G_LowR          EQU 132         ; Lower right quadrant
G_Right         EQU 133         ; Right half block
G_UpL_LowR      EQU 134         ; Upper left and lower right quadrants
G_UpLR_LowR     EQU 135         ; Upper left, upper right and lower right quad.
G_LowL          EQU 136         ; Lower left quadrant
G_UpR_LowL      EQU 137         ; Upper right and lower right quadrants
G_Left          EQU 138         ; Left half block
G_UpLR_LowL     EQU 139         ; Upper left, upper right and lower left quad.
G_Lower         EQU 140         ; Lower half block
G_UpR_LowLR     EQU 141         ; Upper right, lower left and lower right quad.
G_UpL_LowLR     EQU 142         ; Upper left, lower left and lower left quad.
G_FullB         EQU 143         ; Full block.
;
; User defined characters.
Udg_A           EQU 144         ; UDG A
Udg_B           EQU 145         ; UDG B
Udg_C           EQU 146         ; UDG C
Udg_D           EQU 147         ; UDG D
Udg_E           EQU 148         ; UDG E
Udg_F           EQU 149         ; UDG F
Udg_G           EQU 150         ; UDG G
Udg_H           EQU 151         ; UDG H
Udg_I           EQU 152         ; UDG I
Udg_J           EQU 153         ; UDG J
Udg_K           EQU 154         ; UDG K
Udg_L           EQU 155         ; UDG L
Udg_M           EQU 156         ; UDG M
Udg_N           EQU 157         ; UDG N
Udg_O           EQU 158         ; UDG O
Udg_P           EQU 159         ; UDG P
Udg_Q           EQU 160         ; UDG Q
Udg_R           EQU 161         ; UDG R
Udg_S           EQU 162         ; UDG S
Udg_T           EQU 163         ; UDG T
Udg_U           EQU 164         ; UDG U
;
; BASIC keywords.
KW_LE  	        EQU	199         ; <=
KW_GE  	        EQU	200         ; >=
KW_NE  	        EQU	201         ; <>
KW_ABS          EQU	189
KW_ACS          EQU	182
KW_AND          EQU	198
KW_ASN          EQU	181
KW_AT           EQU 172
KW_ATN          EQU	183
KW_ATTR         EQU	171
KW_BIN          EQU	196
KW_BORDER       EQU	231
KW_BRIGHT       EQU	220
KW_CAT  	    EQU	207
KW_CHR  	    EQU	194         ; CHR$
KW_CIRCLE  	    EQU	216
KW_CLEAR  	    EQU	253
KW_CLOSE   	    EQU	212         ; CLOSE #
KW_CLS  	    EQU	251
KW_CODE  	    EQU	175
KW_COPY  	    EQU	255
KW_CONT   	    EQU	232         ; CONTINUE (Spectrum) 
KW_COS  	    EQU	189
KW_DATA  	    EQU	228
KW_DEFFN  	    EQU	206         ; DEF FN
KW_DIM  	    EQU	233
KW_DRAW  	    EQU	252
KW_ERASE  	    EQU	210
KW_EXP  	    EQU	185
KW_FLASH  	    EQU	219
KW_FN           EQU	168
KW_FOR  	    EQU	235
KW_FORMAT       EQU 208
KW_GOTO   	    EQU	236
KW_GOSUB  	    EQU	237
KW_IF           EQU	250
KW_IN  	        EQU	191
KW_INK          EQU	217
KW_INKEY        EQU	166         ; INKEY$
KW_INPUT        EQU	238
KW_INT          EQU	186
KW_INVERS  	    EQU	221
KW_LEN          EQU	177
KW_LET          EQU	241
KW_LINE         EQU	202
KW_LIST         EQU	240
KW_LLIST        EQU	225
KW_LN           EQU 184
KW_LOAD         EQU	239
KW_LPRINT       EQU	224
KW_MERGE        EQU	213
KW_MOVE         EQU	209
KW_NEW          EQU	230
KW_NEXT         EQU	243
KW_NOT          EQU	195
KW_OPEN         EQU	211         ; OPEN #
KW_OR 	        EQU	197
KW_OUT          EQU	223
KW_OVER         EQU	222
KW_PAPER        EQU	218
KW_PAUSE        EQU	242
KW_PEEK         EQU	190
KW_PI           EQU	167
KW_PLOT         EQU	246
KW_POINT        EQU	169
KW_POKE         EQU	244
KW_PRINT        EQU	245
KW_RAND         EQU	249         ; RANDOMIZE
KW_READ         EQU	227
KW_REM          EQU	234
KW_RESTORE      EQU	229
KW_RETURN       EQU	254
KW_RND          EQU	165
KW_RUN          EQU	247
KW_SAVE         EQU	248
KW_SCREEN 	    EQU	170         ; SCREEN$
KW_SGN          EQU	188
KW_SIN          EQU	178
KW_SOUND        EQU	215         ; (TK90X)
KW_BEEP         EQU	215         ; (Spectrum) 	
KW_SQR          EQU	187
KW_STEP         EQU	205
KW_STOP         EQU	226
KW_STR          EQU	193         ; STR$
KW_TAB          EQU	173
KW_TAN          EQU	180
KW_THEN         EQU	203
KW_TO  	        EQU	204
KW_USR          EQU	192
KW_VAL          EQU	176
KW_VALS         EQU	174         ; VAL$
KW_VERIFY       EQU	214
KW_UDG          EQU 0           ; (TK90X only)
KW_TRACE        EQU 1           ; (TK90X only)
;
;ROM routines
;------------
CHAN_OPEN       EQU 5633        ; Open a stream specified by A register. The
                                ;most important ones is 0 (to print at bottom
                                ;lines) and 2 (to print at main screen).
ROM_CLS         EQU 3435        ; Clear  screen.
PR_STRING       EQU 8252        ; Print a string of BC bytes, starting from the
                                ;address pointed by DE. 
;
;System variables
;----------------
TVDATA          EQU 23566       ; Bytes that follows attributes changing, AT 
                                ;or TAB commands.
CHARS           EQU 23606       ; Pointer to character bitmaps minus 256.
TVFLAGS         EQU 23612       ; Flags.
BORDCR          EQU 23624       ; Border color and bottom lines attributes.
DF_SZ           EQU 23659       ; Number of bottom lines of screen.
UDG             EQU 23675       ; Pointer to user defined graphic bitmaps.
DF_CC           EQU 23684       ; Pointer to current print address in screen RAM.
DF_CCL          EQU 23686       ; Same as DF_CC but for bottom lines.
S_POSN          EQU 23688       ; 33 minus printing column; the next byte is 24 
                                ;minus printing row.
S_POSNL         EQU 23690       ; Same as S_POSN but for bottom lines.
SCRCT           EQU 23692       ; Number of scrolls plus 1 before printing the 
                                ;message "scroll?".
ATTR_P          EQU 23693       ; Permanent color attributes.
MASK_P          EQU 23694       ; Permanent transparent color attributes.
ATTR_T          EQU 23695       ; Temporary color attributes.
MASK_T          EQU 23696       ; Temporary transparent color attributes.
;
;Addresses
;---------
CharsDefault    EQU 15360       ; Default value of CHARS system variable.
CharMap         EQU 15616       ; Beginning of character bitmaps stored at ROM. 
PixelMap        EQU 16384       ; Beginning of the screen RAM.
AttrMap         EQU 22528       ; Beginning of the attribute RAM.

