	rem ===========================================
	rem "The Art of Scrolling Without Scrolling"
	rem Pseudo Vertical Scrolling Demo
	rem Blake 'SmittyB' Smith
	rem 2020/06/03 from about 11:07 'til 17:05
	rem ===========================================
	set romsize 128kRAM : rem We need the extra RAM to store the 4K block of graphics
	set zoneheight 16
	set screenheight 224
	displaymode 160A
	

	dim frameCounter = a
	frameCounter = 0
	
	dim colourCycle1 = b
	dim colourCycle2 = c
	dim colourCycle3 = D
	
	colourCycle1 = #$96
	colourCycle2 = #$98
	colourCycle3 = #$9A
	
	dim customTemp1 = e
	dim customTemp2 = f
	dim customTemp3 = g
	dim customTemp4 = h
	
	dim playerX = i
	dim playerY = j
	
	playerX = 74
	playerY = 176
	
	rem k,l,m,
	dim enemyX = k
	
	rem s,t,u,
	dim enemyY = s

	for customTemp1 = 0 to 3
	customTemp2 = rand
	customTemp2 = customTemp2
	enemyY[customTemp1] = customTemp2
	
	customTemp2 = rand&#%01111111
	customTemp2 = customTemp2+16
	enemyX[customTemp1] = customTemp2
	next
	
	rem Background colour for grass because I'm lazy
	BACKGRND = #$C4
	
	rem Palette 0 for colour-cycling water
	P0C1 = colourCycle1
	P0C2 = colourCycle2
	P0C3 = colourCycle3
	
	rem Palette 1 for valley walls
	P1C1 = #$10
	P1C2 = #$13
	P1C3 = #$15
	
	rem Palette 2 for player
	P2C1 = #$03
	P2C2 = #$07
	P2C3 = #$0A
	
	rem Palette 3 for enemies
	P3C1 = #$53
	P3C2 = #$57
	P3C3 = #$5A
	
	rem Import our graphics into ROM at address $A000
	incgraphic gfx/background.png 160A 1 2 3 0
	
	rem Import other graphics
	incbanner gfx/Player/Player.png 160A 0 2 3 1
	incbanner gfx/Player/PlayerLeft.png 160A 0 2 3 1
	incbanner gfx/Player/PlayerRight.png 160A 0 2 3 1
	
	incgraphic gfx/Player/PlayerJetNormal.png 160A 0 1 2 3
	incgraphic gfx/Player/PlayerJetLeftRight.png 160A 0 1 2 3
	
	incbanner gfx/Enemy/Enemy0.png 160A 0 2 3 1
	incbanner gfx/Enemy/Enemy1.png 160A 0 2 3 1
	incbanner gfx/Enemy/Enemy2.png 160A 0 2 3 1
	incbanner gfx/Enemy/Enemy3.png 160A 0 2 3 1
	
	rem ===============================================================
	rem Copy 4K bytes of graphics data from $A000 (ROM) to $4000 (RAM)
	rem ===============================================================
	asm
	ldy #0
.tilesetCopyLoop ;Copy graphics from ROM to RAM
	
	lda $A000,y
	sta $4000,y
	
	lda $A100,y
	sta $4100,y
	
	lda $A200,y
	sta $4200,y
	
	lda $A300,y
	sta $4300,y
	
	lda $A400,y
	sta $4400,y
	
	lda $A500,y
	sta $4500,y
	
	lda $A600,y
	sta $4600,y
	
	lda $A700,y
	sta $4700,y
	
	lda $A800,y
	sta $4800,y
	
	lda $A900,y
	sta $4900,y
	
	lda $AA00,y
	sta $4A00,y
	
	lda $AB00,y
	sta $4B00,y
	
	lda $AC00,y
	sta $4C00,y
	
	lda $AD00,y
	sta $4D00,y
	
	lda $AE00,y
	sta $4E00,y
	
	lda $AF00,y
	sta $4F00,y
	
	dey
	bne .tilesetCopyLoop
end
	

	rem =======================================================
	rem Manually set up the 3 background objects for each zone
	rem =======================================================
	clearscreen
	
	asm
	;~~~~~~~~~~~~~~
	;Initial Setup
	;~~~~~~~~~~~~~~
	lda #(background_mode|%01000000)
	sta temp6 ;Graphics mode - 160A in this case
	
	
	;Here I'm manually setting the palette and width to be what I want
	;lda #(32|background_width_twoscompliment)
	;sta temp3 ;Palette and width
	
	lda #%00110100
	sta temp3 ;Palette and width - 001 is the palette 10100 is the width. -12 in 2's complement with 5 bits
	
	
	;~~~~~~~~~~~~~~
	;Left Wall
	;~~~~~~~~~~~~~~
	;We don't want to load the graphics from where they are in ROM
	;lda #<background
	;sta temp1 ;low byte of the graphics address
	;lda #>background
	;sta temp2 ;high byte of the graphics address
	
	;Load them from address $4000 instead
	lda #$00
	sta temp1 ;low byte of the graphics address
	lda #$40
	sta temp2 ;high byte of the graphics address
	
	
	
	lda #0
	sta temp4 ;x position
	
	lda #0
	sta temp5 ;y position

	jsr plotsprite ;Create the object
	
	lda #16
	sta temp5
	jsr plotsprite ;Draw the one for the next zone
	
	lda #32
	sta temp5
	jsr plotsprite ;Etc
	
	lda #48
	sta temp5
	jsr plotsprite
	
	lda #64
	sta temp5
	jsr plotsprite
	
	lda #80
	sta temp5
	jsr plotsprite
	
	lda #96
	sta temp5
	jsr plotsprite
	
	lda #112
	sta temp5
	jsr plotsprite
	
	lda #128
	sta temp5
	jsr plotsprite
	
	lda #144
	sta temp5
	jsr plotsprite
	
	lda #160
	sta temp5
	jsr plotsprite
	
	lda #176
	sta temp5
	jsr plotsprite
	
	lda #192
	sta temp5
	jsr plotsprite
	
	lda #208
	sta temp5
	jsr plotsprite
	
	
	;~~~~~~~~~~~~~~
	;Right Wall
	;~~~~~~~~~~~~~~
	;Load graphics from address $400C (the high byte hasn't changed so we don't need to reset it)
	lda #$0C
	sta temp1 ;low byte of the graphics address
	
	
	lda #112
	sta temp4 ;x position
	
	lda #0
	sta temp5 ;y position

	jsr plotsprite ;Create the object
	
	lda #16
	sta temp5
	jsr plotsprite ;Draw the one for the next zone
	
	lda #32
	sta temp5
	jsr plotsprite ;Etc
	
	lda #48
	sta temp5
	jsr plotsprite
	
	lda #64
	sta temp5
	jsr plotsprite
	
	lda #80
	sta temp5
	jsr plotsprite
	
	lda #96
	sta temp5
	jsr plotsprite
	
	lda #112
	sta temp5
	jsr plotsprite
	
	lda #128
	sta temp5
	jsr plotsprite
	
	lda #144
	sta temp5
	jsr plotsprite
	
	lda #160
	sta temp5
	jsr plotsprite
	
	lda #176
	sta temp5
	jsr plotsprite
	
	lda #192
	sta temp5
	jsr plotsprite
	
	lda #208
	sta temp5
	jsr plotsprite
	
	
	;~~~~~~~~~~~~~~
	;Water
	;~~~~~~~~~~~~~~
	;Load graphics from address $4018 (the high byte hasn't changed so we don't need to reset it)
	lda #$18
	sta temp1 ;low byte of the graphics address
	
	lda #%00011000
	sta temp3 ;Palette and width - 000 is the palette 10100 is the width. -8 in 2's complement with 5 bits
	
	lda #64
	sta temp4 ;x position
	
	lda #0
	sta temp5 ;y position

	jsr plotsprite ;Create the object
	
	lda #16
	sta temp5
	jsr plotsprite ;Draw the one for the next zone
	
	lda #32
	sta temp5
	jsr plotsprite ;Etc
	
	lda #48
	sta temp5
	jsr plotsprite
	
	lda #64
	sta temp5
	jsr plotsprite
	
	lda #80
	sta temp5
	jsr plotsprite
	
	lda #96
	sta temp5
	jsr plotsprite
	
	lda #112
	sta temp5
	jsr plotsprite
	
	lda #128
	sta temp5
	jsr plotsprite
	
	lda #144
	sta temp5
	jsr plotsprite
	
	lda #160
	sta temp5
	jsr plotsprite
	
	lda #176
	sta temp5
	jsr plotsprite
	
	lda #192
	sta temp5
	jsr plotsprite
	
	lda #208
	sta temp5
	jsr plotsprite
end
	savescreen
	
	rem =======================================================
	rem Main Loop
	rem =======================================================
mainloop
	rem increment the frame counter
	frameCounter=frameCounter+1
	
	
	rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	rem Cycle the colours of Palette 0
	rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	rem Don't cycle the water colours except on every 8th frame
	if frameCounter & #%00000111 then goto skipColourCycle
	asm
	;lda #%00000111 
	;bit frameCounter
	;bne .skipColourCycle
end
	customTemp1 = colourCycle3
	colourCycle3 = colourCycle2
	colourCycle2 = colourCycle1
	colourCycle1 = customTemp1
	
	P0C1 = colourCycle1
	P0C2 = colourCycle2
	P0C3 = colourCycle3
skipColourCycle
	
	gosub shiftTiles
	rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	rem Usual drawing and looping
	rem ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	for customTemp1 = 0 to 3
	enemyY[customTemp1] = enemyY[customTemp1]+1
	customTemp2 = rand&#%01111111
	customTemp2 = customTemp2+16
	if enemyY[customTemp1]=243 then enemyX[customTemp1] = customTemp2
	next
	
	if joy0up && playerY>0 then playerY=playerY-1
	if joy0down && playerY<176 then playerY=playerY+1
	
	restorescreen
	
	customTemp1 = playerY+16
	if joy0left && playerX>0 then playerX = playerX-1: plotbanner PlayerLeft 2 playerX playerY : plotsprite PlayerJetLeftRight 0 playerX customTemp1 : goto skipDrawPlayer
	if joy0right && playerX<148 then playerX = playerX+1 : plotbanner PlayerRight 2 playerX playerY : plotsprite PlayerJetLeftRight 0 playerX customTemp1 : goto skipDrawPlayer
	plotbanner Player 2 playerX playerY
	plotsprite PlayerJetNormal 0 playerX customTemp1
skipDrawPlayer

	customTemp4 = frameCounter & #%00011100
	customTemp4 = customTemp4/4
	for customTemp1 = 0 to 3
	customTemp2 = enemyX[customTemp1]
	customTemp3 = enemyY[customTemp1]
	
	if customTemp4 = 0 then	plotbanner Enemy0 3 customTemp2 customTemp3
	if customTemp4 = 1 then	plotbanner Enemy1 3 customTemp2 customTemp3
	if customTemp4 = 2 then	plotbanner Enemy2 3 customTemp2 customTemp3
	if customTemp4 = 3 then	plotbanner Enemy3 3 customTemp2 customTemp3
	if customTemp4 = 4 then	plotbanner Enemy3 3 customTemp2 customTemp3
	if customTemp4 = 5 then	plotbanner Enemy2 3 customTemp2 customTemp3
	if customTemp4 = 6 then	plotbanner Enemy1 3 customTemp2 customTemp3
	if customTemp4 = 7 then	plotbanner Enemy0 3 customTemp2 customTemp3
	next

	drawscreen
	
	goto mainloop thisbank
	
	rem =======================================================
	rem Graphics Shifting
	rem =======================================================	
shiftTiles

	rem Assuming the gameplay travels down the screen 1 pixel a frame,
	rem scrolling the same amount would put that at the same depth.
	rem More than once every frame would be in front of the gameplay.
	rem Less than once every frame would be in the background.
	
	rem Below are several methods of timing shifts and the same column
	rem can be shifted by several methods to allow for even more variations
	
	rem Shifting Ratios in Pixels per Frame
	rem 1/1 = 1
	rem 63/64 = 0.98
	rem 31/32 = 0.96
	rem 15/16 = 0.93
	rem 7/8 = 0.87
	rem 3/4 = 0.75
	rem 1/2 = 0.50
	rem 1/4 = 0.25
	rem 1/8 = 0.12
	rem 1/16 = 0.06
	rem 1/32 = 0.03
	rem 1/64 = 0.01
	

shiftEveryFrame
	rem Insert calls to shiftColumn here
	customTemp1 = 0
	gosub shiftColumn
	customTemp1 = 23
	gosub shiftColumn
	
	
	asm
	lda #%00111111
	bit frameCounter
	beq .skipAShiftEvery64Frames
end
	rem Insert calls to shiftColumn here
	customTemp1 = 1
	gosub shiftColumn
	customTemp1 = 22
	gosub shiftColumn
skipAShiftEvery64Frames
	
	asm
	lda #%00011111
	bit frameCounter
	beq .skipAShiftEvery32Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 2
	gosub shiftColumn
	customTemp1 = 21
	gosub shiftColumn
skipAShiftEvery32Frames
	
	asm
	lda #%00001111
	bit frameCounter
	beq .skipAShiftEvery16Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 3
	gosub shiftColumn
	customTemp1 = 20
	gosub shiftColumn
skipAShiftEvery16Frames
	
	asm
	lda #%00000111
	bit frameCounter
	beq .skipAShiftEvery8Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 4
	gosub shiftColumn
	customTemp1 = 19
	gosub shiftColumn
skipAShiftEvery8Frames

	asm
	lda #%00000011
	bit frameCounter
	beq .skipAShiftEvery4Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 5
	gosub shiftColumn
	customTemp1 = 18
	gosub shiftColumn
skipAShiftEvery4Frames

	asm
	lda #%00000001
	bit frameCounter
	beq .skipAShiftEveryOtherFrame
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 6
	gosub shiftColumn
	customTemp1 = 17
	gosub shiftColumn
	
skipAShiftEveryOtherFrame


	asm
	lda #%00000011
	bit frameCounter
	bne .shiftEvery4Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 7
	gosub shiftColumn
	customTemp1 = 16
	gosub shiftColumn
shiftEvery4Frames

	asm
	lda #%00000111
	bit frameCounter
	bne .shiftEvery8Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 8
	gosub shiftColumn
	customTemp1 = 15
	gosub shiftColumn
shiftEvery8Frames

	asm
	lda #%00001111
	bit frameCounter
	bne .shiftEvery16Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 9
	gosub shiftColumn
	customTemp1 = 14
	gosub shiftColumn
shiftEvery16Frames

	asm
	lda #%00011111
	bit frameCounter
	bne .shiftEvery32Frames
end	
	rem Insert calls to shiftColumn here
	customTemp1 = 10
	gosub shiftColumn
	customTemp1 = 13
	gosub shiftColumn
shiftEvery32Frames

	asm
	lda #%00111111
	bit frameCounter
	bne .shiftEvery64Frames
end
	rem Insert calls to shiftColumn here
	customTemp1 = 11
	gosub shiftColumn
	customTemp1 = 12
	gosub shiftColumn
shiftEvery64Frames
	return
	
shiftColumn
	asm
	;~~~~~~~~~~~~~~~~
	;Scrolling Down
	;~~~~~~~~~~~~~~~~
	ldx customTemp1 ; Tile Index to shift
	
	
	lda $4000,x	;Copy bottom line temporarily
	sta temp1
	
	lda $4100,x	;Replace each line with the value above it
	sta $4000,x
	
	lda $4200,x
	sta $4100,x
	
	lda $4300,x
	sta $4200,x
	
	lda $4400,x
	sta $4300,x

	lda $4500,x
	sta $4400,x

	lda $4600,x
	sta $4500,x

	lda $4700,x
	sta $4600,x
	
	lda $4800,x
	sta $4700,x
	
	lda $4900,x
	sta $4800,x
	
	lda $4A00,x
	sta $4900,x
	
	lda $4B00,x
	sta $4A00,x
	
	lda $4C00,x
	sta $4B00,x
	
	lda $4D00,x
	sta $4C00,x
	
	lda $4E00,x
	sta $4D00,x
	
	lda $4F00,x
	sta $4E00,x
	
	lda temp1	;Set the top line to be the temp value from the lowest line
	sta $4F00,x
end
	return