goo.ShaderLibExtra=function(e,t,o,r,i,a){"use strict";function n(){}return n.billboard={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,viewMatrix:t.VIEW_MATRIX,worldMatrix:t.WORLD_MATRIX,diffuseMap:t.DIFFUSE_MAP},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewProjectionMatrix;","uniform mat4 worldMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","varying vec2 texCoord0;","void main(void) {","texCoord0 = vertexUV0;","gl_Position = viewProjectionMatrix * worldMatrix * vec4(0.0, 0.0, 0.0, 1.0) + projectionMatrix * vec4(vertexPosition.x, vertexPosition.y, 0.0, 0.0);","}"].join("\n"),fshader:["uniform sampler2D diffuseMap;","varying vec2 texCoord0;","void main(void)","{","gl_FragColor = texture2D(diffuseMap, texCoord0);","}"].join("\n")},n.showDepth={attributes:{vertexPosition:e.POSITION},uniforms:{viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,near:t.NEAR_PLANE,far:t.FAR_PLANE},vshader:["attribute vec3 vertexPosition;","uniform mat4 viewProjectionMatrix;","uniform mat4 worldMatrix;","void main(void) {","gl_Position = viewProjectionMatrix * (worldMatrix * vec4(vertexPosition, 1.0));","}"].join("\n"),fshader:["uniform float near;","uniform float far;","void main(void)","{","float depth = gl_FragCoord.z / gl_FragCoord.w;","float d = 1.0 - smoothstep( near, far, depth );","gl_FragColor = vec4(d);","}"].join("\n")},n.bokehShader={attributes:{position:e.POSITION,uv:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tColor:t.DIFFUSE_MAP,tDepth:t.DEPTH_MAP,focus:1,aspect:1,aperture:.025,maxblur:1},vshader:["attribute vec3 position;","attribute vec2 uv;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = uv;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( position, 1.0 );","}"].join("\n"),fshader:["varying vec2 vUv;","uniform sampler2D tColor;","uniform sampler2D tDepth;","uniform float maxblur;","uniform float aperture;","uniform float focus;","uniform float aspect;","void main() {","vec2 aspectcorrect = vec2( 1.0, aspect );","vec4 depth1 = texture2D( tDepth, vUv );","float factor = depth1.x - focus;","vec2 dofblur = vec2 ( clamp( factor * aperture, -maxblur, maxblur ) );","vec2 dofblur9 = dofblur * 0.9;","vec2 dofblur7 = dofblur * 0.7;","vec2 dofblur4 = dofblur * 0.4;","vec4 col = vec4( 0.0 );","col += texture2D( tColor, vUv.xy );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,   0.4  ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.15,  0.37 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29,  0.29 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.37,  0.15 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.40,  0.0  ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.37, -0.15 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29, -0.29 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.15, -0.37 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,  -0.4  ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.15,  0.37 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29,  0.29 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.37,  0.15 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.4,   0.0  ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.37, -0.15 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29, -0.29 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.15, -0.37 ) * aspectcorrect ) * dofblur );","col += texture2D( tColor, vUv.xy + ( vec2(  0.15,  0.37 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.37,  0.15 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.37, -0.15 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.15, -0.37 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.15,  0.37 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.37,  0.15 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.37, -0.15 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.15, -0.37 ) * aspectcorrect ) * dofblur9 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29,  0.29 ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.40,  0.0  ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29, -0.29 ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,  -0.4  ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29,  0.29 ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.4,   0.0  ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29, -0.29 ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,   0.4  ) * aspectcorrect ) * dofblur7 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29,  0.29 ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.4,   0.0  ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.29, -0.29 ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,  -0.4  ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29,  0.29 ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.4,   0.0  ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2( -0.29, -0.29 ) * aspectcorrect ) * dofblur4 );","col += texture2D( tColor, vUv.xy + ( vec2(  0.0,   0.4  ) * aspectcorrect ) * dofblur4 );","gl_FragColor = col / 41.0;","gl_FragColor.a = 1.0;","}"].join("\n")},n.sepia={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,amount:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform float amount;","uniform sampler2D tDiffuse;","varying vec2 vUv;","void main() {","vec4 color = texture2D(tDiffuse, vUv );","vec3 c = color.rgb;","color.r = dot(c, vec3(1.0 - 0.607 * amount, 0.769 * amount, 0.189 * amount));","color.g = dot(c, vec3(0.349 * amount, 1.0 - 0.314 * amount, 0.168 * amount));","color.b = dot(c, vec3(0.272 * amount, 0.534 * amount, 1.0 - 0.869 * amount));","gl_FragColor = vec4(min(vec3(1.0), color.rgb), color.a);","}"].join("\n")},n.dotscreen={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,tSize:[256,256],center:[.5,.5],angle:1.57,scale:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform vec2 center;","uniform float angle;","uniform float scale;","uniform vec2 tSize;","uniform sampler2D tDiffuse;","varying vec2 vUv;","float pattern() {","float s = sin( angle ), c = cos( angle );","vec2 tex = vUv * tSize - center;","vec2 point = vec2( c * tex.x - s * tex.y, s * tex.x + c * tex.y ) * scale;","return ( sin( point.x ) * sin( point.y ) ) * 4.0;","}","void main() {","vec4 color = texture2D( tDiffuse, vUv );","float average = ( color.r + color.g + color.b ) / 3.0;","gl_FragColor = vec4( color.rgb * vec3( average * 10.0 - 5.0 + pattern() ), color.a );","}"].join("\n")},n.vignette={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,offset:1,darkness:1.5},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform float offset;","uniform float darkness;","uniform sampler2D tDiffuse;","varying vec2 vUv;","void main() {","vec4 texel = texture2D( tDiffuse, vUv );","vec2 uv = ( vUv - vec2( 0.5 ) ) * vec2( offset );","gl_FragColor = vec4( mix( texel.rgb, vec3( 1.0 - darkness ), dot( uv, uv ) ), texel.a );","}"].join("\n")},n.film={attributes:i.copy.attributes,uniforms:{tDiffuse:t.DIFFUSE_MAP,time:t.TIME,nIntensity:.5,sIntensity:.5,sCount:1024,grayscale:0,viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,opacity:1,diffuseMap:t.DIFFUSE_MAP},vshader:i.copy.vshader,fshader:["uniform float time;","uniform bool grayscale;","uniform float nIntensity;","uniform float sIntensity;","uniform float sCount;","uniform sampler2D tDiffuse;","varying vec2 texCoord0;","void main() {","vec4 cTextureScreen = texture2D( tDiffuse, texCoord0 );","float x = texCoord0.x * texCoord0.y * time * 1000.0;","x = mod( x, 13.0 ) * mod( x, 123.0 );","float dx = mod( x, 0.01 );","vec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );","vec2 sc = vec2( sin( texCoord0.y * sCount ), cos( texCoord0.y * sCount ) );","cResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;","cResult = cTextureScreen.rgb + nIntensity * ( cResult - cTextureScreen.rgb );","if ( grayscale ) {","	cResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );","}","gl_FragColor = vec4( cResult, cTextureScreen.a );","}"].join("\n")},n.noise={attributes:i.copy.attributes,uniforms:{tDiffuse:t.DIFFUSE_MAP,time:function(){return a.time},nIntensity:.5,grayscale:0,viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,opacity:1,diffuseMap:t.DIFFUSE_MAP},vshader:i.copy.vshader,fshader:["uniform float time;","uniform bool grayscale;","uniform float nIntensity;","uniform sampler2D tDiffuse;","varying vec2 texCoord0;","void main() {","vec4 cTextureScreen = texture2D( tDiffuse, texCoord0);","float x = texCoord0.x * texCoord0.y * time * 1000.0;","vec3 cResult;","if ( !grayscale ) {","float y = fract(sin(dot(vec2(mod( x + 20.0, 87.0 ), mod( x + 150.0, 23.0 )), vec2(12.9898,78.233))) * 43758.5453);","float z = fract(sin(dot(vec2(mod( x + 30.0, 19.0 ), mod( x + 200.0, 103.0 )), vec2(12.9898,78.233))) * 43758.5453);","x = fract(sin(dot(vec2(mod( x, 13.0 ), mod( x + 50.0, 123.0 )), vec2(12.9898,78.233))) * 43758.5453);","cResult = vec3(x, y, z);","} else {","x = fract(sin(dot(vec2(mod( x, 13.0 ), mod( x + 50.0, 123.0 )), vec2(12.9898,78.233))) * 43758.5453);","cResult = vec3(x);","}","gl_FragColor = vec4( mix(cTextureScreen.rgb, cResult, nIntensity), cTextureScreen.a );","}"].join("\n")},n.bleachbypass={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,opacity:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform float opacity;","uniform sampler2D tDiffuse;","varying vec2 vUv;","void main() {","vec4 base = texture2D( tDiffuse, vUv );","vec3 lumCoeff = vec3( 0.25, 0.65, 0.1 );","float lum = dot( lumCoeff, base.rgb );","vec3 blend = vec3( lum );","float L = min( 1.0, max( 0.0, 10.0 * ( lum - 0.45 ) ) );","vec3 result1 = 2.0 * base.rgb * blend;","vec3 result2 = 1.0 - 2.0 * ( 1.0 - blend ) * ( 1.0 - base.rgb );","vec3 newColor = mix( result1, result2, L );","float A2 = opacity * base.a;","vec3 mixRGB = A2 * newColor.rgb;","mixRGB += ( ( 1.0 - A2 ) * base.rgb );","gl_FragColor = vec4( mixRGB, base.a );","}"].join("\n")},n.horizontalTiltShift={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,h:1/128,r:.5},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform float h;","uniform float r;","varying vec2 vUv;","void main() {","vec4 sum = vec4( 0.0 );","float hh = h * abs( r - vUv.y );","sum += texture2D( tDiffuse, vec2( vUv.x - 4.0 * hh, vUv.y ) ) * 0.051;","sum += texture2D( tDiffuse, vec2( vUv.x - 3.0 * hh, vUv.y ) ) * 0.0918;","sum += texture2D( tDiffuse, vec2( vUv.x - 2.0 * hh, vUv.y ) ) * 0.12245;","sum += texture2D( tDiffuse, vec2( vUv.x - 1.0 * hh, vUv.y ) ) * 0.1531;","sum += texture2D( tDiffuse, vec2( vUv.x,            vUv.y ) ) * 0.1633;","sum += texture2D( tDiffuse, vec2( vUv.x + 1.0 * hh, vUv.y ) ) * 0.1531;","sum += texture2D( tDiffuse, vec2( vUv.x + 2.0 * hh, vUv.y ) ) * 0.12245;","sum += texture2D( tDiffuse, vec2( vUv.x + 3.0 * hh, vUv.y ) ) * 0.0918;","sum += texture2D( tDiffuse, vec2( vUv.x + 4.0 * hh, vUv.y ) ) * 0.051;","gl_FragColor = sum;","}"].join("\n")},n.colorify={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,color:[1,1,1],amount:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform vec3 color;","uniform float amount;","uniform sampler2D tDiffuse;","varying vec2 vUv;","void main() {","gl_FragColor = texture2D( tDiffuse, vUv );","vec3 luma = vec3( 0.299, 0.587, 0.114 );","float v = dot( gl_FragColor.rgb, luma );","gl_FragColor.rgb = mix(gl_FragColor.rgb, v * color, amount);","}"].join("\n")},n.hatch={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,width:0,spread:10,replace:!0},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform float width;","uniform float spread;","uniform bool replace;","varying vec2 vUv;","void main() {","gl_FragColor = texture2D( tDiffuse, vUv );","float lum = length(gl_FragColor.rgb);","vec3 mult = vec3(1.0, 1.0, 1.0);","float halfSpread = (spread*0.5);","if (lum < 1.00) {","float diff = abs(mod(gl_FragCoord.x + gl_FragCoord.y, spread) - halfSpread);","if (diff <= width) {","mult *= vec3(1.0 - (width - diff) / width);","}","}","if (lum < 0.75) {","float diff = abs(mod(gl_FragCoord.x - gl_FragCoord.y, spread) - halfSpread);","if (diff <= width) {","mult *= vec3(1.0 - (width - diff) / width);","}","}","if (lum < 0.50) {","float diff = abs(mod(gl_FragCoord.x + halfSpread + gl_FragCoord.y, spread) - halfSpread);","if (diff <= width) {","mult *= vec3(1.0 - (width - diff) / width);","}","}","if (lum < 0.25) {","float diff = abs(mod(gl_FragCoord.x + halfSpread - gl_FragCoord.y, spread) - halfSpread);","if (diff <= width) {","mult *= vec3(1.0 - (width - diff) / width);","}","}","if (replace) {","gl_FragColor.rgb = mult;","} else {","gl_FragColor.rgb *= mult;","}","}"].join("\n")},n.ssao={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,tDepth:t.DEPTH_MAP,size:[512,512],cameraNear:t.MAIN_NEAR_PLANE,cameraFar:t.MAIN_FAR_PLANE,fogNear:t.MAIN_NEAR_PLANE,fogFar:t.MAIN_FAR_PLANE,fogEnabled:0,onlyAO:0,aoClamp:.3,lumInfluence:0},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform float cameraNear;","uniform float cameraFar;","uniform float fogNear;","uniform float fogFar;","uniform bool fogEnabled;","uniform bool onlyAO;","uniform vec2 size;","uniform float aoClamp;","uniform float lumInfluence;","uniform sampler2D tDiffuse;","uniform sampler2D tDepth;","varying vec2 vUv;","#define DL 2.399963229728653","#define EULER 2.718281828459045","float width = size.x;","float height = size.y;","float cameraFarPlusNear = cameraFar + cameraNear;","float cameraFarMinusNear = cameraFar - cameraNear;","float cameraCoef = 2.0 * cameraNear;","const int samples = 16;","const float radius = 2.0;","const bool useNoise = false;","const float noiseAmount = 0.0003;","const float diffArea = 0.4;","const float gDisplace = 0.4;","const vec3 onlyAOColor = vec3( 1.0, 1.0, 1.0 );","float unpackDepth( const in vec4 rgba_depth ) {","const vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );","float depth = dot( rgba_depth, bit_shift );","return depth;","}","vec2 rand( const vec2 coord ) {","vec2 noise;","if ( useNoise ) {","float nx = dot ( coord, vec2( 12.9898, 78.233 ) );","float ny = dot ( coord, vec2( 12.9898, 78.233 ) * 2.0 );","noise = clamp( fract ( 43758.5453 * sin( vec2( nx, ny ) ) ), 0.0, 1.0 );","} else {","float ff = fract( 1.0 - coord.s * ( width / 2.0 ) );","float gg = fract( coord.t * ( height / 2.0 ) );","noise = vec2( 0.25, 0.75 ) * vec2( ff ) + vec2( 0.75, 0.25 ) * gg;","}","return ( noise * 2.0  - 1.0 ) * noiseAmount;","}","float doFog() {","float zdepth = unpackDepth( texture2D( tDepth, vUv ) );","float depth = -cameraFar * cameraNear / ( zdepth * cameraFarMinusNear - cameraFar );","return smoothstep( fogNear, fogFar, depth );","}","float readDepth( const in vec2 coord ) {","return cameraCoef / ( cameraFarPlusNear - unpackDepth( texture2D( tDepth, coord ) ) * cameraFarMinusNear );","}","float compareDepths( const in float depth1, const in float depth2, inout int far ) {","float garea = 2.0;","float diff = ( depth1 - depth2 ) * 100.0;","if ( diff < gDisplace ) {","garea = diffArea;","} else {","far = 1;","}","float dd = diff - gDisplace;","float gauss = pow( EULER, -2.0 * dd * dd / ( garea * garea ) );","return gauss;","}","float calcAO( float depth, float dw, float dh ) {","float dd = radius - depth * radius;","vec2 vv = vec2( dw, dh );","vec2 coord1 = vUv + dd * vv;","vec2 coord2 = vUv - dd * vv;","float temp1 = 0.0;","float temp2 = 0.0;","int far = 0;","temp1 = compareDepths( depth, readDepth( coord1 ), far );","if ( far > 0 ) {","temp2 = compareDepths( readDepth( coord2 ), depth, far );","temp1 += ( 1.0 - temp1 ) * temp2;","}","return temp1;","}","void main() {","vec2 noise = rand( vUv );","float depth = readDepth( vUv );","float tt = clamp( depth, aoClamp, 1.0 );","float w = ( 1.0 / width )  / tt + ( noise.x * ( 1.0 - noise.x ) );","float h = ( 1.0 / height ) / tt + ( noise.y * ( 1.0 - noise.y ) );","float pw;","float ph;","float ao;","float dz = 1.0 / float( samples );","float z = 1.0 - dz / 2.0;","float l = 0.0;","for ( int i = 0; i <= samples; i ++ ) {","float r = sqrt( 1.0 - z );","pw = cos( l ) * r;","ph = sin( l ) * r;","ao += calcAO( depth, pw * w, ph * h );","z = z - dz;","l = l + DL;","}","ao /= float( samples );","ao = 1.0 - ao;","if ( fogEnabled ) {","ao = mix( ao, 1.0, doFog() );","}","vec3 color = texture2D( tDiffuse, vUv ).rgb;","vec3 lumcoeff = vec3( 0.299, 0.587, 0.114 );","float lum = dot( color.rgb, lumcoeff );","vec3 luminance = vec3( lum );","vec3 final = vec3( color * mix( vec3( ao ), vec3( 1.0 ), luminance * lumInfluence ) );","if ( onlyAO ) {","final = onlyAOColor * vec3( mix( vec3( ao ), vec3( 1.0 ), luminance * lumInfluence ) );","}","gl_FragColor = vec4( final, 1.0 );","}"].join("\n")},n.skinning={defines:{JOINT_COUNT:56,WEIGHTS:4},attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0,vertexWeights:e.WEIGHTS,vertexJointIDs:e.JOINTIDS},uniforms:{viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,diffuseMap:t.DIFFUSE_MAP,jointPalette:function(e){var t=e.meshData,o=t.currentPose;if(o){var r=o._matrixPalette,i=16*t.paletteMap.length,a=t.store;a||(a=new Float32Array(i),t.store=a);for(var n,s=0;s<t.paletteMap.length;s++){n=r[t.paletteMap[s]];for(var l=0;4>l;l++)for(var u=0;4>u;u++)a[16*s+4*l+u]=n.data[4*u+l]}return a}}},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","attribute vec4 vertexWeights;","attribute vec4 vertexJointIDs;","uniform mat4 viewProjectionMatrix;","uniform mat4 worldMatrix;","uniform mat4 jointPalette[JOINT_COUNT];","varying vec2 texCoord0;","void main(void) {","mat4 mat = mat4(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);","mat += jointPalette[int(vertexJointIDs.x)] * vertexWeights.x;","mat += jointPalette[int(vertexJointIDs.y)] * vertexWeights.y;","mat += jointPalette[int(vertexJointIDs.z)] * vertexWeights.z;","mat += jointPalette[int(vertexJointIDs.w)] * vertexWeights.w;","texCoord0 = vertexUV0;","gl_Position = viewProjectionMatrix * worldMatrix * mat * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:["uniform sampler2D diffuseMap;","varying vec2 texCoord0;","void main(void)","{","gl_FragColor = texture2D(diffuseMap, texCoord0);","}"].join("\n")},n.rgbshift={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,amount:.005,angle:0},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform float amount;","uniform float angle;","varying vec2 vUv;","void main() {","vec2 offset = amount * vec2( cos(angle), sin(angle));","vec4 cr = texture2D(tDiffuse, vUv + offset);","vec4 cga = texture2D(tDiffuse, vUv);","vec4 cb = texture2D(tDiffuse, vUv - offset);","gl_FragColor = vec4(cr.r, cga.g, cb.b, cga.a);","}"].join("\n")},n.brightnesscontrast={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,brightness:0,contrast:0,saturation:0},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform float brightness;","uniform float contrast;","uniform float saturation;","varying vec2 vUv;","void main() {","gl_FragColor = texture2D( tDiffuse, vUv );","gl_FragColor.rgb += brightness;","if (contrast > 0.0) {","gl_FragColor.rgb = (gl_FragColor.rgb - 0.5) / (1.0 - contrast) + 0.5;","} else {","gl_FragColor.rgb = (gl_FragColor.rgb - 0.5) * (1.0 + contrast) + 0.5;","}","vec3 gray = vec3(dot(vec3(0.2126,0.7152,0.0722), gl_FragColor.rgb));","gl_FragColor.rgb = mix(gl_FragColor.rgb, gray, -saturation);","}"].join("\n")},n.hsb={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,hue:0,saturation:0,brightness:0},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform float hue;","uniform float saturation;","uniform float brightness;","varying vec2 vUv;",o.methods.hsv,"void main() {","gl_FragColor = texture2D(tDiffuse, vUv);","vec3 fragHSV = rgb2hsv(gl_FragColor.rgb).xyz;","fragHSV.x += hue * 0.5;","fragHSV.y *= saturation + 1.0 - max(brightness, 0.0) * 2.0;","fragHSV.z *= min(brightness + 1.0, 1.0);","fragHSV.z += max(brightness, 0.0);","fragHSV.xyz = clamp(fragHSV.xyz, vec3(-10.0, 0.0, 0.0), vec3(10.0, 1.0, 1.0));","gl_FragColor.rgb = hsv2rgb(fragHSV);","}"].join("\n")},n.luminosity={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","varying vec2 vUv;","void main() {","vec4 texel = texture2D( tDiffuse, vUv );","vec3 luma = vec3( 0.299, 0.587, 0.114 );","float v = dot( texel.xyz, luma );","gl_FragColor = vec4( v, v, v, texel.w );","}"].join("\n")},n.toon={attributes:{vertexPosition:e.POSITION,vertexNormal:e.NORMAL},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,cameraPosition:t.CAMERA,lightPosition:t.LIGHT0,HighlightColor:[.9,.8,.7,1],MidColor:[.65,.55,.45,1],ShadowColor:[.4,.3,.2,1],HighlightSize:.2,ShadowSize:.01,OutlineWidth:.15},vshader:["attribute vec3 vertexPosition;","attribute vec3 vertexNormal;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","uniform vec3 cameraPosition;","uniform vec3 lightPosition;","varying vec3 N;","varying vec3 V;","varying vec3 L;","void main() {","vec4 worldPos = worldMatrix * vec4(vertexPosition, 1.0);","N = (worldMatrix * vec4(vertexNormal, 0.0)).xyz;","L = lightPosition - worldPos.xyz;","V = cameraPosition - worldPos.xyz;","gl_Position = projectionMatrix * viewMatrix * worldPos;","}"].join("\n"),fshader:["uniform vec4 HighlightColor;","uniform vec4 MidColor;","uniform vec4 ShadowColor;","uniform float HighlightSize;","uniform float ShadowSize;","uniform float OutlineWidth;","varying vec3 N;","varying vec3 L;","varying vec3 V;","void main() {","vec3 n = normalize(N);","vec3 l = normalize(L);","vec3 v = normalize(V);","float lambert = dot(l,n);","vec4 color = MidColor;","if (lambert > 1.0 - HighlightSize) color = HighlightColor;","if (lambert < ShadowSize) color = ShadowColor;","if (dot(n,v) < OutlineWidth) color = vec4(0.0,0.0,0.0,1.0);","gl_FragColor = color;","}"].join("\n")},n.differenceOfGaussians={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,gaussBlurredImage1:"BLUR1",gaussBlurredImage2:"BLUR2",originalImage:"ORIGINAL",threshold:.01,edgeColor:[1,0,1,1],backgroundColor:[0,0,0,1],backgroundMix:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoord0;","void main(void) {","texCoord0 = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:["uniform sampler2D gaussBlurredImage1;","uniform sampler2D gaussBlurredImage2;","uniform sampler2D originalImage;","uniform float threshold;","uniform float backgroundMix;","uniform vec4 edgeColor;","uniform vec4 backgroundColor;","varying vec2 texCoord0;","void main(void)","{","vec4 blur1 = texture2D(gaussBlurredImage1, texCoord0);","vec4 blur2 = texture2D(gaussBlurredImage2, texCoord0);","vec4 originalColor = texture2D(originalImage, texCoord0);","vec3 nonEdgeColor = mix(originalColor.rgb, backgroundColor.rgb, backgroundMix);","vec3 diffColor = abs(blur1.rgb - blur2.rgb);","float edgeValue = (diffColor.r + diffColor.g + diffColor.b) / 3.0;","edgeValue = smoothstep(0.0, threshold, edgeValue);","vec3 outputColor = mix(nonEdgeColor, edgeColor.rgb, edgeValue);","gl_FragColor = vec4(outputColor, 1.0);","}"].join("\n")},n.overlay={defines:{OVERLAY_TYPE:0},processors:[function(e,t){var o=t.material._textureMaps.OVERLAY_MAP;if(o){e.setDefine("OVERLAY_MAP",!0);var r=e.uniforms.offsetRepeat;r[0]=o.offset.x,r[1]=o.offset.y,r[2]=o.repeat.x,r[3]=o.repeat.y}else e.removeDefine("OVERLAY_MAP")}],attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,tDiffuse2:"OVERLAY_MAP",offsetRepeat:[0,0,1,1],amount:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:[o.blendmodes,"#define Mixin(base, blend, type, a)	mix(base, type(base, blend), a);","uniform sampler2D tDiffuse;","uniform sampler2D tDiffuse2;","uniform float amount;","#ifdef OVERLAY_MAP","uniform vec4 offsetRepeat;","#endif","varying vec2 vUv;","void main() {","gl_FragColor = texture2D(tDiffuse, vUv);","#ifdef OVERLAY_MAP","vec2 oUv = vUv * offsetRepeat.zw + offsetRepeat.xy;","vec4 blendTexture = texture2D(tDiffuse2, oUv);","float a = amount * blendTexture.a;","#endif","#if !defined(OVERLAY_MAP)","#elif OVERLAY_TYPE == 0","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendNormal, a);","#elif OVERLAY_TYPE == 1","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendLighten, a);","#elif OVERLAY_TYPE == 2","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendDarken, a);","#elif OVERLAY_TYPE == 3","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendMultiply, a);","#elif OVERLAY_TYPE == 4","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendAverage, a);","#elif OVERLAY_TYPE == 5","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendAdd, a);","#elif OVERLAY_TYPE == 6","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendSubstract, a);","#elif OVERLAY_TYPE == 7","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendDifference, a);","#elif OVERLAY_TYPE == 8","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendNegation, a);","#elif OVERLAY_TYPE == 9","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendExclusion, a);","#elif OVERLAY_TYPE == 10","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendScreen, a);","#elif OVERLAY_TYPE == 11","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendOverlay, a);","#elif OVERLAY_TYPE == 12","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendSoftLight, a);","#elif OVERLAY_TYPE == 13","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendHardLight, a);","#elif OVERLAY_TYPE == 14","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendColorDodge, a);","#elif OVERLAY_TYPE == 15","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendColorBurn, a);","#elif OVERLAY_TYPE == 16","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendLinearLight, a);","#elif OVERLAY_TYPE == 17","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendVividLight, a);","#elif OVERLAY_TYPE == 18","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendPinLight, a);","#elif OVERLAY_TYPE == 19","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendHardMix, a);","#elif OVERLAY_TYPE == 20","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendReflect, a);","#elif OVERLAY_TYPE == 21","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendGlow, a);","#elif OVERLAY_TYPE == 22","gl_FragColor.rgb = Mixin(gl_FragColor.rgb, blendTexture.rgb, BlendPhoenix, a);","#endif","}"].join("\n")
},n.levels={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,gamma:1,minInput:0,maxInput:1,minOutput:0,maxOutput:1},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:[o.blendmodes,"uniform sampler2D tDiffuse;","uniform float gamma;","uniform float minInput;","uniform float maxInput;","uniform float minOutput;","uniform float maxOutput;","varying vec2 vUv;","void main() {","gl_FragColor = texture2D( tDiffuse, vUv );","gl_FragColor.rgb = LevelsControl(gl_FragColor.rgb, minInput, gamma, maxInput, minOutput, maxOutput);","}"].join("\n")},n.boxfilter={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,viewport:[128,128]},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 vUv;","void main() {","vUv = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform vec2 viewport;","varying vec2 vUv;","void main() {","vec3 result = vec3(0.0);","for (int x=-1; x<=1; x++) {","for (int y=-1; y<=1; y++) {","result += texture2D(tDiffuse, vUv + vec2(x, y) / viewport).rgb;","}","}","gl_FragColor = vec4(result / vec3(9.0), 1.0);","}"].join("\n")},n.radial={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,frameBufSize:t.RESOLUTION,offset:.5,multiplier:-.75},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoords;","void main() {","texCoords = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform vec2 frameBufSize;","uniform float offset;","uniform float multiplier;","varying vec2 texCoords;","void main() {","vec2 uv = texCoords - 0.5;","vec3 o = texture2D(tDiffuse, 0.5 + (uv.xy *= 0.992)).rgb;","float z = 0.0;","for (float i = 0.0; i < 50.0; i++) {","vec3 T = texture2D(tDiffuse, 0.5 + (uv.xy *= 0.992)).rgb;","z += pow(max(0.0, offset + length(T) * multiplier), 2.0) * exp(-i * 0.08);","}","gl_FragColor = vec4(o*o + z, 1.0);","}"].join("\n")},n.packDepth={attributes:{vertexPosition:e.POSITION},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,farPlane:t.FAR_PLANE},vshader:["attribute vec3 vertexPosition;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec4 vPosition;","void main(void) {","vPosition = viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","gl_Position = projectionMatrix * vPosition;","}"].join("\n"),fshader:["uniform float farPlane;",o.methods.packDepth,"varying vec4 vPosition;","void main(void)","{","float linearDepth = min(length(vPosition), farPlane) / farPlane;","gl_FragColor = packDepth(linearDepth);","}"].join("\n")},n.antialias={attributes:{vertexPosition:e.POSITION,vertexUV0:e.TEXCOORD0},uniforms:{viewMatrix:t.VIEW_MATRIX,projectionMatrix:t.PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,tDiffuse:t.DIFFUSE_MAP,frameBufSize:t.RESOLUTION,FXAA_SPAN_MAX:8,FXAA_REDUCE_MUL:1/8},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoords;","void main() {","texCoords = vertexUV0;","gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4( vertexPosition, 1.0 );","}"].join("\n"),fshader:["uniform sampler2D tDiffuse;","uniform vec2 frameBufSize;","uniform float FXAA_SPAN_MAX;","uniform float FXAA_REDUCE_MUL;","varying vec2 texCoords;","void main() {","float FXAA_REDUCE_MIN = 1.0/128.0;","vec3 rgbNW = texture2D(tDiffuse, texCoords + (vec2(-1.0, -1.0) / frameBufSize)).xyz;","vec3 rgbNE = texture2D(tDiffuse, texCoords + (vec2(1.0, -1.0) / frameBufSize)).xyz;","vec3 rgbSW = texture2D(tDiffuse, texCoords + (vec2(-1.0, 1.0) / frameBufSize)).xyz;","vec3 rgbSE = texture2D(tDiffuse, texCoords + (vec2(1.0, 1.0) / frameBufSize)).xyz;","vec3 rgbM = texture2D(tDiffuse, texCoords).xyz;","vec3 luma=vec3(0.299, 0.587, 0.114);","float lumaNW = dot(rgbNW, luma);","float lumaNE = dot(rgbNE, luma);","float lumaSW = dot(rgbSW, luma);","float lumaSE = dot(rgbSE, luma);","float lumaM  = dot(rgbM,  luma);","float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));","float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));","vec2 dir;","dir.x = -((lumaNW + lumaNE) - (lumaSW + lumaSE));","dir.y =  ((lumaNW + lumaSW) - (lumaNE + lumaSE));","float dirReduce = max(","		(lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_REDUCE_MUL),","		FXAA_REDUCE_MIN);","float rcpDirMin = 1.0/(min(abs(dir.x), abs(dir.y)) + dirReduce);","dir = min(vec2( FXAA_SPAN_MAX,  FXAA_SPAN_MAX),","		  max(vec2(-FXAA_SPAN_MAX, -FXAA_SPAN_MAX),","		  dir * rcpDirMin)) / frameBufSize;","vec3 rgbA = (1.0/2.0) * (","		texture2D(tDiffuse, texCoords.xy + dir * (1.0/3.0 - 0.5)).xyz +","		texture2D(tDiffuse, texCoords.xy + dir * (2.0/3.0 - 0.5)).xyz);","vec3 rgbB = rgbA * (1.0/2.0) + (1.0/4.0) * (","		texture2D(tDiffuse, texCoords.xy + dir * (0.0/3.0 - 0.5)).xyz +","		texture2D(tDiffuse, texCoords.xy + dir * (3.0/3.0 - 0.5)).xyz);","float lumaB = dot(rgbB, luma);","if ((lumaB < lumaMin) || (lumaB > lumaMax)) {","		gl_FragColor.xyz=rgbA;","} else{","		gl_FragColor.xyz=rgbB;","}","}"].join("\n")},n}(goo.MeshData,goo.Shader,goo.ShaderFragment,goo.ShaderBuilder,goo.ShaderLib,goo.World),goo.BloomPass=function(e,t,o,r,i,a,n){"use strict";function s(o){o=o||{},this.target=void 0!==o.target?o.target:null;var n=void 0!==o.strength?o.strength:0,l=void 0!==o.sigma?o.sigma:4,u=2*Math.ceil(3*l)+1;this.downsampleAmount=void 0!==o.downsampleAmount?Math.max(o.downsampleAmount,1):4;var d=window.innerWidth||1024,c=window.innerHeight||1024;this.updateSize({x:0,y:0,width:d,height:c}),this.renderable={meshData:t.quad,materials:[]},this.copyMaterial=new e(i.copyPure),this.copyMaterial.uniforms.opacity=n,this.copyMaterial.blendState.blending="AdditiveBlending",this.convolutionShader=r.deepClone(i.convolution),this.convolutionShader.defines={KERNEL_SIZE_FLOAT:u.toFixed(1),KERNEL_SIZE_INT:u.toFixed(0)},this.convolutionMaterial=new e(this.convolutionShader),this.convolutionMaterial.uniforms.uImageIncrement=s.blurX,this.convolutionMaterial.uniforms.cKernel=this.convolutionShader.buildKernel(l),this.bcMaterial=new e(a.brightnesscontrast),this.bcMaterial.uniforms.brightness=0,this.bcMaterial.uniforms.contrast=0,this.enabled=!0,this.clear=!1,this.needsSwap=!1}return s.prototype=Object.create(n.prototype),s.prototype.constructor=s,s.prototype.destroy=function(e){this.renderTargetX&&this.renderTargetX.destroy(e.context),this.renderTargetY&&this.renderTargetY.destroy(e.context),this.convolutionMaterial.shader.destroy(),this.copyMaterial.shader.destroy(),this.bcMaterial.shader.destroy()},s.prototype.invalidateHandles=function(e){e.invalidateMaterial(this.convolutionMaterial),e.invalidateMaterial(this.copyMaterial),e.invalidateMaterial(this.convolutionMaterial),e.invalidateMaterial(this.bcMaterial),e.invalidateRenderTarget(this.renderTargetX),e.invalidateRenderTarget(this.renderTargetY),e.invalidateMeshData(this.renderable.meshData)},s.prototype.updateSize=function(e,t){var r=e.width/this.downsampleAmount,i=e.height/this.downsampleAmount;this.renderTargetX&&this.renderTargetX.destroy(t.context),this.renderTargetY&&this.renderTargetY.destroy(t.context),this.renderTargetX=new o(r,i),this.renderTargetY=new o(r,i)},s.prototype.render=function(e,o,r){this.renderable.materials[0]=this.bcMaterial,this.bcMaterial.setTexture("DIFFUSE_MAP",r),e.render(this.renderable,t.camera,[],this.renderTargetY,!0),this.renderable.materials[0]=this.convolutionMaterial,this.convolutionMaterial.setTexture("DIFFUSE_MAP",this.renderTargetY),this.convolutionMaterial.uniforms.uImageIncrement=s.blurY,e.render(this.renderable,t.camera,[],this.renderTargetX,!0),this.convolutionMaterial.setTexture("DIFFUSE_MAP",this.renderTargetX),this.convolutionMaterial.uniforms.uImageIncrement=s.blurX,e.render(this.renderable,t.camera,[],this.renderTargetY,!0),this.renderable.materials[0]=this.copyMaterial,this.copyMaterial.setTexture("DIFFUSE_MAP",this.renderTargetY),null!==this.target?e.render(this.renderable,t.camera,[],this.target,this.clear):e.render(this.renderable,t.camera,[],r,this.clear)},s.blurX=[.001953125,0],s.blurY=[0,.001953125],s}(goo.Material,goo.FullscreenUtils,goo.RenderTarget,goo.ObjectUtils,goo.ShaderLib,goo.ShaderLibExtra,goo.Pass),goo.BlurPass=function(e,t,o,r,i,a){"use strict";function n(o){o=o||{},this.target=void 0!==o.target?o.target:null;var a=void 0!==o.strength?o.strength:1,n=void 0!==o.sigma?o.sigma:4,s=2*Math.ceil(3*n)+1;this.downsampleAmount=void 0!==o.downsampleAmount?Math.max(o.downsampleAmount,1):4,this.blurX=[.001953125,0],this.blurY=[0,.001953125];var l=window.innerWidth||1024,u=window.innerHeight||1024;this.updateSize({x:0,y:0,width:l,height:u}),this.renderable={meshData:t.quad,materials:[]},this.copyMaterial=new e(i.copyPure),this.copyMaterial.uniforms.opacity=a,this.copyMaterial.blendState.blending="CustomBlending",this.convolutionShader=r.deepClone(i.convolution),this.convolutionShader.defines={KERNEL_SIZE_FLOAT:s.toFixed(1),KERNEL_SIZE_INT:s.toFixed(0)},this.convolutionShader.uniforms.uImageIncrement=this.blurX,this.convolutionShader.uniforms.cKernel=this.convolutionShader.buildKernel(n),this.convolutionMaterial=new e(this.convolutionShader),this.enabled=!0,this.clear=!1,this.needsSwap=!1}return n.prototype=Object.create(a.prototype),n.prototype.constructor=n,n.prototype.destroy=function(e){this.renderTargetX&&this.renderTargetX.destroy(e.context),this.renderTargetY&&this.renderTargetY.destroy(e.context),this.convolutionMaterial.shader.destroy(),this.copyMaterial.shader.destroy()},n.prototype.invalidateHandles=function(e){e.invalidateMaterial(this.convolutionMaterial),e.invalidateMaterial(this.copyMaterial),e.invalidateRenderTarget(this.renderTargetX),e.invalidateRenderTarget(this.renderTargetY),e.invalidateMeshData(this.renderable.meshData)},n.prototype.updateSize=function(e,t){var r=e.width/this.downsampleAmount,i=e.height/this.downsampleAmount;this.renderTargetX&&t._deallocateRenderTarget(this.renderTargetX),this.renderTargetY&&t._deallocateRenderTarget(this.renderTargetY),this.renderTargetX=new o(r,i),this.renderTargetY=new o(r,i)},n.prototype.render=function(e,o,r){this.renderable.materials[0]=this.convolutionMaterial,this.convolutionMaterial.setTexture("DIFFUSE_MAP",r),this.convolutionMaterial.uniforms.uImageIncrement=this.blurY,e.render(this.renderable,t.camera,[],this.renderTargetX,!0),this.convolutionMaterial.setTexture("DIFFUSE_MAP",this.renderTargetX),this.convolutionMaterial.uniforms.uImageIncrement=this.blurX,e.render(this.renderable,t.camera,[],this.renderTargetY,!0),this.renderable.materials[0]=this.copyMaterial,this.copyMaterial.setTexture("DIFFUSE_MAP",this.renderTargetY),null!==this.target?e.render(this.renderable,t.camera,[],this.target,this.clear):e.render(this.renderable,t.camera,[],r,this.clear)},n}(goo.Material,goo.FullscreenUtils,goo.RenderTarget,goo.ObjectUtils,goo.ShaderLib,goo.Pass),goo.DepthPass=function(e,t,o,r,i,a,n,s,l){"use strict";function u(o,r){this.depthPass=new a(o);var i=new e(d);this.depthPass.overrideMaterial=i,this.blurTarget=new t(256,256),this.blurPass=new l({target:this.blurTarget});var s=r||c;this.outPass=new n(s),this.outPass.useReadBuffer=!1;var u=window.innerWidth||1,v=window.innerHeight||1;this.depthTarget=new t(u,v),this.enabled=!0,this.clear=!1,this.needsSwap=!0}u.prototype=Object.create(s.prototype),u.prototype.constructor=u,u.prototype.render=function(e,t,o,i){this.depthPass.render(e,null,this.depthTarget,i),this.blurPass.render(e,t,o,i),this.outPass.material.setTexture(r.DEPTH_MAP,this.depthTarget),this.outPass.material.setTexture(r.DIFFUSE_MAP,o),this.outPass.material.setTexture("BLUR_MAP",this.blurTarget),this.outPass.render(e,t,o,i)};var d={attributes:{vertexPosition:o.POSITION},uniforms:{viewMatrix:r.VIEW_MATRIX,projectionMatrix:r.PROJECTION_MATRIX,worldMatrix:r.WORLD_MATRIX,farPlane:r.FAR_PLANE},vshader:["attribute vec3 vertexPosition;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec4 vPosition;","void main(void) {","	vPosition = viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","	gl_Position = projectionMatrix * vPosition;","}"].join("\n"),fshader:["precision mediump float;","uniform float farPlane;",i.methods.packDepth,"varying vec4 vPosition;","void main(void)","{","	float linearDepth = min(length(vPosition), farPlane) / farPlane;","	gl_FragColor = packDepth(linearDepth);","}"].join("\n")},c={attributes:{vertexPosition:o.POSITION,vertexUV0:o.TEXCOORD0},uniforms:{viewMatrix:r.VIEW_MATRIX,projectionMatrix:r.PROJECTION_MATRIX,worldMatrix:r.WORLD_MATRIX,depthMap:r.DEPTH_MAP,diffuseMap:r.DIFFUSE_MAP},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoord0;","void main(void) {","	texCoord0 = vertexUV0;","	gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:["precision mediump float;","uniform sampler2D depthMap;","uniform sampler2D diffuseMap;","varying vec2 texCoord0;",i.methods.unpackDepth,"void main(void)","{","	vec4 depthCol = texture2D(depthMap, texCoord0);","	vec4 diffuseCol = texture2D(diffuseMap, texCoord0);","	float depth = unpackDepth(depthCol);","	gl_FragColor = diffuseCol * vec4(depth);","}"].join("\n")};return u}(goo.Material,goo.RenderTarget,goo.MeshData,goo.Shader,goo.ShaderFragment,goo.RenderPass,goo.FullscreenPass,goo.Pass,goo.BlurPass),goo.DofPass=function(e,t,o,r,i,a,n,s,l,u,d,c){"use strict";function v(o,r){this.depthPass=new a(o,function(e){return!(e instanceof u)}),this.regularPass=new a(o);var i=new e(f);this.depthPass.overrideMaterial=i;var s=r||m;this.outPass=new n(s),this.outPass.useReadBuffer=!1,this.outPass.renderToScreen=!0;var l=window.innerWidth||1,c=window.innerHeight||1,v=d.nearestPowerOfTwo(Math.max(l,c));this.depthTarget=new t(l,c),this.regularTarget=new t(v/2,v/2),this.regularTarget2=new t(l,c),this.regularTarget.generateMipmaps=!0,this.regularTarget.minFilter="Trilinear",this.enabled=!0,this.clear=!1,this.needsSwap=!0}v.prototype=Object.create(c.prototype),v.prototype.constructor=v,v.prototype.render=function(e,t,o,i){this.depthPass.render(e,null,this.depthTarget,i),this.regularPass.render(e,null,this.regularTarget,i),this.regularPass.render(e,null,this.regularTarget2,i),this.outPass.material.setTexture(r.DEPTH_MAP,this.depthTarget),this.outPass.material.setTexture(r.DIFFUSE_MAP,this.regularTarget),this.outPass.material.setTexture("DIFFUSE_MIP",this.regularTarget2),this.outPass.render(e,t,o,i)};var f={attributes:{vertexPosition:o.POSITION},uniforms:{viewMatrix:r.VIEW_MATRIX,projectionMatrix:r.PROJECTION_MATRIX,worldMatrix:r.WORLD_MATRIX,farPlane:r.FAR_PLANE},vshader:["attribute vec3 vertexPosition;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","varying vec4 vPosition;","void main(void) {","vPosition = viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","gl_Position = projectionMatrix * vPosition;","}"].join("\n"),fshader:["precision mediump float;","uniform float farPlane;",i.methods.packDepth,"varying vec4 vPosition;","void main(void)","{","float linearDepth = min(-vPosition.z, farPlane) / farPlane;","gl_FragColor = packDepth(linearDepth);","}"].join("\n")},m={attributes:{vertexPosition:o.POSITION,vertexUV0:o.TEXCOORD0},uniforms:{worldMatrix:r.WORLD_MATRIX,viewProjectionMatrix:r.VIEW_PROJECTION_MATRIX,depthMap:r.DEPTH_MAP,diffuseMap:r.DIFFUSE_MAP,diffuseMip:"DIFFUSE_MIP",zfar:r.FAR_PLANE,focalDepth:100,fStop:2,CoC:.003,focalLength:75,maxBlur:16},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewProjectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoord0;","void main(void) {","texCoord0 = vertexUV0;","gl_Position = viewProjectionMatrix * worldMatrix * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:"uniform sampler2D diffuseMap;\nuniform sampler2D diffuseMip;\nuniform sampler2D depthMap;\nuniform float zfar; //camera clipping end\nuniform float focalDepth;\nuniform float focalLength;\nuniform float fStop;\nuniform float CoC;\nuniform float maxBlur;\nvarying vec2 texCoord0;\n"+i.methods.unpackDepth+"void main() {\nfloat depth = unpackDepth(texture2D(depthMap,texCoord0)) * zfar;\nfloat f = focalLength; //focal length in mm\nfloat d = focalDepth*1000.0; //focal plane in mm\nfloat o = depth*1000.0; //depth in mm\nfloat a = (o*f)/(o-f);\nfloat b = (d*f)/(d-f);\nfloat c = (d-f)/(d*fStop*CoC); \nfloat blur = clamp(abs(a-b)*c, 0.0, maxBlur);\nif (blur < 0.3) {\ngl_FragColor = texture2D(diffuseMip, texCoord0);\n} else {\ngl_FragColor = texture2D(diffuseMap, texCoord0, log2(blur));\n}\ngl_FragColor.a = 1.0;}"};return v}(goo.Material,goo.RenderTarget,goo.MeshData,goo.Shader,goo.ShaderFragment,goo.RenderPass,goo.FullscreenPass,goo.BlurPass,goo.RendererUtils,goo.Skybox,goo.MathUtils,goo.Pass),goo.DogPass=function(e,t,o,r,i,a,n){"use strict";function s(o){o=o||{},this.target=void 0!==o.target?o.target:null;var n=void 0!==o.width?o.width:1024,s=void 0!==o.height?o.height:1024,l=void 0!==o.sigma?o.sigma:.6,u=void 0!==o.threshold?o.threshold:.005;this.downsampleAmount=void 0!==o.downsampleAmount?Math.max(o.downsampleAmount,1):2,l>2.5&&(l=2.5),this.updateSize({width:n,height:s}),this.renderable={meshData:t.quad,materials:[]},this.convolutionShader1=r.deepClone(i.convolution),this.convolutionShader2=r.deepClone(i.convolution),this.differenceShader=r.deepClone(a.differenceOfGaussians),this.differenceShader.uniforms.threshold=u,this.differenceMaterial=new e(this.differenceShader),this.updateSigma(l),this.enabled=!0,this.clear=!1,this.needsSwap=!0}return s.prototype=Object.create(n.prototype),s.prototype.constructor=s,s.prototype.destroy=function(e){var t=e.context;this.convolutionMaterial1&&this.convolutionMaterial1.shader.destroy(),this.convolutionMaterial2&&this.convolutionMaterial2.shader.destroy(),this.differenceMaterial.shader.destroy(),this.gaussian1&&this.gaussian1.destroy(t),this.gaussian2&&this.gaussian2.destroy(t),this.renderTargetX&&this.renderTargetX.destroy(t),this.target&&this.target.destroy(t)},s.prototype.updateThreshold=function(e){this.differenceMaterial.shader.uniforms.threshold=e},s.prototype.updateEdgeColor=function(e){this.differenceMaterial.shader.uniforms.edgeColor=[e[0],e[1],e[2],1]},s.prototype.updateBackgroundColor=function(e){this.differenceMaterial.shader.uniforms.backgroundColor=[e[0],e[1],e[2],1]},s.prototype.updateBackgroundMix=function(e){this.differenceMaterial.shader.uniforms.backgroundMix=e},s.prototype.updateSize=function(e){var t=e.width/this.downsampleAmount,r=e.height/this.downsampleAmount;this.renderTargetX=new o(t,r),this.gaussian1=new o(t,r),this.gaussian2=new o(t,r),this.blurX=[.5/t,0],this.blurY=[0,.5/r]},s.prototype.updateSigma=function(t){var o=this.convolutionShader1.buildKernel(t),r=this.convolutionShader2.buildKernel(1.6*t),i=o.length;this.convolutionShader1.defines={KERNEL_SIZE_FLOAT:i.toFixed(1),KERNEL_SIZE_INT:i.toFixed(0)},i=r.length,this.convolutionShader2.defines={KERNEL_SIZE_FLOAT:i.toFixed(1),KERNEL_SIZE_INT:i.toFixed(0)},this.convolutionShader1.uniforms.cKernel=o,this.convolutionShader2.uniforms.cKernel=r,this.convolutionMaterial1=new e(this.convolutionShader1),this.convolutionMaterial2=new e(this.convolutionShader2)},s.prototype.render=function(e,o,r){this.renderable.materials[0]=this.convolutionMaterial1,this.convolutionMaterial1.setTexture("DIFFUSE_MAP",r),this.convolutionShader1.uniforms.uImageIncrement=this.blurX,e.render(this.renderable,t.camera,[],this.renderTargetX,!0),this.convolutionMaterial1.setTexture("DIFFUSE_MAP",this.renderTargetX),this.convolutionShader1.uniforms.uImageIncrement=this.blurY,e.render(this.renderable,t.camera,[],this.gaussian1,!0),this.renderable.materials[0]=this.convolutionMaterial2,this.convolutionMaterial2.setTexture("DIFFUSE_MAP",r),this.convolutionShader2.uniforms.uImageIncrement=this.blurX,e.render(this.renderable,t.camera,[],this.renderTargetX,!0),this.convolutionMaterial2.setTexture("DIFFUSE_MAP",this.renderTargetX),this.convolutionShader2.uniforms.uImageIncrement=this.blurY,e.render(this.renderable,t.camera,[],this.gaussian2,!0),this.renderable.materials[0]=this.differenceMaterial,this.differenceMaterial.setTexture("BLUR1",this.gaussian1),this.differenceMaterial.setTexture("BLUR2",this.gaussian2),this.differenceMaterial.setTexture("ORIGINAL",r),null!==this.target?e.render(this.renderable,t.camera,[],this.target,this.clear):e.render(this.renderable,t.camera,[],o,this.clear)},s.prototype.invalidateHandles=function(e){e.invalidateMaterial(this.convolutionMaterial1),e.invalidateMaterial(this.convolutionMaterial2),e.invalidateMaterial(this.differenceMaterial),e.invalidateMeshData(this.renderable.meshData),e.invalidateRenderTarget(this.renderTargetX),e.invalidateRenderTarget(this.gaussian1),e.invalidateRenderTarget(this.gaussian2)},s}(goo.Material,goo.FullscreenUtils,goo.RenderTarget,goo.ObjectUtils,goo.ShaderLib,goo.ShaderLibExtra,goo.Pass),goo.MotionBlurPass=function(e,t,o,r,i,a,n,s){"use strict";function l(){this.inPass=new n(u),this.outPass=new n(o.copyPure);var e=window.innerWidth||1024,t=window.innerHeight||1024;this.updateSize({x:0,y:0,width:e,height:t}),this.enabled=!0,this.clear=!1,this.needsSwap=!0}l.prototype=Object.create(s.prototype),l.prototype.constructor=l,l.prototype.destroy=function(e){this.inPass.destroy(e),this.outPass.destroy(e),this.targetSwap&&(this.targetSwap[0].destroy(e.context),this.targetSwap[1].destroy(e.context),this.targetSwap=void 0)},l.prototype.invalidateHandles=function(e){this.inPass.invalidateHandles(e),this.outPass.invalidateHandles(e),e.invalidateRenderTarget(this.targetSwap[0]),e.invalidateRenderTarget(this.targetSwap[1])},l.prototype.updateSize=function(e,t){var o=e.width,r=e.height;if(this.targetSwap)for(var i=0;i<this.targetSwap.length;i++)t._deallocateRenderTarget(this.targetSwap[i]);this.targetSwap=[new a(o,r),new a(o,r)]},l.prototype.render=function(e,t,o){this.inPass.material.setTexture("MOTION_MAP",this.targetSwap[1]),this.inPass.render(e,this.targetSwap[0],o),this.outPass.render(e,t,this.targetSwap[0]),this.targetSwap.reverse()};var u={defines:{},processors:[function(e,t){t.material._textureMaps.MOTION_MAP.glTexture?e.setDefine("MOTION_MAP",!0):e.removeDefine("MOTION_MAP")}],attributes:{vertexPosition:i.POSITION,vertexUV0:i.TEXCOORD0},uniforms:{viewProjectionMatrix:t.VIEW_PROJECTION_MATRIX,worldMatrix:t.WORLD_MATRIX,blend:.9,scale:1,diffuseMap:t.DIFFUSE_MAP,motionMap:"MOTION_MAP"},vshader:["attribute vec3 vertexPosition;","attribute vec2 vertexUV0;","uniform mat4 viewProjectionMatrix;","uniform mat4 worldMatrix;","varying vec2 texCoord0;","void main(void) {","texCoord0 = vertexUV0;","gl_Position = viewProjectionMatrix * worldMatrix * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:["uniform sampler2D diffuseMap;","uniform sampler2D motionMap;","uniform float blend;","uniform float scale;","varying vec2 texCoord0;","void main(void)","{","vec4 colA = texture2D(diffuseMap, texCoord0);","#ifdef MOTION_MAP","vec4 colB = texture2D(motionMap, (texCoord0 - 0.5) / scale + 0.5);","float wBlend = blend;// * length(colB) / sqrt(3.0);","gl_FragColor = mix(colA, colB, wBlend);","#else","gl_FragColor = colA;","#endif","}"].join("\n")};return l}(goo.Material,goo.Shader,goo.ShaderLib,goo.FullscreenUtils,goo.MeshData,goo.RenderTarget,goo.FullscreenPass,goo.Pass),goo.PassLib=function(e,t,o,r,i,a,n){"use strict";function s(e){o.call(this),this.id=e}function l(e){i.call(this,arguments),this.id=e}function u(e){r.call(this,arguments),this.id=e}function d(o){t.call(this,n.deepClone(e.vignette)),this.id=o}function c(o){t.call(this,n.deepClone(e.sepia)),this.id=o}function v(o){t.call(this,n.deepClone(e.film)),this.id=o}function f(o){t.call(this,n.deepClone(e.noise)),this.id=o}function m(o){t.call(this,n.deepClone(e.rgbshift)),this.id=o}function p(o){t.call(this,n.deepClone(e.bleachbypass)),this.id=o}function g(o){t.call(this,n.deepClone(e.hsb)),this.id=o}function h(o){t.call(this,n.deepClone(e.colorify)),this.id=o}function x(o){t.call(this,n.deepClone(e.hatch)),this.id=o}function M(o){t.call(this,n.deepClone(e.dotscreen)),this.id=o}function b(o){t.call(this,n.deepClone(e.brightnesscontrast)),this.id=o}function y(e){a.call(this),this.id=e}function P(o){t.call(this,n.deepClone(e.antialias)),this.id=o}function _(o){t.call(this,n.deepClone(e.radial)),this.id=o}function D(o){t.call(this,n.deepClone(e.overlay)),this.id=o}function T(o){t.call(this,n.deepClone(e.levels)),this.id=o}return s.prototype=Object.create(o.prototype),s.prototype.constructor=s,s.prototype.update=function(e){var t=e.options||{};void 0!==t.opacity&&(this.copyMaterial.uniforms.opacity=t.opacity/100),void 0!==t.size&&(this.convolutionMaterial.uniforms.size=t.size),void 0!==t.brightness&&(this.bcMaterial.uniforms.brightness=t.brightness/100),void 0!==t.contrast&&(this.bcMaterial.uniforms.contrast=t.contrast/100),void 0!==e.enabled&&(this.enabled=e.enabled)},s.label="Bloom",s.options=[{key:"opacity",name:"Opacity",type:"int",control:"slider",min:0,max:100,"default":100},{key:"size",name:"Size",type:"float",control:"slider",min:0,max:10,decimals:1,"default":2},{key:"brightness",name:"Gain",type:"int",control:"slider",min:-100,max:100,"default":0},{key:"contrast",name:"Intensity",type:"int",control:"slider",min:-100,max:100,"default":0}],l.prototype=Object.create(i.prototype),l.prototype.constructor=l,l.prototype.update=function(e){var t=e.options||{};void 0!==e.enabled&&(this.enabled=e.enabled),void 0!==t.sigma&&this.updateSigma(t.sigma),void 0!==t.threshold&&this.updateThreshold(t.threshold),void 0!==t.edgeColor&&this.updateEdgeColor(t.edgeColor),void 0!==t.backgroundColor&&this.updateBackgroundColor(t.backgroundColor),void 0!==t.backgroundMix&&this.updateBackgroundMix(t.backgroundMix)},l.label="Edge detect",l.options=[{key:"sigma",name:"Gauss Sigma",type:"float",control:"slider",min:.01,max:1.7,decimals:2,"default":.6},{key:"threshold",name:"Threshold",type:"float",control:"slider",min:1e-14,max:.11,decimals:20,"default":.005},{key:"backgroundMix",name:"Background %",type:"float",control:"slider",min:0,max:1,decimals:2,"default":0},{key:"edgeColor",name:"Edge Color",type:"vec3",control:"color","default":[0,1,0]},{key:"backgroundColor",name:"Background Color",type:"vec3",control:"color","default":[0,0,0]}],u.prototype=Object.create(r.prototype),u.prototype.constructor=u,u.prototype.update=function(e){var t=e.options||{};void 0!==t.opacity&&(this.copyMaterial.uniforms.opacity=t.opacity/100),void 0!==t.size&&(this.blurX=[.001953125*t.size,0],this.blurY=[0,.001953125*t.size]),void 0!==e.enabled&&(this.enabled=e.enabled)},u.label="Blur",u.options=[{key:"opacity",name:"Amount",type:"int",control:"slider",min:0,max:100,"default":100},{key:"size",name:"Size",type:"float",control:"slider",min:0,max:5,decimals:1,"default":1}],d.prototype=Object.create(t.prototype),d.prototype.construcor=d,d.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.offset&&(o.uniforms.offset=t.offset),void 0!==t.darkness&&(o.uniforms.darkness=t.darkness),void 0!==e.enabled&&(this.enabled=e.enabled)},d.label="Vignette",d.options=[{key:"offset",type:"float",control:"slider",name:"Offset",min:0,max:10,decimals:1,"default":1},{key:"darkness",type:"float",control:"slider",name:"Darkness",min:0,max:2,decimals:2,"default":1.5}],c.prototype=Object.create(t.prototype),c.prototype.constructor=c,c.prototype.update=function(e){var t=e.options;void 0!==t.amount&&(this.material.uniforms.amount=t.amount/100),void 0!==e.enabled&&(this.enabled=e.enabled)},c.label="Sepia",c.options=[{key:"amount",name:"Amount",type:"int",control:"slider",min:0,max:100,"default":100}],v.prototype=Object.create(t.prototype),v.prototype.constructor=v,v.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.nIntensity&&(o.uniforms.nIntensity=t.nIntensity/100),void 0!==t.sIntensity&&(o.uniforms.sIntensity=t.sIntensity/100),void 0!==t.sCount&&(o.uniforms.sCount=t.sCount),void 0!==e.enabled&&(this.enabled=e.enabled)},v.label="Film Grain",v.options=[{key:"nIntensity",type:"int",control:"slider",name:"Noise",min:0,max:100,"default":50},{key:"sIntensity",type:"int",control:"slider",name:"Line Intensity",min:0,max:100,"default":50},{key:"sCount",type:"int",control:"slider",name:"Line Count",min:1,max:4096,"default":1024}],f.prototype=Object.create(t.prototype),f.prototype.constructor=f,f.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.nIntensity&&(o.uniforms.nIntensity=t.nIntensity/100),void 0!==e.enabled&&(this.enabled=e.enabled)},f.label="Noise",f.options=[{key:"nIntensity",type:"int",control:"slider",name:"Noise",min:0,max:100,"default":50}],m.prototype=Object.create(t.prototype),m.prototype.constructor=m,m.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.amount&&(o.uniforms.amount=t.amount),void 0!==t.angle&&(o.uniforms.angle=t.angle),void 0!==e.enabled&&(this.enabled=e.enabled)},m.label="RgbShift",m.options=[{key:"amount",type:"float",control:"slider",name:"Amount",min:0,max:.05,decimals:3,"default":.005},{key:"angle",type:"float",control:"slider",name:"Angle",min:0,max:6.28,decimals:1,"default":0}],p.prototype=Object.create(t.prototype),p.prototype.constructor=p,p.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.opacity&&(o.uniforms.opacity=t.opacity),void 0!==e.enabled&&(this.enabled=e.enabled)},p.label="Bleach",p.options=[{key:"opacity",type:"float",control:"slider",name:"Opacity",min:0,max:1,decimals:2,"default":1}],g.prototype=Object.create(t.prototype),g.prototype.constructor=g,g.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.hue&&(o.uniforms.hue=t.hue),void 0!==t.saturation&&(o.uniforms.saturation=t.saturation),void 0!==t.brightness&&(o.uniforms.brightness=t.brightness),void 0!==e.enabled&&(this.enabled=e.enabled)},g.label="HSB",g.options=[{key:"hue",type:"float",control:"slider",name:"Hue",min:-1,max:1,decimals:2,"default":0},{key:"saturation",type:"float",control:"slider",name:"Saturation",min:-1,max:1,decimals:2,"default":0},{key:"brightness",type:"float",control:"slider",name:"Brightness",min:-1,max:1,decimals:2,"default":0}],h.prototype=Object.create(t.prototype),h.prototype.constructor=h,h.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.color&&(o.uniforms.color=t.color),void 0!==t.amount&&(o.uniforms.amount=t.amount),void 0!==e.enabled&&(this.enabled=e.enabled)},h.label="Tint",h.options=[{key:"color",type:"vec3",control:"color",name:"Color","default":[1,1,1]},{key:"amount",type:"float",control:"slider",name:"Amount",min:0,max:1,decimals:2,"default":1}],x.prototype=Object.create(t.prototype),x.prototype.constructor=x,x.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.width&&(o.uniforms.width=t.width),void 0!==t.spread&&(o.uniforms.spread=t.spread),void 0!==e.enabled&&(this.enabled=e.enabled);
},x.label="Hatch",x.options=[{key:"width",type:"float",control:"slider",name:"Width",min:0,max:10,decimals:1,"default":2},{key:"spread",type:"int",control:"slider",name:"Spread",min:1,max:50,"default":8}],M.prototype=Object.create(t.prototype),M.prototype.constructor=M,M.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.angle&&(o.uniforms.angle=t.angle),void 0!==t.scale&&(o.uniforms.scale=t.scale),void 0!==t.sizex&&(o.uniforms.tSize[0]=t.sizex),void 0!==t.sizey&&(o.uniforms.tSize[1]=t.sizey),void 0!==e.enabled&&(this.enabled=e.enabled)},M.label="Dot",M.options=[{key:"angle",type:"float",control:"slider",name:"Angle",min:0,max:10,decimals:2,"default":1.57},{key:"scale",type:"float",control:"slider",name:"Scale",min:0,max:10,decimals:2,"default":1},{key:"sizex",type:"int",control:"slider",name:"SizeX",min:0,max:1024,"default":256},{key:"sizey",type:"int",control:"slider",name:"SizeY",min:0,max:1024,"default":256}],b.prototype=Object.create(t.prototype),b.prototype.constructor=b,b.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.brightness&&(o.uniforms.brightness=t.brightness),void 0!==t.contrast&&(o.uniforms.contrast=t.contrast),void 0!==t.saturation&&(o.uniforms.saturation=t.saturation),void 0!==e.enabled&&(this.enabled=e.enabled)},b.label="Contrast",b.options=[{key:"brightness",type:"float",control:"slider",name:"Brightness",min:-1,max:1,decimals:2,"default":0},{key:"contrast",type:"float",control:"slider",name:"Contrast",min:0,max:1,"default":0},{key:"saturation",type:"float",control:"slider",name:"Saturation",min:-1,max:1,decimals:2,"default":0}],y.prototype=Object.create(a.prototype),y.prototype.constructor=y,y.prototype.update=function(e){var t=e.options,o=this.inPass.material.shader;void 0!==t.blend&&(o.uniforms.blend=t.blend),void 0!==t.scale&&(o.uniforms.scale=t.scale),void 0!==e.enabled&&(this.enabled=e.enabled)},y.label="Motion Blur",y.options=[{key:"blend",type:"float",control:"slider",name:"Amount",min:0,max:1,"default":.5},{key:"scale",type:"float",name:"Scale",min:.2,"default":1,scale:.01}],P.prototype=Object.create(t.prototype),P.prototype.constructor=P,P.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.span&&(o.uniforms.FXAA_SPAN_MAX=t.span,o.uniforms.FXAA_REDUCE_MUL=1/t.span),void 0!==e.enabled&&(this.enabled=e.enabled)},P.label="Antialias",P.options=[{key:"span",type:"int",control:"slider",name:"Span",min:0,max:16,"default":8}],_.prototype=Object.create(t.prototype),_.prototype.constructor=_,_.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.offset&&(o.uniforms.offset=t.offset),void 0!==t.multiplier&&(o.uniforms.multiplier=t.multiplier),void 0!==e.enabled&&(this.enabled=e.enabled)},_.label="Radial",_.options=[{key:"offset",type:"float",control:"slider",name:"Offset",min:-1,max:1,decimals:2,"default":-.5},{key:"multiplier",type:"float",control:"slider",name:"Multiplier",min:-1,max:1,decimals:2,"default":.75}],D.prototype=Object.create(t.prototype),D.prototype.constructor=D,D.blendmodes=["Normal","Lighten","Darken","Multiply","Average","Add","Substract","Difference","Negation","Exclusion","Screen","Overlay","SoftLight","HardLight","ColorDodge","ColorBurn","LinearLight","VividLight","PinLight","HardMix","Reflect","Glow","Phoenix"],D.prototype.update=function(e){var t=e.options,o=this.material.shader;if(void 0!==t.blendmode){var r=D.blendmodes.indexOf(t.blendmode);r!==o.defines.OVERLAY_TYPE&&(o.setDefine("OVERLAY_TYPE",r),o.uniforms.amount=t.amount-.01)}void 0!==t.amount&&(o.uniforms.amount=t.amount),null!=t.url?this.material.setTexture("OVERLAY_MAP",t.url):this.material.removeTexture("OVERLAY_MAP"),void 0!==e.enabled&&(this.enabled=e.enabled)},D.label="Overlay",D.options=[{key:"url",name:"Texture",type:"texture","default":{enabled:!0}},{key:"blendmode",name:"Blend Mode",type:"string",control:"select",options:D.blendmodes,"default":"Normal"},{key:"amount",name:"Amount",type:"float",control:"slider",min:0,max:1,decimals:2,"default":1}],T.prototype=Object.create(t.prototype),T.prototype.constructor=T,T.prototype.update=function(e){var t=e.options,o=this.material.shader;void 0!==t.gamma&&(o.uniforms.gamma=t.gamma),void 0!==t.gamma&&(o.uniforms.gamma=t.gamma),void 0!==t.minInput&&(o.uniforms.minInput=t.minInput),void 0!==t.maxInput&&(o.uniforms.maxInput=t.maxInput),void 0!==t.minOutput&&(o.uniforms.minOutput=t.minOutput),void 0!==t.maxOutput&&(o.uniforms.maxOutput=t.maxOutput),void 0!==e.enabled&&(this.enabled=e.enabled)},T.label="Levels",T.options=[{key:"gamma",type:"float",control:"slider",name:"Gamma",min:0,max:5,decimals:2,"default":1},{key:"minInput",type:"float",control:"slider",name:"Min Input",min:0,max:1,decimals:2,"default":0},{key:"maxInput",type:"float",control:"slider",name:"Max Input",min:0,max:1,decimals:2,"default":1},{key:"minOutput",type:"float",control:"slider",name:"Min Output",min:0,max:1,decimals:2,"default":0},{key:"maxOutput",type:"float",control:"slider",name:"Max Output",min:0,max:1,decimals:2,"default":1}],{Bloom:s,Blur:u,Vignette:d,Sepia:c,Grain:v,Noise:f,RgbShift:m,Bleach:p,HSB:g,Colorify:h,Hatch:x,Dot:M,Contrast:b,DiffOfGaussians:l,MotionBlur:y,Antialias:P,Radial:_,Overlay:D,Levels:T}}(goo.ShaderLibExtra,goo.FullscreenPass,goo.BloomPass,goo.BlurPass,goo.DogPass,goo.MotionBlurPass,goo.ObjectUtils),goo.PosteffectsHandler=function(e,t,o,r,i,a,n,s,l,u){"use strict";function d(){e.apply(this,arguments),this._composer=new a;var t=this.world.getSystem("RenderSystem");this._renderPass=new n(t.renderList),this._outPass=new s(i.deepClone(l.copy)),this._outPass.renderToScreen=!0}return d.prototype=Object.create(e.prototype),d.prototype.constructor=d,e._registerClass("posteffects",d),d.prototype._remove=function(e){var o=this.world.getSystem("RenderSystem");t.remove(o.composers,this._composer),this._objects["delete"](e),this.world&&this._composer.destroy(this.world.gooRunner.renderer),this._composer=new a},d.prototype._create=function(){return[]},d.prototype._update=function(r,a,n){var s=this;return e.prototype._update.call(this,r,a,n).then(function(e){if(e){var t=e.slice(),r=[];return i.forEach(a.posteffects,function(e){r.push(s._updateEffect(e,t,n))},null,"sortValue"),o.all(r).then(function(t){for(var o=0;o<t.length;o++)e[o]=t[o];return e.length=o,e})}}).then(function(e){if(e){var o=e.some(function(e){return e.enabled}),r=s.world.getSystem("RenderSystem"),i=s._composer;if(o){i.passes=[],i.addPass(s._renderPass);for(var a=0;a<e.length;a++){var n=e[a];n&&n.enabled&&i.addPass(e[a],s.world.gooRunner.renderer)}i.addPass(s._outPass),-1===r.composers.indexOf(i)&&r.composers.push(i)}else t.remove(r.composers,s._composer);return e}})},d.prototype._updateEffect=function(e,t,r){function a(e,t){return l._load(t,r).then(function(t){s.options[e]=t})}for(var n,s=i.deepClone(e),l=this,d=0;d<t.length;d++)if(t[d].id===s.id){n=t[d];break}if(!n){if(!u[s.type])return null;n=new u[s.type](s.id)}for(var c=[],d=0;d<u[s.type].options.length;d++){var v=u[s.type].options[d],f=v.key,m=v.type;"texture"===m?s.options[f]&&s.options[f].textureRef&&s.options[f].enabled?c.push(a(f,s.options[f].textureRef)):s.options[f]=null:"entity"===m&&(s.options[f]&&s.options[f].entityRef&&s.options[f].enabled?c.push(a(f,s.options[f].entityRef)):s.options[f]=null)}return o.all(c).then(function(){return n.update(s),n})},d}(goo.ConfigHandler,goo.ArrayUtils,goo.rsvp,goo.PromiseUtils,goo.ObjectUtils,goo.Composer,goo.RenderPass,goo.FullscreenPass,goo.ShaderLib,goo.PassLib),goo.SsaoPass=function(e,t,o,r,i,a,n,s,l,u,d){"use strict";function c(t){this.depthPass=new n(t),this.depthPass.clearColor.setDirect(1,1,1,1);var o=new e(v);this.depthPass.overrideMaterial=o,this.downsampleAmount=4;var r=window.innerWidth||1024,i=window.innerHeight||1024;this.updateSize({x:0,y:0,width:r,height:i}),this.enabled=!0,this.clear=!1,this.needsSwap=!0}c.prototype=Object.create(d.prototype),c.prototype.constructor=c,c.prototype.updateSize=function(e){var r=Math.floor(e.width/this.downsampleAmount),i=Math.floor(e.height/this.downsampleAmount),a=o.deepClone(u.ssao);a.uniforms.size=[r,i],this.outPass=new s(a),this.outPass.useReadBuffer=!1,this.blurPass=new l({sizeX:r,sizeY:i}),this.depthTarget=new t(r,i,{magFilter:"NearestNeighbor",minFilter:"NearestNeighborNoMipMaps"}),console.log("UPDATE SSAOPASS: ",r,i)},c.prototype.render=function(e,t,o,r){this.depthPass.render(e,null,this.depthTarget,r),this.outPass.material.setTexture(i.DIFFUSE_MAP,o),this.outPass.material.setTexture(i.DEPTH_MAP,this.depthTarget),this.outPass.render(e,t,o,r)};var v={attributes:{vertexPosition:r.POSITION},uniforms:{viewMatrix:i.VIEW_MATRIX,projectionMatrix:i.PROJECTION_MATRIX,worldMatrix:i.WORLD_MATRIX},vshader:["attribute vec3 vertexPosition;","uniform mat4 viewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 worldMatrix;","void main(void) {","	gl_Position = projectionMatrix * viewMatrix * worldMatrix * vec4(vertexPosition, 1.0);","}"].join("\n"),fshader:["precision mediump float;",a.methods.packDepth,"void main(void) {","	gl_FragColor = packDepth(gl_FragCoord.z);","}"].join("\n")};return c}(goo.Material,goo.RenderTarget,goo.ObjectUtils,goo.MeshData,goo.Shader,goo.ShaderFragment,goo.RenderPass,goo.FullscreenPass,goo.BlurPass,goo.ShaderLibExtra,goo.Pass),"function"==typeof require&&(define("goo/passpack/ShaderLibExtra",[],function(){return goo.ShaderLibExtra}),define("goo/passpack/BloomPass",[],function(){return goo.BloomPass}),define("goo/passpack/BlurPass",[],function(){return goo.BlurPass}),define("goo/passpack/DepthPass",[],function(){return goo.DepthPass}),define("goo/passpack/DofPass",[],function(){return goo.DofPass}),define("goo/passpack/DogPass",[],function(){return goo.DogPass}),define("goo/passpack/MotionBlurPass",[],function(){return goo.MotionBlurPass}),define("goo/passpack/PassLib",[],function(){return goo.PassLib}),define("goo/passpack/PosteffectsHandler",[],function(){return goo.PosteffectsHandler}),define("goo/passpack/SsaoPass",[],function(){return goo.SsaoPass}));