/***********************************************/
/* Demo							*/
/* Small demo to show background spritefonts	*/
/* And yes after the trivia starfield we now	*/
/* progress to the trival sine scroller :-)	*/
/* 								*/
/*There are probably 100 more effective ways	*/
/*to create a similar scroller, anyone care	*/
/*to mail me a better one ?				*/
/*								*/
/* Use this code in whatever way you want...	*/
/* 								*/
/* All rights reserved 					*/
/* Copyright Richard van der Brugge,2000		*/
/*								*/
/* Email: rvdbrugge@yahoo.com 			*/
/*								*/
/***********************************************/

//standard GBDK includes
#include <gb.h>

//import background map made with GBTD and GBMD
//picture converted using FREEGIQ
#include "gfx/Splash_t.c"
#include "gfx/Splash_t.h"
#include "gfx/Splash_p.c"
#include "gfx/Splash_p.h"
#include "gfx/Splash_m.c"
#include "gfx/Splash_m.h"

//include Font data created using GBTD and GB font assistant
#include "gfx/Font_t.c"
#include "gfx/Font_t.h"

//include scroller sine data created with rollercoaster
#include "sine.c"

//Scroller textdata is text translated using a simple VB program I wrote
//SPACE=0 A=1 b=2 etc etc. this nicely matches the Font/font data
//make sure that everything is UPPERCASE 
//This VB program is included with the source code (very very very simple program)

UBYTE scrollertext[]={
0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 5, 12, 3, 15, 13, 5, 0, 20, 15, 0, 20, 8, 5, 0, 19, 3, 18, 15, 12, 12, 5, 18, 0, 4, 5, 13, 15, 0, 2, 25, 0, 18, 9, 3, 8, 1, 18, 4, 0, 22, 1, 14, 0, 4, 5, 18, 0, 2, 18, 21, 7, 7, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 1, 11, 5, 0, 1, 0, 12, 15, 15, 11, 0, 1, 20, 0, 20, 8, 5, 0, 19, 15, 21, 18, 3, 5, 0, 3, 15, 4, 5, 0, 9, 6, 0, 25, 15, 21, 0, 14, 5, 5, 4, 0, 1, 0, 19, 20, 1, 18, 20, 0, 23, 9, 20, 8, 0, 7, 2, 4, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 8, 5, 0, 16, 9, 3, 20, 21, 18, 5, 0, 9, 19, 0, 14, 15, 20, 0, 13, 9, 14, 5, 0, 9, 20, 0, 23, 1, 19, 0, 3, 18, 5, 1, 20, 5, 4, 0, 2, 25, 0, 13, 5, 14, 14, 15, 0, 19, 5, 5, 7, 5, 18, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 18, 5, 5, 20, 9, 14, 7, 19, 0, 20, 15, 0, 5, 22, 5, 18, 25, 15, 14, 5, 0, 9, 14, 0, 20, 8, 5, 0, 7, 2, 0, 19, 3, 5, 14, 5, 0, 0, 0, 0, 0, 0, 0
};

//the lenght of the text
#define SCROLL_LENGHT 270

//create pallette array for the splashmap
UWORD SplashTilesPAL[8*4] =
{ SplashTilesCGBPal0c0,SplashTilesCGBPal0c1,SplashTilesCGBPal0c2,SplashTilesCGBPal0c3,
  SplashTilesCGBPal1c0,SplashTilesCGBPal1c1,SplashTilesCGBPal1c2,SplashTilesCGBPal1c3,
  SplashTilesCGBPal2c0,SplashTilesCGBPal2c1,SplashTilesCGBPal2c2,SplashTilesCGBPal2c3,
  SplashTilesCGBPal3c0,SplashTilesCGBPal3c1,SplashTilesCGBPal3c2,SplashTilesCGBPal3c3,
  SplashTilesCGBPal4c0,SplashTilesCGBPal4c1,SplashTilesCGBPal4c2,SplashTilesCGBPal4c3,
  SplashTilesCGBPal5c0,SplashTilesCGBPal5c1,SplashTilesCGBPal5c2,SplashTilesCGBPal5c3,
  SplashTilesCGBPal6c0,SplashTilesCGBPal6c1,SplashTilesCGBPal6c2,SplashTilesCGBPal6c3,
  SplashTilesCGBPal7c0,SplashTilesCGBPal7c1,SplashTilesCGBPal7c2,SplashTilesCGBPal7c3 };

//palette for the Fonts
UWORD FontPalList[]=
{FontTilesCGBPal1c0,FontTilesCGBPal1c1,FontTilesCGBPal1c2,FontTilesCGBPal1c3,
FontTilesCGBPal2c0,FontTilesCGBPal2c1,FontTilesCGBPal2c2,FontTilesCGBPal2c3,
FontTilesCGBPal3c0,FontTilesCGBPal3c1,FontTilesCGBPal3c2,FontTilesCGBPal3c3,
FontTilesCGBPal4c0,FontTilesCGBPal4c1,FontTilesCGBPal4c2,FontTilesCGBPal4c3,};
//arrays for the scroller
UBYTE xpos[10];
UBYTE ycounter[10];
//controls if a sprite is displayed or not (moved beyond the screen at 200,200 is off in this case)
UBYTE spriteon[10];
UBYTE scrollcounter;

//tell the compiler that the following procedures are really in this code
void scrollsprite(UBYTE scrnumber);
void init();

void main()
{
UBYTE i;
UBYTE r;
//if we're not on a color gameboy, complain and stop....

//setup Fonts
HIDE_SPRITES;
SPRITES_8x8;
//transfer sprite pallete data
set_sprite_palette( 0, 1, &FontPalList[0] );
set_sprite_palette( 1, 1, &FontPalList[4] );
set_sprite_palette( 2, 1, &FontPalList[8] );
set_sprite_palette( 3, 1, &FontPalList[12] );
set_sprite_palette( 4, 1, &FontPalList[16] );
set_sprite_palette( 5, 1, &FontPalList[20] );
set_sprite_palette( 6, 1, &FontPalList[24] );
//transfer sprite tile data
set_sprite_data(0,50,FontTiles);
for (i=2;i<28;i++){
	set_sprite_tile(i,i);
}
SHOW_SPRITES;
//create background picture, first hide the background 
HIDE_BKG;
//transfer the palette data


  set_bkg_palette( 7, 1, &SplashTilesPAL[28]  );
  set_bkg_palette( 6, 1, &SplashTilesPAL[24]  );
  set_bkg_palette( 5, 1, &SplashTilesPAL[20]  );
  set_bkg_palette( 4, 1, &SplashTilesPAL[16] );
  set_bkg_palette( 3, 1, &SplashTilesPAL[12] );
  set_bkg_palette( 2, 1, &SplashTilesPAL[8] );
  set_bkg_palette( 1, 1, &SplashTilesPAL[4] );
  set_bkg_palette( 0, 1, &SplashTilesPAL[0] );
  /* Select VRAM bank 0 */
  VBK_REG = 0;

  /* Transfer first half */
  set_bkg_data( 0, 256, SplashTiles );


  /* Select VRAM bank 1 */
  VBK_REG = 1;

  /* Transfer second half */
//  set_bkg_data( 0, 256, SplashTilesBLK1 );


  /* Select VRAM bank 1 (which stores the attributes) */
  VBK_REG = 1;

  /* Set attributes */
	set_bkg_tiles(0,0,SplashWidth,SplashHeight,SplashPLN1);


  /* Select VRAM bank 0 (which stores the tiles) */
  VBK_REG = 0;

  /* Set data */
	set_bkg_tiles(0,0,SplashWidth,SplashHeight,SplashPLN0);





SHOW_BKG;
//call the init procedure to set things up
init();

//loop forever
while (1) {
for (i=0;i<11;i++){
if (spriteon[i]==1){scrollsprite(i);}
}
wait_vbl_done();
}

}//end main

void init()
{
UBYTE i;
//fillup the first 10 sprites with the text
for (i=0;i<11;i++){
	xpos[i]=160;
	set_sprite_tile(i,scrollertext[i]);
	ycounter[i]=0;
}
scrollcounter=11;
//set the first sprite on else nothing will happen
//sprite1 will trigger sprite2 etc etc until sprite 10 which will trigger sprite 1 again
spriteon[1]=1;



}//end init


void scrollsprite(UBYTE sprnumber)
{

move_sprite(sprnumber,xpos[sprnumber],siney[ycounter[sprnumber]]);
xpos[sprnumber]--;

if (xpos[sprnumber]==142){
	spriteon[sprnumber+1]=1;
	if (sprnumber=10){spriteon[1]=1;}
}

if (xpos[sprnumber]==0){
	xpos[sprnumber]=160;
	spriteon[sprnumber]=0;
	move_sprite(sprnumber,200,200);
	ycounter[sprnumber]=0;
	set_sprite_tile(sprnumber,scrollertext[scrollcounter]);

	scrollcounter++;
		if (scrollcounter==SCROLL_LENGHT){
		scrollcounter=0;
		}
	return;
}

ycounter[sprnumber]++;
if (ycounter[sprnumber]==160){
	ycounter[sprnumber]=0;
	}
}//end scrollsprite
