varying vec3 coord;
varying vec3 vcoord;
varying vec3 normal;

uniform float ptimer;
uniform sampler2D tex;

void main()
{
	float t = ptimer / 64.0;
	float d = abs(vcoord.z / 886.0);
	if (d<0.125) d = 0.125;
	if (d>1.0) d = 1.0;

	vec2 tc = gl_TexCoord[0].st;

	tc.s = tc.s + sin((7.5 * (coord.y + t)) / 40.0) * 0.075 + sin((3.5 * (coord.z + coord.x + t)) / 96.0) * 0.025;
	tc.t = tc.t + sin((5.0 * (coord.x + t)) / 32.0) * 0.05 + sin((2.5 * (coord.z + coord.y + t)) / 80.0) * 0.0125;

	vec4 color = texture2D(tex,tc);

	color.r = (((1.5 * color.r * (1.0 - d) + 1.0 * d)) * 1.25 * normal.x * normal.z) * (1.0 - d) + 1.0 * d;
	color.g = (((1.5 * color.g * (1.0 - d) + 1.0 * d)) * 0.75 * normal.y * normal.z) * (1.0 - d) + 1.0 * d;
	color.b = (((2.0 * color.b * (1.0 - d) + 1.0 * d)) * 2.0 * normal.z * normal.z) * (1.0 - d) + 1.5 * d;
	color.a = 1.0;

	gl_FragColor = color;
}
