//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

// nulstein.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "nulstein.h"
#include "Gfx/Gfx.h"
#include "nulsteinWindow.h"

// Global Variables:
CNulsteinWindow*	gpMainWindow;

// Forward declarations of functions included in this code module:
BOOL InitInstance(HINSTANCE, int, const char*);
void ExitInstance();

int APIENTRY WinMain  (	HINSTANCE 	hInstance,
						HINSTANCE 	hPrevInstance,
						LPSTR		lpCmdLine,
						int			nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	gpMainWindow = NULL;
	
	// init CRT
	// init_heap();
	// init_global_vars();
	// init_exception_handling();

	/* Perform application initialization */ 
	if (!InitInstance (hInstance, nCmdShow, lpCmdLine))
		return FALSE;

	/* Main message loop */ 
	for(;;)
	{
		MSG		msg;

		/* process windows messages */ 
		while( PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) ) 
		{  
			if (msg.message==WM_QUIT) 
			{
				ExitInstance();
				return (int) msg.wParam;
			}
					
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		
		/* run game */ 
		gpMainWindow->Frame();
	}
}


//________________________________________________________________________________
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow, const char* lpCmdLine)
{
	bool	bOk;
	ULONG	HeapFragValue;
	
	/* Use low fragmentation heap */ 
	HeapFragValue = 2;
    HeapSetInformation( GetProcessHeap(), HeapCompatibilityInformation, &HeapFragValue, sizeof(HeapFragValue) );
	
	/* register window class */ 
	CNulsteinWindow::RegisterClass(hInstance);

	/* create Window */ 
	gpMainWindow = new CNulsteinWindow;
	
	#if FULLSCREEN_DEFAULT
	gpMainWindow->m_Gfx.m_bFullscreen = (*lpCmdLine!='W');
	#else
	gpMainWindow->m_Gfx.m_bFullscreen = (*lpCmdLine=='F');
	#endif
	
	bOk = gpMainWindow->Create(	_T("nulstein"), 
								WS_OVERLAPPEDWINDOW,
								CW_USEDEFAULT, CW_USEDEFAULT, 
								CW_USEDEFAULT, CW_USEDEFAULT, 
								NULL, NULL, hInstance);

	if (FAILED(bOk))
		return FALSE;

	/* show it up */ 	
	if (gpMainWindow->m_Gfx.m_bFullscreen)
	{
		 ShowWindow(gpMainWindow->m_hWnd, SW_SHOWMAXIMIZED);
		 SetWindowPos(gpMainWindow->m_hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
	}
	else 
	{
		ShowWindow(gpMainWindow->m_hWnd, nCmdShow);
	}
	
	return TRUE;
}

void ExitInstance()
{
}

//________________________________________________________________________________
#ifdef _DEBUG
void TRACE(const char * format, ...)
{
	char s[256];
	va_list argptr;
          
	va_start( argptr, format );
	wvsprintfA( s, format, argptr );
	va_end( argptr );
	
	OutputDebugStringA(s);
}
#endif
