//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "stdafx.h"
#include "nulstein.h"
#include "Gfx/Gfx.h"
#include "NulsteinWindow.h"
#include "Mutex.h"
#include "TaskScheduler.h"

#include <mmSystem.h>

#define WINDOWCLASSNAME _T("NULSTEIN")

CNulsteinWindow::CNulsteinWindow()
{
	m_bInFrame	= false;
}

CNulsteinWindow::~CNulsteinWindow()
{
}

ATOM CNulsteinWindow::RegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= CNulsteinWindow::_WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_NULSTEIN));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= WINDOWCLASSNAME;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_NULSTEIN));

	return RegisterClassEx(&wcex);
}

bool CNulsteinWindow::Create(
							LPCTSTR lpWindowName, 
							DWORD dwStyle,
							int x,
							int y,
							int nWidth,
							int nHeight,
							HWND hWndParent,
							HMENU hMenu,
							HINSTANCE hInstance)
{
	m_hInst = hInstance;
	
	m_hWnd = CreateWindow(	WINDOWCLASSNAME,
							lpWindowName,
							dwStyle,
							x,y,
							nWidth,nHeight,
							hWndParent,
							hMenu,
							hInstance,
							(LPVOID)this);
	
	if (!m_hWnd) return false;

	return true;
}

LRESULT CALLBACK CNulsteinWindow::_WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	CNulsteinWindow*	pThis;
	CREATESTRUCT*		pCS;
	
	pThis = (CNulsteinWindow*) GetWindowLongPtr(hWnd, GWLP_USERDATA);
	
	/* if we know the window, handle message to object */ 
	if (pThis) 
		return pThis->WndProc(message, wParam, lParam);
	
	/* Take default action until we get WM_CREATE */ 
	if (message!=WM_NCCREATE)
		return DefWindowProc(hWnd, message, wParam, lParam);
	
	/* On WM_NCCREATE, retrieve pointer to object */ 
	pCS = (CREATESTRUCT*) lParam;
	pThis = (CNulsteinWindow*) pCS->lpCreateParams;
	
	/* link hWnd and pThis together */ 
	pThis->m_hWnd = hWnd;
	SetWindowLongPtr(hWnd, GWLP_USERDATA, (LONG_PTR)pThis);
	
	/* process WM_CREATE */ 
	return pThis->WndProc(message, wParam, lParam);
}

LRESULT CNulsteinWindow::WndProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	bool		bOk;
	PAINTSTRUCT	ps;
	HDC			hdc;

	switch (message)
	{
		case WM_CREATE:
		{

			bOk = m_Tasks.Start();
			bOk = m_Gfx.Open(m_hWnd);
			bOk = m_Sono.Init(5);
			
			bOk = m_Frame.Open(&m_Gfx, &m_Sono, &m_Tasks, &m_Game, &m_Game);
			
			SetTimer(m_hWnd, 100, USER_TIMER_MINIMUM, NULL);
		}	break;

		case WM_PAINT:
		{
			hdc = BeginPaint(m_hWnd, &ps);
				/* ignore draw */ 
			EndPaint(m_hWnd, &ps);
		}	break;
		
		case WM_ERASEBKGND:
		{	/* Ignore background erasing */ 
		}	break;
		
		case WM_SETCURSOR:
		{
			SetCursor(NULL);
		}	return true;
		
		case WM_TIMER:
		case WM_SIZING: /* keeps window udated cleanly while sizing */ 
		{	
			DefWindowProc(m_hWnd, message, wParam, lParam);
			bOk = Frame();
			
			if (GetKeyState(VK_ESCAPE) & 0x80)
				DestroyWindow(m_hWnd);
		}	break;

		case WM_DESTROY:
		{
			Destroy();
			PostQuitMessage(0);
		}	break;
		
		
#ifdef _DEBUG
		case WM_LBUTTONUP:
		{
			m_Sono.Save("NulsteinTest.wav");
		}	break;
#endif		
		
		default:
			return DefWindowProc(m_hWnd, message, wParam, lParam);
	}
	
	return 0;
}

void CNulsteinWindow::Destroy()
{
	m_Sono.Close();
	m_Frame.Close();
	m_Tasks.Stop();
	m_Gfx.Close();
}

// Frame handler
bool CNulsteinWindow::Frame()
{
	bool bOk;
	
	if (m_bInFrame) 
		return false;
	
	m_bInFrame = true;
	
	bOk = m_Frame.Frame();
	
	m_bInFrame = false;
	return bOk;
}



class CFrameRootTask : public CInternalTask
{
public:
	CFrameRootTask(CTaskCompletion* pCompletion, CFrame* pFrame, int dt)
	:	CInternalTask(pCompletion)
	{
		m_pFrame = pFrame;
		m_dt	 = dt;
	}
	
	bool Run(CWorkerThread* pThread)
	{
		bool bOk;
		
		/* update world */ 
		bOk = m_pFrame->Update(m_dt);
		IF_FAILED_RETURN(bOk);
		
		/* draw frame */ 	
		bOk = m_pFrame->m_pGfx->BeginFrame();
		IF_FAILED_RETURN(bOk);
		
		bOk = m_pFrame->Draw();
		IF_FAILED_RETURN(bOk);
		
		#if USE_PARALLELSORT
		{
			PROFILE_SCOPE("Sort display list")
			/* put things in order */ 	
			m_pFrame->m_DisplayList.EndAndSort();
		}
		#endif

		return true;
	}
	
public:
	CFrame*		m_pFrame;
	int			m_dt;
};

bool CFrame::Frame()
{
	// PROFILE_SCOPE("CFrame::Frame")
	DWORD	t,dt;
	bool	bOk;
	
	/* if we're not initialized (yet), return gracefuly */ 
	if (!m_pGfx) return true;
	
	/* update time */ 
	t		= m_pSono->GetBufferTime(); 
	dt		= t-m_t0;
	m_t0	= t;
	
	{	/* update and draw */ 
		CWorkerThread*	pThread = CWorkerThread::GetCurrent();
		CTaskCompletion	Completion;
		CFrameRootTask	RootTask(&Completion, this, dt);

		#if USE_FRAMEROOTTASK
		/* create one big root task, to avoid going idle during update+draw (spins more) */ 
		pThread->PushTask(&RootTask);
		pThread->WorkUntilDone(&Completion);
		#else
		/* don't use a big root task, go idle between phases (syncs more) */ 
		RootTask.Run(pThread);	
		#endif
	}
	
	/* Serial part starts here, let tasking engine go idle */ 
	#if !USE_FRAMEROOTTASK || !USE_PARALLELSORT
	{
		PROFILE_SCOPE("Sort display list")
		/* put things in order */ 	
		m_DisplayList.EndAndSort();
	}
	#endif

	bOk = Render();
	IF_FAILED_RETURN(bOk);
	
	bOk = m_pGfx->EndFrame();
	IF_FAILED_RETURN(bOk);
			
	return true;
}

