//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx/Mesh.h"
#include "Gfx/DisplayList.h"
#include "MeshPrimitive.h"
#include "EntityCamera.h"
#include "Frame.h"

CMeshInstance::CMeshInstance()
:	m_Tint(1.0f, 1.0f, 1.0f, 0.8f)
{
}

CMeshInstance::~CMeshInstance()
{
}

bool CMeshInstance::Render(CGfx* pGfx, const CDisplayItemKey &Key, ULONG iMtl)
{
	bool		bOk;
	
	/* render */ 
	bOk = m_pMesh->Draw(pGfx, m_ModelToWorld, m_Tint);
	IF_FAILED_RETURN(bOk);
	
	return true;
}

bool CMeshInstance::AddToDisplayList(CDisplayListAdder* pDisplayListAdder, uint32_t EntityKey, int iView)
{
	bool				bOk;
	int					iMtl;
	CDisplayList*		pDL;
	CView*				pView;
	CDisplayItemKey		Key;
	CVector3			WorldPos(m_ModelToWorld.m14, m_ModelToWorld.m24, m_ModelToWorld.m34);

	/* easy pointers */ 
	pDL		= pDisplayListAdder->m_pDisplayList;
	pView	= &pDL->m_View[iView];
	
	/* make display list key */ 
	Key.Clear();
	bOk = pView->SetDisplayItemKey(&Key, iView);
	IF_FAILED_RETURN(bOk);
	
	/* compute Z in this view */ 
	Key.m_Depth = pView->m_pCamera->ComputeZ(WorldPos);
		
	/* add each primitive */ 
	for(iMtl=0; iMtl<1; iMtl++)
	{
		/* TODO: update key to reflect material */ 
		Key.m_AlphaBlend	= m_Tint.w < 255.0f/256.0f;
		pDisplayListAdder->Add(Key, EntityKey, iMtl);
	}
	
	return true;
}

