//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_MESHCUBE_H_
#define _NULSTEIN_MESHCUBE_H_

#include "Gfx/Gfx.h"
#include "Gfx/Mesh.h"

class CMeshCube : public CMesh
{
public:
	CMeshCube();
	~CMeshCube();
	
	bool Create(CGfx* pGfx, float Spherity /* cube=0.0f, sphere=1.0f */, float Length /* 1.0f */, int SubdivisionCount /* 0 */ );
	
	bool CreateCube(CGfx* pGfx, float Length /* 1.0f */, int SubdivisionCount /* 0 */ )
	{
		return Create(pGfx, 0.0f, Length, SubdivisionCount);
	}
	
	bool CreateSphere(CGfx* pGfx, float Radius /* 1.0f */, int SubdivisionCount /* 0 */ );
};

#endif //_NULSTEIN_MESHCUBE_H_