//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//
#ifndef _NULSTEIN_GAME_H_ 
#define _NULSTEIN_GAME_H_ 

#include "Frame.h"
#include "MeshCube.h"
#include "EntitySimpleMesh.h"
#include "EntityCamera.h"


#define CUBES_PER_AXIS	8
#define CUBES_TOTAL		(CUBES_PER_AXIS*CUBES_PER_AXIS*CUBES_PER_AXIS)
#define CUBES_OFFSET	float(CUBES_PER_AXIS-1)

//________________________________________________________________________________ 
class CEntityGameCamera : public CEntityCamera
{
public:
	CEntityGameCamera(CEntitySlot* pSlot): CEntityCamera(pSlot) {}

	bool Update(CFrame* pFrame, float dt);
	
public:
	float	m_t;
};

//________________________________________________________________________________
class CEntityMusic : public CEntity
{
public:
	CEntityMusic(CEntitySlot* pSlot): CEntity(pSlot) {}

	bool PreUpdate(CFrame* pFrame, float dt) { return true; }
	bool Update(CFrame* pFrame, float dt);
	
	bool Draw(CDisplayListAdder* pDL, uint32_t EntityKey, int iView) { return true; }
	
	bool Render(CGfx* pGfx, const CDisplayItemKey &Key, uint32_t EntityKey, ULONG Param) { return true; }
};

//________________________________________________________________________________
class CGame : public IGame
{
public:
	CGame();
	
	virtual bool Init(CFrame* pFrame);

public:
	CMeshCube				m_MeshCube;
	
	CEntitySimpleMesh*		m_Cube[CUBES_TOTAL];
	CEntityMusic*			m_pMusic;
};

inline CGame* GetGame(CFrame* pFrame) {return (CGame*)pFrame->m_pGameAsVoid;}

//________________________________________________________________________________
class CEntityDancingSimpleMesh : public CEntitySimpleMesh
{
public:
	CEntityDancingSimpleMesh(CEntitySlot* pSlot, int iTrack);
	
	bool Update(CFrame* pFrame, float dt);
	
public:
	int		m_iChannel;
	int		m_iTrackItem;
	float	m_TrackTicks;
	float	m_NotesOn;
	
	float	m_BlipTime;

};

//________________________________________________________________________________
class CEntityOrbiter : public CEntitySimpleMesh
{
public:
	CEntityOrbiter(CEntitySlot* pSlot, CEntitySimpleMesh* pParent);

	bool PreUpdate(CFrame* pFrame, float dt);
	bool Update(CFrame* pFrame, float dt);
	
	bool UpdateChase(const CVector3 &Target, const CVector3 &Velocity, float dt);
	
public:
	int					m_iParent;
	CVector3			m_Target;	/* in parent space */ 
	
	bool				m_bChasing;	/* true if we're not attached to our parent */ 
	float				m_NextChase;
	CVector3			m_LastPos;
	float				m_LastDt;
};

#endif // _NULSTEIN_GAME_H_ 