//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "stdafx.h"
#include "nulstein.h"
#include "Gfx/Gfx.h"
#include "nulsteinWindow.h"

bool CFrame::SelectRenderTarget(int iRenderTarget)
{
	bool bOk;
	
	bOk = m_pGfx->SelectRenderTarget(&m_View[iRenderTarget].m_RenderTarget);
	IF_FAILED_RETURN(bOk);
		
	return true;
}

bool CFrame::SelectLayer(int iRenderTarget)
{
	return true;
}

bool CFrame::SelectViewport(int iRenderTarget, int iViewport)
{
	bool bOk;

	/* setup view */ 
	bOk = m_View[iRenderTarget].Setup(m_pGfx);
	IF_FAILED_RETURN(bOk);
	
	/* select default set of lights */ 
	bOk = m_pGfx->SetLights(m_Light, m_LightCount);
	IF_FAILED_RETURN(bOk);
	
	return true;
}

bool CFrame::SelectViewportLayer(int iViewportLayer)
{
	/* TODO: setup layer */ 
	return true;
}

bool CFrame::SelectAlpha(bool bAlpha)
{
	bool bOk;

	bOk = m_pGfx->SelectAlpha(bAlpha);
	IF_FAILED_RETURN(bOk);
	
	return true;
}

//________________________________________________________________________________
bool CFrame::ProcessRenderContextChanges(CDisplayItemKey* pCurrent, const CDisplayItemKey& New)
{
	/* Render Target & Viewport */ 
	if (pCurrent->m_iRenderTarget != New.m_iRenderTarget)
	{
		pCurrent->m_iRenderTarget = New.m_iRenderTarget;
		SelectRenderTarget(New.m_iRenderTarget);
	}
	
	if (pCurrent->m_iLayer != New.m_iLayer)
	{
		pCurrent->m_iLayer = New.m_iLayer;
		SelectLayer(New.m_iLayer);
	}
	
	if (pCurrent->m_iViewport != New.m_iViewport)
	{
		pCurrent->m_iViewport = New.m_iViewport;
		SelectViewport(New.m_iRenderTarget, New.m_iViewport);
	}
	
	if (pCurrent->m_iViewportLayer != New.m_iViewportLayer)
	{
		pCurrent->m_iViewportLayer = New.m_iViewportLayer;
		SelectViewportLayer(New.m_iViewportLayer);
	}
	
	/* if this is a command, were done */ 	
	if (New.m_isCmd)
	{
		pCurrent->m_isCmd		= New.m_isCmd;
		pCurrent->m_CmdPriority	= New.m_CmdPriority;
		pCurrent->m_CmdParam	= New.m_CmdParam;
		return true;
	}
	
	/* Material */ 
	if (pCurrent->m_AlphaBlend != New.m_AlphaBlend)
	{
		pCurrent->m_AlphaBlend = New.m_AlphaBlend;
		SelectAlpha( 0!=New.m_AlphaBlend );
	}
		
	return true;
} 
