//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_DISPLAYITEM_H_
#define _NULSTEIN_DISPLAYITEM_H_

#define MAX_DISPLAYLISTSIZE 16384

//________________________________________________________________________________
class CDisplayItemKey
{
public:
	CDisplayItemKey(){}
	CDisplayItemKey(uint64_t Key) {Decode(Key);}
	
	void Clear();
	void MakeOutOfRange();
	
	operator uint64_t();
	void Decode(uint64_t Key);
	
public:
	int		m_iRenderTarget;
	int		m_iLayer;
	int		m_iViewport;
	int		m_iViewportLayer;
	int		m_AlphaBlend; 
	int		m_isCmd;
	
	int		m_CmdPriority;
	int		m_CmdParam;
	
	int		m_MtlId;
	int		m_MtlPass;
	float	m_Depth; /* 0-1 */ 
};

//________________________________________________________________________________
struct sDisplayItem
{
	uint64_t	m_Key;
	uint32_t	m_EntityKey;
	uint32_t	m_Param;
};

#endif // _NULSTEIN_DISPLAYITEM_H_