//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_ALIGNMENT_H_
#define _NULSTEIN_ALIGNMENT_H_

#define CACHELINE_SIZE			16
#define CACHELINE_ALIGNED		__declspec(align(CACHELINE_SIZE))

//________________________________________________________________________________
#include "Nulstein-Common/ReturnValues.h"

inline bool _FAILED(HRESULT hr)		{return FAILED(hr);} 

//________________________________________________________________________________
#ifdef PROFILE

#include "libittnotify.h"

class CProfilerEvent
{
public:
	CProfilerEvent(const char *sName)
	{
		m_hEvent = __itt_event_createA( (char*)sName, strlen(sName) );
	}
	
	__itt_event m_hEvent;
};

class CProfilerScope
{
public:
	CProfilerScope(CProfilerEvent* pEvent)
	{
		m_pEvent = pEvent;
		__itt_event_start(m_pEvent->m_hEvent);
	}
	
	~CProfilerScope()
	{
		__itt_event_end(m_pEvent->m_hEvent);
	}
	
	CProfilerEvent* m_pEvent;
};

#define PROFILE_SCOPE(_name) static CProfilerEvent ProfilerEvent(_name); CProfilerScope ProfilerScope(&ProfilerEvent);

#define PROFILE_SYNC_PREPARE(pObj)		__itt_notify_sync_prepare( pObj )
#define PROFILE_SYNC_CANCEL(pObj)		__itt_notify_sync_cancel( pObj )
#define PROFILE_SYNC_ACQUIRED(pObj) 	__itt_notify_sync_acquired( pObj )
#define PROFILE_SYNC_RELEASING(pObj)	__itt_notify_sync_releasing( pObj )

#else
#define PROFILE_SCOPE(_name) 

#define PROFILE_SYNC_PREPARE(pObj)		
#define PROFILE_SYNC_CANCEL(pObj)		
#define PROFILE_SYNC_ACQUIRED(pObj) 	
#define PROFILE_SYNC_RELEASING(pObj)	
#endif

#endif //_NULSTEIN_ALIGNMENT_H_