//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

float4		MtxModelToScreen[4];	/* vertices to screen		*/ 
float4		LightPos[4];			/* lights in model space	*/ 

struct VS_INPUT
{
	float3 Position : POSITION;
	float3 Normal	: NORMAL; 
};

struct VS_OUTPUT
{
    float4 Position	: POSITION; 
    float4 Color	: COLOR;	
};

VS_OUTPUT main( in  VS_INPUT Input)
{
	VS_OUTPUT	Output;
	float4		M;
	float4		N;
	float4		L; /* light vector */ 
	
	/* Position */ 
	M = float4(Input.Position.x, Input.Position.y, Input.Position.z, 1.0f);
	Output.Position.x = dot(M, MtxModelToScreen[0]);
	Output.Position.y = dot(M, MtxModelToScreen[1]);
	Output.Position.z = dot(M, MtxModelToScreen[2]);
	Output.Position.w = dot(M, MtxModelToScreen[3]);
	
	/* color */ 
	N = float4(Input.Normal.x,   Input.Normal.y,   Input.Normal.z,   0.0f);
	L = normalize( LightPos[0] - M );
	
	Output.Color   = max(0.0f, dot(N, L));
	Output.Color.w = 1.0f;
	
	return Output;
}
