//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_SHADER_H_
#define _NULSTEIN_SHADER_H_

#include "Gfx/GfxMath.h"

//________________________________________________________________________________
class CVertexShader
{
public:
	CVertexShader();
	virtual ~CVertexShader();

	bool Create(CGfx* pGfx, IDirect3DVertexDeclaration9* pVtxDecl);
	void Destroy();

	bool SetupGfx(CGfx* pGfx);
	bool SetupConstants(CGfx* pGfx, const CVector4 *pConstants, ULONG Count);
	
	virtual const DWORD* GetByteCode() =0;
	
public:
	CComPtr<IDirect3DVertexShader9>			m_spShader;
	CComPtr<IDirect3DVertexDeclaration9>	m_spVtxDecl;
};

#define DECLARE_VERTEXSHADER()	\
	virtual const DWORD* GetByteCode();

#define IMPLEMENT_VERTEXSHADER(_T)		\
	const DWORD* _T::GetByteCode() {return (DWORD*)g_vs20_main;}

//________________________________________________________________________________
class CPixelShader
{
public:
	CPixelShader();
	virtual ~CPixelShader();

	bool Create(CGfx *pGfx);
	void Destroy();

	bool SetupGfx(CGfx* pGfx);
	bool SetupConstants(CGfx* pGfx, const CVector4 *pConstants, ULONG Count);
	
	virtual const DWORD* GetByteCode() =0;
	
public:
	CComPtr<IDirect3DPixelShader9>	m_spShader;
};

#define DECLARE_PIXELSHADER()	\
	virtual const DWORD* GetByteCode();

#define IMPLEMENT_PIXELSHADER(_T)		\
	const DWORD* _T::GetByteCode() {return (DWORD*)g_ps20_main;}

#endif // _NULSTEIN_SHADER_H_
