//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#include "StdAfx.h"
#include "Gfx.h"
#include "Shader.h"


// Vertex shaders
CVertexShader::CVertexShader()
{
}

CVertexShader::~CVertexShader()
{
	Destroy();
}


bool	CVertexShader::Create(CGfx *pGfx, IDirect3DVertexDeclaration9* pVtxDecl)
{
	HRESULT hr;
	
	Destroy();
	
	hr = pGfx->m_spDevice->CreateVertexShader(GetByteCode(), &m_spShader);
	IF_FAILED_RETURN(hr);

	m_spVtxDecl = pVtxDecl;
	return true;
}

void	CVertexShader::Destroy()
{
	m_spShader	= NULL;
	m_spVtxDecl	= NULL;
}

bool CVertexShader::SetupGfx(CGfx* pGfx)
{
	HRESULT hr;
	
	/* setup vertex format */ 
	hr = pGfx->m_spDevice->SetVertexDeclaration(m_spVtxDecl);
	IF_FAILED_RETURN(hr);

	/* setup shader */ 
	hr = pGfx->m_spDevice->SetVertexShader(m_spShader);
	IF_FAILED_RETURN(hr);
	
	return true;
}


bool	CVertexShader::SetupConstants(CGfx* pGfx, const CVector4 *pConstants, ULONG Count)
{
	HRESULT hr;
	
	hr = pGfx->m_spDevice->SetVertexShaderConstantF(0, (float*)pConstants, Count);
	IF_FAILED_RETURN(hr);
	
	return true;
}

// Pixel shaders
CPixelShader::CPixelShader()
{
}

CPixelShader::~CPixelShader()
{
	Destroy();
}


bool	CPixelShader::Create(CGfx *pGfx)
{
	HRESULT hr;
	
	Destroy();
	
	hr = pGfx->m_spDevice->CreatePixelShader(GetByteCode(), &m_spShader);
	IF_FAILED_RETURN(hr);

	return true;
}

void	CPixelShader::Destroy()
{
	m_spShader = NULL;
}

bool	CPixelShader::SetupGfx(CGfx* pGfx)
{
	HRESULT hr;
	
	/* setup shader */ 
	hr = pGfx->m_spDevice->SetPixelShader(m_spShader);
	IF_FAILED_RETURN(hr);
	
	return true;
}

bool	CPixelShader::SetupConstants(CGfx* pGfx, const CVector4 *pConstants, ULONG Count)
{
	HRESULT hr;
	
	hr = pGfx->m_spDevice->SetPixelShaderConstantF(0, (float*)pConstants, Count);
	IF_FAILED_RETURN(hr);
	
	return true;
}
