//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_GFXMATH_INL_
#define _NULSTEIN_GFXMATH_INL_

//________________________________________________________________________________
inline CVector3 operator *(const CVector3 &V, float k)
{
	return CVector3(V.x*k, V.y*k, V.z*k);
}

inline CVector3 operator +(const CVector3 &A, const CVector3 &B)
{
	return CVector3(A.x+B.x, A.y+B.y, A.z+B.z);
}

inline const CVector3 &CVector3::operator += (const CVector3 &V)
{
	x += V.x;
	y += V.y;
	z += V.z;

	return *this;
}

inline CVector3 operator -(const CVector3 &A, const CVector3 &B)
{
	return CVector3(A.x-B.x, A.y-B.y, A.z-B.z);
}

inline const CVector3 &CVector3::operator -= (const CVector3 &V)
{
	x -= V.x;
	y -= V.y;
	z -= V.z;
	
	return *this;
}

inline CVector3 Cross(const CVector3 &A, const CVector3 &B)
{
	return CVector3(	A.y*B.z - A.z*B.y,
						A.z*B.x - A.x*B.z,
						A.x*B.y - A.y*B.x );
}

inline float Dot(const CVector3 &A, const CVector3 &B)
{
	return A.x*B.x + A.y*B.y + A.z*B.z;
}

inline float SquareNorm(const CVector3 &V)
{
	return Dot(V,V);
}

//________________________________________________________________________________
inline CVector4 operator *(const CVector4 &V, float k)
{
	return CVector4(V.x*k, V.y*k, V.z*k, V.w*k);
}

//________________________________________________________________________________
inline CMatrix operator *(const CMatrix& AtoB, const CMatrix& BtoC)
{
	CMatrix AtoC;
	
	MtxMul(&AtoC, AtoB, BtoC);
	return AtoC;
}


#endif // _NULSTEIN_GFXMATH_INL_
