//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

#ifndef _NULSTEIN_DISPLAYLIST_H_
#define _NULSTEIN_DISPLAYLIST_H_

/* a display list in the spirit of http://realtimecollisiondetection.net/blog/?p=86 */ 

class CGfx;
class CView;
class CMaterial;
class CDisplayList;
class CDisplayListAdder;


#include "nulstein-common/DisplayItem.h"

class CDisplayListAdder
{	/* each thread uses a different one */ 
public:
	CDisplayListAdder();
	
public: 
	void Reset();
	bool Add(ULONGLONG Key, uint32_t iEntity, uint32_t Param); /* called by primitive */ 
	
public:
	CDisplayList*	m_pDisplayList;
	sDisplayItem*	m_pNextItem;
	int				m_ItemsReserved;
	int				m_AddCount;
};

class CACHELINE_ALIGNED CDisplayList
{
public:
	CDisplayList();
	~CDisplayList();

	void	Begin();
	void	EndAndSort();

public:
	sDisplayItem	m_Item[MAX_DISPLAYLISTSIZE];
	CView*			m_View; /* pointer to the list of views, managed externally */ 
	
	volatile LONG	m_ItemCount;
	LONG			_pad[3];
};

#endif // _NULSTEIN_DISPLAYLIST_H_
