//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_pow_ess(__m128 x, __m128 y)
{
	__asm
	{
		xorps	xmm5, xmm5
		movss	xmm2, _ps_am_inv_mant_mask
		cmpltss	xmm5, xmm0
		maxss	xmm0, _ps_am_min_norm_pos  // cut off denormalized stuff
		movss	xmm7, _ps_am_1
		movaps	xmm3, xmm0

		andps	xmm0, xmm2
		orps	xmm0, xmm7

		movss	[esp - 4], xmm5

		movaps	xmm4, xmm0
		movd	xmm2, _epi32_0x7f
		subss	xmm0, xmm7
		addss	xmm4, xmm7
		psrld	xmm3, 23
		rcpss	xmm4, xmm4
		mulss	xmm0, xmm4
		psubd	xmm3, xmm2
		addss	xmm0, xmm0

		movaps	xmm2, xmm0
		mulss	xmm0, xmm0

		movss	xmm4, _ps_log_p0
		movss	xmm6, _ps_log_q0

		mulss	xmm4, xmm0
		movss	xmm5, _ps_log_p1
		mulss	xmm6, xmm0
		movss	xmm7, _ps_log_q1

		addss	xmm4, xmm5
		addss	xmm6, xmm7

		movss	xmm5, _ps_log_p2
		mulss	xmm4, xmm0
		movss	xmm7, _ps_log_q2
		mulss	xmm6, xmm0

		addss	xmm4, xmm5
		movss	xmm5, _ps_log2_c0
		addss	xmm6, xmm7
		cvtdq2ps	xmm7, xmm3

		mulss	xmm0, xmm4
		rcpss	xmm6, xmm6

		mulss	xmm0, xmm6
		movss	xmm4, _ps_exp2_hi
		mulss	xmm0, xmm2
		movss	xmm6, _ps_exp2_lo
		mulss	xmm2, xmm5
		mulss	xmm0, xmm5
		addss	xmm2, xmm7
		movss	xmm3, _ps_am_0p5
		addss	xmm0, xmm2
		xorps	xmm2, xmm2
		movd	xmm5, _epi32_1

		mulss	xmm0, xmm1

		minss	xmm0, xmm4
		movss	xmm4, _ps_exp2_p0
		maxss	xmm0, xmm6
		movss	xmm6, _ps_exp2_q0

		addss	xmm3, xmm0

		cmpnltss	xmm2, xmm3
		pand	xmm2, xmm5

		cvttps2dq	xmm3, xmm3

		psubd	xmm3, xmm2

		cvtdq2ps	xmm2, xmm3

		subss	xmm0, xmm2

		movaps	xmm2, xmm0
		mulss	xmm0, xmm0

		paddd	xmm3, _epi32_0x7f

		mulss	xmm4, xmm0
		mulss	xmm6, xmm0
		addss	xmm4, _ps_exp2_p1
		addss	xmm6, _ps_exp2_q1

		mulss	xmm4, xmm0
		addss	xmm4, _ps_exp2_p2

		mulss	xmm2, xmm4

		movss	xmm0, _ps_am_1
		subss	xmm6, xmm2
		pslld	xmm3, 23
		rcpss	xmm6, xmm6
		movss	xmm5, [esp - 4]
		mulss	xmm2, xmm6
		andps	xmm3, xmm5
		addss	xmm2, xmm2
		addss	xmm0, xmm2

		mulss	xmm0, xmm3


		ret		
	}
}

#endif