//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_exp_ess(__m128 x)
{
	__asm
	{
		minss	xmm0, _ps_exp_hi
		movss	xmm1, _ps_exp_rln2
		maxss	xmm0, _ps_exp_lo
		mulss	xmm1, xmm0
		movd	xmm3, _epi32_1
		xorps	xmm2, xmm2
		addss	xmm1, _ps_am_0p5

		cmpnltss	xmm2, xmm1
		pand	xmm2, xmm3

		cvttps2dq	xmm1, xmm1
		movss	xmm4, _ps_exp_c2

		psubd	xmm1, xmm2
		movss	xmm5, _ps_exp_c1

		cvtdq2ps	xmm3, xmm1

		movd	xmm7, _epi32_0x7f

		mulss	xmm4, xmm3
		mulss	xmm5, xmm3
		movss	xmm6, _ps_exp_q0
		subss	xmm0, xmm4
		movss	xmm4, _ps_exp_p0
		subss	xmm0, xmm5

		paddd	xmm1, xmm7
		movss	xmm2, xmm0
		mulss	xmm0, xmm0

		movss	xmm5, _ps_exp_q1
		mulss	xmm6, xmm0
		movss	xmm3, _ps_exp_p1
		mulss	xmm4, xmm0
		addss	xmm6, xmm5
		movss	xmm5, _ps_exp_q2
		addss	xmm4, xmm3
		movss	xmm3, _ps_exp_q3
		mulss	xmm6, xmm0
		mulss	xmm4, xmm0
		addss	xmm6, xmm5
		mulss	xmm4, xmm2
		mulss	xmm6, xmm0
		movss	xmm0, _ps_am_1
		addss	xmm2, xmm4
		addss	xmm6, xmm3

		pslld	xmm1, 23
		subss	xmm6, xmm2
		rcpss	xmm6, xmm6
		mulss	xmm2, xmm6
		addss	xmm2, xmm2
		addss	xmm0, xmm2

		mulss	xmm0, xmm1

		ret		16
	}
}

#endif