//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_exp2_ps(__m128 x)
{
	__asm
	{
		minps	xmm0, _ps_exp2_hi
		movaps	xmm1, _ps_am_0p5
		maxps	xmm0, _ps_exp2_lo
		xorps	xmm7, xmm7

		addps	xmm1, xmm0
		mov		ecx, esp

		movaps	xmm2, xmm1

		cvttps2pi	mm0, xmm1
		cmpltps	xmm2, xmm7
		ASM_MOVE_H2L(xmm1)
		andps	xmm2, _ps_am_1
		cvttps2pi	mm1, xmm1
		movq	mm6, _pi32_0x7f

		cvtps2pi	mm2, xmm2
		ASM_MOVE_H2L(xmm2)
		movq	mm7, _pi32_0xff
		cvtps2pi	mm3, xmm2

		psubd	mm0, mm2
		psubd	mm1, mm3
		and		ecx, ~15

		cvtpi2ps	xmm1, mm1
		ASM_MOVE_L2H(xmm1)
		paddd	mm1, mm6
		cvtpi2ps	xmm1, mm0
		paddd	mm0, mm6

		subps	xmm0, xmm1
		movaps	xmm2, xmm0
		mulps	xmm2, xmm2

		movaps	xmm6, _ps_exp2_q0
		movaps	xmm4, _ps_exp2_p0

		mulps	xmm6, xmm2
		movaps	xmm7, _ps_exp2_q1
		mulps	xmm4, xmm2
		movaps	xmm5, _ps_exp2_p1

		addps	xmm6, xmm7
		pslld	mm0, 23
		addps	xmm4, xmm5

		movaps	xmm5, _ps_exp2_p2
		mulps	xmm4, xmm2
		pslld	mm1, 23

		addps	xmm4, xmm5
		movq	[ecx - 16], mm0

		mulps	xmm4, xmm0
		movq	[ecx - 16 + 8], mm1

		subps	xmm6, xmm4
		movaps	xmm7, _ps_am_1
		rcpps	xmm6, xmm6  
		mulps	xmm4, xmm6
		movaps	xmm0, [ecx - 16]
		addps	xmm4, xmm4
		addps	xmm4, xmm7

		mulps	xmm0, xmm4

		ret		16
	}
}

#endif