//-------------------------------------------------------------------------------------
//
// Copyright 2009 Intel Corporation
// All Rights Reserved
//
// Permission is granted to use, copy, distribute and prepare derivative works of this
// software for any purpose and without fee, provided, that the above copyright notice
// and this statement appear in all copies.  Intel makes no representations about the
// suitability of this software for any purpose.  THIS SOFTWARE IS PROVIDED "AS IS."
// INTEL SPECIFICALLY DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, AND ALL LIABILITY,
// INCLUDING CONSEQUENTIAL AND OTHER INDIRECT DAMAGES, FOR THE USE OF THIS SOFTWARE,
// INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PROPRIETARY RIGHTS, AND INCLUDING THE
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  Intel does not
// assume any responsibility for any errors which may appear in this software nor any
// responsibility to update it.
//

/////////////////////////////////////////////////////////////////////////////
// Based upon:
//
// Approximate Math Library for SSE / SSE2
//  Header File
//  Version 2.0
//  Author Alex Klimovitski, Intel GmbH
/////////////////////////////////////////////////////////////////////////////
#include <emmintrin.h>

#include "AMaths.h"
#include "AMaths_internal.h"

#ifdef AMATHS_ASM

__m128 __declspec(naked) __stdcall am_exp2_eps(__m128 x)
{
	__asm
	{
		minps	xmm0, _ps_exp2_hi
		movaps	xmm1, _ps_am_0p5
		maxps	xmm0, _ps_exp2_lo
		xorps	xmm2, xmm2
		addps	xmm1, xmm0

		cmpnltps	xmm2, xmm1
		pand	xmm2, _epi32_1

		cvttps2dq	xmm1, xmm1

		psubd	xmm1, xmm2

		movaps	xmm4, _ps_exp2_p0
		movaps	xmm6, _ps_exp2_q0

		cvtdq2ps	xmm2, xmm1

		subps	xmm0, xmm2

		movaps	xmm2, xmm0
		mulps	xmm0, xmm0

		paddd	xmm1, _epi32_0x7f

		mulps	xmm4, xmm0
		mulps	xmm6, xmm0
		addps	xmm4, _ps_exp2_p1
		addps	xmm6, _ps_exp2_q1

		mulps	xmm4, xmm0
		addps	xmm4, _ps_exp2_p2

		mulps	xmm2, xmm4

		subps	xmm6, xmm2
		pslld	xmm1, 23
		rcpps	xmm6, xmm6
		movaps	xmm0, _ps_am_1
		mulps	xmm2, xmm6
		addps	xmm2, xmm2
		addps	xmm0, xmm2

		mulps	xmm0, xmm1

		ret		16
	}
}

#endif