
#define USE_ASSEMBLY (1)
void crt (void);
int rnd (void);
void output_char (char color);
void play_note (int p, int t);
char *output_char_p;
char *rnd_state;

int main (void) {
	rnd_state = 1024;
	output_char_p = 0x5800;
	while (1) {
		play_note(rnd(), 20);
		int i;
		for (i = 0; i < 20; i++) {
			output_char((rnd() & 1) ? 0b10100100 : 0b00000000);
		}
	}
}

void crt (void) {
	main();
}



void output_char (char color) {
	*output_char_p = color;
	output_char_p++;
	if (output_char_p > (0x5800 + 768)) output_char_p = 0x5800;
}

char *rnd_state;
int rnd (void) {
	rnd_state++;
	if (rnd_state > 0x3800) rnd_state = 0;
	int r = (*rnd_state) | (*(rnd_state+1) << 8);
	r &= 0b0000000011111111;
	if (r < 2) r = 2;
	return r;
}

void play_note (int p, int t) {
	if (0 == p) p = 2000;
	int q = t * 100 / p;
	while (q) {
		/* beeper up */
		__asm__ ("; border bright\n"
		"\tpush bc\n"
		"\tld c,#0xfe\n"
		"\tld b,#0xff\n"
		"\tld a,#0b00010100\n"
		"\tout (c),a\n"
		"\tpop bc\n"
		"\tdi\n");
		int i;
		for (i = p; i > 0; i--) {
		}
		/* beeper down */
		__asm__ ("; border bright\n"
		"\tpush bc\n"
		"\tld c,#0xfe\n"
		"\tld b,#0xff\n"
		"\tld a,#0b00000000\n"
		"\tout (c),a\n"
		"\tpop bc\n");
		for (i = p; i > 0; i--) {
		}
		q--;
	}
}
