// [graphics modes]
#define _240x160x1x256_		0x04
#define _240x160x0x32k_		0x03
#define _160x128x0x32k_		0x05


// [palettes]
#define BACKGROUND	((volatile u16 *)0x05000000)
#define OBJECT		((volatile u16 *)0x05000200)

#define VRAM 		0x06000000

#define FOCAL 256.0f

// [shade models]
#define GBAL_FLAT 0
#define GBAL_SMOOTH 1

// [polygon modes]
#define GBAL_POINT  0
#define GBAL_LINE   1
#define GBAL_FILL   2


#define GBAL_TEXTURE_2D     1
#define GBAL_DMA_CLEAR      2



typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#define BIT0	0x1
#define BIT1	0x2
#define BIT2	0x4
#define BIT3	0x8
#define BIT4	0x10
#define BIT5	0x20
#define BIT6	0x40
#define BIT7	0x80
#define BIT8	0x100
#define BIT9	0x200
#define BIT10	0x400
#define BIT11	0x800
#define BIT12	0x1000
#define BIT13	0x2000
#define BIT14	0x4000
#define BIT15	0x8000
#define BIT27	0x08000000


/* Define some registers */
#define DISPCNT    *(u32 *)0x4000000
#define DISPCNT_L  *(u16 *)0x4000000
#define DISPCNT_H  *(u16 *)0x4000002
#define DISPSTAT   *(u16 *)0x4000004
#define VCOUNT     *(u16 *)0x4000006
#define BG0CNT     *(u16 *)0x04000008
#define BG1CNT     *(u16 *)0x0400000A
#define BG2CNT     *(u16 *)0x0400000C
#define BG3CNT     *(u16 *)0x0400000E

#define BG0HOFS    *(u16 *)0x04000010
#define BG0VOFS    *(u16 *)0x04000012
#define BG1HOFS    *(u16 *)0x04000014
#define BG1VOFS    *(u16 *)0x04000016
#define BG2HOFS    *(u16 *)0x04000018
#define BG2VOFS    *(u16 *)0x0400001A
#define BG3HOFS    *(u16 *)0x0400001C
#define BG3VOFS    *(u16 *)0x0400001E
 
#define MOSAIC     *(u16 *)0x0400004C
#define BLDMOD     *(u16 *)0x04000050
#define COLEV      *(u16 *)0x04000052
#define COLY       *(u16 *)0x04000054

#define CFX_NONE	0
#define CFX_ABLEND	BIT6
#define CFX_LUM_INC	BIT7
#define CFX_LUM_DEC	BIT6|BIT7

#define BG2X_L	*(short *)0x04000028
#define BG2X_H	*(short *)0x0400002A
#define BG2Y_L	*(short *)0x0400002C
#define BG2Y_H	*(short *)0x0400002E
#define BG2PA	*(short *)0x04000020
#define BG2PB	*(short *)0x04000022
#define BG2PC	*(short *)0x04000024
#define BG2PD	*(short *)0x04000026
#define BG3X_L	*(short *)0x04000038
#define BG3X_H	*(short *)0x0400003A
#define BG3Y_L	*(short *)0x0400003C
#define BG3Y_H	*(short *)0x0400003E
#define BG3PA	*(short *)0x04000030
#define BG3PB	*(short *)0x04000032
#define BG3PC	*(short *)0x04000034
#define BG3PD	*(short *)0x04000036

/* Timer channels */
#define TM0D       *(u16 *)0x4000100
#define TM0CNT     *(u16 *)0x4000102
#define TM1D       *(u16 *)0x4000104
#define TM1CNT     *(u16 *)0x4000106
#define TM2D       *(u16 *)0x4000108
#define TM2CNT     *(u16 *)0x400010A
#define TM3D       *(u16 *)0x400010C
#define TM3CNT     *(u16 *)0x400010E


/* DMA channels */
#define DM0SAD     *(u32 *)0x40000B0
#define DM0SAD_L   *(u16 *)0x40000B0
#define DM0SAD_H   *(u16 *)0x40000B2
#define DM0DAD     *(u32 *)0x40000B4
#define DM0DAD_L   *(u16 *)0x40000B4
#define DM0DAD_H   *(u16 *)0x40000B6
#define DM0CNT     *(u32 *)0x40000B8
#define DM0CNT_L   *(u16 *)0x40000B8
#define DM0CNT_H   *(u16 *)0x40000BA
#define DM1SAD     *(u32 *)0x40000BC
#define DM1SAD_L   *(u16 *)0x40000BC
#define DM1SAD_H   *(u16 *)0x40000BE
#define DM1DAD     *(u32 *)0x40000C0
#define DM1DAD_L   *(u16 *)0x40000C0
#define DM1DAD_H   *(u16 *)0x40000C2
#define DM1CNT     *(u32 *)0x40000C4
#define DM1CNT_L   *(u16 *)0x40000C4
#define DM1CNT_H   *(u16 *)0x40000C6
#define DM2SAD     *(u32 *)0x40000C8
#define DM2SAD_L   *(u16 *)0x40000C8
#define DM2SAD_H   *(u16 *)0x40000CA
#define DM2DAD     *(u32 *)0x40000CC
#define DM2DAD_L   *(u16 *)0x40000CC
#define DM2DAD_H   *(u16 *)0x40000CE
#define DM2CNT     *(u32 *)0x40000D0
#define DM2CNT_L   *(u16 *)0x40000D0
#define DM2CNT_H   *(u16 *)0x40000D2
#define DM3SAD     *(u32 *)0x40000D4
#define DM3SAD_L   *(u16 *)0x40000D4
#define DM3SAD_H   *(u16 *)0x40000D6
#define DM3DAD     *(u32 *)0x40000D8
#define DM3DAD_L   *(u16 *)0x40000D8
#define DM3DAD_H   *(u16 *)0x40000DA
#define DM3CNT     *(u32 *)0x40000DC
#define DM3CNT_L   *(u16 *)0x40000DC
#define DM3CNT_H   *(u16 *)0x40000DE



#define BG_CHR_BASE_0 0
#define BG_CHR_BASE_1 BIT2
#define BG_CHR_BASE_2 BIT3
#define BG_CHR_BASE_3 BIT2|BIT3

#define BG_SCREEN_BASE_0 0
#define BG_SCREEN_BASE_1 BIT8
#define BG_SCREEN_BASE_2 BIT9
#define BG_SCREEN_BASE_3 BIT8|BIT9
#define BG_SCREEN_BASE_4 BIT10
#define BG_SCREEN_BASE_5 BIT8|BIT10
#define BG_SCREEN_BASE_6 BIT9|BIT10
#define BG_SCREEN_BASE_7 BIT8|BIT9|BIT10


#define BG_MODE_0	 0
#define BG_MODE_1	 1
#define BG_MODE_2	 2
#define BG_MODE_3	 3
#define BG_MODE_4	 4
#define BG_MODE_5	 5

#define BG0_ENABLE	 BIT8
#define BG1_ENABLE	 BIT9
#define BG2_ENABLE	 BIT10
#define BG3_ENABLE	 BIT11
#define OBJ_ENABLE	 BIT12

#define BG_COLOR_MODE_16x16	 0
#define BG_COLOR_MODE_256x1	 BIT7

#define CHR_HFLIP       	 BIT10
#define CHR_VFLIP       	 BIT11
#define OBJ_HFLIP       	 BIT12
#define OBJ_VFLIP       	 BIT13

#define MOSAIC_ON	BIT6
#define MOSAIC_OFF	(~BIT6)
#define MOSAIC_YDIM_SHIFT 4


#define OBJ_1D_MAP	 1
#define OBJ_2D_MAP	 0

#define OBJDATA   	*(u16  *)0x06010000
#define OAM ((Sprite *)0x7000000)

#define TIMER_INTERVAL_1    0
#define TIMER_INTERVAL_64   1
#define TIMER_INTERVAL_256  2
#define TIMER_INTERVAL_1024 3

#define TIMER_COUNT_UP  4



typedef struct
{
 u16 Attrib0, Attrib1, Attrib2, RotateScale;
}Sprite;


typedef struct POINT
{
  long x, y;
  long c;
  long u,v;
}POINT;


typedef void (*tri_func)(POINT *pp1, POINT *pp2, POINT *pp3);



#define gbalMakeColor(r,g,b) (u16)(((r&248)>>3)|((g&248)<<2)|((b&248)<<7))




extern void gbalWait(int);

extern void gbalSwapBuffers(void);

extern void DMACopyInstant(char *, char *, int);

extern void gbalSetMode(u8);
extern void gbalVSync(void);

extern void gbalSetColor(volatile u16 *,long, u16);
extern u16 gbalGetColor(volatile u16 *, long);
extern void gbalSetPalette(volatile u16 *, u16 *, int);


