;-----------------------------------------------------------------------------------------------
; Master Blaster
;
; Registry-Functions
;
;-----------------------------------------------------------------------------------------------
Type T_TwisterTxt
	Field x#,y#
	Field sx#,sy#
	Field tx#,ty#
	Field Stp#
	Field Txt$
	Field Col1,col2,col3
End Type

Type T_Txt
	Field x,y
	Field gamma#
	Field Txt$
	Field Col1,col2,col3
End Type
	
;-------------------------------------------------------------------------
Function CREDITS()


	Font=LoadFont("Arial",120,1 )
	SetFont Font
	
	color 255,255,255
	cls
	text 400,150,"PROGRAMMING",1,1
	PixelSwarmInit(0,C_ScreenX/2,20,20,$ffffffff,0,0.6)
	PixelSwarmInit(1,C_ScreenX/2,20,20,$ffffffff,1,0.6)
	
	cls
	text 400,100,"GRAPHICS",1,1
	PixelSwarmInit(2,C_ScreenX/2,250,20,$ffffffff,0,0.6)
	PixelSwarmInit(3,C_ScreenX/2,250,20,$ffffffff,1,0.6)


  cls
	text 400,400,"MUSIC",1,1
	PixelSwarmInit(18,500,200,20,$ffffffff,0,0.6)
	PixelSwarmInit(19,500,200,20,$ffffffff,1,0.6)
	
	
	cls
	text 200,200,"SOUND",1,1
	PixelSwarmInit(4,500,200,20,$ffffffff,0,0.6)
	PixelSwarmInit(5,500,200,20,$ffffffff,1,0.6)
	
	cls
	text 500,100,"ADDITIONAL",1,1
	text 500,200,"GRAPHICS",1,1
	PixelSwarmInit(6,300,300,20,$ffffffff,0,0.6)
	PixelSwarmInit(7,300,300,20,$ffffffff,1,0.6)	

	cls
	text 450,400,"ALPHA-TEST",1,1
	text 450,500,"AND IDEAS",1,1
	PixelSwarmInit(8,150,200,20,$ffffffff,0,0.6)
	PixelSwarmInit(9,150,200,20,$ffffffff,1,0.6)
	
	cls
	text 400,300,"BETA-TEST",1,1
	PixelSwarmInit(10,C_ScreenX/2,300,20,$ffffffff,0,0.6)
	PixelSwarmInit(11,C_ScreenX/2,300,20,$ffffffff,1,0.6)	
	
	cls
	text 400,100,"SUPPORT",1,1
	text 400,500,"MANUAL",1,1
	PixelSwarmInit(12,C_ScreenX/2,300,20,$ffffffff,0,0.6)
	PixelSwarmInit(13,C_ScreenX/2,300,20,$ffffffff,1,0.6)			

	cls
	text 400,100,"SPECIAL",1,1
	text 400,200,"THANKS TO",1,1
	PixelSwarmInit(14,C_ScreenX/2,250,20,$ffffffff,0,0.6)
	PixelSwarmInit(15,C_ScreenX/2,250,20,$ffffffff,1,0.6)
	
	cls
	text 400,200,"MASTER",1,1
	text 400,300,"BLASTER",1,1
	text 400,400,VERSYEAR,1,1
	PixelSwarmInit(16,C_ScreenX/2,400,150,$ff9090ff,0,0.6)
	PixelSwarmInit(17,C_ScreenX/2,400,20,$ff9090ff,1,0.6)

	PixelSwarmSetState(0)
  PixelSwarmSetState(1)
	
	Font=LoadFont( "Comic Sans MS",50,False )

	SetFont Font
	SetBuffer BackBuffer()
	
	cls
	flip
	cls
	Playsong("music\other\leave my ship.mp3")	
	
	CREDITS_Draw(60)
	;CreateTwisterTxt( 50,225,11,"Programming:",255,000,000)
	CreateTwisterTxt(300,325,15,"Alexander Ivanof",255,000,000)
	CreateTwisterTxt(300,400,15,"Meili",255,000,000)
	CREDITS_Draw(660)
  PixelSwarmSetState(0,"explode")
  
  PixelSwarmSetState(2)
  PixelSwarmSetState(3)
	;CreateTxt(300, 50,8,"Graphics:",000,000,255)
	CreateTwisterTxt(450,250,15,"Alexander Ivanof",000,000,255)
	CreateTwisterTxt(450,300,15,"Andreas Ivanof",000,000,255)
	CREDITS_Draw(725)
  PixelSwarmSetState(2,"explode")

  PixelSwarmSetState(6)
  PixelSwarmSetState(7)
;	CreateTxt(150,200,8,"Additional Graphics:",255,255,000)
	CreateTwisterTxt(100,300,15,"Simone Kaehler",255,255,000)
	CreateTwisterTxt(100,350,15,"Olaf Leppert",255,255,000)
	CreateTwisterTxt(100,400,15,"Holger Brensing",255,255,000)
	CreateTwisterTxt(100,450,15,"Suco-X",255,255,000)	
	CreateTwisterTxt(100,500,15,"Meili",255,255,000)
	CREDITS_Draw(725)
	PixelSwarmSetState(6,"explode")


  PixelSwarmSetState(18)
  PixelSwarmSetState(19)
;	CreateTxt(  1,350,8,"Sound:",255,000,255)
	CreateTwisterTxt(350,200,15,"Nils Feske (505)",105,79,174)
	CREDITS_Draw(725)
	PixelSwarmSetState(18,"explode")
	
	
	
  PixelSwarmSetState(4)
  PixelSwarmSetState(5)
;	CreateTxt(  1,350,8,"Sound:",255,000,255)
	CreateTwisterTxt(100,350,15,"Alexander Ivanof",255,000,255)
	CreateTwisterTxt(100,400,15,"Holger Brensing",255,000,255)
	CreateTwisterTxt(100,450,15,"free sounds from quite a few web sites",255,000,255)
	CREDITS_Draw(725)
	PixelSwarmSetState(4,"explode")
	
	
	
  PixelSwarmSetState(8)
  PixelSwarmSetState(9)
;	CreateTxt( 50,100,8,"Alpha-Testing/Ideas:",000,255,255)
	CreateTwisterTxt(500,100,7,"Markus Kaehler",000,255,255)
	CreateTwisterTxt(500,150,7,"Kai Hillebrand",000,255,255)
	CreateTwisterTxt(500,200,7,"Davut Guersoy",000,255,255)
	CREDITS_Draw(660)
	
  PixelSwarmSetState(8,"explode")
  clscolor 255,255,255
  cls
  clscolor 0,0,0
  CREDITS_Draw(35)
  clscolor 255,255,255
  cls
  clscolor 0,0,0
  CREDITS_Draw(35)
  clscolor 255,255,255
  cls
  clscolor 0,0,0
  CREDITS_Draw(10)
  clscolor 255,255,255
  cls
  clscolor 0,0,0
  CREDITS_Draw(5)
   clscolor 255,255,255
  cls
  clscolor 0,0,0
  CREDITS_Draw(5)

  
	PixelSwarmSetState(10)
  PixelSwarmSetState(11)
;	CreateTxt( 50,300,8,"Beta-Testing:",000,255,255)
	CreateTwisterTxt(200,50,15,"Holger Brensing",000,255,255)
	CreateTwisterTxt(200,150,15,"Nils Feske",000,255,255)
	CreateTwisterTxt(200,550,15,"Alexander Ivanof",000,255,255)
	CreateTwisterTxt(200,100,15,"Olaf Leppert",000,255,255)
	CreateTwisterTxt(200,450,15,"Norman 'Death in slippers' Ruppert",000,255,255)
	CreateTwisterTxt(200,500,15,"Andreas Raddatz",000,255,255)
	CreateTwisterTxt(200,400,15,"Thomas Frenzel",000,255,255)
	CREDITS_Draw(720)
  PixelSwarmSetState(10,"explode")

	PixelSwarmSetState(12)
  PixelSwarmSetState(13)
;	CreateTxt(390,400,8,"Support/Manual:",200,000,055)
	CreateTwisterTxt(300,250,15,"Kai Hillebrand",200,000,055)
	CreateTwisterTxt(300,300,15,"Markus Kaehler",200,000,055)
	CREDITS_Draw(725)
	PixelSwarmSetState(12,"explode")

	PixelSwarmSetState(14)
  PixelSwarmSetState(15)	
;	CreateTxt(  0,300,7,"Thanks to:",000,255,000)
	CreateTwisterTxt(  100,300,15,"all Master Blaster I, II and 2001 fans",000,255,000)
	CreateTwisterTxt(  100,500,15,"Nils, for his great music",000,255,000)
	CreateTwisterTxt(  100,400,15,"Alex, for his great game",000,255,000)
	CREDITS_Draw(725)
;	CreateTxt(  0,300,7,"whole B.C.S.-team",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Peter Elzner (web support)",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Patrick Diesel (web support)",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Guildhall Leisure Service (Blitz Basic)",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"U 2 (great new album)",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Schauburg (best pub around)",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Guinness brewery (best beer in the world)",000,255,000)
;	CREDITS_Draw(350)
;	CreateTxt(  0,300,7,"Warsteiner (beer in 'best pub around')",000,255,000)
;	CREDITS_Draw(250)
;	CreateTxt(  0,300,7,"Iserlohner (best beer for playing)",000,255,000)
;	CREDITS_Draw(250)
	PixelSwarmSetState(14,"explode")
	
	CreateTwisterTxt(  0,100,10,"and now go on and enjoy the new",255,255,125)
	CREDITS_Draw(500)
	;CreateTxt(  0,250,12,"M A S T E R",255,000,000)
	;CreateTxt(  0,300,12,"B L A S T E R",255,000,000)
	;CreateTxt(  0,350,12,"2 0 0 6",255,000,000)
	PixelSwarmSetState(16)
	PixelSwarmSetState(17)
	CREDITS_Draw(60000000)
  
	;CreateTxt(  0,300,6,"Guinness is good for you !",000,200,000)
	c#=1

	Cls
	SetFont Font_24
	FreeFont Font
	
	Delete Each T_TwisterTxt
	PixelSwarmSetState(0,"destroyall")
	
	click_lock = 30
	
End Function

;-------------------------------------------------------------------------
Function CREDITS_Draw(tim)
	While ((Mousedown(1)=0) And tim>0)
		
		PixelSwarmUpdate()
		tim=tim-1
		TwisterText_update()
		Flip 0
		Waittimer(Timer)
		Cls
	Wend
End Function

;-------------------------------------------------------------------------
function TwisterText_update()
	For Txt.T_TwisterTxt=Each T_TwisterTxt
			Color Txt\col1,Txt\Col2,Txt\Col3

			If Txt\x<>1 Then
				x=Txt\tx+(Sin(Txt\Stp*5)*Txt\Stp*5)
				y=Txt\ty-(Cos(Txt\Stp*5)*Txt\Stp*5)
			Else
				x=Txt\tx-(Cos(Txt\Stp*5)*Txt\Stp*5)
				y=Txt\ty+(Sin(Txt\Stp*5)*Txt\Stp*5)
			EndIf
			
			Text x,y,txt\txt$

			If Txt\Stp<>0 Then
;				Txt\x=Txt\x+Txt\sx
;				Txt\y=Txt\y+Txt\sy
				Txt\Stp=Txt\Stp-0.5
			Else
				If Txt\y=0 Then
					If Txt\Col1>0 Then Txt\Col1=Txt\Col1-2
					If Txt\Col2>0 Then Txt\Col2=Txt\Col2-2
					If Txt\Col3>0 Then Txt\Col3=Txt\Col3-2
					If Txt\col1<0 Then Txt\Col1=0
					If Txt\col2<0 Then Txt\Col2=0
					If Txt\col3<0 Then Txt\Col3=0
					If (Txt\Col1+Txt\Col2+Txt\Col3=0) Then Delete Txt
				Else
					Txt\y=Txt\y-1
				EndIf
			EndIf
		Next
end function


function text_update()
	For Txt.T_Txt=Each T_Txt
		if Txt\gamma > 0.01
			col1 = Txt\col1+(255-Txt\col1)*Txt\gamma
			col2 = Txt\col2+(255-Txt\col2)*Txt\gamma
			col3 = Txt\col3+(255-Txt\col3)*Txt\gamma
			Txt\gamma = Txt\gamma-0.05
			Color col1,col2,col3
		else
		  Color Txt\col1,Txt\col2,Txt\col3
		endif	
    Text Txt\x,Txt\y,txt\txt$
	Next
end function

;-------------------------------------------------------------------------
function text_destroy()
	For Txt.T_Txt=Each T_Txt
		Delete Txt
	Next
end function


;-------------------------------------------------------------------------
Function CreateTwisterTxt(x,y,tim,Txt$,c1,c2,c3)
	If x=0 Then x=400-StringWidth(Txt$)/2
	For z=1 To Len(Txt$)
		Stp=Rand(160,210);80-120
		T.T_TwisterTxt=New T_TwisterTxt
		T\Txt$=Mid$(Txt$,z,1)
		T\tX=x+StringWidth(Left$(Txt$,z-1))
		T\ty=y
		T\Stp=Stp
;		t\x=Rand(0,800)
		t\x=Rand(0,1)
		t\y=tim*15
;t\x=400
;t\y=300
		T\sx=(T\tx-T\x)/T\Stp
		T\sy=(T\ty-T\y)/T\Stp
		T\col1=c1
		T\col2=c2
		T\col3=c3
	Next
End Function


;-------------------------------------------------------------------------
Function CreateTxt(x,y,Txt$,c1,c2,c3)
		T.T_Txt	=	New T_Txt
		T\Txt$	=	Txt$
		T\x 		= x
		T\y 		= y
		T\col1	=	c1
		T\col2	=	c2
		T\col3	=	c3
		T\gamma = 1.0
End Function

;-------------------------------------------------------------------------
Function HandleConfig(ToDo$)

	if ToDo="LoadNames" then
		dir=readdir("config\")
		if dir<>0
			Repeat
				name$=NextFile$(dir)
				If name$="" Then Exit
				If (left(name$,1)="C") And (right(name$,4)=".cfg") Then
					pos = instr(name$,"_")
					if pos = 0 then exit
					x=mid(name$,2,pos-2)
					if x>0 and x<=C_MaxConfigs then
						pos2=len(name$)-4
					  Array_Configs$(x-1) = mid(name$,pos+1,pos2-pos)
					endif
				EndIf
			forever
			CloseDir(dir)	
		endif
		
		if FileType("config\additional.txt") <> 0 then
			File=openfile("config\additional.txt")

			SeekFile(File,0)
			Repeat
				name$=ReadLine$(File)
				name$=replace$(name$," ","") ; Trim does not function, don't kwow why
				if name$ <> "" then ParseAdditional(name$)
			Until Eof(File)			
			CloseFile(File)
		EndIf
		
		return true
	
	elseIf ToDo="Save" Then
		x=ConfigEntryChoosed+ConfigEntryOffset
		if FileType("config\C"+x+"_"+Array_Configs(x-1)+".cfg")<>0 Then
			DeleteFile("config\C"+x+"_"+Array_Configs(x-1)+".cfg")
		endif
		if FileType("config\C"+x+"_"+Array_Configs(x-1)+".cfg")=0 Then
			Menu_FindFrame("CONFIG-"+ ConfigEntryChoosed)
			File=WriteFile("config\C"+x+"_"+frame\txt$+".cfg")
			
			if File = 0 then return 0
			 
			WriteString(File,RSet$(IPAddress$,20))
			For i=0 To 20
				WriteInt(File,MaxItems(i))
			Next
			WriteInt(File,B_Time)
			WriteInt(File,Game_mode)
			WriteInt(File,Level)
			WriteInt(File,WinsNeeded)
			WriteInt(File,Shop_On)
			WriteInt(File,Wheel_On)
			WriteInt(File,Menu_Shrinking_On)
			WriteInt(File,Special_On)
			WriteInt(File,Music_On)
			writeint(File,Video_On)
			writeint(File,Pitch_On)
			writeint(File,Menu_Alarm_On)
			writefloat(File,musicvolume)
			writefloat(File,alarmvolume)
			
			cnt=0
			For Net_Player=Each T_NetPlayer
				If Net_Player\CompID=Net_MyNetID then cnt=cnt+1
			next
		  writeint(File,cnt)
					
		  For Net_Player=Each T_NetPlayer
				If Net_Player\CompID=Net_MyNetID then
					writestring(File,Net_Player\Name$)
					writeint(File,Net_Player\Hero)
					writeint(File,Net_Player\Team)
					
					writeint(File,Net_Player\Device)
					writeint(File,Net_Player\DevCodeLeft1)
					writeint(File,Net_Player\DevCodeRight1)
					writeint(File,Net_Player\DevCodeUp1)
					writeint(File,Net_Player\DevCodeDown1)
					writeint(File,Net_Player\DevCodeBomb1)
					writeint(File,Net_Player\DevCodePause1)
					
					writeint(File,Net_Player\DevCodeLeft2)
					writeint(File,Net_Player\DevCodeRight2)
					writeint(File,Net_Player\DevCodeUp2)
					writeint(File,Net_Player\DevCodeDown2)
					writeint(File,Net_Player\DevCodeBomb2)
					writeint(File,Net_Player\DevCodePause2)
					
					writeint(File,Net_Player\DevCodeLeft3)
					writeint(File,Net_Player\DevCodeRight3)
					writeint(File,Net_Player\DevCodeUp3)
					writeint(File,Net_Player\DevCodeDown3)
					writeint(File,Net_Player\DevCodeBomb3)
					writeint(File,Net_Player\DevCodePause3)
					
					
					writeint(File,Net_Player\DevCodeLeft4)
					writeint(File,Net_Player\DevCodeRight4)
					writeint(File,Net_Player\DevCodeUp4)
					writeint(File,Net_Player\DevCodeDown4)
					writeint(File,Net_Player\DevCodeBomb4)
					writeint(File,Net_Player\DevCodePause4)	
				endif
			next

			CloseFile(File)
			Array_Configs(x-1)=frame\txt$
			return true		
		endif
			
	Elseif ToDo="Load"
		x=ConfigEntryChoosed+ConfigEntryOffset
		if FileType("config\C"+x+"_"+Array_Configs(x-1)+".cfg")<>0 Then
			File=OpenFile("config\C"+x+"_"+Array_Configs(x-1)+".cfg")
			IPAddress$=Trim$(ReadString$(file))
			if(Net_Type = 1)			
				x=filepos(File)
				seekfile(file,x+132)
			else
				For i=0 To 20
					MaxItems(i)=ReadInt(File)
				Next
				B_Time=ReadInt(File)
				Game_mode=ReadInt(File)
				Level=ReadInt(File)
				WinsNeeded=ReadInt(File)
				Shop_On=ReadInt(File)
				Wheel_On=ReadInt(File)
				Menu_Shrinking_On=ReadInt(File)
				Special_On=ReadInt(File)
				Music_On=ReadInt(File)
				Video_On=ReadInt(File)
				Pitch_On=ReadInt(File)
				Menu_Alarm_On=ReadInt(File)
			endif
			
						
			musicvolume=Readfloat(File)
			alarmvolume=Readfloat(File)
			
			x=ReadInt(File)
			For i=1 to x
				name$=readstring(File)
				temp1=ReadInt(File)
				temp2=ReadInt(File)
				temp3=ReadInt(File)
				for j=0 to C_MAX_INP_CODES-1
					InpDeviceCode(j,0) = ReadInt(File)
				next
				Menu_AddPlayer(name$,Net_MyName$,Net_MyNetId,temp2,temp1,temp3)
				
				dat$=LSet(Net_Player\CompID,10)
				dat$=dat$+LSet(Net_Player\CompName$,10)
				dat$=dat$+LSet(Net_Player\Name$,40)
				dat$=dat$+LSet(Net_Player\Team,1)
				dat$=dat$+LSet(Net_Player\Device,1)
				dat$=dat$+LSet(Im_Player(Net_Player\Hero)\File$,30)
				If Net_Type<>0 Then	SendNetMsg(10,Dat$,Net_MyNetID,0,True)
				
				LoadDefaultInput(0)
			next
			closefile(File)
			return true
		ENDIF
	
	elseIf ToDo="Delete" Then
		x=ConfigEntryChoosed+ConfigEntryOffset
		if FileType("config\C"+x+"_"+Array_Configs(x-1)+".cfg")<>0 Then
			DeleteFile("config\C"+x+"_"+Array_Configs(x-1)+".cfg")
		endif
		if FileType("config\C"+x+"_"+Array_Configs(x-1)+".cfg")=0 Then
			Menu_FindFrame("CONFIG-"+ ConfigEntryChoosed)
			frame\txt$ = ""
			Array_Configs(x-1)=""
			return true
		else
		 	return false		
		endif
	endif
	
	return false
	
End Function

;-------------------------------------------------------------------------
Function ParseAdditional(name$)

	if instr(name$,"playerstartspeed") <> 0 then
		Player_StartSpeed = findvalue#(name$,1,20)
	else if instr(name$,"playerincrementspeed") <> 0 then
		Player_IncSpeed = findvalue#(name$,-5,20)
	else if instr(name$,"playermaxspeed") <> 0 then
		Player_MaxSpeed = findvalue#(name$,1,20)
	else if instr(name$,"cbombspeed") <> 0 then
		CBombSpeed			= findvalue#(name$,0,20)
	else if instr(name$,"bombticks") <> 0 then
		BombTicks 			= findvalue#(name$,500,10000)
	else if instr(name$,"playerrandomposition") <> 0 then
		PlayerRandomPos	= findvalue#(name$,0,1)
	else if instr(name$,"playersliding") <> 0 then
		SlideValue			= findvalue#(name$,0,17)
	else if instr(name$,"specialprobability") <> 0 then
		SpecialProbability	= findvalue#(name$,1,100) 		
	else if instr(name$,"specialhaste") <> 0 then	
		SpecialGames    = (SpecialGames or int(findvalue#(name$,0,1)) )
	else if instr(name$,"specialboom") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*2)
	else if instr(name$,"specialhaha") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*4)
	else if instr(name$,"specialnukem") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*8)
	else if instr(name$,"specialsimple") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*16)
	else if instr(name$,"specialrocknroll") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*32)
	else if instr(name$,"specialrunningman") <> 0 then	
		SpecialGames    = (SpecialGames or (int(findvalue#(name$,0,1)))*64)
	else if instr(name$,"???darkness") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1))))
	else if instr(name$,"???inverted") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*2)
	else if instr(name$,"???smallbomb") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*4)
	else if instr(name$,"???wallbomb") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*8)
	else if instr(name$,"???nobomb") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*16)
	else if instr(name$,"???bombshit") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*32)
	else if instr(name$,"???slowdown") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*64)
	else if instr(name$,"???personalstop") <> 0 then	
		QuestionItems   = (QuestionItems or (int(findvalue#(name$,0,1)))*128)
	else if instr(name$,"crumblewalls") <> 0 then
		CrumbleWalls		= findvalue#(name$,0,1)
	endif

end function
;-------------------------------------------------------------------------


;-------------------------------------------------------------------------
Function findvalue#(name$,min#,max#)

	pos1 = instr(name$,"=")+1
	pos2 = instr(name$,";")
	if pos2 = 0 then pos2 = len(name$)+1
	x#=mid(name$,pos1,pos2-pos1)
	
	if x < min then
		return min
	elseif x > max
		Return max
	else
		return x#
	endif

end function
;-------------------------------------------------------------------------



				
;-------------------------------------------------------------------------
;-------------------------------------------------------------------------
;-------------------------------------------------------------------------

;-------------------------------------------------------------------------
Function HS_Insert(Name$,Score,Date$)
	If Score<=HSScore(10) Then Return
	x=10
	While (HSScore(x)<Score) And (x>=1)
		x=x-1
	Wend
	x=x+1
	For y=10 To x Step -1
		HSName$(y)=HSName$(y-1)
		HSScore(y)=HSScore(y-1)
		HSDate$(y)=HSDate$(y-1)
	Next
	HSName$(x)=Name$
	HSScore(x)=Score
	HSDate$(x)=Date$
End Function


;-------------------------------------------------------------------------
Function HS_Save()
	If FileType("data\confighighscore.dat")=1 Then
		File=OpenFile("data\Highscore.dat")
	Else
		File=WriteFile("data\Highscore.dat")
	EndIf
	For X=1 To 10 
		WriteString(File,HSName$(x))
		WriteInt(File,HSScore(x))
		WriteString(File,HSDate$(x))
	Next
	CloseFile(File)
End Function


;-------------------------------------------------------------------------
Function Reg_FormatString$(s$)
	s$=Upper$(s$)
	s$=Replace$(s$," ","")
	s$=Replace$(s$,".","")
	s$=Replace$(s$,",","")
	s$=Replace$(s$,"-","")
	s$=Replace$(s$,"_","")
	Return s$
End Function


;-------------------------------------------------------------------------
Function Reg_Shuffle$(s$)
	l=Len(s$)
	s2$=String$("_",l)

	y=9481+l
	For x=1 To l
		y=y+Asc(Mid$(s$,x,1))
	Next
	SeedRnd(y)
	
	For x=1 To l
		Repeat
			y=Rand(l)
		Until Mid$(s2$,y,1)="_"
		s2$=LSet$(s2$,y-1)+Mid$(s$,x,1)+Mid$(s2$,y+1)
	Next
	
	Return s2$
End Function



;-----------------------------------------------------------------------------------------------
Function aReg_FindPathTo$(Folder$,Match$,depth)

	dir=ReadDir(Folder$)
	Repeat
		file$=Upper$(NextFile$(dir))
;DebugLog "found "+Folder+"\"+file$
		If file$="" Then Exit
		If (FileType(folder$+"\"+file$)=1) And (match$=file$) Then Exit
	Forever

	CloseDir dir
	If match$=file$ Then
		Return Folder$
	EndIf

	If depth>0 Then 
		dir=ReadDir(Folder$)
		Repeat
			file$=Upper$(NextFile$(dir))
			If file$="" Then Exit
			If (file$<>".") And (file$<>"..") Then
				If FileType(folder$+"\"+file$)=2 Then
;Print "Scanning "+folder$+"\"+file$
					subdir$=aReg_FindPathTo$(folder$+"\"+file$,Match$,depth-1)
					If subdir$<>"" Then Exit
				EndIf
			EndIf
		Forever
		CloseDir dir
		Return subdir$
	Else
;Print "to deep"
		Return ""
	EndIf

End Function


;-----------------------------------------------------------------------------------------------
Function aReg_Date2Integer(a$)
	If Len(a$)<>11 Then Return
	i%=(Int(Right$(a$,4))-1900)*372
	i=i+Int(Left$(a$,2))
	Select Mid$(a$,4,3)
	Case "Jan" i=i+( 0*31)
	Case "Feb" i=i+( 1*31)
	Case "Mar" i=i+( 2*31)
	Case "Apr" i=i+( 3*31)
	Case "May" i=i+( 4*31)
	Case "Jun" i=i+( 5*31)
	Case "Jul" i=i+( 6*31)
	Case "Aug" i=i+( 7*31)
	Case "Sep" i=i+( 8*31)
	Case "Oct" i=i+( 9*31)
	Case "Nov" i=i+(10*31)
	Case "Dec" i=i+(11*31)
	End Select
	Return i
End Function


;;	DeadLineFile$="\MSREG98.DLL"
