#version 410

#define emit(p, c, r) \
        g_out.coord.xy = c; \
        g_out.coord.z  = r; \
        gl_Position.xy = p; \
        gl_Position.zw = vec2(0.0, 1.0); \
        EmitVertex();
        
layout(lines, invocations = 1) in;
layout(triangle_strip, max_vertices = 8) out;

out GeometryOut
{
    noperspective vec3 coord;
    
} g_out;


void emitLine(in vec2 pos0, in vec2 pos1, in float rad0, in float rad1)
{
    float rad_ratio = rad1 / rad0;
    
    vec2 pll = normalize(pos1 - pos0) * rad0, // parallel
         prp = pll.yx * vec2(-1, +1); // perpendicular

    emit(pos0 + prp * (+1.0) + pll * (-1.0), vec2(+1.0, -1.0), rad0);
    emit(pos0 + prp * (-1.0) + pll * (-1.0), vec2(-1.0, -1.0), rad0);

    emit(pos0 + prp * (+1.0), vec2(+1.0, 0.0), rad0);
    emit(pos0 + prp * (-1.0), vec2(-1.0, 0.0), rad0);

    emit(pos1 + prp * (+1.0) * rad_ratio, vec2(+1.0, 0.0), rad1);
    emit(pos1 + prp * (-1.0) * rad_ratio, vec2(-1.0, 0.0), rad1);
 
    emit(pos1 + prp * (+1.0) * rad_ratio + pll * (+1.0) * rad_ratio, vec2(+1.0, +1.0), rad1);
    emit(pos1 + prp * (-1.0) * rad_ratio + pll * (+1.0) * rad_ratio, vec2(-1.0, +1.0), rad1);

    EndPrimitive();
}

void main()
{
    emitLine(gl_in[0].gl_Position.xy, gl_in[1].gl_Position.xy, gl_in[0].gl_Position.z, gl_in[1].gl_Position.z);
}
