#version 410

uniform vec4 colour;

layout(early_fragment_tests) in;

in GeometryOut
{
    noperspective vec3 coord;
    
} g_out;

out vec4 output;

void main()
{
    float a = step(dot(g_out.coord.xy, g_out.coord.xy), 1.0);
    
    if(a < 1.0)
        discard;
    
    output.rgb = colour.rgb;
    output.a = (length(g_out.coord.xy) * g_out.coord.z - (g_out.coord.z - 0.1)) * 10.0;
}
