#version 410

#define saturate(x) clamp(x, 0.0, 1.0)

uniform sampler2D tex0;

noperspective in vec2 v2f_coord;

out vec4 output;

void main()
{
    float d = texture2D(tex0, v2f_coord).r;
    vec3 col = mix(vec3(0.0), vec3(1.0), smoothstep(0.3, 0.8, d));
    output = vec4(col.r, col.g, col.b, smoothstep(0.3, 0.7, d));
}

