#version 410

uniform sampler2D tex0;
uniform vec2 scale;

in vec2 v2f_coord;

out vec4 output;

vec2 kernel[16] = vec2[16] (
 vec2(0.000000, -0.333333),
 vec2(-0.500000, 0.333333),
 vec2(0.500000, -0.777778),
 vec2(-0.750000, -0.111111),
 vec2(0.250000, 0.555556),
 vec2(-0.250000, -0.555556),
 vec2(0.750000, 0.111111),
 vec2(0.125000, -0.925926),
 vec2(-0.375000, -0.259259),
 vec2(0.625000, 0.407407),
 vec2(-0.625000, -0.703704),
 vec2(0.375000, -0.037037),
 vec2(-0.125000, 0.629630),
 vec2(0.875000, -0.481481),
 vec2(-0.937500, 0.185185),
 vec2(0.062500, 0.851852) );
 
void main()
{
    output = vec4(0.0);
    
    for(int i = 0; i < kernel.length(); ++i)
        output += texture2D(tex0, v2f_coord + kernel[i] * scale);
    
    output /= float(kernel.length());
}

