#version 410

uniform sampler2D tex0, tex1;
uniform vec2 noise_offset, u_scale;

in vec2 v2f_coord;

out vec4 output;

vec2 blur_kernel[32] = vec2[32] (
vec2(0.000000, -0.333333),
vec2(-0.500000, 0.333333),
vec2(0.500000, -0.777778),
vec2(-0.750000, -0.111111),
vec2(0.250000, 0.555556),
vec2(-0.250000, -0.555556),
vec2(0.750000, 0.111111),
vec2(0.125000, -0.925926),
vec2(-0.375000, -0.259259),
vec2(0.625000, 0.407407),
vec2(-0.625000, -0.703704),
vec2(0.375000, -0.037037),
vec2(-0.125000, 0.629630),
vec2(0.875000, -0.481481),
vec2(-0.937500, 0.185185),
vec2(0.062500, 0.851852),
vec2(-0.437500, -0.851852),
vec2(0.562500, -0.185185),
vec2(-0.687500, 0.481482),
vec2(0.312500, -0.629630),
vec2(-0.187500, 0.037037),
vec2(-0.812500, -0.407407),
vec2(0.187500, 0.259259),
vec2(-0.312500, 0.925926),
vec2(-0.562500, -0.308642),
vec2(0.437500, 0.358025),
vec2(-0.062500, -0.753086),
vec2(0.937500, -0.086420),
vec2(0.031250, -0.530864),
vec2(-0.468750, 0.135803),
vec2(0.531250, 0.802469),
vec2(0.281250, -0.234568) );

vec2 rotate(in vec2 v, in float angle)
{
    return vec2(v.x * cos(angle) - v.y * sin(angle),
                v.y * cos(angle) + v.x * sin(angle));
}

float shadow(vec2 scale, vec2 offset)
{
    float sh = 0.0;
    float rot_angle = texelFetch(tex1, ivec2(mod(gl_FragCoord.xy + noise_offset, textureSize(tex1, 0).xy)), 0).r * 2.0 * 3.1415926;
    
    //for(int i = 0; i < blur_kernel.length(); ++i)
        //sh += texture2D(tex0, v2f_coord + rotate(blur_kernel[i], rot_angle) * scale + offset).a;

    vec2 n = vec2(cos(rot_angle), sin(rot_angle)) * scale;

    for(int i = 0; i < blur_kernel.length(); ++i)
    {
        vec2 d = blur_kernel[i];
    
        d = vec2(d.x * n.x - d.y * n.y,
                 d.y * n.x + d.x * n.y) + offset;
    
        sh += textureLod(tex0, v2f_coord + d, 1.0).a;
    }
    
    return 1.0 - sh / float(blur_kernel.length());
}

void main()
{
    vec4 fore = texture2D(tex0, v2f_coord);
    
    vec3 back = vec3(shadow(vec2(0.08) * u_scale, vec2( 0.0))) * vec3(0.1, 0.1, 0.16) * 3.0 +
                vec3(shadow(vec2(0.01) * u_scale, vec2(0.03))) * vec3(0.4, 0.4, 0.34);
    
    output.rgb = mix(back.rgb, fore.rgb, fore.a);
}

