/*
   Voxel landscape
   w/s   = forward/backward
   q/e   = rotate
   space = exit

   (c)dox@emugaming.com
*/

#include <stdio.h>
#include <conio.h>
#include <math.h>

char buff [320*210];
char coords[16*64*2];
char perspec[64*16];
char tx[16384];
char height[16384];

float sin2(float kat){ return (sin(3.14*kat/180));}
float cos2(float kat){ return (cos(3.14*kat/180));}

void tabp(void)
{
 for(int wart=0;wart<64;wart++)
  for(int y=0;y<16;y++)
   perspec[wart*16+y]=wart*sin2(y*10);
 FILE *file=fopen("persp.bin","wb+");
 fwrite(perspec,1,64*16,file);
 fclose(file);
 float xx;
 for(int var_1=0;var_1<64;var_1++)
 {
  xx=-90+30+var_1*1.875;
  for(int y=0;y<16;y++)
  {
   coords[2*(y*64+var_1)]=y*sin2(xx)*3;
   coords[1+2*(y*64+var_1)]=y*cos2(xx)*3;
  }
 }
 file=fopen("rays.bin","wb+");
 fwrite(coords,1,64*16*2,file);
 fclose(file);
}

void copy(void);
#pragma aux copy=\
"lea esi,buff" "mov edi,0a1900h" "cld" "mov ecx,12800" "rep movsd" modify [esi edi ecx];

void colory(void)
{
  outp(0x3c8,0);
  for(int giu=0;giu<64;giu++)
   {
    outp(0x3c9,giu);
    outp(0x3c9,giu);
    outp(0x3c9,giu/2);
   }
}


void plot(int x,int y,int kol){ buff[y*320+x]=kol;}
unsigned char tex(long x,long y){ return tx[(y*128+x)%16384]; }
unsigned char tex2(long x,long y){ return height[(y*128+x)%16384]; }

void gfx(int);
#pragma aux gfx="int 10h" parm [eax];

void main(void)
{
 char wart,z,color,index,key;
 int x,y,end=1,zzz;
 long start=33,yx=33,val2;
 tabp();
 gfx(0x13);
 colory();
 FILE* file=fopen("height.raw","rb+");
 fread(tx,1,16384,file);
 fclose(file);
 file=fopen("tex.raw","rb+");
 fread(height,1,16384,file);
 fclose(file);
 while(end)
 {
  for(x=0;x<64;x++)
   for(y=0;y<200;y++)
    plot(128+x,y,0);
  for(x=0;x<64;x++)
  {
   index=0;
   for(y=0;y<15;y++)
   {
    val2=perspec[(tex(coords[(y*64+x)*2]+yx,coords[(y*64+x)*2+1]+start)/4)*16+y];
    color=9*tex2(coords[(y*64+x)*2]+yx,coords[(y*64+x)*2+1]+start);
    if(val2>index)
    {
     for(zzz=index;zzz<val2+1;zzz++)
      plot(128+x,100-zzz,color);
     index=val2;
    }
   }
  }
  copy();
  key=getch();
  switch(key)
  {
   case 119 : start++;break;
   case 115 : start--;break;
   case 32  : end=0;break;
   case 113 : yx--;break;
   case 101 : yx++;break;
  }
 }
 gfx(3);
}