/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.RolloverButtonListener;
import com.pagosoft.plaf.ToolBarToggleButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class PgsToggleButtonUI
extends MetalToggleButtonUI {
    private static PgsToggleButtonUI INSTANCE = new PgsToggleButtonUI();

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent.getParent() instanceof JToolBar) {
            return ToolBarToggleButtonUI.createUI(jComponent);
        }
        return INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setFocusPainted(false);
        abstractButton.putClientProperty("rolloverBackground", UIManager.getColor("ToggleButton.rolloverBackground"));
        abstractButton.putClientProperty("pgs.isFlat", UIManager.get("ToggleButton.isFlat"));
        abstractButton.putClientProperty("gradientStart", UIManager.get("ToggleButton.gradientStart"));
        abstractButton.putClientProperty("gradientEnd", UIManager.get("ToggleButton.gradientEnd"));
        abstractButton.putClientProperty("rollover.gradientStart", UIManager.get("ToggleButton.rolloverGradientStart"));
        abstractButton.putClientProperty("rollover.gradientEnd", UIManager.get("ToggleButton.rolloverGradientEnd"));
        abstractButton.putClientProperty("selected.gradientStart", UIManager.get("ToggleButton.selectedGradientStart"));
        abstractButton.putClientProperty("selected.gradientEnd", UIManager.get("ToggleButton.selectedGradientEnd"));
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new RolloverButtonListener(abstractButton);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = 3;
        int n2 = abstractButton.getWidth() - n * 2;
        int n3 = abstractButton.getHeight() - n * 2;
        graphics.setColor(this.getFocusColor());
        PgsUtils.drawRoundRect(graphics, n, n, n2 - 1, n3 - 1, 3, 3);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (jComponent.isOpaque() && abstractButton.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(jComponent.getClientProperty("pgs.isFlat")) || !abstractButton.isEnabled()) {
                graphics.setColor(jComponent.isEnabled() && abstractButton.getModel().isRollover() ? (Color)jComponent.getClientProperty("rolloverBackground") : jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else if (jComponent.isEnabled() && abstractButton.getModel().isRollover()) {
                PgsUtils.drawGradient(graphics, jComponent, "rollover");
            } else {
                PgsUtils.drawGradient(graphics, jComponent);
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(abstractButton.getClientProperty("pgs.isFlat"))) {
                graphics.setColor(this.getSelectColor());
                graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            } else {
                PgsUtils.drawGradient(graphics, abstractButton, "selected");
            }
        }
    }
}

