/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class Settings {
    private static File file = new File(System.getProperty("user.home"), ".DskManager/Settings.ini");
    private static final Settings instance = new Settings();
    private final Properties props = new Properties();
    public static final String lastpath = "last_path";
    public static final String lastopened = "last_opened";

    private Settings() {
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkRead(file.getAbsolutePath());
            }
            this.props.load(new FileInputStream(file));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("true");
    }

    public static int getInt(String key, int defaultValue) {
        String value = Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static void setBoolean(String key, boolean value) {
        Settings.instance.props.setProperty(key, value ? "true" : "false");
        Settings.save();
    }

    public static String get(String key, String defaultValue) {
        String value = Settings.instance.props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void set(String key, String value) {
        if (value.equals(Settings.get(key, null))) {
            return;
        }
        Settings.instance.props.setProperty(key, value);
        Settings.save();
    }

    public static void remove(String key) {
        Settings.instance.props.remove(key);
        Settings.save();
    }

    public static void delete() {
        try {
            Settings.instance.props.clear();
            Settings.save();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void save() {
        try {
            File f = new File(System.getProperty("user.home"), ".DskManager");
            f.mkdir();
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkWrite(file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            Settings.instance.props.store(fos, "[Settings]");
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

