/*
 * Decompiled with CFR 0.152.
 */
package CPCFileSystem;

import CPCFileSystem.DskFile;
import CPCFileSystem.DskManager;
import CPCFileSystem.DskMaster;
import CPCFileSystem.DskSector;
import CPCFileSystem.DskSectorCatalog;
import CPCFileSystem.DskSectorCatalogs;
import CPCFileSystem.DskType;
import classes.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CPCFileSystem {
    DskManager dm = new DskManager();
    DskFile dsk;
    boolean[] sys = new boolean[1];
    boolean[] ro = new boolean[1];
    int[] size = new int[1];
    boolean diskloaded = false;
    String lastDisk = "";
    boolean overWrite = false;
    String[] sizes;
    protected String[] realFile;
    LinkedHashMap<String, ByteArrayOutputStream> list;
    byte[] HEADER;
    byte[] RESULT;
    protected String internalname = "           ";
    protected int namepos = 1;
    protected int filetypepos = 18;
    protected int datalengthpos = 19;
    protected int datalocationpos = 21;
    protected int firstblockpos = 23;
    protected int filelengthpos = 24;
    protected int execaddresspos = 26;
    protected int lengthpos = 64;
    protected int checksumpos = 67;
    String content;

    public static void main(String[] args) {
        CPCFileSystem sys = new CPCFileSystem();
        File a = new File("hexenkueche.dsk");
        sys.loadDisk("hexenkueche.dsk");
        String[] dir = sys.DIR();
        for (int i = 0; i < dir.length; ++i) {
            System.out.println(dir[i] + ":" + (sys.ro[i] ? "R" : " ") + (sys.sys[i] ? "S" : " "));
        }
    }

    public static void mainr(String[] args) {
        CPCFileSystem sys = new CPCFileSystem();
        try {
            File a = new File("test.dsk");
            if (!a.exists()) {
                sys.dm.newDsk(new File("test.dsk"), "", DskType.SS40);
            }
            sys.writeFile("ANTIRAD2", "test.dsk");
            System.out.println("---------------");
            sys.writeFile("ANTIRAD3", "test.dsk");
            sys.deleteFile("ANTIRAD2", "test.dsk");
            System.out.println("---------------");
            sys.DIR();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDisk(String path, String name) {
        this.loadDisk(new File(path + name), "");
    }

    public void deleteFile(String name, String dskname) {
        try {
            this.loadDisk(dskname);
            name = this.getAmsdosString(name);
            this.dm.eraseFile(this.dsk, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getAmsdosString(String name) {
        while (name.contains("/")) {
            name = name.substring(1);
        }
        while (name.contains("\\")) {
            name = name.substring(1);
        }
        while (name.length() > 12) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.contains(".")) {
            name = name.replace(".", "x-SplitMeHere-x");
            String[] names = name.split("x-SplitMeHere-x");
            while (names[0].length() < 8) {
                names[0] = names[0] + " ";
            }
            while (names[1].length() < 3) {
                names[1] = names[1] + " ";
            }
            name = names[0] + "." + names[1];
        } else {
            while (name.length() > 8) {
                name = name.substring(0, name.length() - 1);
            }
        }
        if (name.length() < 8) {
            while (name.length() < 8) {
                name = name + " ";
            }
        }
        if (name.length() < 9) {
            name = name + ".";
        }
        while (name.length() < 12) {
            name = name + " ";
        }
        return name.toUpperCase();
    }

    public void writeFile(String name, String dskname) {
        if (!this.lastDisk.equals(dskname)) {
            this.overWrite = false;
        }
        this.lastDisk = dskname;
        this.loadDisk(dskname);
        File a = new File(name);
        try {
            String parent = a.getParent();
            if (parent == null) {
                parent = "./";
            }
            String toErase = this.getAmsdosString(name);
            try {
                byte[] test = this.dm.readFile(this.dsk, toErase);
                if (!(test == null || test.length <= 1 || this.overWrite || name.toLowerCase().contains("sprcode") || name.toLowerCase().contains("shapecod"))) {
                    Object[] options = new Object[]{"No", "Yes"};
                    int n = JOptionPane.showOptionDialog(new JFrame(), "File(s) already exist on your DSK.\r\n" + name + "\r\nOverwrite them?", "File exist!", 0, 2, null, options, options[0]);
                    if (n == 1) {
                        this.overWrite = true;
                    } else {
                        return;
                    }
                }
                if (test != null && (name.toLowerCase().contains("sprcode") || name.toLowerCase().contains("shapecod"))) {
                    this.deleteFile(toErase, dskname);
                }
                if (this.overWrite) {
                    this.deleteFile(toErase, dskname);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dm.addFile(this.dsk, new File(parent), a.getName(), null);
            this.DIR();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] readFile(String dskname, String osname) {
        this.loadDisk(dskname);
        try {
            return this.dm.readFile(this.dsk, osname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void loadDisk(String name) {
        this.loadDisk(new File(name), "");
    }

    public void get(String name) {
        File a = new File(name);
        if (!a.exists()) {
            try {
                this.dm.newDsk(new File(name), "", DskType.SS40);
            }
            catch (Exception ex) {
                return;
            }
        }
        this.loadDisk(new File(name), "");
    }

    public int getSpace() {
        this.DIR();
        int space = this.getFreeSize();
        for (int i = 0; i < this.size.length; ++i) {
            space -= this.size[i];
        }
        return space;
    }

    public int getFree() {
        this.DIR();
        int space = this.getFreeSize();
        for (int i = 0; i < this.size.length; ++i) {
            space -= this.size[i];
        }
        return space;
    }

    public void loadDisk(File currentDir, String name) {
        try {
            this.dsk = this.dm.loadDsk(currentDir, name);
            this.diskloaded = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] realDir() {
        return this.realFile;
    }

    public String[] DIR() {
        String[] dir;
        if (!this.diskloaded) {
            String[] empty = new String[]{"<empty>"};
            return empty;
        }
        try {
            this.list = this.listFiles(this.dsk);
            Object[] obj = this.list.keySet().toArray();
            dir = new String[obj.length];
            this.sys = new boolean[obj.length];
            this.ro = new boolean[obj.length];
            this.sizes = new String[obj.length];
            this.size = new int[obj.length];
            this.realFile = new String[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                String a = obj[i].toString();
                String filename = "";
                this.sys[i] = false;
                this.ro[i] = false;
                this.realFile[i] = a;
                for (int g = 0; g < a.length(); ++g) {
                    int c = a.charAt(g);
                    if (g == 9 && c > 127) {
                        this.ro[i] = true;
                    }
                    if (g == 10 && c > 127) {
                        this.sys[i] = true;
                    }
                    filename = filename + (char)(c &= 0x7F);
                }
                int fileSize = this.list.get(this.realFile[i]).toByteArray().length / 1024;
                if (this.list.get(this.realFile[i]).size() % 1024 > 0) {
                    ++fileSize;
                }
                if (this.dsk.master.type == DskType.PARADOS80 || this.dsk.master.type == DskType.PARADOS40D || this.dsk.master.type == DskType.DOSD2 || this.dsk.master.type == DskType.DOSD20 || this.dsk.master.type == DskType.DOSD40 || this.dsk.master.type == DskType.SDOS || this.dsk.master.type == DskType.VORTEX) {
                    if (fileSize / 2 * 2 != fileSize) {
                        ++fileSize;
                    }
                    if (this.dsk.master.type == DskType.VORTEX && fileSize / 4 * 4 != fileSize) {
                        fileSize += 2;
                    }
                }
                this.sizes[i] = fileSize + "";
                dir[i] = filename + ":" + this.sizes[i] + ":" + (this.ro[i] ? "R" : "-") + ":" + (this.sys[i] ? "S" : "-") + ":" + this.realFile[i];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dir = null;
        }
        Arrays.sort(dir);
        for (int i = 0; i < dir.length; ++i) {
            String[] b = dir[i].split(":");
            this.realFile[i] = b[4];
            this.sys[i] = b[3].contains("S");
            this.ro[i] = b[2].contains("R");
            this.size[i] = Integer.parseInt(b[1]);
            String l = this.size[i] + "k";
            while (l.length() < 4) {
                l = " " + l;
            }
            if (b[0].endsWith(".   ")) {
                b[0] = b[0].replace(".", " ");
            }
            dir[i] = b[0] + " " + l;
            if (this.ro[i]) {
                int n = i;
                dir[n] = dir[n] + " *";
            }
            if (!this.sys[i]) continue;
            int n = i;
            dir[n] = dir[n] + " S";
        }
        return dir;
    }

    public int getFreeSize() {
        int freeSize = 0;
        if (this.dsk.master.type == null) {
            return 0;
        }
        switch (this.dsk.master.type) {
            case PARADOS80: {
                freeSize = 396;
                break;
            }
            case PARADOS41: {
                freeSize = 203;
                break;
            }
            case PARADOS40D: {
                freeSize = 396;
                break;
            }
            case SS40: {
                freeSize = 178;
                break;
            }
            case SYSTEM: {
                freeSize = 169;
                break;
            }
            case VORTEX: {
                freeSize = 704;
                break;
            }
            case DOSD2: {
                freeSize = 712;
                break;
            }
            case DOSD10: {
                freeSize = 796;
                break;
            }
            case DOSD20: {
                freeSize = 792;
                break;
            }
            case DOSD40: {
                freeSize = 396;
                break;
            }
            case SDOS: {
                freeSize = 396;
                break;
            }
        }
        return freeSize;
    }

    public LinkedHashMap<String, ByteArrayOutputStream> listFiles(DskFile dskFile) throws IOException {
        if (dskFile == null) {
            return null;
        }
        LinkedHashMap<String, ByteArrayOutputStream> listFiles = new LinkedHashMap<String, ByteArrayOutputStream>();
        List<DskSectorCatalogs> catalogsC1C4 = dskFile.master.buildCatalogs(dskFile.tracks);
        int fileLength = 0;
        boolean checkAMSDOS = false;
        for (DskSectorCatalogs cat : catalogsC1C4) {
            for (DskSectorCatalog entryFile : cat.cats) {
                for (DskSector sector : entryFile.catsSector) {
                    String key = dskFile.master.cpcname2realname(entryFile.filename);
                    if (listFiles.containsKey(key)) {
                        if (checkAMSDOS) {
                            listFiles.get(key).write(sector.data, 0, Math.min(sector.data.length, fileLength));
                            continue;
                        }
                        listFiles.get(key).write(sector.data);
                        continue;
                    }
                    DskMaster cfr_ignored_0 = dskFile.master;
                    checkAMSDOS = DskMaster.CheckAMSDOS(sector.data);
                    if (checkAMSDOS) {
                        fileLength = 128 + dskFile.master.getFileLengthAMSDOSHeader(sector.data);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (checkAMSDOS) {
                        baos.write(sector.data, 0, Math.min(sector.data.length, fileLength));
                    } else {
                        baos.write(sector.data);
                    }
                    listFiles.put(key, baos);
                }
            }
        }
        for (String key : listFiles.keySet()) {
            listFiles.get(key).flush();
            listFiles.get(key).close();
        }
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRom(String name, int size) {
        byte[] buffer = new byte[size];
        int offs = 0;
        try (InputStream stream = null;){
            InputStream is;
            stream = is = this.getClass().getResourceAsStream(name);
            while (size > 0) {
                int read = stream.read(buffer, offs, size);
                if (read == -1) {
                    break;
                }
                offs += read;
                size -= read;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer;
    }

    public byte[] makeHeader(int type, int start, int length, int exec, String intname, byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        this.HEADER = new byte[128];
        intname = intname.replace(".", "");
        while (intname.length() > 11) {
            intname = intname.substring(0, intname.length() - 1);
        }
        intname = intname.toUpperCase();
        try {
            System.arraycopy("           ".getBytes("UTF-8"), 0, this.HEADER, this.namepos, 11);
            System.arraycopy(intname.getBytes("UTF-8"), 0, this.HEADER, this.namepos, intname.length());
        }
        catch (Exception e) {
            System.err.println("Something went wrong with " + intname);
        }
        this.HEADER[this.filetypepos] = (byte)type;
        CPCFileSystem.putWord(this.HEADER, this.datalengthpos, length);
        CPCFileSystem.putWord(this.HEADER, this.datalocationpos, start);
        this.HEADER[this.firstblockpos] = -1;
        CPCFileSystem.putWord(this.HEADER, this.filelengthpos, length);
        CPCFileSystem.putWord(this.HEADER, this.execaddresspos, exec);
        CPCFileSystem.put24Bit(this.HEADER, this.lengthpos, length);
        CPCFileSystem.put24Bit(this.HEADER, this.checksumpos, CPCFileSystem.ChecksumAMSDOS(this.HEADER));
        SOURCEFILE = this.addHeader(SOURCEFILE);
        return SOURCEFILE;
    }

    public byte[] addHeader(byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        if (CPCFileSystem.CheckAMSDOS(SOURCEFILE)) {
            this.removeHeader(SOURCEFILE);
        }
        this.RESULT = new byte[SOURCEFILE.length + 128];
        System.arraycopy(this.HEADER, 0, this.RESULT, 0, 128);
        System.arraycopy(SOURCEFILE, 0, this.RESULT, 128, SOURCEFILE.length);
        SOURCEFILE = new byte[this.RESULT.length];
        System.arraycopy(this.RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        this.content = Util.dumpBytes(SOURCEFILE);
        return SOURCEFILE;
    }

    public byte[] removeHeader(byte[] SOURCEFILE) {
        if (SOURCEFILE == null) {
            return SOURCEFILE;
        }
        if (!CPCFileSystem.CheckAMSDOS(SOURCEFILE)) {
            return SOURCEFILE;
        }
        this.RESULT = new byte[SOURCEFILE.length - 128];
        System.arraycopy(SOURCEFILE, 128, this.RESULT, 0, this.RESULT.length);
        SOURCEFILE = new byte[this.RESULT.length];
        System.arraycopy(this.RESULT, 0, SOURCEFILE, 0, SOURCEFILE.length);
        this.content = Util.dumpBytes(SOURCEFILE);
        return SOURCEFILE;
    }

    public static int ChecksumAMSDOS(byte[] pHeader) {
        int Checksum = 0;
        for (int i = 0; i < 67; ++i) {
            int CheckSumByte = pHeader[i] & 0xFF;
            Checksum += CheckSumByte;
        }
        return Checksum;
    }

    public static boolean CheckAMSDOS(byte[] pHeader) {
        int CalculatedChecksum;
        try {
            CalculatedChecksum = CPCFileSystem.ChecksumAMSDOS(pHeader);
        }
        catch (Exception e) {
            return false;
        }
        int ChecksumFromHeader = pHeader[67] & 0xFF | (pHeader[68] & 0xFF) << 8;
        return ChecksumFromHeader == CalculatedChecksum && ChecksumFromHeader != 0;
    }

    public static int getWord(byte[] buffer, int offs) {
        return buffer[offs] & 0xFF | buffer[offs + 1] << 8 & 0xFF00;
    }

    public static void putWord(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
    }

    public static void put24Bit(byte[] buffer, int offs, int data) {
        buffer[offs] = (byte)(data & 0xFF);
        buffer[offs + 1] = (byte)(data >> 8 & 0xFF);
        buffer[offs + 2] = (byte)(data >> 16 & 0xFF);
    }
}

