.module Video

	Tiles1		= $0000 ; Tiles 0..255
	Tiles2		= $2000 ; Tiles 256..447
	NameTable	= $3800 ; Name table
	SpriteTable	= $3F00 ; Sprite info table
	
	.module Reg
		Mode1 = $00
		.module Mode1
			Monochrome	= %00000001 ; Monochrome display, no synch
			AllowHeight	= %00000010 ; Allow screen height changes
			Mode4   	= %00000100 ; Use mode 4
			SpritesLeft8	= %00001000 ; Shift sprites left 8 pixels
			LineInterrupt	= %00010000 ; Line interrupt mode
			MaskColumn0	= %00100000 ; Mask column 0 with overscan colour
		.endmodule
		Mode2 = $01
		.module Mode2
			ZoomSprites	= %00000001 ; Zoom sprites to 16x16
			DoubleSprites	= %00000010 ; Double (pair) sprites to be 16x8
			Res30		= %00001000 ; 30 row / 240 line mode
			Res240		= %00001000 ; 30 row / 240 line mode
			Res28		= %00010000 ; 28 row / 224 line mode
			Res224		= %00010000 ; 28 row / 224 line mode
			VBlankInterrupt	= %00100000 ; Vblank interrupts
			Enable		= %01000000 ; Enable the display
		.endmodule
		NameTableLocation = $02
		OverscanColour = $07
		ScrollX = $08
		ScrollY = $09
		LineCountInterrupt = $0A
	.endmodule
	
	
	Reset ; Preload the VDP registers with sensible data.
		ld hl,ResetData 
		ld b,ResetDataEnd-ResetData
		ld c,$BF
		otir
		jp ClearAll
		ResetData .db $04,$80,$84,$81,$FF,$82,$FF,$85,$FF,$86,$FF,$87,$00,$88,$00,$89,$FF,$8A \ ResetDataEnd
	
	GotoHL ; Set the VRAM pointer to the address in HL.
		in a,($BF)
		ld a,l
		out ($BF),a
		ld a,h
		or %01000000
		out ($BF),a
		ret
		
	GotoHLRead
		in a,($BF)
		ld a,l
		out ($BF),a
		ld a,h
		or %00000000
		out ($BF),a
		ret

		
	GotoPalette ; Set the CRAM pointer to colour a.
		add a,a
		out ($BF),a
		ld a,$C0
		out ($BF),a
		ret
		
	
	ScreenOn ; Switch the screen on.
		ld a,Reg.Mode2.Enable
		jr {+}
	ScreenOff ; Switch the screen off
		xor a
	+	ld b,Reg.Mode2
	
	SetReg ; Set register B to value A.
		out ($BF),a
		ld a,%10000000
		or b
		out ($BF),a
		ret
	
	ClearAll
		ld hl,$0000
		call GotoHL
		ld hl,16*1024
	-	xor a
		out ($BE),a
		dec hl
		ld a,h \ or l
		jr nz,{-}
		call GotoPalette
		xor a
		ld b,64
	-	out ($BE),a
		djnz {-}	
		ret
		
	WaitVBlank ; Wait for VBlank
		in a,($7E)
		cp $C0
		jr nz,WaitVBlank
		ret
.endmodule