.module Sprites
	.var ubyte, BitplaneCount
	
	Load
		ld a,(Config.Platform == Config.Platform.GG) ? 34 : 17
		ld d,$20|$40
	LoadDirect
		push de
		out ($BF),a
		ld a,$C0
		out ($BF),a
		
		ld a,(hl) ; bit depth
		ld (BitplaneCount),a
		ld b,a
		inc hl
		ld a,1
		
	-	add a,a
		djnz {-}
		
		add a,a
		ld b,a
		
		; Load up the CRAM
		

		.if Config.Platform == Config.Platform.GG
			ld c,$BE
			otir
		.else
			; GGGGRRRR----BBBB
			; --BBGGRR
		-
		
			ld c,0
			ld a,(hl)
			add a,a
			rl c
			add a,a
			rl c
			sla c
			sla c
			ld a,(hl)
			srl a
			srl a
			and 3
			add a,c
			ld c,a
			
			inc hl
			ld a,(hl)
			inc hl
			
			add a,a
			add a,a
			and %00110000
			add a,c
			
			out ($BE),a
			dec b
			djnz {-}
		.endif
		
		xor a
		out ($BF),a
		pop af
		out ($BF),a
	
		ld c,(hl) ; Tile count
		inc hl		
		ld b,(hl)
		inc hl
		
	WriteTile
		push bc
		ld b,8
		
	WriteTileRow
		ld a,(BitplaneCount) \ ld e,a
		
	-	ld a,(hl) \ inc hl \ out ($BE),a
		dec e
		jr nz,{-}
		
		
		ld a,(BitplaneCount)
		neg
		add a,4
		jr z,{+}
		ld e,a
	-	xor a \ out ($BE),a \ dec e \ jr nz,{-}
	+
		djnz WriteTileRow
		
		pop bc
		dec bc
		ld a,b \ or c
		jr nz,WriteTile
		ret
		
	Clear
		ld hl,Video.SpriteTable
		call Video.GotoHL
		xor a
		ld b,0
	-	out ($BE),a
		djnz {-}
		ret
.endmodule