; Maths module
.module Maths

	.module Trig
		Cos
			add a,64
		Sin
			ld h,Table >> 8
			ld l,a
			ld a,(hl)
			ret
		.align 256
		Table .dbsin 256, 127, 0, 255, 1, 0
	.endmodule

	.module Mul

		U8U8 ; HL = E*A
			ld hl,0
			ld d,h
			.rept 8
				rrca
				jp nc,{+}
				add hl,de
			+	sla e
				rl d
			.loop
			ret

		S8S8 ; HL = E*B

			ld d,0
			ld h,d
			
			
			bit 7,e
			jp z,{+}
			inc h
			ld a,e
			neg
			ld e,a
		+
			ld a,b	
			bit 7,a
			jp z,{+}
			inc h
			neg
		+	
			
			bit 0,h
			jp z,U8U8
			call U8U8
			dec hl
			ld a,h \ cpl \ ld h,a
			ld a,l \ cpl \ ld l,a
			ret
			
		S8U8 ; sHL = sE*uA
			
			bit 7,e
			jp z,U8U8

			ld b,a
			ld a,e
			neg
			ld e,a
			ld a,b
			call U8U8
			dec hl
			ld a,h \ cpl \ ld h,a
			ld a,l \ cpl \ ld l,a
			ret
		
		U16U8 ; AHL = uA*uDE
			ld hl,0
			ld c,0
			add a,a
			jr nc,$+4
			ld h,d
			ld l,e

			.rept 7
				add hl,hl
				rla
				jr nc,$+4
				add hl,de
				adc a,c
			.loop
			ret
			
		S16S8 ; AHL = sA*sDE
			ld h,0
			bit 7,a
			jp z,{+}
			inc h
			neg
		+	
			bit 7,d
			jp z,{+}
			inc h
			push af
			dec de
			ld a,d \ cpl \ ld d,a
			ld a,e \ cpl \ ld e,a
			pop af
		+	bit 0,h
			jp z,U16U8
			call U16U8
			ld e,a
			dec hl
			ld a,h \ cpl \ ld h,a
			ld a,l \ cpl \ ld l,a
			ld a,e
			neg
			ret
			

		U16U16 ; DEHL = sDE*sBC
			ld hl,0
			.rept 16
			add hl,hl
			rl e
			rl d
			jp nc,{+}
			add hl,bc
			jp nc,{+}
			inc de
		+	.loop
			ret


		S16S16 ; sDEHL = sDE*sBC
			ld l,0
			bit 7,d
			jp z,{+}
			; DE is -ve
			inc l
			
			dec de
			ld a,d \ cpl \ ld d,a
			ld a,e \ cpl \ ld e,a
		+

			bit 7,b
			jp z,{+}
			; BC is signed.
			inc l
			dec bc
			ld a,b \ cpl \ ld b,a
			ld a,c \ cpl \ ld c,a
		+
			ld a,l
			call U16U16
	
			and 1
			ret z ; No need to flip sign of DEHL
			ld a,h \ or l
			dec hl
			jp nz,{+}
			dec de
		+	

			ld a,d \ cpl \ ld d,a
			ld a,e \ cpl \ ld e,a
			ld a,h \ cpl \ ld h,a
			ld a,l \ cpl \ ld l,a
	
			ret
		
		
		
	.endmodule
	
	.module Div
		U16U8 ; HL rA = uHL / uC
			xor a
			.rept 16
				add hl,hl
				rla
				cp c
				jr c,$+4
				sub c
				inc l
			.loop
			ret
	

		U16S8 ; HL = uHL / sC
			bit 7,c
			jp z,U16U8
			
			ld a,c
			neg
			ld c,a
		
			xor a
			.rept 16
				add hl,hl
				rla
				cp c
				jr c,$+4
				sub c
				inc l
			.loop
			
			dec hl
			ld a,h \ cpl \ ld h,a
			ld a,l \ cpl \ ld l,a
			ret

	.endmodule
.endmodule