; code in this file execute before main loop,here clearing, settings, e.t.c.
Start:
 ld   hl,zx             ; variable loop (for F2)
 di
 ld   sp,$fff0
 xor  a
 ld   [rIE],a           ; disable interrupts
 ld   [rIF],a
 ld   [rSCX],a
 ld   [rSCY],a
 ld   [vmode],a

 ld   a,72              ; set line at which lcdc interrupt occurs
 ld   [rLYC],a
 ld   a,%01000000       ; set lcdc int to occur when LY = LCY
 ld   [rSTAT],a

 ld   a,4 
 ldio [$07],a           ; Timer On
 call LCDoff
;------ Clear hiram ----------------------------------------------------------
 xor  a
 ld   hl,[sp+0]
 ld   [hld],a
 bit  7,l               ; hl==$ff7f ?
 jr   nz,@-3            ; no

;------ Ini HiRAM code -------------------------------------------------------
 ld   a,$3e             ; code for ld   a,N
 ldio [$fff2],a
 ld   a,$c9             ; code for ret
 ldio [$fff4],a 
 ld   a,$21             ; code for ld   hl,NN
 push af

;------ Clear lowram ---------------------------------------------------------
ClearLowRAM:
 rst  40
 db   %00111011         ; bc,d,hl
 dw   $2000             ; len
 db   0
 dw   $c000
 db   $54               ; FillHL

 ld   sp,$cfff          ; Init stack ptr
 call ClearObjects

 rst  40
 db   %00111101         ; c,de,hl
 db   dmaEnd-dmaCode    ; 23-de
 dw   dmaTrans          ; 45-hl
 dw   dmaCode
 db   $52               ; code of CopyHLtoDEinC

;------------------------------- Sqr table Ini
 ld   c,1
 ld   de,sqrTab
 ld   h,e
 ld   l,e
sqrSetLoop:
 call putNumb
 inc  d
 call putNumb
 add  hl,bc
 inc  bc                ; inc  c
 inc  bc
 dec  d
 dec  d
 dec  d
 inc  e
 jr   nz,sqrSetLoop
;------------------------------- Fast Fill Middle setup
 call FastTriCodeIni

;
; jp   worlds
 call ClearScr1Map
 rst  0
 rst  40
 db   %00111111         ; bc,de,hl
 dw   55*16             ; len
 dw   $8050             ; dest
 dw   Tilesgbdevs       ; source
 db   $50               ; CopyHLtoDE

 ld   a,5
 ld   hl,RectXYsize+1
 ld   [hld],a
 ld   [hl],20
 ld   [RectTile],a
 xor  a
 rst  40                
 db   %00111111         ; bc,de,hl
 dw   AttrMapgbdevs  
 dw   CharMapgbdevs  
 dw   $600              ; in : a-attr of tiles /flips,bgpriority/
 db   $5c               ; FillRect
 ld   a,%10010011
 ldio [$40],a
 if   sound
 ld   hl,MusicOne
 call plaInitMusic
 endc
 call eii
 xor  a
 ld   b,64
 ld   hl,FreeMem
 ld   [hli],a
 dec  b
 jr   nz,@-2
;-----------
 xor  a                    ;  a- index of pal    / 0 all
 ld   b,56                 ;  b- how many colors /64 all
 ld   hl,FreeMem           ; hl- start of Pals
 call SetBkgPalette
 ld   b,logoPause1
 call haltbv
 ld   b,32
showgbdev:
 push bc
 ld   b,logoPause2
 call haltbv
 xor  a                    ;  a- index of pal
 ld   b,56                 ;  b- how many colors /32 all
 ld   hl,FreeMem           ; hl- start of Palette
 push hl
 call SetBkgPalette
 ld   b,28
 ld   de,Palettegbdevs
 pop  hl
 call ColorFlashing
 pop  bc
 dec  b
 jr   nz,showgbdev
 ld   b,logoPause3
 call haltbv
 ld   b,32
fadegbdev:
 push bc
 ld   b,logoPause2
 call haltbv
 xor  a             ;  a: index of pal
 ld   b,56          ;  b: how many colors /32 all
 ld   hl,FreeMem    ; hl: start of monoPalette /only one color-component
 push hl
 call SetBkgPalette
 pop  hl
 ld   b,28
 call ColorFading
 pop  bc
 dec  b
 jr   nz,fadegbdev
 inc  b
 call haltbv

 call ClearScr1Map
 call ClearScrBank1
 rst  0
 rst  40
 db   %00111111         ; bc,de,hl
 dw   53*16             ; len
 dw   $8000             ; dest
 dw   Tilesdimens       ; source
 db   $50               ; CopyHLtoDE

 ld   hl,RectXYsize
 ld   [hl],20
 inc  hl
 ld   [hl],5
 xor  a
 ld   [RectTile],a

 ld   a,1
 rst  40                
 db   %00111111         ; bc,de,hl
 dw   AttrMapdimens
 dw   CharMapdimens  
 dw   $200              ; in :  a-attr of tiles /flips,bgpriority/
 db   $5c               ; FillRect

 ld   hl,FirstNote
 call PrintMessActive

 ld   b,32
showdimens:
 push bc
 ld   b,logoPause2
 call haltbv
 xor  a                    ;  a- index of pal
 ld   b,16                 ;  b- how many colors /32 all
 ld   hl,FreeMem           ; hl- start of Palette
 push hl
 call SetBkgPalette
 ld   b,8
 ld   de,Palettedimens
 pop  hl
 call ColorFlashing
 pop  bc
 dec  b
 jr   nz,showdimens

 ld   b,logoPause4-10
 call haltbv
 ld   b,32
fadedimens:
 push bc
 ld   b,logoPause2
 call haltbv
 xor  a                    ;  a: index of pal
 ld   b,16                 ;  b: how many colors /32 all
 ld   hl,FreeMem           ; hl: start of monoPalette /only one color-component
 push hl
 call SetBkgPalette
 pop  hl
 xor  a
 ld   b,16
 call ColorDiving
 pop  bc
 dec  b
 jr   nz,fadedimens
 call ClearScr1Map
 call ClearScrBank1

 ld   b,32
fadelogo1:
 push bc
 ld   b,2
 call haltbv
 xor  a                    ;  a- index of pal
 ld   b,4                  ;  b- how many colors /32 all
 ld   de,%0111111111111111 ; de- mask of colors: 0bbbbbgg,gggrrrrr
 ld   hl,FreeMem           ; hl- start of monoPalette /only one color-component
 push hl
 call SetMonoBkgPal
 pop  hl
 ld   c,4
 inc  [hl]
 dec  [hl]
 jr   z,@+3
 dec  [hl]
 inc  hl
 dec  c
 jr   nz,@-7
 pop  bc
 dec  b
 jr   nz,fadelogo1

worlds:
; call DrawSphere
; call FinalMess
 ld   a,60
 ld   [vblanks],a
 xor  a
 ld   [frames],a
 dec  a                 ; a=$ff
 ld   [numBuf+5],a
 ld   a,sbuf0
 ld   [wbuf],a
;
 ld   hl,$ffff
 ld   d,[hl]
 xor  a
 ld   [hl],a
 ldh  [$0F],a
 ld   a,$30
 ldh  [$00],a
 ld   a,1
 ldh  [$4D],a
 stop                   ; set to double speed!
 ld   [hl],d
;
 xor  a
 ld   b,64
 ld   hl,MyPal
 call SetBkgPalette
 xor  a
 ld   b,16
 ld   hl,ObjPal
 call SetObjPalette
;
 call initApaScr1
; call LCDon
; call eii

 include "motion.asm"
 include "shapes.asm"
putNumb:
 ld   a,l
 ld   [de],a
 cpl
 ld   l,a
 inc  d
 ld   a,h
 ld   [de],a
 cpl
 ld   h,a
 inc  hl
 ret
;
initApaScr1:
 rst  0
 ld   bc,8
 ld   de,Screen0        ; e=one notused bgtile ($8f)
 call SetLine
 ld   c,2
 call SetLine
 ld   c,4
 call SetLine
 ld   c,1
 call SetLine
 ld   c,6
 call SetLine
 ld   c,3
 call SetLine
 ld   c,5
 call SetLine
 ld   c,7
 call SetLine

 rst  40
 db   %00111111         ; bc,de,hl
 dw   $400              ; len
 dw   Screen1
 dw   Screen0           ; source
 db   $50               ; CopyHLtoDE

 rst  8
 ld   b,4
 ld   hl,Screen0
 ld   d,l
 call FillHL
 ld   b,4
 ld   d,8
 jp   FillHL
;
SetLine:
 ld   hl,TTable
 add  hl,bc
 push de
 ld   b,32
ias2:
 ld   a,[hli]  
 ld   c,a
 waitvblank
 ld   a,c
 ld   [de],a
 inc  de
 dec  b
 jr   nz,ias2
 ld   h,d
 ld   l,e
 pop  de
 ld   b,96
ias3:
 ld   a,[de]
 inc  de
 inc  a     
 ld   c,a
 waitvblank
 ld   [hl],c
 inc  hl
 dec  b
 jr   nz,ias3
 ld   d,h
 ld   e,l
 ret
 
;
ClearVram1:
 rst  8
 jr   @+3
ClearVram0:
 rst  0
 rst  40
 db   %00111011         ; bc,d,hl
 dw   $1800
 db   0
 dw   $8000
 db   $54
 ret
;
ClearScrBank1:
 rst  0
 db   62                ; code of 'ld a,n'
ClearScrBank2:
 rst  8
 rst  40
 db   %00111011         ; bc,d,hl
 dw   $1800             ; len
 db   0
 dw   $8000
 db   $54               ; FillHL
 ret
ClearScr1Map:
 ld   h,$98
 db   1                 ; code of 'ld bc,nn'
ClearScr2Map:
 ld   h,$9c
ClearScrMaps:
 rst  0
 xor  a
 ld   l,a
 ld   d,a
 push hl
 rst  40
 db   %00000011         ; bc
 dw   $400
 db   $54               ; FillHL
 pop  hl
 rst  8
 rst  40
 db   %00000011         ; bc
 dw   $400
 db   $54               ; FillHL
 ret
;
SetFont:
 call ClearVram0
 ld   b,20
 ld   de,MyFnt
 ld   hl,$8000
SetTwoLett:
 ld   c,7
 push de
 ld   a,[de]
 inc  de
 call SetLet
 dec  c
 jr   nz,@-6
 pop  de
 inc  hl
 inc  hl
 ld   c,7
 ld   a,[de]
 inc  de
 swap a
 call SetLet
 dec  c
 jr   nz,@-8
 inc  hl
 inc  hl
 dec  b
 jr   nz,SetTwoLett
 ret
;
SetLet:
 rla
 jr   nc,slet1
 push af
 waitvblank
 set  7,[hl]
 set  6,[hl]
 pop  af
slet1:
 rla
 jr   nc,slet2
 inc  hl
 push af
 waitvblank
 set  5,[hl]
 set  4,[hl]
 pop  af
 dec  hl
slet2:
 rla
 jr   nc,slet3
 push af
 waitvblank
 set  3,[hl]
 set  2,[hl]
 inc  hl
 waitvblank
 set  3,[hl]
 set  2,[hl]
 pop  af
 dec  hl
slet3:
 inc  hl
 inc  hl
 ret
 
MyPal:
 RGBSet  0, 0, 0
 RGBSet 17, 0, 0
 RGBSet 31, 0, 0
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet 20,20, 0
 RGBSet 31,31, 0
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet  9, 8, 0
 RGBSet 18,16, 0
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet  0,20, 1
 RGBSet  1,31, 0
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet 12,12,12
 RGBSet 20,20,20
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet  0,20,20
 RGBSet  0,31,31
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet 20, 0,20
 RGBSet 31, 0,31
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet  1, 4,13
 RGBSet  2, 7,26
 RGBSet 31,31,31
;
 RGBSet  0, 0, 0
 RGBSet  0,17, 0
 RGBSet  0,31, 0
 RGBSet 31,31,31
;
ObjPal:
 RGBSet 0 , 0, 0    
 RGBSet 31,31,10
 RGBSet 22,22, 5
 RGBSet 15,15, 3
theend: